/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.cio;

import io.ktor.http.HttpMethod;
import io.ktor.http.RequestConnectionPoint;
import io.ktor.http.URLProtocol;
import io.ktor.util.network.NetworkAddressJvmKt;
import java.net.SocketAddress;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\b\n\u0002\b\u001b\b\u0000\u0018\u00002\u00020\u0001BI\u0012\u000e\u0010\u0004\u001a\n\u0018\u00010\u0002j\u0004\u0018\u0001`\u0003\u0012\u000e\u0010\u0005\u001a\n\u0018\u00010\u0002j\u0004\u0018\u0001`\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\f\u0010\rJ\u000f\u0010\u000e\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0004\u001a\n\u0018\u00010\u0002j\u0004\u0018\u0001`\u00038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u0010\u0010R\u001c\u0010\u0005\u001a\n\u0018\u00010\u0002j\u0004\u0018\u0001`\u00038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0010R\u001a\u0010\u0007\u001a\u00020\u00068\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0007\u0010\u0011\u001a\u0004\b\u0012\u0010\u000fR\u001a\u0010\b\u001a\u00020\u00068\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\b\u0010\u0011\u001a\u0004\b\u0013\u0010\u000fR\u0016\u0010\t\u001a\u0004\u0018\u00010\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010\u0011R\u001a\u0010\u000b\u001a\u00020\n8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u000b\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0018\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u000fR\u0014\u0010\u001a\u001a\u00020\u00198\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001f\u001a\u00020\u00068VX\u0097\u0004\u00a2\u0006\f\u0012\u0004\b\u001d\u0010\u001e\u001a\u0004\b\u001c\u0010\u000fR\u001a\u0010#\u001a\u00020\u00198VX\u0097\u0004\u00a2\u0006\f\u0012\u0004\b\"\u0010\u001e\u001a\u0004\b \u0010!R\u0014\u0010%\u001a\u00020\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010!R\u0014\u0010'\u001a\u00020\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010!R\u0014\u0010)\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010\u000fR\u0014\u0010+\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010\u000fR\u0014\u0010-\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010\u000fR\u0014\u0010/\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010\u000fR\u0014\u00101\u001a\u00020\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u0010!R\u0014\u00103\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b2\u0010\u000f\u00a8\u00064"}, d2={"Lio/ktor/server/cio/CIOConnectionPoint;", "Lio/ktor/http/RequestConnectionPoint;", "Ljava/net/SocketAddress;", "Lio/ktor/util/network/NetworkAddress;", "remoteNetworkAddress", "localNetworkAddress", "", "version", "uri", "hostHeaderValue", "Lio/ktor/http/HttpMethod;", "method", "<init>", "(Ljava/net/SocketAddress;Ljava/net/SocketAddress;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lio/ktor/http/HttpMethod;)V", "toString", "()Ljava/lang/String;", "Ljava/net/SocketAddress;", "Ljava/lang/String;", "getVersion", "getUri", "Lio/ktor/http/HttpMethod;", "getMethod", "()Lio/ktor/http/HttpMethod;", "getScheme", "scheme", "", "defaultPort", "I", "getHost", "getHost$annotations", "()V", "host", "getPort", "()I", "getPort$annotations", "port", "getLocalPort", "localPort", "getServerPort", "serverPort", "getLocalHost", "localHost", "getServerHost", "serverHost", "getLocalAddress", "localAddress", "getRemoteHost", "remoteHost", "getRemotePort", "remotePort", "getRemoteAddress", "remoteAddress", "ktor-server-cio"})
public final class CIOConnectionPoint
implements RequestConnectionPoint {
    @Nullable
    private final SocketAddress remoteNetworkAddress;
    @Nullable
    private final SocketAddress localNetworkAddress;
    @NotNull
    private final String version;
    @NotNull
    private final String uri;
    @Nullable
    private final String hostHeaderValue;
    @NotNull
    private final HttpMethod method;
    private final int defaultPort;

    public CIOConnectionPoint(@Nullable SocketAddress remoteNetworkAddress, @Nullable SocketAddress localNetworkAddress, @NotNull String version, @NotNull String uri, @Nullable String hostHeaderValue, @NotNull HttpMethod method) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        this.remoteNetworkAddress = remoteNetworkAddress;
        this.localNetworkAddress = localNetworkAddress;
        this.version = version;
        this.uri = uri;
        this.hostHeaderValue = hostHeaderValue;
        this.method = method;
        this.defaultPort = URLProtocol.Companion.createOrDefault(this.getScheme()).getDefaultPort();
    }

    @NotNull
    public String getVersion() {
        return this.version;
    }

    @NotNull
    public String getUri() {
        return this.uri;
    }

    @NotNull
    public HttpMethod getMethod() {
        return this.method;
    }

    @NotNull
    public String getScheme() {
        return "http";
    }

    @NotNull
    public String getHost() {
        Object object = this.localNetworkAddress;
        if (object == null || (object = NetworkAddressJvmKt.getHostname((SocketAddress)object)) == null) {
            String string = this.hostHeaderValue;
            object = string != null ? StringsKt.substringBefore$default((String)string, (String)":", null, (int)2, null) : "localhost";
        }
        return object;
    }

    @Deprecated(message="Use localPort or serverPort instead")
    public static /* synthetic */ void getHost$annotations() {
    }

    public int getPort() {
        String string;
        SocketAddress socketAddress = this.localNetworkAddress;
        return socketAddress != null ? NetworkAddressJvmKt.getPort((SocketAddress)socketAddress) : ((string = this.hostHeaderValue) != null && (string = StringsKt.substringAfter((String)string, (String)":", (String)"80")) != null ? Integer.parseInt(string) : 80);
    }

    @Deprecated(message="Use localPort or serverPort instead")
    public static /* synthetic */ void getPort$annotations() {
    }

    public int getLocalPort() {
        SocketAddress socketAddress = this.localNetworkAddress;
        return socketAddress != null ? NetworkAddressJvmKt.getPort((SocketAddress)socketAddress) : this.defaultPort;
    }

    public int getServerPort() {
        String string;
        String string2 = this.hostHeaderValue;
        return string2 != null && (string = StringsKt.substringAfterLast((String)string2, (String)":", (String)String.valueOf(this.defaultPort))) != null ? Integer.parseInt(string) : this.getLocalPort();
    }

    @NotNull
    public String getLocalHost() {
        Object object = this.localNetworkAddress;
        if (object == null || (object = NetworkAddressJvmKt.getHostname((SocketAddress)object)) == null) {
            object = "localhost";
        }
        return object;
    }

    @NotNull
    public String getServerHost() {
        String string = this.hostHeaderValue;
        if (string == null || (string = StringsKt.substringBeforeLast$default((String)string, (String)":", null, (int)2, null)) == null) {
            string = this.getLocalHost();
        }
        return string;
    }

    @NotNull
    public String getLocalAddress() {
        Object object = this.localNetworkAddress;
        if (object == null || (object = NetworkAddressJvmKt.getAddress((SocketAddress)object)) == null) {
            object = "localhost";
        }
        return object;
    }

    @NotNull
    public String getRemoteHost() {
        Object object = this.remoteNetworkAddress;
        if (object == null || (object = NetworkAddressJvmKt.getHostname((SocketAddress)object)) == null) {
            object = "unknown";
        }
        return object;
    }

    public int getRemotePort() {
        SocketAddress socketAddress = this.remoteNetworkAddress;
        return socketAddress != null ? NetworkAddressJvmKt.getPort((SocketAddress)socketAddress) : 0;
    }

    @NotNull
    public String getRemoteAddress() {
        Object object = this.remoteNetworkAddress;
        if (object == null || (object = NetworkAddressJvmKt.getAddress((SocketAddress)object)) == null) {
            object = "unknown";
        }
        return object;
    }

    @NotNull
    public String toString() {
        return "CIOConnectionPoint(uri=" + this.getUri() + ", method=" + this.getMethod() + ", version=" + this.getVersion() + ", localAddress=" + this.getLocalAddress() + ", localPort=" + this.getLocalPort() + ", remoteAddress=" + this.getRemoteAddress() + ", remotePort=" + this.getRemotePort() + ')';
    }
}

