/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.client.plugins.compression;

import io.ktor.client.HttpClientConfig;
import io.ktor.client.call.DelegatedCallKt;
import io.ktor.client.call.HttpClientCall;
import io.ktor.client.plugins.HttpClientPlugin;
import io.ktor.client.plugins.api.ClientHook;
import io.ktor.client.plugins.api.ClientPlugin;
import io.ktor.client.plugins.api.ClientPluginBuilder;
import io.ktor.client.plugins.api.CreatePluginUtilsKt;
import io.ktor.client.plugins.api.OnRequestContext;
import io.ktor.client.plugins.compression.AfterRenderHook;
import io.ktor.client.plugins.compression.ContentEncodingConfig;
import io.ktor.client.plugins.compression.ContentEncodingKt;
import io.ktor.client.plugins.compression.ContentEncoding_jvmKt;
import io.ktor.client.plugins.compression.ReceiveStateHook;
import io.ktor.client.plugins.compression.UnsupportedContentEncodingException;
import io.ktor.client.request.HttpRequestBuilder;
import io.ktor.client.statement.HttpResponse;
import io.ktor.client.statement.HttpResponseKt;
import io.ktor.http.Headers;
import io.ktor.http.HeadersBuilder;
import io.ktor.http.HeadersKt;
import io.ktor.http.HttpHeaders;
import io.ktor.http.HttpMessage;
import io.ktor.http.HttpMessagePropertiesKt;
import io.ktor.http.HttpMethod;
import io.ktor.http.content.CompressedContentKt;
import io.ktor.http.content.OutgoingContent;
import io.ktor.util.AttributeKey;
import io.ktor.util.ContentEncoder;
import io.ktor.util.logging.KtorSimpleLoggerJvmKt;
import io.ktor.util.logging.LoggerJvmKt;
import io.ktor.util.reflect.TypeInfo;
import io.ktor.utils.io.ByteReadChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.reflect.KType;
import kotlin.reflect.KTypeProjection;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a:\u0010\b\u001a\u00020\u0005*\u0006\u0012\u0002\b\u00030\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00012\u0019\b\u0002\u0010\u0007\u001a\u0013\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\b\u0006\u00a2\u0006\u0004\b\b\u0010\t\u001a%\u0010\u000e\u001a\u00020\u0005*\u00020\n2\u0012\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000b\"\u00020\f\u00a2\u0006\u0004\b\u000e\u0010\u000f\u001a\u001f\u0010\u000e\u001a\u00020\u0005*\u00020\n2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u0010\u00a2\u0006\u0004\b\u000e\u0010\u0012\"\u0018\u0010\u0015\u001a\u00060\u0013j\u0002`\u00148\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0016\"#\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u00178\u0006\u00a2\u0006\u0012\n\u0004\b\b\u0010\u0018\u0012\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u0019\u0010\u001a\"&\u0010\u001e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u00100\u001d8\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b\u001e\u0010\u001f\u001a\u0004\b \u0010!\"&\u0010\"\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u00100\u001d8\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b\"\u0010\u001f\u001a\u0004\b#\u0010!\"\u001b\u0010'\u001a\b\u0012\u0004\u0012\u00020\f0\u0010*\u00020$8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010&\u00a8\u0006("}, d2={"Lio/ktor/client/HttpClientConfig;", "Lio/ktor/client/plugins/compression/ContentEncodingConfig$Mode;", "mode", "Lkotlin/Function1;", "Lio/ktor/client/plugins/compression/ContentEncodingConfig;", "", "Lkotlin/ExtensionFunctionType;", "block", "ContentEncoding", "(Lio/ktor/client/HttpClientConfig;Lio/ktor/client/plugins/compression/ContentEncodingConfig$Mode;Lkotlin/jvm/functions/Function1;)V", "Lio/ktor/client/request/HttpRequestBuilder;", "", "", "contentEncoderName", "compress", "(Lio/ktor/client/request/HttpRequestBuilder;[Ljava/lang/String;)V", "", "contentEncoderNames", "(Lio/ktor/client/request/HttpRequestBuilder;Ljava/util/List;)V", "Lorg/slf4j/Logger;", "Lio/ktor/util/logging/Logger;", "LOGGER", "Lorg/slf4j/Logger;", "Lio/ktor/client/plugins/api/ClientPlugin;", "Lio/ktor/client/plugins/api/ClientPlugin;", "getContentEncoding", "()Lio/ktor/client/plugins/api/ClientPlugin;", "getContentEncoding$annotations", "()V", "Lio/ktor/util/AttributeKey;", "CompressionListAttribute", "Lio/ktor/util/AttributeKey;", "getCompressionListAttribute", "()Lio/ktor/util/AttributeKey;", "DecompressionListAttribute", "getDecompressionListAttribute", "Lio/ktor/client/statement/HttpResponse;", "getAppliedDecoders", "(Lio/ktor/client/statement/HttpResponse;)Ljava/util/List;", "appliedDecoders", "ktor-client-encoding"})
@SourceDebugExtension(value={"SMAP\nContentEncoding.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ContentEncoding.kt\nio/ktor/client/plugins/compression/ContentEncodingKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Logger.kt\nio/ktor/util/logging/LoggerKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 Attributes.kt\nio/ktor/util/AttributesKt\n+ 6 Type.kt\nio/ktor/util/reflect/TypeKt\n*L\n1#1,299:1\n1#2:300\n38#3,2:301\n1563#4:303\n1634#4,3:304\n1563#4:307\n1634#4,3:308\n774#4:311\n865#4,2:312\n21#5:314\n21#5:324\n69#6:315\n84#6,8:316\n69#6:325\n84#6,8:326\n*S KotlinDebug\n*F\n+ 1 ContentEncoding.kt\nio/ktor/client/plugins/compression/ContentEncodingKt\n*L\n133#1:301,2\n144#1:303\n144#1:304,3\n146#1:307\n146#1:308,3\n162#1:311\n162#1:312,2\n263#1:314\n264#1:324\n263#1:315\n263#1:316,8\n264#1:325\n264#1:326,8\n*E\n"})
public final class ContentEncodingKt {
    @NotNull
    private static final Logger LOGGER;
    @NotNull
    private static final ClientPlugin<ContentEncodingConfig> ContentEncoding;
    @NotNull
    private static final AttributeKey<List<String>> CompressionListAttribute;
    @NotNull
    private static final AttributeKey<List<String>> DecompressionListAttribute;

    @NotNull
    public static final ClientPlugin<ContentEncodingConfig> getContentEncoding() {
        return ContentEncoding;
    }

    public static /* synthetic */ void getContentEncoding$annotations() {
    }

    public static final void ContentEncoding(@NotNull HttpClientConfig<?> $this$ContentEncoding, @NotNull ContentEncodingConfig.Mode mode, @NotNull Function1<? super ContentEncodingConfig, Unit> block) {
        Intrinsics.checkNotNullParameter($this$ContentEncoding, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        $this$ContentEncoding.install((HttpClientPlugin)ContentEncoding, arg_0 -> ContentEncodingKt.ContentEncoding$lambda$2(mode, block, arg_0));
    }

    public static /* synthetic */ void ContentEncoding$default(HttpClientConfig httpClientConfig, ContentEncodingConfig.Mode mode, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            mode = ContentEncodingConfig.Mode.DecompressResponse;
        }
        if ((n & 2) != 0) {
            function1 = ContentEncodingKt::ContentEncoding$lambda$1;
        }
        ContentEncodingKt.ContentEncoding(httpClientConfig, mode, (Function1<? super ContentEncodingConfig, Unit>)function1);
    }

    @NotNull
    public static final AttributeKey<List<String>> getCompressionListAttribute() {
        return CompressionListAttribute;
    }

    @NotNull
    public static final AttributeKey<List<String>> getDecompressionListAttribute() {
        return DecompressionListAttribute;
    }

    public static final void compress(@NotNull HttpRequestBuilder $this$compress, String ... contentEncoderName) {
        Intrinsics.checkNotNullParameter((Object)$this$compress, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)contentEncoderName, (String)"contentEncoderName");
        $this$compress.getAttributes().put(CompressionListAttribute, (Object)ArraysKt.toList((Object[])contentEncoderName));
    }

    public static final void compress(@NotNull HttpRequestBuilder $this$compress, @NotNull List<String> contentEncoderNames) {
        Intrinsics.checkNotNullParameter((Object)$this$compress, (String)"<this>");
        Intrinsics.checkNotNullParameter(contentEncoderNames, (String)"contentEncoderNames");
        $this$compress.getAttributes().put(CompressionListAttribute, contentEncoderNames);
    }

    @NotNull
    public static final List<String> getAppliedDecoders(@NotNull HttpResponse $this$appliedDecoders) {
        Intrinsics.checkNotNullParameter((Object)$this$appliedDecoders, (String)"<this>");
        List list = (List)$this$appliedDecoders.getCall().getAttributes().getOrNull(DecompressionListAttribute);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private static final Unit ContentEncoding$lambda$0(ClientPluginBuilder $this$createClientPlugin) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)$this$createClientPlugin, (String)"$this$createClientPlugin");
        Map<String, ContentEncoder> encoders = ((ContentEncodingConfig)$this$createClientPlugin.getPluginConfig()).getEncoders$ktor_client_encoding();
        Map<String, Float> qualityValues = ((ContentEncodingConfig)$this$createClientPlugin.getPluginConfig()).getQualityValues$ktor_client_encoding();
        ContentEncodingConfig.Mode mode = ((ContentEncodingConfig)$this$createClientPlugin.getPluginConfig()).getMode();
        StringBuilder $this$ContentEncoding_u24lambda_u240_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        for (ContentEncoder encoder : encoders.values()) {
            if (((CharSequence)$this$ContentEncoding_u24lambda_u240_u240).length() > 0) {
                $this$ContentEncoding_u24lambda_u240_u240.append(',');
            }
            $this$ContentEncoding_u24lambda_u240_u240.append(encoder.getName());
            Float f = qualityValues.get(encoder.getName());
            if (f == null) {
                continue;
            }
            float quality = f.floatValue();
            double d = quality;
            if (!(0.0 <= d ? d <= 1.0 : false)) {
                boolean bl2 = false;
                String string = "Invalid quality value: " + quality + " for encoder: " + encoder;
                throw new IllegalStateException(string.toString());
            }
            String qualityValue = StringsKt.take((String)String.valueOf(quality), (int)5);
            $this$ContentEncoding_u24lambda_u240_u240.append(";q=" + qualityValue);
        }
        String requestHeader = stringBuilder.toString();
        $this$createClientPlugin.onRequest((Function4)new Function4<OnRequestContext, HttpRequestBuilder, Object, Continuation<? super Unit>, Object>(mode, requestHeader, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ ContentEncodingConfig.Mode $mode;
            final /* synthetic */ String $requestHeader;
            {
                this.$mode = $mode;
                this.$requestHeader = $requestHeader;
                super(4, $completion);
            }

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object $result) {
                HttpRequestBuilder httpRequestBuilder = (HttpRequestBuilder)this.L$0;
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$trace$iv;
                        void request;
                        ResultKt.throwOnFailure((Object)$result);
                        if (!this.$mode.getResponse$ktor_client_encoding()) {
                            return Unit.INSTANCE;
                        }
                        if (request.getHeaders().contains(HttpHeaders.INSTANCE.getAcceptEncoding())) {
                            return Unit.INSTANCE;
                        }
                        Logger logger = ContentEncodingKt.access$getLOGGER$p();
                        String string = this.$requestHeader;
                        boolean $i$f$trace = false;
                        if (LoggerJvmKt.isTraceEnabled((Logger)$this$trace$iv)) {
                            void var7_6 = $this$trace$iv;
                            boolean bl = false;
                            var7_6.trace("Adding Accept-Encoding=" + string + " for " + request.getUrl());
                        }
                        request.getHeaders().set(HttpHeaders.INSTANCE.getAcceptEncoding(), this.$requestHeader);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Object invoke(OnRequestContext p1, HttpRequestBuilder p2, Object p3, Continuation<? super Unit> p4) {
                Function4<OnRequestContext, HttpRequestBuilder, Object, Continuation<? super Unit>, Object> function4 = new /* invalid duplicate definition of identical inner class */;
                function4.L$0 = p2;
                return function4.invokeSuspend((Object)Unit.INSTANCE);
            }
        });
        $this$createClientPlugin.on((ClientHook)AfterRenderHook.INSTANCE, (Object)new Function3<HttpRequestBuilder, OutgoingContent, Continuation<? super OutgoingContent>, Object>(mode, (ClientPluginBuilder<ContentEncodingConfig>)$this$createClientPlugin, encoders, null){
            int label;
            /* synthetic */ Object L$0;
            /* synthetic */ Object L$1;
            final /* synthetic */ ContentEncodingConfig.Mode $mode;
            final /* synthetic */ ClientPluginBuilder<ContentEncodingConfig> $this_createClientPlugin;
            final /* synthetic */ Map<String, ContentEncoder> $encoders;
            {
                this.$mode = $mode;
                this.$this_createClientPlugin = $this_createClientPlugin;
                this.$encoders = $encoders;
                super(3, $completion);
            }

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object $result) {
                HttpRequestBuilder httpRequestBuilder = (HttpRequestBuilder)this.L$0;
                OutgoingContent outgoingContent = (OutgoingContent)this.L$1;
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$fold$iv;
                        void content;
                        void $this$mapTo$iv$iv;
                        Iterable $this$map$iv;
                        Object object;
                        void request;
                        ResultKt.throwOnFailure((Object)$result);
                        if (!this.$mode.getRequest$ktor_client_encoding()) {
                            return null;
                        }
                        List list = (List)request.getAttributes().getOrNull(ContentEncodingKt.getCompressionListAttribute());
                        if (list == null) {
                            ClientPluginBuilder<ContentEncodingConfig> $this$invokeSuspend_u24lambda_u240 = this.$this_createClientPlugin;
                            boolean bl = false;
                            Logger $this$trace$iv2 = ContentEncodingKt.access$getLOGGER$p();
                            boolean $i$f$trace = false;
                            if (LoggerJvmKt.isTraceEnabled((Logger)$this$trace$iv2)) {
                                Logger logger = $this$trace$iv2;
                                boolean bl2 = false;
                                logger.trace("Skipping request compression for " + request.getUrl() + " because no compressions set");
                            }
                            return null;
                        }
                        List encoderNames = list;
                        Logger $this$trace$iv = ContentEncodingKt.access$getLOGGER$p();
                        boolean $i$f$trace22 = false;
                        if (LoggerJvmKt.isTraceEnabled((Logger)$this$trace$iv)) {
                            object = $this$trace$iv;
                            boolean bl = false;
                            object.trace("Compressing request body for " + request.getUrl() + " using " + encoderNames);
                        }
                        Iterable $i$f$trace22 = encoderNames;
                        Map<String, ContentEncoder> bl = this.$encoders;
                        boolean $i$f$map = false;
                        void $this$trace$iv2 = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            void it;
                            String string = (String)item$iv$iv;
                            object = destination$iv$iv;
                            boolean bl3 = false;
                            ContentEncoder contentEncoder = bl.get(it);
                            if (contentEncoder == null) {
                                throw new UnsupportedContentEncodingException((String)it);
                            }
                            object.add(contentEncoder);
                        }
                        List selectedEncoders = (List)destination$iv$iv;
                        if (selectedEncoders.isEmpty()) {
                            return null;
                        }
                        $this$map$iv = selectedEncoders;
                        void initial$iv = content;
                        boolean $i$f$fold = false;
                        OutgoingContent accumulator$iv = initial$iv;
                        for (T element$iv : $this$fold$iv) {
                            void encoder;
                            ContentEncoder bl2 = (ContentEncoder)element$iv;
                            void compressed = accumulator$iv;
                            boolean bl4 = false;
                            OutgoingContent outgoingContent2 = CompressedContentKt.compressed((OutgoingContent)compressed, (ContentEncoder)encoder, (CoroutineContext)((CoroutineContext)request.getExecutionContext()));
                            if (outgoingContent2 == null) {
                                outgoingContent2 = compressed;
                            }
                            accumulator$iv = outgoingContent2;
                        }
                        return accumulator$iv;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Object invoke(HttpRequestBuilder p1, OutgoingContent p2, Continuation<? super OutgoingContent> p3) {
                Function3<HttpRequestBuilder, OutgoingContent, Continuation<? super OutgoingContent>, Object> function3 = new /* invalid duplicate definition of identical inner class */;
                function3.L$0 = p1;
                function3.L$1 = p2;
                return function3.invokeSuspend((Object)Unit.INSTANCE);
            }
        });
        $this$createClientPlugin.on((ClientHook)ReceiveStateHook.INSTANCE, (Object)new Function2<HttpResponse, Continuation<? super HttpResponse>, Object>(mode, encoders, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ ContentEncodingConfig.Mode $mode;
            final /* synthetic */ Map<String, ContentEncoder> $encoders;
            {
                this.$mode = $mode;
                this.$encoders = $encoders;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object $result) {
                HttpResponse httpResponse = (HttpResponse)this.L$0;
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        Long contentLength;
                        void response;
                        ResultKt.throwOnFailure((Object)$result);
                        if (!this.$mode.getResponse$ktor_client_encoding()) {
                            return null;
                        }
                        HttpMethod method = HttpResponseKt.getRequest((HttpResponse)response).getMethod();
                        Long l = contentLength = HttpMessagePropertiesKt.contentLength((HttpMessage)((HttpMessage)response));
                        long l2 = 0L;
                        if (l != null && l == l2) {
                            return null;
                        }
                        if (contentLength == null && Intrinsics.areEqual((Object)method, (Object)HttpMethod.Companion.getHead())) {
                            return null;
                        }
                        return ContentEncodingKt.access$ContentEncoding$lambda$0$decode(this.$encoders, (HttpResponse)response);
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                Function2<HttpResponse, Continuation<? super HttpResponse>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)function2;
            }

            public final Object invoke(HttpResponse p1, Continuation<? super HttpResponse> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        });
        return Unit.INSTANCE;
    }

    private static final ByteReadChannel ContentEncoding$lambda$0$decodeContent(HttpResponse $this$ContentEncoding_u24lambda_u240_u24decodeContent, List<? extends ContentEncoder> encoders) {
        ByteReadChannel current = $this$ContentEncoding_u24lambda_u240_u24decodeContent.getRawContent();
        for (ContentEncoder contentEncoder : encoders) {
            Logger $this$trace$iv = LOGGER;
            boolean $i$f$trace = false;
            if (LoggerJvmKt.isTraceEnabled((Logger)$this$trace$iv)) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("Decoding response with " + contentEncoder + " for " + $this$ContentEncoding_u24lambda_u240_u24decodeContent.getCall().getRequest().getUrl());
            }
            current = contentEncoder.decode(current, $this$ContentEncoding_u24lambda_u240_u24decodeContent.getCoroutineContext());
        }
        return current;
    }

    /*
     * WARNING - void declaration
     */
    private static final HttpResponse ContentEncoding$lambda$0$decode(Map<String, ? extends ContentEncoder> encoders, HttpResponse response) {
        void $this$mapTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        if (!ContentEncoding_jvmKt.shouldDecode(response)) {
            return response;
        }
        String string = response.getHeaders().get(HttpHeaders.INSTANCE.getContentEncoding());
        if (string == null) {
            throw new IllegalStateException((HttpHeaders.INSTANCE.getContentEncoding() + " unavailable").toString());
        }
        String contentEncodingHeader = string;
        String[] stringArray = new String[]{","};
        Iterable $this$map$iv = StringsKt.split$default((CharSequence)contentEncodingHeader, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            String string2 = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            String string3 = ((Object)StringsKt.trim((CharSequence)((CharSequence)it))).toString().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
            collection.add(string3);
        }
        List encodings = (List)destination$iv$iv;
        Iterable $this$map$iv2 = CollectionsKt.asReversed((List)encodings);
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void encoding;
            String bl = (String)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            ContentEncoder contentEncoder = encoders.get(encoding);
            if (contentEncoder == null) {
                throw new UnsupportedContentEncodingException((String)encoding);
            }
            collection.add(contentEncoder);
        }
        List selectedEncoders = (List)destination$iv$iv2;
        Headers headers = HeadersKt.headers(arg_0 -> ContentEncodingKt.ContentEncoding$lambda$0$decode$4(response, encodings, arg_0));
        response.getCall().getAttributes().put(DecompressionListAttribute, (Object)encodings);
        return DelegatedCallKt.replaceResponse((HttpClientCall)response.getCall(), (Headers)headers, arg_0 -> ContentEncodingKt.ContentEncoding$lambda$0$decode$5(selectedEncoders, arg_0)).getResponse();
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit ContentEncoding$lambda$0$decode$4(HttpResponse $response, List $encodings, HeadersBuilder $this$headers) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$headers, (String)"$this$headers");
        $response.getHeaders().forEach((arg_0, arg_1) -> ContentEncodingKt.ContentEncoding$lambda$0$decode$4$0($this$headers, arg_0, arg_1));
        Iterable $this$filter$iv = $encodings;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            if (!(!$encodings.contains(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List remainingEncodings = (List)destination$iv$iv;
        if (!((Collection)remainingEncodings).isEmpty()) {
            $this$headers.append(HttpHeaders.INSTANCE.getContentEncoding(), CollectionsKt.joinToString$default((Iterable)remainingEncodings, (CharSequence)",", null, null, (int)0, null, null, (int)62, null));
        }
        return Unit.INSTANCE;
    }

    private static final Unit ContentEncoding$lambda$0$decode$4$0(HeadersBuilder $this_headers, String name, List values) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        if (StringsKt.equals((String)name, (String)HttpHeaders.INSTANCE.getContentEncoding(), (boolean)true) || StringsKt.equals((String)name, (String)HttpHeaders.INSTANCE.getContentLength(), (boolean)true)) {
            return Unit.INSTANCE;
        }
        $this_headers.appendAll(name, (Iterable)values);
        return Unit.INSTANCE;
    }

    private static final ByteReadChannel ContentEncoding$lambda$0$decode$5(List $selectedEncoders, HttpResponse $this$replaceResponse) {
        Intrinsics.checkNotNullParameter((Object)$this$replaceResponse, (String)"$this$replaceResponse");
        return ContentEncodingKt.ContentEncoding$lambda$0$decodeContent($this$replaceResponse, $selectedEncoders);
    }

    private static final Unit ContentEncoding$lambda$1(ContentEncodingConfig contentEncodingConfig) {
        Intrinsics.checkNotNullParameter((Object)contentEncodingConfig, (String)"<this>");
        ContentEncodingConfig.gzip$default(contentEncodingConfig, null, 1, null);
        ContentEncodingConfig.deflate$default(contentEncodingConfig, null, 1, null);
        ContentEncodingConfig.identity$default(contentEncodingConfig, null, 1, null);
        return Unit.INSTANCE;
    }

    private static final Unit ContentEncoding$lambda$2(ContentEncodingConfig.Mode $mode, Function1 $block, ContentEncodingConfig $this$install) {
        Intrinsics.checkNotNullParameter((Object)$this$install, (String)"$this$install");
        $this$install.setMode($mode);
        $block.invoke((Object)$this$install);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Logger access$getLOGGER$p() {
        return LOGGER;
    }

    public static final /* synthetic */ HttpResponse access$ContentEncoding$lambda$0$decode(Map encoders, HttpResponse response) {
        return ContentEncodingKt.ContentEncoding$lambda$0$decode(encoders, response);
    }

    static {
        KType kType;
        LOGGER = KtorSimpleLoggerJvmKt.KtorSimpleLogger((String)"io.ktor.client.plugins.compression.ContentEncoding");
        ContentEncoding = CreatePluginUtilsKt.createClientPlugin((String)"HttpEncoding", (Function0)ContentEncoding.1.INSTANCE, ContentEncodingKt::ContentEncoding$lambda$0);
        String name$iv = "CompressionListAttribute";
        boolean $i$f$AttributeKey = false;
        String string = name$iv;
        boolean $i$f$typeInfo = false;
        KClass kClass = Reflection.getOrCreateKotlinClass(List.class);
        boolean $i$f$typeOfOrNull = false;
        try {
            kType = Reflection.typeOf(List.class, (KTypeProjection)KTypeProjection.Companion.invariant(Reflection.typeOf(String.class)));
        }
        catch (Throwable throwable) {
            kType = null;
        }
        KType kType2 = kType;
        KClass kClass2 = kClass;
        TypeInfo typeInfo = new TypeInfo(kClass2, kType2);
        String string2 = string;
        CompressionListAttribute = new AttributeKey(string2, typeInfo);
        name$iv = "DecompressionListAttribute";
        $i$f$AttributeKey = false;
        string = name$iv;
        $i$f$typeInfo = false;
        kClass = Reflection.getOrCreateKotlinClass(List.class);
        $i$f$typeOfOrNull = false;
        try {
            kType = Reflection.typeOf(List.class, (KTypeProjection)KTypeProjection.Companion.invariant(Reflection.typeOf(String.class)));
        }
        catch (Throwable throwable) {
            kType = null;
        }
        kType2 = kType;
        kClass2 = kClass;
        typeInfo = new TypeInfo(kClass2, kType2);
        string2 = string;
        DecompressionListAttribute = new AttributeKey(string2, typeInfo);
    }
}

