/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigationevent;

import androidx.compose.runtime.Immutable;
import androidx.navigationevent.NavigationEventInfo;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u001f\b\u0002\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bB\t\b\u0010\u00a2\u0006\u0004\b\u0007\u0010\tB1\b\u0011\u0012\u0006\u0010\n\u001a\u00020\u0004\u0012\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u000e\b\u0002\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0007\u0010\rJ\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0015\u001a\u00020\u0006H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0018"}, d2={"Landroidx/navigationevent/NavigationEventHistory;", "", "mergedHistory", "", "Landroidx/navigationevent/NavigationEventInfo;", "currentIndex", "", "<init>", "(Ljava/util/List;I)V", "()V", "currentInfo", "backInfo", "forwardInfo", "(Landroidx/navigationevent/NavigationEventInfo;Ljava/util/List;Ljava/util/List;)V", "getMergedHistory", "()Ljava/util/List;", "getCurrentIndex", "()I", "equals", "", "other", "hashCode", "toString", "", "navigationevent"})
@Immutable
public final class NavigationEventHistory {
    @NotNull
    private final List<NavigationEventInfo> mergedHistory;
    private final int currentIndex;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private NavigationEventHistory(List<? extends NavigationEventInfo> mergedHistory, int currentIndex) {
        this.mergedHistory = mergedHistory;
        this.currentIndex = currentIndex;
        if (this.mergedHistory.isEmpty()) {
            if (this.currentIndex == -1) return;
        }
        if (!((Collection)this.mergedHistory).isEmpty()) {
            boolean bl;
            int n = ((Collection)this.mergedHistory).size();
            int n2 = this.currentIndex;
            if (0 <= n2) {
                if (n2 < n) {
                    return;
                }
                bl = false;
            } else {
                bl = false;
            }
            if (bl) {
                return;
            }
        }
        boolean bl = false;
        if (bl) return;
        boolean bl2 = false;
        String string = "Invalid 'NavigationEventHistory' state:  'currentIndex' must be within the bounds of 'mergedHistory' (or -1 if empty). Received: currentIndex = '" + this.currentIndex + "', bounds = '" + CollectionsKt.getIndices((Collection)this.mergedHistory) + "'.";
        throw new IllegalArgumentException(string.toString());
    }

    @NotNull
    public final List<NavigationEventInfo> getMergedHistory() {
        return this.mergedHistory;
    }

    public final int getCurrentIndex() {
        return this.currentIndex;
    }

    public NavigationEventHistory() {
        this(CollectionsKt.emptyList(), -1);
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public NavigationEventHistory(@NotNull NavigationEventInfo currentInfo, @NotNull List<? extends NavigationEventInfo> backInfo, @NotNull List<? extends NavigationEventInfo> forwardInfo) {
        void $this$_init__u24lambda_u241;
        List list;
        Intrinsics.checkNotNullParameter((Object)currentInfo, (String)"currentInfo");
        Intrinsics.checkNotNullParameter(backInfo, (String)"backInfo");
        Intrinsics.checkNotNullParameter(forwardInfo, (String)"forwardInfo");
        List list2 = list = CollectionsKt.createListBuilder();
        NavigationEventHistory navigationEventHistory = this;
        boolean bl = false;
        CollectionsKt.addAll((Collection)((Collection)$this$_init__u24lambda_u241), (Iterable)backInfo);
        ((Collection)$this$_init__u24lambda_u241).add(currentInfo);
        CollectionsKt.addAll((Collection)((Collection)$this$_init__u24lambda_u241), (Iterable)forwardInfo);
        navigationEventHistory(CollectionsKt.build((List)list), backInfo.size());
    }

    public /* synthetic */ NavigationEventHistory(NavigationEventInfo navigationEventInfo, List list, List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 4) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        this(navigationEventInfo, list, list2);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        NavigationEventHistory cfr_ignored_0 = (NavigationEventHistory)other;
        if (this.currentIndex != ((NavigationEventHistory)other).currentIndex) {
            return false;
        }
        return Intrinsics.areEqual(this.mergedHistory, ((NavigationEventHistory)other).mergedHistory);
    }

    public int hashCode() {
        int result = this.currentIndex;
        result = 31 * result + ((Object)this.mergedHistory).hashCode();
        return result;
    }

    @NotNull
    public String toString() {
        return "NavigationEventHistory(currentIndex=" + this.currentIndex + ", mergedHistory=" + this.mergedHistory + ")";
    }

    @JvmOverloads
    public NavigationEventHistory(@NotNull NavigationEventInfo currentInfo, @NotNull List<? extends NavigationEventInfo> backInfo) {
        Intrinsics.checkNotNullParameter((Object)currentInfo, (String)"currentInfo");
        Intrinsics.checkNotNullParameter(backInfo, (String)"backInfo");
        this(currentInfo, backInfo, null, 4, null);
    }

    @JvmOverloads
    public NavigationEventHistory(@NotNull NavigationEventInfo currentInfo) {
        Intrinsics.checkNotNullParameter((Object)currentInfo, (String)"currentInfo");
        this(currentInfo, null, null, 6, null);
    }
}

