/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.animation;

import androidx.compose.animation.BoundsAnimationKt;
import androidx.compose.animation.BoundsTransform;
import androidx.compose.animation.SharedTransitionScope;
import androidx.compose.animation.core.AnimationVector4D;
import androidx.compose.animation.core.FiniteAnimationSpec;
import androidx.compose.animation.core.Transition;
import androidx.compose.runtime.MutableState;
import androidx.compose.runtime.SnapshotStateKt;
import androidx.compose.runtime.State;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.geometry.Rect;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000f\b\u0001\u0018\u00002\u00020\u0001BQ\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u001c\u0010\u0007\u001a\u0018\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bR\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\u0004\b\u0010\u0010\u0011J,\u0010\u001f\u001a\u00020 2\u001c\u0010\u0007\u001a\u0018\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bR\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u000b\u001a\u00020\fJ\"\u00108\u001a\u00020 2\u0006\u00109\u001a\u00020\t2\u0006\u0010:\u001a\u00020\t2\n\b\u0002\u0010;\u001a\u0004\u0018\u00010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017RW\u0010\u0007\u001a\u0018\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bR\b\u0012\u0004\u0012\u00020\u00060\u00052\u001c\u0010\u0018\u001a\u0018\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bR\b\u0012\u0004\u0012\u00020\u00060\u00058F@BX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u001d\u0010\u001e\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR+\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\f8B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b%\u0010\u001e\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u0011\u0010&\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R \u0010(\u001a\b\u0012\u0004\u0012\u00020\t0)X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-R;\u0010/\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010.2\u000e\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010.8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b4\u0010\u001e\u001a\u0004\b0\u00101\"\u0004\b2\u00103R\u0013\u00105\u001a\u0004\u0018\u00010\t8F\u00a2\u0006\u0006\u001a\u0004\b6\u00107R\u0011\u0010<\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b=\u0010'\u00a8\u0006\u0007"}, d2={"Landroidx/compose/animation/BoundsAnimation;", "", "transitionScope", "Landroidx/compose/animation/SharedTransitionScope;", "transition", "Landroidx/compose/animation/core/Transition;", "", "animation", "Landroidx/compose/animation/core/Transition$DeferredAnimation;", "Landroidx/compose/ui/geometry/Rect;", "Landroidx/compose/animation/core/AnimationVector4D;", "boundsTransform", "Landroidx/compose/animation/BoundsTransform;", "momentumOffset", "Lkotlin/Function0;", "Landroidx/compose/ui/geometry/Offset;", "<init>", "(Landroidx/compose/animation/SharedTransitionScope;Landroidx/compose/animation/core/Transition;Landroidx/compose/animation/core/Transition$DeferredAnimation;Landroidx/compose/animation/BoundsTransform;Lkotlin/jvm/functions/Function0;)V", "getTransitionScope", "()Landroidx/compose/animation/SharedTransitionScope;", "getTransition", "()Landroidx/compose/animation/core/Transition;", "getMomentumOffset", "()Lkotlin/jvm/functions/Function0;", "<set-?>", "getAnimation", "()Landroidx/compose/animation/core/Transition$DeferredAnimation;", "setAnimation", "(Landroidx/compose/animation/core/Transition$DeferredAnimation;)V", "animation$delegate", "Landroidx/compose/runtime/MutableState;", "updateAnimation", "", "getBoundsTransform", "()Landroidx/compose/animation/BoundsTransform;", "setBoundsTransform", "(Landroidx/compose/animation/BoundsTransform;)V", "boundsTransform$delegate", "isRunning", "()Z", "animationSpec", "Landroidx/compose/animation/core/FiniteAnimationSpec;", "getAnimationSpec", "()Landroidx/compose/animation/core/FiniteAnimationSpec;", "setAnimationSpec", "(Landroidx/compose/animation/core/FiniteAnimationSpec;)V", "Landroidx/compose/runtime/State;", "animationState", "getAnimationState", "()Landroidx/compose/runtime/State;", "setAnimationState", "(Landroidx/compose/runtime/State;)V", "animationState$delegate", "value", "getValue", "()Landroidx/compose/ui/geometry/Rect;", "animate", "currentBounds", "targetBounds", "forcedBoundsTransform", "target", "getTarget"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nBoundsAnimation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BoundsAnimation.kt\nandroidx/compose/animation/BoundsAnimation\n+ 2 SnapshotState.kt\nandroidx/compose/runtime/SnapshotStateKt__SnapshotStateKt\n*L\n1#1,117:1\n85#2:118\n117#2,2:119\n85#2:121\n117#2,2:122\n85#2:124\n117#2,2:125\n*S KotlinDebug\n*F\n+ 1 BoundsAnimation.kt\nandroidx/compose/animation/BoundsAnimation\n*L\n40#1:118\n40#1:119,2\n55#1:121\n55#1:122,2\n70#1:124\n70#1:125,2\n*E\n"})
public final class BoundsAnimation {
    @NotNull
    private final SharedTransitionScope transitionScope;
    @NotNull
    private final Transition<Boolean> transition;
    @NotNull
    private final Function0<Offset> momentumOffset;
    @NotNull
    private final MutableState animation$delegate;
    @NotNull
    private final MutableState boundsTransform$delegate;
    @NotNull
    private FiniteAnimationSpec<Rect> animationSpec;
    @NotNull
    private final MutableState animationState$delegate;
    public static final int $stable = 8;

    public BoundsAnimation(@NotNull SharedTransitionScope transitionScope, @NotNull Transition<Boolean> transition, @NotNull Transition.DeferredAnimation<Rect, AnimationVector4D> animation, @NotNull BoundsTransform boundsTransform, @NotNull Function0<Offset> momentumOffset) {
        Intrinsics.checkNotNullParameter((Object)transitionScope, (String)"transitionScope");
        Intrinsics.checkNotNullParameter(transition, (String)"transition");
        Intrinsics.checkNotNullParameter(animation, (String)"animation");
        Intrinsics.checkNotNullParameter((Object)boundsTransform, (String)"boundsTransform");
        Intrinsics.checkNotNullParameter(momentumOffset, (String)"momentumOffset");
        this.transitionScope = transitionScope;
        this.transition = transition;
        this.momentumOffset = momentumOffset;
        this.animation$delegate = SnapshotStateKt.mutableStateOf$default(animation, null, (int)2, null);
        this.boundsTransform$delegate = SnapshotStateKt.mutableStateOf$default((Object)boundsTransform, null, (int)2, null);
        this.animationSpec = (FiniteAnimationSpec)BoundsAnimationKt.access$getDefaultBoundsAnimation$p();
        this.animationState$delegate = SnapshotStateKt.mutableStateOf$default(null, null, (int)2, null);
    }

    @NotNull
    public final SharedTransitionScope getTransitionScope() {
        return this.transitionScope;
    }

    @NotNull
    public final Transition<Boolean> getTransition() {
        return this.transition;
    }

    @NotNull
    public final Function0<Offset> getMomentumOffset() {
        return this.momentumOffset;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Transition.DeferredAnimation<Rect, AnimationVector4D> getAnimation() {
        void $this$getValue$iv;
        State state = (State)this.animation$delegate;
        BoundsAnimation boundsAnimation = this;
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return (Transition.DeferredAnimation)$this$getValue$iv.getValue();
    }

    /*
     * WARNING - void declaration
     */
    private final void setAnimation(Transition.DeferredAnimation<Rect, AnimationVector4D> deferredAnimation) {
        void $this$setValue$iv;
        MutableState mutableState = this.animation$delegate;
        BoundsAnimation boundsAnimation = this;
        Object var4_4 = null;
        Transition.DeferredAnimation<Rect, AnimationVector4D> value$iv = deferredAnimation;
        boolean $i$f$setValue = false;
        $this$setValue$iv.setValue(value$iv);
    }

    public final void updateAnimation(@NotNull Transition.DeferredAnimation<Rect, AnimationVector4D> animation, @NotNull BoundsTransform boundsTransform) {
        Intrinsics.checkNotNullParameter(animation, (String)"animation");
        Intrinsics.checkNotNullParameter((Object)boundsTransform, (String)"boundsTransform");
        if (!Intrinsics.areEqual(this.getAnimation(), animation)) {
            this.setAnimation(animation);
            this.setAnimationState(null);
            this.animationSpec = (FiniteAnimationSpec)BoundsAnimationKt.access$getDefaultBoundsAnimation$p();
        }
        this.setBoundsTransform(boundsTransform);
    }

    /*
     * WARNING - void declaration
     */
    private final BoundsTransform getBoundsTransform() {
        void $this$getValue$iv;
        State state = (State)this.boundsTransform$delegate;
        BoundsAnimation boundsAnimation = this;
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return (BoundsTransform)$this$getValue$iv.getValue();
    }

    /*
     * WARNING - void declaration
     */
    private final void setBoundsTransform(BoundsTransform boundsTransform) {
        void $this$setValue$iv;
        MutableState mutableState = this.boundsTransform$delegate;
        BoundsAnimation boundsAnimation = this;
        Object var4_4 = null;
        BoundsTransform value$iv = boundsTransform;
        boolean $i$f$setValue = false;
        $this$setValue$iv.setValue((Object)value$iv);
    }

    public final boolean isRunning() {
        Transition parent = this.transition;
        while (parent.getParentTransition() != null) {
            Intrinsics.checkNotNull((Object)parent.getParentTransition());
        }
        return !Intrinsics.areEqual((Object)parent.getCurrentState(), (Object)parent.getTargetState());
    }

    @NotNull
    public final FiniteAnimationSpec<Rect> getAnimationSpec() {
        return this.animationSpec;
    }

    public final void setAnimationSpec(@NotNull FiniteAnimationSpec<Rect> finiteAnimationSpec) {
        Intrinsics.checkNotNullParameter(finiteAnimationSpec, (String)"<set-?>");
        this.animationSpec = finiteAnimationSpec;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final State<Rect> getAnimationState() {
        void $this$getValue$iv;
        State state = (State)this.animationState$delegate;
        BoundsAnimation boundsAnimation = this;
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return (State)$this$getValue$iv.getValue();
    }

    /*
     * WARNING - void declaration
     */
    public final void setAnimationState(@Nullable State<Rect> state) {
        void $this$setValue$iv;
        MutableState mutableState = this.animationState$delegate;
        BoundsAnimation boundsAnimation = this;
        Object var4_4 = null;
        State<Rect> value$iv = state;
        boolean $i$f$setValue = false;
        $this$setValue$iv.setValue(value$iv);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Rect getValue() {
        Object object;
        if (this.transitionScope.isTransitionActive()) {
            Rect rect = this.getAnimationState();
            if (rect != null && (rect = (Rect)rect.getValue()) != null) {
                void var1_1;
                Rect it = rect;
                boolean bl = false;
                long offset = ((Offset)this.momentumOffset.invoke()).unbox-impl();
                object = !Offset.equals-impl0((long)offset, (long)Offset.Companion.getZero-F1C5BW0()) ? it.translate-k-4lQ0M(offset) : var1_1;
            } else {
                object = null;
            }
        } else {
            object = null;
        }
        return object;
    }

    public final void animate(@NotNull Rect currentBounds, @NotNull Rect targetBounds, @Nullable BoundsTransform forcedBoundsTransform) {
        Intrinsics.checkNotNullParameter((Object)currentBounds, (String)"currentBounds");
        Intrinsics.checkNotNullParameter((Object)targetBounds, (String)"targetBounds");
        if (this.transitionScope.isTransitionActive()) {
            if (this.getAnimationState() == null) {
                BoundsTransform boundsTransform = forcedBoundsTransform;
                if (boundsTransform == null) {
                    boundsTransform = this.getBoundsTransform();
                }
                this.animationSpec = boundsTransform.createAnimationSpec(currentBounds, targetBounds);
            }
            this.setAnimationState((State<Rect>)this.getAnimation().animate(arg_0 -> BoundsAnimation.animate$lambda$0(this, arg_0), arg_0 -> BoundsAnimation.animate$lambda$1(this, targetBounds, currentBounds, arg_0)));
        }
    }

    public static /* synthetic */ void animate$default(BoundsAnimation boundsAnimation, Rect rect, Rect rect2, BoundsTransform boundsTransform, int n, Object object) {
        if ((n & 4) != 0) {
            boundsTransform = null;
        }
        boundsAnimation.animate(rect, rect2, boundsTransform);
    }

    public final boolean getTarget() {
        return (Boolean)this.transition.getTargetState();
    }

    private static final FiniteAnimationSpec animate$lambda$0(BoundsAnimation this$0, Transition.Segment $this$animate) {
        Intrinsics.checkNotNullParameter((Object)$this$animate, (String)"$this$animate");
        return this$0.animationSpec;
    }

    private static final Rect animate$lambda$1(BoundsAnimation this$0, Rect $targetBounds, Rect $currentBounds, boolean it) {
        return it == (Boolean)this$0.transition.getTargetState() ? $targetBounds : $currentBounds;
    }
}

