/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.runtime.saveable;

import androidx.compose.runtime.RememberObserver;
import androidx.compose.runtime.saveable.RememberSaveableKt;
import androidx.compose.runtime.saveable.SaveableStateRegistry;
import androidx.compose.runtime.saveable.Saver;
import androidx.compose.runtime.saveable.SaverScope;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u00022\u00020\u0003BG\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00028\u0000\u0012\u0010\u0010\f\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00060\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJK\u0010\u0016\u001a\u00020\u00172\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00060\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00028\u00002\u0010\u0010\f\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00060\r\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u0018\u001a\u00020\u0017H\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u000b\u001a\u00020\u0006H\u0016J\b\u0010\u001b\u001a\u00020\u0017H\u0016J\b\u0010\u001c\u001a\u00020\u0017H\u0016J\b\u0010\u001d\u001a\u00020\u0017H\u0016J\u001f\u0010\u001e\u001a\u0004\u0018\u00018\u00002\u0010\u0010\f\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00060\r\u00a2\u0006\u0002\u0010\u001fR\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00028\u0000X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u001a\u0010\f\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00060\rX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0011R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0014\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Landroidx/compose/runtime/saveable/SaveableHolder;", "T", "Landroidx/compose/runtime/saveable/SaverScope;", "Landroidx/compose/runtime/RememberObserver;", "saver", "Landroidx/compose/runtime/saveable/Saver;", "", "registry", "Landroidx/compose/runtime/saveable/SaveableStateRegistry;", "key", "", "value", "inputs", "", "<init>", "(Landroidx/compose/runtime/saveable/Saver;Landroidx/compose/runtime/saveable/SaveableStateRegistry;Ljava/lang/String;Ljava/lang/Object;[Ljava/lang/Object;)V", "Ljava/lang/Object;", "[Ljava/lang/Object;", "entry", "Landroidx/compose/runtime/saveable/SaveableStateRegistry$Entry;", "valueProvider", "Lkotlin/Function0;", "update", "", "register", "canBeSaved", "", "onRemembered", "onForgotten", "onAbandoned", "getValueIfInputsDidntChange", "([Ljava/lang/Object;)Ljava/lang/Object;", "runtime-saveable"})
@SourceDebugExtension(value={"SMAP\nRememberSaveable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RememberSaveable.kt\nandroidx/compose/runtime/saveable/SaveableHolder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,391:1\n1#2:392\n*E\n"})
final class SaveableHolder<T>
implements SaverScope,
RememberObserver {
    @NotNull
    private Saver<T, Object> saver;
    @Nullable
    private SaveableStateRegistry registry;
    @NotNull
    private String key;
    private T value;
    @NotNull
    private Object[] inputs;
    @Nullable
    private SaveableStateRegistry.Entry entry;
    @NotNull
    private final Function0<Object> valueProvider;

    public SaveableHolder(@NotNull Saver<T, Object> saver, @Nullable SaveableStateRegistry registry, @NotNull String key, T value, @NotNull Object[] inputs) {
        this.saver = saver;
        this.registry = registry;
        this.key = key;
        this.value = value;
        this.inputs = inputs;
        this.valueProvider = () -> SaveableHolder.valueProvider$lambda$0(this);
    }

    public final void update(@NotNull Saver<T, Object> saver, @Nullable SaveableStateRegistry registry, @NotNull String key, T value, @NotNull Object[] inputs) {
        boolean entryIsOutdated = false;
        if (this.registry != registry) {
            this.registry = registry;
            entryIsOutdated = true;
        }
        if (!Intrinsics.areEqual((Object)this.key, (Object)key)) {
            this.key = key;
            entryIsOutdated = true;
        }
        this.saver = saver;
        this.value = value;
        this.inputs = inputs;
        if (this.entry != null && entryIsOutdated) {
            SaveableStateRegistry.Entry entry = this.entry;
            if (entry != null) {
                entry.unregister();
            }
            this.entry = null;
            this.register();
        }
    }

    private final void register() {
        SaveableStateRegistry registry = this.registry;
        if (!(this.entry == null)) {
            boolean bl = false;
            String string = "entry(" + this.entry + ") is not null";
            throw new IllegalArgumentException(string.toString());
        }
        if (registry != null) {
            RememberSaveableKt.access$requireCanBeSaved(registry, this.valueProvider.invoke());
            this.entry = registry.registerProvider(this.key, this.valueProvider);
        }
    }

    @Override
    public boolean canBeSaved(@NotNull Object value) {
        SaveableStateRegistry registry = this.registry;
        return registry == null || registry.canBeSaved(value);
    }

    public void onRemembered() {
        this.register();
    }

    public void onForgotten() {
        block0: {
            SaveableStateRegistry.Entry entry = this.entry;
            if (entry == null) break block0;
            entry.unregister();
        }
    }

    public void onAbandoned() {
        block0: {
            SaveableStateRegistry.Entry entry = this.entry;
            if (entry == null) break block0;
            entry.unregister();
        }
    }

    @Nullable
    public final T getValueIfInputsDidntChange(@NotNull Object[] inputs) {
        return Arrays.equals(inputs, this.inputs) ? (T)this.value : null;
    }

    private static final Object valueProvider$lambda$0(SaveableHolder this$0) {
        Saver $this$valueProvider_u24lambda_u240_u240 = this$0.saver;
        boolean bl = false;
        Saver saver = $this$valueProvider_u24lambda_u240_u240;
        SaverScope saverScope = this$0;
        Object t = this$0.value;
        if (t == null) {
            SaverScope saverScope2 = saverScope;
            Saver saver2 = saver;
            boolean bl2 = false;
            String string = "Value should be initialized";
            Saver saver3 = saver2;
            SaverScope saverScope3 = saverScope2;
            String string2 = string;
            throw new IllegalArgumentException(string2.toString());
        }
        return saver.save(saverScope, t);
    }
}

