/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.viewer;

import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.freedesktop.dbus.viewer.DBusEntry;

class DBusTableModel
extends AbstractTableModel {
    private static final String INTROSPECTABLE = "introspectable?";
    private static final String OWNER = "owner";
    private static final String USER = "user";
    private static final String NAME = "name";
    private static final String PATH = "path";
    private final String[] columns = new String[]{"name", "path", "user", "owner", "introspectable?"};
    private final List<DBusEntry> entries = new ArrayList<DBusEntry>();

    DBusTableModel() {
    }

    @Override
    public int getRowCount() {
        return this.entries.size();
    }

    public void add(DBusEntry _entry) {
        this.entries.add(_entry);
    }

    @Override
    public int getColumnCount() {
        return this.columns.length;
    }

    @Override
    public String getColumnName(int _column) {
        return this.columns[_column];
    }

    public DBusEntry getEntry(int _row) {
        return this.entries.get(_row);
    }

    @Override
    public Class<?> getColumnClass(int _columnIndex) {
        String columnName = this.getColumnName(_columnIndex);
        if (columnName.equals(NAME)) {
            return String.class;
        }
        return switch (columnName) {
            case PATH -> String.class;
            case USER -> Object.class;
            case OWNER -> String.class;
            case INTROSPECTABLE -> Boolean.class;
            default -> super.getColumnClass(_columnIndex);
        };
    }

    @Override
    public Object getValueAt(int _rowIndex, int _columnIndex) {
        DBusEntry entry = this.getEntry(_rowIndex);
        String columnName = this.getColumnName(_columnIndex);
        if (columnName.equals(NAME)) {
            return entry.getName();
        }
        return switch (columnName) {
            case PATH -> entry.getPath();
            case USER -> entry.getUser();
            case OWNER -> entry.getOwner();
            case INTROSPECTABLE -> entry.getIntrospectable() != null;
            default -> null;
        };
    }
}

