/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.utils.generator;

import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.freedesktop.dbus.annotations.DBusInterfaceName;
import org.freedesktop.dbus.utils.Util;
import org.freedesktop.dbus.utils.bin.IdentifierMangler;
import org.freedesktop.dbus.utils.generator.TypeConverter;

public class ClassBuilderInfo {
    private static final String DEFAULT_INDENT = "    ";
    private final Set<String> imports = new TreeSet<String>();
    private final List<AnnotationInfo> annotations = new ArrayList<AnnotationInfo>();
    private final List<MemberOrArgument> members = new ArrayList<MemberOrArgument>();
    private final Set<String> implementedInterfaces = new LinkedHashSet<String>();
    private final List<ClassMethod> methods = new ArrayList<ClassMethod>();
    private final List<ClassBuilderInfo> innerClasses = new ArrayList<ClassBuilderInfo>();
    private final List<ClassConstructor> constructors = new ArrayList<ClassConstructor>();
    private final String argumentPrefix;
    private String className;
    private String packageName;
    private String dbusPackageName;
    private ClassType classType;
    private String extendClass;

    public ClassBuilderInfo() {
        this(null);
    }

    public ClassBuilderInfo(String _argumentPrefix) {
        this.argumentPrefix = _argumentPrefix;
    }

    public Set<String> getImports() {
        return this.imports;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String _packageName) {
        this.packageName = _packageName;
    }

    public String getDbusPackageName() {
        return this.dbusPackageName;
    }

    public void setDbusPackageName(String _dbusPackageName) {
        this.dbusPackageName = _dbusPackageName;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String _className) {
        this.className = _className;
    }

    public ClassType getClassType() {
        return this.classType;
    }

    public void setClassType(ClassType _classType) {
        this.classType = _classType;
    }

    public List<AnnotationInfo> getAnnotations() {
        return this.annotations;
    }

    public Set<String> getImplementedInterfaces() {
        return this.implementedInterfaces;
    }

    public String getExtendClass() {
        return this.extendClass;
    }

    public void setExtendClass(String _extendClass) {
        this.extendClass = _extendClass;
    }

    public List<ClassMethod> getMethods() {
        return this.methods;
    }

    public List<MemberOrArgument> getMembers() {
        return this.members;
    }

    public List<ClassBuilderInfo> getInnerClasses() {
        return this.innerClasses;
    }

    public List<ClassConstructor> getConstructors() {
        return this.constructors;
    }

    public String createClassFileContent() {
        List<String> result = this.createClassFileContent(false, new LinkedHashSet<String>());
        return String.join((CharSequence)System.lineSeparator(), result) + System.lineSeparator();
    }

    private List<String> createClassFileContent(boolean _staticClass, Set<String> _otherImports) {
        ArrayList<String> content = new ArrayList<String>();
        String classIndent = _staticClass ? DEFAULT_INDENT : "";
        String memberIndent = _staticClass ? DEFAULT_INDENT.repeat(2) : DEFAULT_INDENT;
        TreeSet<String> allImports = new TreeSet<String>();
        allImports.addAll(this.getImports());
        if (_otherImports != null) {
            allImports.addAll(_otherImports);
        }
        if (!_staticClass) {
            content.add("package " + this.getPackageName() + ";");
            content.add("");
            content.add("/**");
            content.add(" * Auto-generated class.");
            content.add(" */");
        } else {
            ClassBuilderInfo.addEmptyLineIfNeeded(content);
        }
        if (this.getDbusPackageName() != null) {
            allImports.add(DBusInterfaceName.class.getName());
            content.add(classIndent + "@" + DBusInterfaceName.class.getSimpleName() + "(\"" + this.getDbusPackageName() + "\")");
        }
        for (AnnotationInfo annotation : this.annotations) {
            allImports.add(annotation.getAnnotationClass().getName());
            String annotationCode = classIndent + "@" + annotation.getAnnotationClass().getSimpleName();
            if (annotation.getAnnotationParams() != null) {
                annotationCode = annotationCode + "(" + annotation.getAnnotationParams() + ")";
            }
            content.add(annotationCode);
        }
        String bgn = classIndent + "public " + (_staticClass ? "static " : "") + (this.getClassType() == ClassType.INTERFACE ? "interface" : "class");
        bgn = bgn + " " + this.getClassName();
        if (this.getExtendClass() != null) {
            Set<String> lImports = ClassBuilderInfo.getImportsForType(this.getExtendClass());
            this.getImports().addAll(lImports);
            allImports.addAll(lImports);
            bgn = bgn + " extends " + ClassBuilderInfo.getSimpleTypeClasses(this.getExtendClass());
        }
        if (!this.getImplementedInterfaces().isEmpty()) {
            bgn = bgn + " implements " + this.getImplementedInterfaces().stream().map(ClassBuilderInfo::getClassName).collect(Collectors.joining(", "));
            this.getImports().addAll(this.getImplementedInterfaces().stream().filter(s -> !s.startsWith("java.lang.")).toList());
        }
        bgn = bgn + " {";
        content.add(bgn);
        if (_staticClass) {
            ClassBuilderInfo.addEmptyLineIfNeeded(content);
        }
        for (MemberOrArgument member : this.members) {
            if (!member.getAnnotations().isEmpty()) {
                content.addAll(member.getAnnotations().stream().map(l -> memberIndent + l).toList());
            }
            content.add(memberIndent + "private " + member.asOneLineString(allImports, "", false) + ";");
        }
        if (!this.getConstructors().isEmpty()) {
            for (ClassConstructor constructor : this.getConstructors()) {
                ClassBuilderInfo.addEmptyLineIfNeeded(content);
                String outerIndent = _staticClass ? DEFAULT_INDENT.repeat(2) : DEFAULT_INDENT;
                content.addAll(constructor.generatedCode(outerIndent, this.getClassName(), this.argumentPrefix, allImports));
            }
        }
        for (MemberOrArgument member : this.members) {
            ClassBuilderInfo.addEmptyLineIfNeeded(content);
            content.addAll(member.generateCode(memberIndent, this.argumentPrefix, allImports));
        }
        for (ClassMethod mth : this.getMethods()) {
            ClassBuilderInfo.addEmptyLineIfNeeded(content);
            content.addAll(mth.generateCode(this.getClassType() == ClassType.INTERFACE, this.argumentPrefix, memberIndent, allImports));
        }
        for (ClassBuilderInfo inner : this.getInnerClasses()) {
            ClassBuilderInfo.addEmptyLineIfNeeded(content);
            content.addAll(inner.createClassFileContent(true, allImports));
            allImports.addAll(inner.getImports());
        }
        ClassBuilderInfo.addEmptyLineIfNeeded(content);
        content.add(classIndent + "}");
        if (!_staticClass) {
            content.add(2, "");
            content.addAll(2, allImports.stream().filter(l -> !l.startsWith("java.lang.")).filter(l -> !l.replaceFirst("(.+)\\..+", "$1").equals(this.getPackageName())).filter(l -> l.contains(".")).map(l -> "import " + l + ";").toList());
        }
        return content;
    }

    private static String maybePrefix(String _arg, String _prefix) {
        return Util.isBlank((String)_prefix) ? _arg : _prefix + _arg;
    }

    private static void addEmptyLineIfNeeded(List<String> _content) {
        if (_content == null || _content.isEmpty()) {
            return;
        }
        String lastLine = _content.get(_content.size() - 1);
        if (!Util.isBlank((String)lastLine)) {
            _content.add("");
        }
    }

    public String getFileName() {
        if (this.getClassName() == null) {
            return null;
        }
        if (this.getPackageName() == null) {
            return this.getClassName() + ".java";
        }
        return this.getPackageName().replace(".", File.separator) + File.separator + this.getClassName() + ".java";
    }

    public String getFqcn() {
        return Util.isBlank((String)this.getPackageName()) ? this.getClassName() : this.getPackageName() + "." + this.getClassName();
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [imports=" + String.valueOf(this.imports) + ", annotations=" + String.valueOf(this.annotations) + ", members=" + String.valueOf(this.members) + ", implementedInterfaces=" + String.valueOf(this.implementedInterfaces) + ", methods=" + String.valueOf(this.methods) + ", innerClasses=" + String.valueOf(this.innerClasses) + ", constructors=" + String.valueOf(this.constructors) + ", className=" + this.className + ", packageName=" + this.packageName + ", dbusPackageName=" + this.dbusPackageName + ", classType=" + String.valueOf((Object)this.classType) + ", extendClass=" + this.extendClass + "]";
    }

    static String getClassName(String _fqcn) {
        if (_fqcn == null) {
            return null;
        }
        String clzzName = _fqcn;
        if (clzzName.contains(".")) {
            clzzName = clzzName.substring(clzzName.lastIndexOf(46) + 1);
        }
        return clzzName;
    }

    static String getSimpleTypeClasses(String _type) {
        if (_type == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        Pattern compile = Pattern.compile("([^, <>?]+)");
        Matcher matcher = compile.matcher(_type);
        while (matcher.find()) {
            String match = matcher.group();
            matcher.appendReplacement(sb, ClassBuilderInfo.getClassName(match));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    static Set<String> getImportsForType(String _type) {
        HashSet<String> imports = new HashSet<String>();
        if (!_type.contains("<")) {
            if (!_type.startsWith("java.lang.") && _type.contains(".")) {
                imports.add(_type);
            }
            return imports;
        }
        Pattern compile = Pattern.compile("([^, <>?]+)");
        Matcher matcher = compile.matcher(_type);
        while (matcher.find()) {
            String match = matcher.group();
            if (match.startsWith("java.lang.") || !match.contains(".")) continue;
            imports.add(match);
        }
        return imports;
    }

    public static enum ClassType {
        INTERFACE,
        CLASS;

    }

    public static class AnnotationInfo {
        private final Class<? extends Annotation> annotationClass;
        private final String annotationParams;

        public AnnotationInfo(Class<? extends Annotation> _annotationClass, String _annotationParams) {
            this.annotationClass = _annotationClass;
            this.annotationParams = _annotationParams;
        }

        public Class<? extends Annotation> getAnnotationClass() {
            return this.annotationClass;
        }

        public String getAnnotationParams() {
            return this.annotationParams;
        }
    }

    public static class MemberOrArgument {
        private static final String GETTER_TEMPL = "public %s get%s() {\n%sreturn %s;\n}\n";
        private static final String SETTER_TEMPL = "public void set%s(%s %s) {\n%s%s = %s;\n}\n";
        private final String name;
        private final String type;
        private final boolean finalArg;
        private final List<String> generics = new ArrayList<String>();
        private final List<String> annotations = new ArrayList<String>();

        public MemberOrArgument(String _name, String _type, boolean _finalMember) {
            this.name = IdentifierMangler.isReservedWord(_name) || IdentifierMangler.isReservedWord(_name.replaceFirst("^_(.+)", "$1")) ? _name + "param" : _name;
            this.type = _type;
            this.finalArg = _finalMember;
        }

        public MemberOrArgument(String _name, String _type) {
            this(_name, _type, false);
        }

        public List<String> getAnnotations() {
            return this.annotations;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public boolean isFinalArg() {
            return this.finalArg;
        }

        public List<String> getGenerics() {
            return this.generics;
        }

        public String getFullType(Set<String> _allImports) {
            StringBuilder sb = new StringBuilder();
            sb.append(TypeConverter.getProperJavaClass(this.getType(), _allImports));
            if (!this.getGenerics().isEmpty()) {
                sb.append("<").append(this.getGenerics().stream().map(c -> TypeConverter.convertJavaType(c, false)).collect(Collectors.joining(", "))).append(">");
            }
            return sb.toString();
        }

        public String asOneLineString(Set<String> _allImports, String _prefix, boolean _includeAnnotations) {
            StringBuilder sb = new StringBuilder();
            if (this.isFinalArg()) {
                sb.append("final ");
            }
            if (_includeAnnotations && !this.getAnnotations().isEmpty()) {
                sb.append(String.join((CharSequence)" ", this.getAnnotations())).append(" ");
            }
            sb.append(this.getFullType(_allImports));
            sb.append(" ");
            sb.append(ClassBuilderInfo.maybePrefix(this.getName(), _prefix));
            return sb.toString();
        }

        public List<String> generateCode(String _indent, String _prefix, Set<String> _allImports) {
            ArrayList<String> result = new ArrayList<String>();
            Object memberType = TypeConverter.getProperJavaClass(this.getType(), _allImports);
            if (!this.getGenerics().isEmpty()) {
                memberType = (String)memberType + "<" + this.getGenerics().stream().map(c -> TypeConverter.convertJavaType(c, false)).collect(Collectors.joining(", ")) + ">";
            }
            String getterSetterName = Util.snakeToCamelCase((String)Util.upperCaseFirstChar((String)this.getName()));
            if (!this.isFinalArg()) {
                SETTER_TEMPL.formatted(getterSetterName, memberType, ClassBuilderInfo.maybePrefix("arg", _prefix), ClassBuilderInfo.DEFAULT_INDENT, this.getName(), ClassBuilderInfo.maybePrefix("arg", _prefix)).lines().map(l -> _indent + l).forEach(result::add);
            }
            ClassBuilderInfo.addEmptyLineIfNeeded(result);
            GETTER_TEMPL.formatted(memberType, getterSetterName, ClassBuilderInfo.DEFAULT_INDENT, this.getName()).lines().map(l -> _indent + l).forEach(result::add);
            return result;
        }

        public String toString() {
            return this.getClass().getSimpleName() + " [name=" + this.name + ", type=" + this.type + ", finalArg=" + this.finalArg + ", generics=" + String.valueOf(this.generics) + ", annotations=" + String.valueOf(this.annotations) + "]";
        }
    }

    public static class ClassConstructor {
        private static final String CONSTRUCTOR_TEMPL = "public %s(%s)%s {\n%s\n}\n";
        private final List<MemberOrArgument> arguments = new ArrayList<MemberOrArgument>();
        private final List<MemberOrArgument> superArguments = new ArrayList<MemberOrArgument>();
        private final List<String> throwArguments = new ArrayList<String>();

        public List<String> getThrowArguments() {
            return this.throwArguments;
        }

        public List<MemberOrArgument> getArguments() {
            return this.arguments;
        }

        public List<MemberOrArgument> getSuperArguments() {
            return this.superArguments;
        }

        public String argumentsAsString(Set<String> _allImports, String _prefix) {
            return this.getArguments().stream().map(a -> a.asOneLineString(_allImports, _prefix, true)).collect(Collectors.joining(", "));
        }

        public List<String> generatedCode(String _indent, String _className, String _argumentPrefix, Set<String> _allImports) {
            ArrayList<MemberOrArgument> filteredSuperArguments = new ArrayList<MemberOrArgument>(this.getSuperArguments());
            filteredSuperArguments.removeIf(e -> this.getArguments().contains(e));
            Object constructorArgs = "";
            if (!filteredSuperArguments.isEmpty()) {
                constructorArgs = (String)constructorArgs + filteredSuperArguments.stream().map(e -> e.asOneLineString(_allImports, _argumentPrefix, false)).collect(Collectors.joining(", "));
                if (!this.getArguments().isEmpty()) {
                    constructorArgs = (String)constructorArgs + ", ";
                }
            }
            if (!this.getArguments().isEmpty()) {
                constructorArgs = (String)constructorArgs + this.argumentsAsString(_allImports, _argumentPrefix);
            }
            String throwArgs = this.getThrowArguments().isEmpty() ? "" : " throws " + String.join((CharSequence)", ", this.getThrowArguments());
            Object assignments = "";
            if (!this.getSuperArguments().isEmpty()) {
                assignments = _indent + "super(" + this.getSuperArguments().stream().map(MemberOrArgument::getName).collect(Collectors.joining(", ")) + ");";
            }
            if (!this.getArguments().isEmpty()) {
                ArrayList<CallSite> assigns = new ArrayList<CallSite>();
                for (MemberOrArgument e2 : this.getArguments()) {
                    assigns.add((CallSite)((Object)(_indent + "this." + e2.getName().replaceFirst("^_(.+)", "$1") + " = " + ClassBuilderInfo.maybePrefix(e2.getName(), _argumentPrefix) + ";")));
                }
                assignments = (String)assignments + String.join((CharSequence)System.lineSeparator(), assigns);
            }
            return CONSTRUCTOR_TEMPL.formatted(_className, constructorArgs, throwArgs, assignments).lines().map(l -> _indent + l).toList();
        }

        public String toString() {
            return this.getClass().getSimpleName() + " [arguments=" + String.valueOf(this.arguments) + ", superArguments=" + String.valueOf(this.superArguments) + ", throwArguments=" + String.valueOf(this.throwArguments) + "]";
        }
    }

    public static class ClassMethod {
        private static final String METHOD_TEMPL = "%s%s %s(%s);\n";
        private final String name;
        private final String returnType;
        private final boolean finalMethod;
        private final List<MemberOrArgument> arguments = new ArrayList<MemberOrArgument>();
        private final List<String> annotations = new ArrayList<String>();

        public ClassMethod(String _name, String _returnType, boolean _finalMethod) {
            this.name = _name;
            this.returnType = _returnType;
            this.finalMethod = _finalMethod;
        }

        public String getName() {
            return this.name;
        }

        public String getReturnType() {
            return this.returnType;
        }

        public boolean isFinalMethod() {
            return this.finalMethod;
        }

        public List<MemberOrArgument> getArguments() {
            return this.arguments;
        }

        public List<String> getAnnotations() {
            return this.annotations;
        }

        public List<String> generateCode(boolean _isInterface, String _argumentPrefix, String _indent, Set<String> _allImports) {
            ArrayList<String> result = new ArrayList<String>();
            if (!this.getAnnotations().isEmpty()) {
                result.addAll(this.getAnnotations().stream().map(a -> _indent + a).toList());
            }
            String publicModifier = !_isInterface ? "public " : "";
            String mthReturnType = this.getReturnType() == null ? "void" : TypeConverter.getProperJavaClass(this.getReturnType(), _allImports);
            Object args = "";
            if (!this.getArguments().isEmpty()) {
                args = (String)args + this.getArguments().stream().map(e -> e.asOneLineString(_allImports, _argumentPrefix, true)).collect(Collectors.joining(", "));
            }
            METHOD_TEMPL.formatted(publicModifier, mthReturnType, this.getName(), args).lines().map(l -> _indent + l).forEach(result::add);
            return result;
        }
    }
}

