/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.signalstore;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import org.jetbrains.annotations.NotNull;
import vet.inpulse.core.models.record_data.CapnoSample;
import vet.inpulse.core.models.record_data.Spo2Sample;
import vet.inpulse.core.models.record_data.TempSample;
import vet.inpulse.libcomm.core.device.data.EcgData;
import vet.inpulse.libcomm.core.device.data.PpgData;
import vet.inpulse.shared.models.EcgLeadData;
import vet.inpulse.signalstore.SignalStoreEcgChannels;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u0088\u0001\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0014\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0016\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\n\u0010\u0005\u001a\u00020\u0004*\u00020\u0006\u001a\u0012\u0010\u0007\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\n\u0010\b\u001a\u00020\u0004*\u00020\u0006\u001a\u0012\u0010\t\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\n\u001a\n\u0010\u000b\u001a\u00020\n*\u00020\u0006\u001a\u0012\u0010\f\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\n\u001a\n\u0010\r\u001a\u00020\n*\u00020\u0006\u001a\u001e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0000\u001a\u001f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00180\u0013\u00a2\u0006\u0002\u0010\u0019\u001aW\u0010\u001a\u001a\u0002H\u001b\"\u0004\b\u0000\u0010\u001b*\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001126\u0010\u001e\u001a2\u0012\u0013\u0012\u00110\u0011\u00a2\u0006\f\b \u0012\b\b!\u0012\u0004\b\b(\"\u0012\u0013\u0012\u00110#\u00a2\u0006\f\b \u0012\b\b!\u0012\u0004\b\b($\u0012\u0004\u0012\u0002H\u001b0\u001fH\u0000\u00a2\u0006\u0002\u0010%\u001a\f\u0010&\u001a\u00020'*\u00020\u001cH\u0000\u001a\u0012\u0010(\u001a\u00020\u001c*\b\u0012\u0004\u0012\u00020)0\u0013H\u0000\u001a\u0012\u0010*\u001a\b\u0012\u0004\u0012\u00020+0\u0013*\u00020\u001cH\u0000\u001a\u0012\u0010,\u001a\u00020\u001c*\b\u0012\u0004\u0012\u00020+0\u0013H\u0000\u001a\u0012\u0010-\u001a\b\u0012\u0004\u0012\u00020.0\u0013*\u00020\u001cH\u0000\u001a\u0012\u0010/\u001a\u00020\u001c*\b\u0012\u0004\u0012\u00020.0\u0013H\u0000\u001a\u0012\u00100\u001a\b\u0012\u0004\u0012\u0002010\u0013*\u00020\u001cH\u0000\u001a\u0012\u00102\u001a\u00020\u001c*\b\u0012\u0004\u0012\u0002010\u0013H\u0000\u00a8\u00063"}, d2={"writeFloat", "", "Lokio/BufferedSink;", "value", "", "readFloat", "Lokio/BufferedSource;", "writeFloatLe", "readFloatLe", "writeDouble", "", "readDouble", "writeDoubleLe", "readDoubleLe", "separateInEcgChannels", "Lvet/inpulse/signalstore/SignalStoreEcgChannels;", "numChannels", "", "data", "", "Lvet/inpulse/libcomm/core/device/data/EcgData;", "separateInPpgChannels", "", "", "Lvet/inpulse/libcomm/core/device/data/PpgData;", "(Ljava/util/List;)[[F", "convertTo", "T", "", "sampleSize", "constructor", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "numSamples", "Lokio/Buffer;", "buffer", "([BILkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "decodeToLongArray", "", "encodeFromLongArray", "", "decodeToTempList", "Lvet/inpulse/core/models/record_data/TempSample;", "encodeFromTempList", "decodeToSpo2List", "Lvet/inpulse/core/models/record_data/Spo2Sample;", "encodeFromSpo2List", "decodeToCapnoList", "Lvet/inpulse/core/models/record_data/CapnoSample;", "encodeFromCapnoList", "signal-store"})
@SourceDebugExtension(value={"SMAP\nSignalStoreUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SignalStoreUtils.kt\nvet/inpulse/signalstore/SignalStoreUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,181:1\n1#2:182\n*E\n"})
public final class SignalStoreUtilsKt {
    public static final void writeFloat(@NotNull BufferedSink $this$writeFloat, float value) {
        Intrinsics.checkNotNullParameter((Object)$this$writeFloat, (String)"<this>");
        $this$writeFloat.writeInt(Float.floatToRawIntBits(value));
    }

    public static final float readFloat(@NotNull BufferedSource $this$readFloat) {
        Intrinsics.checkNotNullParameter((Object)$this$readFloat, (String)"<this>");
        return Float.intBitsToFloat($this$readFloat.readInt());
    }

    public static final void writeFloatLe(@NotNull BufferedSink $this$writeFloatLe, float value) {
        Intrinsics.checkNotNullParameter((Object)$this$writeFloatLe, (String)"<this>");
        $this$writeFloatLe.writeIntLe(Float.floatToRawIntBits(value));
    }

    public static final float readFloatLe(@NotNull BufferedSource $this$readFloatLe) {
        Intrinsics.checkNotNullParameter((Object)$this$readFloatLe, (String)"<this>");
        return Float.intBitsToFloat($this$readFloatLe.readIntLe());
    }

    public static final void writeDouble(@NotNull BufferedSink $this$writeDouble, double value) {
        Intrinsics.checkNotNullParameter((Object)$this$writeDouble, (String)"<this>");
        $this$writeDouble.writeLong(Double.doubleToRawLongBits(value));
    }

    public static final double readDouble(@NotNull BufferedSource $this$readDouble) {
        Intrinsics.checkNotNullParameter((Object)$this$readDouble, (String)"<this>");
        return Double.longBitsToDouble($this$readDouble.readLong());
    }

    public static final void writeDoubleLe(@NotNull BufferedSink $this$writeDoubleLe, double value) {
        Intrinsics.checkNotNullParameter((Object)$this$writeDoubleLe, (String)"<this>");
        $this$writeDoubleLe.writeLongLe(Double.doubleToRawLongBits(value));
    }

    public static final double readDoubleLe(@NotNull BufferedSource $this$readDoubleLe) {
        Intrinsics.checkNotNullParameter((Object)$this$readDoubleLe, (String)"<this>");
        return Double.longBitsToDouble($this$readDoubleLe.readLongLe());
    }

    @NotNull
    public static final SignalStoreEcgChannels separateInEcgChannels(int numChannels, @NotNull List<EcgData> data) {
        int n;
        Intrinsics.checkNotNullParameter(data, (String)"data");
        ArrayList<float[]> arrayList = new ArrayList<float[]>(numChannels);
        int n2 = 0;
        while (n2 < numChannels) {
            int n3 = n = n2++;
            ArrayList<float[]> arrayList2 = arrayList;
            boolean bl = false;
            arrayList2.add(new float[data.size()]);
        }
        List array = arrayList;
        int[] leadOff = new int[data.size()];
        n = ((Collection)data).size();
        for (int i = 0; i < n; ++i) {
            EcgData d = data.get(i);
            for (int c = 0; c < numChannels; ++c) {
                ((float[])array.get((int)c))[i] = EcgLeadData.get-impl((float[])d.getLeads-wgjypNo(), (int)c);
            }
            leadOff[i] = d.getLeadOffs-any4o4A();
        }
        return new SignalStoreEcgChannels(array, ArraysKt.asList((int[])leadOff));
    }

    @NotNull
    public static final float[][] separateInPpgChannels(@NotNull List<PpgData> data) {
        Intrinsics.checkNotNullParameter(data, (String)"data");
        int n = 0;
        float[][] fArrayArray = new float[2][];
        while (n < 2) {
            int n2 = n++;
            fArrayArray[n2] = new float[data.size()];
        }
        float[][] array = fArrayArray;
        float[] red = (float[])((Object[])array)[0];
        float[] ir = (float[])((Object[])array)[1];
        int n3 = ((Collection)data).size();
        for (int i = 0; i < n3; ++i) {
            PpgData d = data.get(i);
            red[i] = d.getRed();
            ir[i] = d.getInfrared();
        }
        return array;
    }

    public static final <T> T convertTo(@NotNull byte[] $this$convertTo, int sampleSize, @NotNull Function2<? super Integer, ? super Buffer, ? extends T> constructor) {
        Buffer buffer;
        Intrinsics.checkNotNullParameter((Object)$this$convertTo, (String)"<this>");
        Intrinsics.checkNotNullParameter(constructor, (String)"constructor");
        Buffer it = buffer = new Buffer();
        boolean bl = false;
        it.write($this$convertTo);
        Buffer buffer2 = buffer;
        int numSamples = $this$convertTo.length / sampleSize;
        return (T)constructor.invoke((Object)numSamples, (Object)buffer2);
    }

    @NotNull
    public static final long[] decodeToLongArray(@NotNull byte[] $this$decodeToLongArray) {
        Intrinsics.checkNotNullParameter((Object)$this$decodeToLongArray, (String)"<this>");
        return (long[])SignalStoreUtilsKt.convertTo($this$decodeToLongArray, 8, SignalStoreUtilsKt::decodeToLongArray$lambda$2);
    }

    @NotNull
    public static final byte[] encodeFromLongArray(@NotNull List<Long> $this$encodeFromLongArray) {
        Intrinsics.checkNotNullParameter($this$encodeFromLongArray, (String)"<this>");
        Buffer buffer = new Buffer();
        boolean bl = false;
        Iterator<Long> iterator = $this$encodeFromLongArray.iterator();
        while (iterator.hasNext()) {
            long v = ((Number)iterator.next()).longValue();
            buffer.writeLong(v);
        }
        return buffer.readByteArray();
    }

    @NotNull
    public static final List<TempSample> decodeToTempList(@NotNull byte[] $this$decodeToTempList) {
        Intrinsics.checkNotNullParameter((Object)$this$decodeToTempList, (String)"<this>");
        return (List)SignalStoreUtilsKt.convertTo($this$decodeToTempList, 16, SignalStoreUtilsKt::decodeToTempList$lambda$5);
    }

    @NotNull
    public static final byte[] encodeFromTempList(@NotNull List<TempSample> $this$encodeFromTempList) {
        Intrinsics.checkNotNullParameter($this$encodeFromTempList, (String)"<this>");
        Buffer buffer = new Buffer();
        boolean bl = false;
        for (TempSample d : $this$encodeFromTempList) {
            buffer.writeLong(d.getTimestamp());
            SignalStoreUtilsKt.writeFloat((BufferedSink)buffer, d.getT1());
            SignalStoreUtilsKt.writeFloat((BufferedSink)buffer, d.getT2());
        }
        return buffer.readByteArray();
    }

    @NotNull
    public static final List<Spo2Sample> decodeToSpo2List(@NotNull byte[] $this$decodeToSpo2List) {
        Intrinsics.checkNotNullParameter((Object)$this$decodeToSpo2List, (String)"<this>");
        return (List)SignalStoreUtilsKt.convertTo($this$decodeToSpo2List, 12, SignalStoreUtilsKt::decodeToSpo2List$lambda$8);
    }

    @NotNull
    public static final byte[] encodeFromSpo2List(@NotNull List<Spo2Sample> $this$encodeFromSpo2List) {
        Intrinsics.checkNotNullParameter($this$encodeFromSpo2List, (String)"<this>");
        Buffer buffer = new Buffer();
        boolean bl = false;
        for (Spo2Sample v : $this$encodeFromSpo2List) {
            buffer.writeLong(v.getTimestamp());
            SignalStoreUtilsKt.writeFloat((BufferedSink)buffer, v.getValue());
        }
        return buffer.readByteArray();
    }

    @NotNull
    public static final List<CapnoSample> decodeToCapnoList(@NotNull byte[] $this$decodeToCapnoList) {
        Intrinsics.checkNotNullParameter((Object)$this$decodeToCapnoList, (String)"<this>");
        return (List)SignalStoreUtilsKt.convertTo($this$decodeToCapnoList, 11, SignalStoreUtilsKt::decodeToCapnoList$lambda$11);
    }

    @NotNull
    public static final byte[] encodeFromCapnoList(@NotNull List<CapnoSample> $this$encodeFromCapnoList) {
        Intrinsics.checkNotNullParameter($this$encodeFromCapnoList, (String)"<this>");
        Buffer buffer = new Buffer();
        boolean bl = false;
        for (CapnoSample d : $this$encodeFromCapnoList) {
            buffer.writeLong(d.getTimestamp());
            buffer.writeByte(d.getInspiredCO2());
            buffer.writeByte(d.getEtCO2());
            buffer.writeByte(d.getRespRate());
        }
        return buffer.readByteArray();
    }

    private static final long[] decodeToLongArray$lambda$2(int samples2, Buffer buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        int n = 0;
        long[] lArray = new long[samples2];
        while (n < samples2) {
            int n2 = n++;
            lArray[n2] = buffer.readLong();
        }
        return lArray;
    }

    private static final List decodeToTempList$lambda$5(int samples2, Buffer buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        ArrayList<TempSample> arrayList = new ArrayList<TempSample>(samples2);
        int n = 0;
        while (n < samples2) {
            int n2;
            int n3 = n2 = n++;
            ArrayList<TempSample> arrayList2 = arrayList;
            boolean bl = false;
            long timeout = buffer.readLong();
            float t1 = SignalStoreUtilsKt.readFloat((BufferedSource)buffer);
            float t2 = SignalStoreUtilsKt.readFloat((BufferedSource)buffer);
            arrayList2.add(new TempSample(timeout, t1, t2, 0.0f, 0.0f, 24, null));
        }
        return arrayList;
    }

    private static final List decodeToSpo2List$lambda$8(int samples2, Buffer buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        ArrayList<Spo2Sample> arrayList = new ArrayList<Spo2Sample>(samples2);
        int n = 0;
        while (n < samples2) {
            int n2;
            int n3 = n2 = n++;
            ArrayList<Spo2Sample> arrayList2 = arrayList;
            boolean bl = false;
            long timestamp = buffer.readLong();
            float value = SignalStoreUtilsKt.readFloat((BufferedSource)buffer);
            arrayList2.add(new Spo2Sample(timestamp, value));
        }
        return arrayList;
    }

    private static final List decodeToCapnoList$lambda$11(int samples2, Buffer buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        ArrayList<CapnoSample> arrayList = new ArrayList<CapnoSample>(samples2);
        int n = 0;
        while (n < samples2) {
            int n2;
            int n3 = n2 = n++;
            ArrayList<CapnoSample> arrayList2 = arrayList;
            boolean bl = false;
            long timestamp = buffer.readLong();
            byte inspiredCO2 = buffer.readByte();
            byte etCO2 = buffer.readByte();
            byte respRate = buffer.readByte();
            arrayList2.add(new CapnoSample(timestamp, (int)inspiredCO2, (int)etCO2, (int)respRate));
        }
        return arrayList;
    }
}

