/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.signalstore;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.ULong;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import org.jetbrains.annotations.NotNull;
import vet.inpulse.shared.utils.collections.CollectionsUtilsKt;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000Z\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0010\u0016\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0006\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\n\u0010\u0005\u001a\u00020\u0004*\u00020\u0006\u001a\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u001a\u001c\u0010\r\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\u00022\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\u000e\u001a\u001c\u0010\u000f\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\u00022\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\u000e\u001a\u0016\u0010\u0007\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u0011\u001a\u000e\u0010\u0012\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\b\u001a\u0016\u0010\u0013\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0003\u001a\u00020\f\u001aH\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\b\b\u0002\u0010\u0016\u001a\u00020\u00172\b\b\u0002\u0010\u0018\u001a\u00020\u00172\b\b\u0002\u0010\u0019\u001a\u00020\u00172\b\b\u0002\u0010\u001a\u001a\u00020\u00172\b\b\u0002\u0010\u001b\u001a\u00020\u0017\u001a\u0016\u0010\u001c\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u0017\u001aH\u0010\u001f\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\b\b\u0002\u0010\u0016\u001a\u00020\u00172\b\b\u0002\u0010\u0018\u001a\u00020\u00172\b\b\u0002\u0010\u0019\u001a\u00020\u00172\b\b\u0002\u0010\u001a\u001a\u00020\u00172\b\b\u0002\u0010\u001b\u001a\u00020\u0017\u001a\u0016\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00172\u0006\u0010#\u001a\u00020$\u001a4\u0010%\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u00022\u0006\u0010&\u001a\u00020\u00112\b\b\u0002\u0010'\u001a\u00020\u00172\b\b\u0002\u0010\u001b\u001a\u00020\u00172\b\b\u0002\u0010(\u001a\u00020\u0017\u001a\u001e\u0010)\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u0006\u00a8\u0006*"}, d2={"writeVarint", "", "Lokio/BufferedSink;", "input", "", "readVarint", "Lokio/BufferedSource;", "encode", "", "buffer", "Lokio/Buffer;", "data", "", "encodeLongs", "", "differentialCompressLongs", "sink", "", "decode", "differentialCompression", "", "output", "inputOffset", "", "inputStride", "outputOffset", "outputStride", "length", "differentialDecompression", "source", "size", "differentialDecompressLongs", "byteOfFloat", "", "i", "f", "", "deconstructFloatArray", "array", "offset", "stride", "reconstructFloatArray", "signal-store"})
@SourceDebugExtension(value={"SMAP\nCompressor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Compressor.kt\nvet/inpulse/signalstore/CompressorKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,202:1\n1#2:203\n*E\n"})
public final class CompressorKt {
    public static final void writeVarint(@NotNull BufferedSink $this$writeVarint, long input) {
        Intrinsics.checkNotNullParameter((Object)$this$writeVarint, (String)"<this>");
        long uLong = ULong.constructor-impl((long)input);
        int size = Long.compareUnsigned(uLong, ULong.constructor-impl((long)((long)127 & 0xFFFFFFFFL))) <= 0 ? 1 : (Long.compareUnsigned(uLong, ULong.constructor-impl((long)((long)262143 & 0xFFFFFFFFL))) <= 0 ? 2 : (Long.compareUnsigned(uLong, ULong.constructor-impl((long)((long)0x1FFFFF & 0xFFFFFFFFL))) <= 0 ? 3 : (Long.compareUnsigned(uLong, ULong.constructor-impl((long)((long)0xFFFFFFF & 0xFFFFFFFFL))) <= 0 ? 4 : (Long.compareUnsigned(uLong, 0x7FFFFFFFFL) <= 0 ? 5 : (Long.compareUnsigned(uLong, 0x3FFFFFFFFFFL) <= 0 ? 6 : (Long.compareUnsigned(uLong, 0x1FFFFFFFFFFFFL) <= 0 ? 7 : (Long.compareUnsigned(uLong, 0xFFFFFFFFFFFFFFL) <= 0 ? 8 : (Long.compareUnsigned(uLong, Long.MAX_VALUE) <= 0 ? 9 : 10))))))));
        for (int i = 0; i < size; ++i) {
            long mask = ULong.constructor-impl((long)(127L << i * 7));
            long l = ULong.constructor-impl((long)(ULong.constructor-impl((long)(uLong & mask)) >>> i * 7));
            if (i != size - 1) {
                l = ULong.constructor-impl((long)(l | 0x80L));
            }
            $this$writeVarint.writeByte((int)((byte)l));
        }
    }

    public static final long readVarint(@NotNull BufferedSource $this$readVarint) {
        Intrinsics.checkNotNullParameter((Object)$this$readVarint, (String)"<this>");
        long output = 0L;
        for (int i = 0; i < 10; ++i) {
            long l = ULong.constructor-impl((long)(ULong.constructor-impl((long)$this$readVarint.readByte()) & 0xFFL));
            long masked = ULong.constructor-impl((long)(l & 0x7FL));
            output = ULong.constructor-impl((long)(output | ULong.constructor-impl((long)(masked << 7 * i))));
            if (ULong.constructor-impl((long)(l & 0x80L)) != 128L) break;
        }
        return output;
    }

    @NotNull
    public static final byte[] encode(@NotNull Buffer buffer, @NotNull int[] data) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        for (int i : data) {
            buffer.writeInt(i);
        }
        return buffer.readByteArray();
    }

    public static final void encodeLongs(@NotNull BufferedSink buffer, @NotNull List<Long> data) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        Intrinsics.checkNotNullParameter(data, (String)"data");
        Iterator<Long> iterator = data.iterator();
        while (iterator.hasNext()) {
            long i = ((Number)iterator.next()).longValue();
            buffer.writeLong(i);
        }
    }

    public static final void differentialCompressLongs(@NotNull BufferedSink buffer, @NotNull List<Long> data) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        Intrinsics.checkNotNullParameter(data, (String)"data");
        if (!(!((Collection)data).isEmpty())) {
            boolean bl = false;
            String string = "input must not be empty";
            throw new IllegalArgumentException(string.toString());
        }
        long first = ((Number)CollectionsKt.first(data)).longValue();
        buffer.writeLong(first);
        long last = first;
        int n = data.size();
        for (int i = 1; i < n; ++i) {
            long cur = ((Number)data.get(i)).longValue();
            long diff = cur - last;
            last = cur;
            CompressorKt.writeVarint(buffer, diff);
        }
    }

    public static final void encode(@NotNull BufferedSink sink, @NotNull float[] data) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        for (float v : data) {
            int i = Float.floatToIntBits(v);
            sink.writeInt(i);
        }
    }

    @NotNull
    public static final int[] decode(@NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Buffer buffer = new Buffer();
        buffer.write(data);
        int outputSize = (int)Math.floor((float)data.length / 4.0f);
        int[] output = new int[outputSize];
        for (int i = 0; i < outputSize; ++i) {
            output[i] = buffer.readInt();
        }
        return output;
    }

    public static final void differentialCompression(@NotNull BufferedSink sink, @NotNull int[] input) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        if (!(!(input.length == 0))) {
            boolean $i$a$-require-CompressorKt$differentialCompression$22 = false;
            String $i$a$-require-CompressorKt$differentialCompression$22 = "input must not be empty";
            throw new IllegalArgumentException($i$a$-require-CompressorKt$differentialCompression$22.toString());
        }
        int first = ArraysKt.first((int[])input);
        sink.writeInt(first);
        int last = first;
        int n = input.length;
        for (int i = 1; i < n; ++i) {
            int cur = input[i];
            int diff = cur - last;
            last = cur;
            CompressorKt.writeVarint(sink, diff);
        }
    }

    public static final void differentialCompressLongs(@NotNull long[] input, @NotNull long[] output, int inputOffset, int inputStride, int outputOffset, int outputStride, int length) {
        long value;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        if (!(length > 0)) {
            boolean bl = false;
            String string = "length must be positive";
            throw new IllegalArgumentException(string.toString());
        }
        output[outputOffset] = value = input[inputOffset];
        for (int i = 1; i < length; ++i) {
            long diff;
            int inIdx = inputOffset + i * inputStride;
            int outIdx = outputOffset + i * outputStride;
            long curr = input[inIdx];
            output[outIdx] = diff = curr - value;
            value = curr;
        }
    }

    public static /* synthetic */ void differentialCompressLongs$default(long[] lArray, long[] lArray2, int n, int n2, int n3, int n4, int n5, int n6, Object object) {
        if ((n6 & 4) != 0) {
            n = 0;
        }
        if ((n6 & 8) != 0) {
            n2 = 1;
        }
        if ((n6 & 0x10) != 0) {
            n3 = 0;
        }
        if ((n6 & 0x20) != 0) {
            n4 = 1;
        }
        if ((n6 & 0x40) != 0) {
            n5 = lArray.length;
        }
        CompressorKt.differentialCompressLongs(lArray, lArray2, n, n2, n3, n4, n5);
    }

    @NotNull
    public static final int[] differentialDecompression(@NotNull BufferedSource source, int size) {
        int first;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        int[] decompressed = new int[size];
        decompressed[0] = first = source.readInt();
        for (int i = 1; i < size; ++i) {
            long read = CompressorKt.readVarint(source);
            long next = (long)decompressed[i - 1] + read;
            decompressed[i] = (int)next;
        }
        return decompressed;
    }

    public static final void differentialDecompressLongs(@NotNull long[] input, @NotNull long[] output, int inputOffset, int inputStride, int outputOffset, int outputStride, int length) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        output[outputOffset] = input[inputOffset];
        for (int i = 1; i < length; ++i) {
            long next;
            int inputIdx = inputOffset + i * inputStride;
            int outputIdx = outputOffset + i * outputStride;
            long read = input[inputIdx];
            output[i] = next = output[outputIdx - outputStride] + read;
        }
    }

    public static /* synthetic */ void differentialDecompressLongs$default(long[] lArray, long[] lArray2, int n, int n2, int n3, int n4, int n5, int n6, Object object) {
        if ((n6 & 4) != 0) {
            n = 0;
        }
        if ((n6 & 8) != 0) {
            n2 = 1;
        }
        if ((n6 & 0x10) != 0) {
            n3 = 0;
        }
        if ((n6 & 0x20) != 0) {
            n4 = 1;
        }
        if ((n6 & 0x40) != 0) {
            n5 = lArray.length;
        }
        CompressorKt.differentialDecompressLongs(lArray, lArray2, n, n2, n3, n4, n5);
    }

    public static final byte byteOfFloat(int i, float f) {
        int raw = Float.floatToRawIntBits(f);
        int shift = (3 - i) * 8;
        int mask = 255 << shift;
        int n = (raw & mask) >> shift;
        return (byte)n;
    }

    public static final void deconstructFloatArray(@NotNull BufferedSink sink, @NotNull float[] array, int offset, int length, int stride) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        for (int pos = 0; pos < 4; ++pos) {
            for (int i = 0; i < length; ++i) {
                int index = offset + i * stride;
                byte by = CompressorKt.byteOfFloat(pos, array[index]);
                sink.writeByte((int)by);
            }
        }
    }

    public static /* synthetic */ void deconstructFloatArray$default(BufferedSink bufferedSink, float[] fArray, int n, int n2, int n3, int n4, Object object) {
        if ((n4 & 4) != 0) {
            n = 0;
        }
        if ((n4 & 8) != 0) {
            n2 = fArray.length;
        }
        if ((n4 & 0x10) != 0) {
            n3 = 1;
        }
        CompressorKt.deconstructFloatArray(bufferedSink, fArray, n, n2, n3);
    }

    public static final void reconstructFloatArray(@NotNull float[] output, int size, @NotNull BufferedSource source) {
        BufferedSource bufferedSource;
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        BufferedSource src0 = source.peek();
        BufferedSource it = bufferedSource = source.peek();
        boolean bl = false;
        it.skip((long)size);
        BufferedSource src1 = bufferedSource;
        BufferedSource it2 = it = source.peek();
        boolean bl2 = false;
        it2.skip((long)size * 2L);
        BufferedSource src2 = it;
        BufferedSource it3 = it2 = source.peek();
        boolean bl3 = false;
        it3.skip((long)size * 3L);
        BufferedSource src3 = it2;
        for (int i = 0; i < size; ++i) {
            byte b0 = src0.readByte();
            byte b1 = src1.readByte();
            byte b2 = src2.readByte();
            byte b3 = src3.readByte();
            output[i] = CollectionsUtilsKt.floatFromBytes((byte)b0, (byte)b1, (byte)b2, (byte)b3);
        }
        source.skip((long)size * 4L);
    }
}

