/*
 * Decompiled with CFR 0.152.
 */
package com.multiplatform.webview.web;

import co.touchlab.kermit.BaseLogger;
import co.touchlab.kermit.Logger;
import co.touchlab.kermit.Severity;
import com.multiplatform.webview.request.RequestInterceptor;
import com.multiplatform.webview.request.WebRequest;
import com.multiplatform.webview.request.WebRequestInterceptResult;
import com.multiplatform.webview.util.KLogger;
import com.multiplatform.webview.web.IWebView;
import com.multiplatform.webview.web.LoadingState;
import com.multiplatform.webview.web.WebViewError;
import com.multiplatform.webview.web.WebViewNavigator;
import com.multiplatform.webview.web.WebViewState;
import dev.datlag.kcef.KCEFBrowser;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.cef.CefSettings;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefFrame;
import org.cef.handler.CefDisplayHandler;
import org.cef.handler.CefLoadHandler;
import org.cef.handler.CefRequestHandler;
import org.cef.handler.CefRequestHandlerAdapter;
import org.cef.network.CefRequest;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u0002H\u0000\u001a\u0014\u0010\u0003\u001a\u00020\u0004*\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u001a\u001c\u0010\u0007\u001a\u00020\u0004*\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0000\u001a\u001c\u0010\n\u001a\u00020\u0004*\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0000\u00a8\u0006\f"}, d2={"getCurrentUrl", "", "Lorg/cef/browser/CefBrowser;", "addDisplayHandler", "", "state", "Lcom/multiplatform/webview/web/WebViewState;", "addLoadListener", "navigator", "Lcom/multiplatform/webview/web/WebViewNavigator;", "addRequestHandler", "Ldev/datlag/kcef/KCEFBrowser;", "webview"})
public final class WebEngineExtKt {
    @Nullable
    public static final String getCurrentUrl(@NotNull CefBrowser $this$getCurrentUrl) {
        Intrinsics.checkNotNullParameter((Object)$this$getCurrentUrl, (String)"<this>");
        return $this$getCurrentUrl.getURL();
    }

    public static final void addDisplayHandler(@NotNull CefBrowser $this$addDisplayHandler, @NotNull WebViewState state) {
        Intrinsics.checkNotNullParameter((Object)$this$addDisplayHandler, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        $this$addDisplayHandler.getClient().addDisplayHandler(new CefDisplayHandler(state, $this$addDisplayHandler){
            final /* synthetic */ WebViewState $state;
            final /* synthetic */ CefBrowser $this_addDisplayHandler;
            {
                this.$state = $state;
                this.$this_addDisplayHandler = $receiver;
            }

            /*
             * WARNING - void declaration
             */
            public void onAddressChange(CefBrowser browser, CefFrame frame, String url) {
                void this_$iv$iv;
                Logger $this$iv = KLogger.INSTANCE;
                Throwable throwable$iv = null;
                String tag$iv = $this$iv.getTag();
                boolean $i$f$d = false;
                BaseLogger baseLogger = (BaseLogger)$this$iv;
                Severity severity$iv$iv = Severity.Debug;
                boolean $i$f$logBlock = false;
                if (this_$iv$iv.getConfig().getMinSeverity().compareTo((Enum)severity$iv$iv) <= 0) {
                    Throwable throwable = throwable$iv;
                    String string2 = tag$iv;
                    Severity severity = severity$iv$iv;
                    void var12_14 = this_$iv$iv;
                    boolean bl = false;
                    String string3 = "onAddressChange: " + url;
                    var12_14.processLog(severity, string2, throwable, string3);
                }
                this.$state.setLastLoadedUrl$webview(WebEngineExtKt.getCurrentUrl(this.$this_addDisplayHandler));
            }

            /*
             * WARNING - void declaration
             */
            public void onTitleChange(CefBrowser browser, String title) {
                void this_$iv$iv;
                double givenZoomLevel = this.$state.getWebSettings().getZoomLevel();
                double percentage = givenZoomLevel * 100.0;
                double realZoomLevel = (percentage - 100.0) / 25.0;
                Logger $this$iv = KLogger.INSTANCE;
                Throwable throwable$iv = null;
                String tag$iv = $this$iv.getTag();
                boolean $i$f$d = false;
                BaseLogger baseLogger = (BaseLogger)$this$iv;
                Severity severity$iv$iv = Severity.Debug;
                boolean $i$f$logBlock = false;
                if (this_$iv$iv.getConfig().getMinSeverity().compareTo((Enum)severity$iv$iv) <= 0) {
                    Throwable throwable = throwable$iv;
                    String string2 = tag$iv;
                    Severity severity = severity$iv$iv;
                    void var17_16 = this_$iv$iv;
                    boolean bl = false;
                    String string3 = "titleProperty: " + title;
                    var17_16.processLog(severity, string2, throwable, string3);
                }
                this.$this_addDisplayHandler.setZoomLevel(realZoomLevel);
                this.$state.setPageTitle$webview(title);
            }

            public void onFullscreenModeChange(CefBrowser p0, boolean p1) {
            }

            public boolean onTooltip(CefBrowser browser, String text) {
                return false;
            }

            public void onStatusMessage(CefBrowser browser, String value) {
            }

            public boolean onConsoleMessage(CefBrowser browser, CefSettings.LogSeverity level, String message, String source, int line) {
                return false;
            }

            public boolean onCursorChange(CefBrowser browser, int cursorType) {
                return false;
            }
        });
    }

    public static final void addLoadListener(@NotNull CefBrowser $this$addLoadListener, @NotNull WebViewState state, @NotNull WebViewNavigator navigator) {
        Intrinsics.checkNotNullParameter((Object)$this$addLoadListener, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)navigator, (String)"navigator");
        $this$addLoadListener.getClient().addLoadHandler(new CefLoadHandler(state, $this$addLoadListener, navigator){
            private String lastLoadedUrl;
            final /* synthetic */ WebViewState $state;
            final /* synthetic */ CefBrowser $this_addLoadListener;
            final /* synthetic */ WebViewNavigator $navigator;
            {
                this.$state = $state;
                this.$this_addLoadListener = $receiver;
                this.$navigator = $navigator;
                this.lastLoadedUrl = "null";
            }

            /*
             * WARNING - void declaration
             */
            public void onLoadingStateChange(CefBrowser browser, boolean isLoading, boolean canGoBack, boolean canGoForward) {
                void this_$iv$iv;
                void $this$iv;
                Logger logger = KLogger.INSTANCE;
                CefBrowser cefBrowser = this.$this_addLoadListener;
                Throwable throwable$iv = null;
                String tag$iv = $this$iv.getTag();
                boolean $i$f$d = false;
                BaseLogger baseLogger = (BaseLogger)$this$iv;
                Severity severity$iv$iv = Severity.Debug;
                boolean $i$f$logBlock = false;
                if (this_$iv$iv.getConfig().getMinSeverity().compareTo((Enum)severity$iv$iv) <= 0) {
                    Throwable throwable = throwable$iv;
                    String string2 = tag$iv;
                    Severity severity = severity$iv$iv;
                    void var14_16 = this_$iv$iv;
                    boolean bl = false;
                    String string3 = "onLoadingStateChange: " + cefBrowser.getURL() + ", " + isLoading + " " + canGoBack + " " + canGoForward;
                    var14_16.processLog(severity, string2, throwable, string3);
                }
                if (isLoading) {
                    this.$state.setLoadingState$webview(LoadingState.Initializing.INSTANCE);
                } else {
                    this.$state.setLoadingState$webview(LoadingState.Finished.INSTANCE);
                    if (this.$this_addLoadListener.getURL() != null && !Intrinsics.areEqual((Object)this.$this_addLoadListener.getURL(), (Object)this.lastLoadedUrl)) {
                        IWebView iWebView = this.$state.getWebView$webview();
                        if (iWebView != null) {
                            iWebView.injectJsBridge();
                        }
                        String string4 = this.$this_addLoadListener.getURL();
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getURL(...)");
                        this.lastLoadedUrl = string4;
                    }
                }
                this.$navigator.setCanGoBack$webview(canGoBack);
                this.$navigator.setCanGoForward$webview(canGoForward);
            }

            /*
             * WARNING - void declaration
             */
            public void onLoadStart(CefBrowser browser, CefFrame frame, CefRequest.TransitionType transitionType) {
                void this_$iv$iv;
                Logger $this$iv = KLogger.INSTANCE;
                Throwable throwable$iv = null;
                String tag$iv = $this$iv.getTag();
                boolean $i$f$d = false;
                BaseLogger baseLogger = (BaseLogger)$this$iv;
                Severity severity$iv$iv = Severity.Debug;
                boolean $i$f$logBlock = false;
                if (this_$iv$iv.getConfig().getMinSeverity().compareTo((Enum)severity$iv$iv) <= 0) {
                    Throwable throwable = throwable$iv;
                    String string2 = tag$iv;
                    Severity severity = severity$iv$iv;
                    void var12_14 = this_$iv$iv;
                    boolean bl = false;
                    CefBrowser cefBrowser = browser;
                    String string3 = "Load Start " + (cefBrowser != null ? cefBrowser.getURL() : null);
                    var12_14.processLog(severity, string2, throwable, string3);
                }
                this.lastLoadedUrl = "null";
                this.$state.setLoadingState$webview(new LoadingState.Loading(0.0f));
                this.$state.getErrorsForCurrentRequest().clear();
            }

            /*
             * WARNING - void declaration
             */
            public void onLoadEnd(CefBrowser browser, CefFrame frame, int httpStatusCode) {
                void this_$iv$iv;
                Logger $this$iv = KLogger.INSTANCE;
                Throwable throwable$iv = null;
                String tag$iv = $this$iv.getTag();
                boolean $i$f$d = false;
                BaseLogger baseLogger = (BaseLogger)$this$iv;
                Severity severity$iv$iv = Severity.Debug;
                boolean $i$f$logBlock = false;
                if (this_$iv$iv.getConfig().getMinSeverity().compareTo((Enum)severity$iv$iv) <= 0) {
                    Throwable throwable = throwable$iv;
                    String string2 = tag$iv;
                    Severity severity = severity$iv$iv;
                    void var12_14 = this_$iv$iv;
                    boolean bl = false;
                    CefBrowser cefBrowser = browser;
                    String string3 = "Load End " + (cefBrowser != null ? cefBrowser.getURL() : null);
                    var12_14.processLog(severity, string2, throwable, string3);
                }
                this.$state.setLoadingState$webview(LoadingState.Finished.INSTANCE);
                this.$navigator.setCanGoBack$webview(this.$this_addLoadListener.canGoBack());
                this.$navigator.setCanGoForward$webview(this.$this_addLoadListener.canGoForward());
                this.$state.setLastLoadedUrl$webview(WebEngineExtKt.getCurrentUrl(this.$this_addLoadListener));
            }

            /*
             * WARNING - void declaration
             */
            public void onLoadError(CefBrowser browser, CefFrame frame, CefLoadHandler.ErrorCode errorCode, String errorText, String failedUrl) {
                void this_$iv$iv;
                this.$state.setLoadingState$webview(LoadingState.Finished.INSTANCE);
                Logger $this$iv = KLogger.INSTANCE;
                Throwable throwable$iv = null;
                String tag$iv = $this$iv.getTag();
                boolean $i$f$i = false;
                BaseLogger baseLogger = (BaseLogger)$this$iv;
                Severity severity$iv$iv = Severity.Info;
                boolean $i$f$logBlock = false;
                if (this_$iv$iv.getConfig().getMinSeverity().compareTo((Enum)severity$iv$iv) <= 0) {
                    Throwable throwable = throwable$iv;
                    String string2 = tag$iv;
                    Severity severity = severity$iv$iv;
                    void var14_16 = this_$iv$iv;
                    boolean bl = false;
                    String string3 = "Failed to load url: " + errorCode + " " + failedUrl + "\n" + errorText;
                    var14_16.processLog(severity, string2, throwable, string3);
                }
                CefLoadHandler.ErrorCode errorCode2 = errorCode;
                CefFrame cefFrame = frame;
                this.$state.getErrorsForCurrentRequest().add((Object)new WebViewError(errorCode2 != null ? errorCode2.getCode() : 404, "Failed to load url: " + failedUrl + "\n" + errorText, cefFrame != null ? cefFrame.isMain() : false));
            }
        });
    }

    public static final void addRequestHandler(@NotNull KCEFBrowser $this$addRequestHandler, @NotNull WebViewState state, @NotNull WebViewNavigator navigator) {
        Intrinsics.checkNotNullParameter((Object)$this$addRequestHandler, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)navigator, (String)"navigator");
        $this$addRequestHandler.getClient().addRequestHandler((CefRequestHandler)new CefRequestHandlerAdapter(navigator){
            final /* synthetic */ WebViewNavigator $navigator;
            {
                this.$navigator = $navigator;
            }

            /*
             * WARNING - void declaration
             */
            public boolean onBeforeBrowse(CefBrowser browser, CefFrame frame, CefRequest request, boolean userGesture, boolean isRedirect) {
                RequestInterceptor requestInterceptor = this.$navigator.getRequestInterceptor();
                if (requestInterceptor != null) {
                    boolean bl;
                    WebRequest webRequest;
                    WebRequestInterceptResult interceptResult;
                    WebRequestInterceptResult webRequestInterceptResult;
                    void this_$iv$iv;
                    RequestInterceptor requestInterceptor2 = requestInterceptor;
                    WebViewNavigator webViewNavigator = this.$navigator;
                    RequestInterceptor $this$onBeforeBrowse_u24lambda_u242 = requestInterceptor2;
                    boolean bl2 = false;
                    Map map = new LinkedHashMap<K, V>();
                    CefRequest cefRequest = request;
                    if (cefRequest != null) {
                        cefRequest.getHeaderMap(map);
                    }
                    Logger $this$iv = KLogger.INSTANCE;
                    Throwable throwable$iv = null;
                    String tag$iv = $this$iv.getTag();
                    boolean $i$f$d = false;
                    BaseLogger baseLogger = (BaseLogger)$this$iv;
                    Severity severity$iv$iv = Severity.Debug;
                    boolean $i$f$logBlock = false;
                    if (this_$iv$iv.getConfig().getMinSeverity().compareTo((Enum)severity$iv$iv) <= 0) {
                        Throwable throwable = throwable$iv;
                        String string2 = tag$iv;
                        Severity severity = severity$iv$iv;
                        void var22_24 = this_$iv$iv;
                        boolean bl3 = false;
                        CefRequest cefRequest2 = request;
                        String string3 = "onBeforeBrowse " + (cefRequest2 != null ? cefRequest2.getURL() : null) + " " + map;
                        var22_24.processLog(severity, string2, throwable, string3);
                    }
                    CefRequest cefRequest3 = request;
                    String string4 = String.valueOf(cefRequest3 != null ? cefRequest3.getURL() : null);
                    CefFrame cefFrame = frame;
                    boolean bl4 = cefFrame != null ? cefFrame.isMain() : false;
                    Object object = request;
                    if (object == null || (object = object.getMethod()) == null) {
                        object = "GET";
                    }
                    if ((webRequestInterceptResult = (interceptResult = $this$onBeforeBrowse_u24lambda_u242.onInterceptUrlRequest(webRequest = new WebRequest(string4, map, bl4, isRedirect, (String)object), webViewNavigator))) instanceof WebRequestInterceptResult.Allow) {
                        bl = super.onBeforeBrowse(browser, frame, request, userGesture, isRedirect);
                    } else if (webRequestInterceptResult instanceof WebRequestInterceptResult.Reject) {
                        bl = true;
                    } else if (webRequestInterceptResult instanceof WebRequestInterceptResult.Modify) {
                        WebRequest webRequest2;
                        WebRequest $this$onBeforeBrowse_u24lambda_u242_u24lambda_u241 = webRequest2 = ((WebRequestInterceptResult.Modify)interceptResult).getRequest();
                        boolean bl5 = false;
                        webViewNavigator.loadUrl($this$onBeforeBrowse_u24lambda_u242_u24lambda_u241.getUrl(), $this$onBeforeBrowse_u24lambda_u242_u24lambda_u241.getHeaders());
                        bl = true;
                    } else {
                        throw new NoWhenBranchMatchedException();
                    }
                    return bl;
                }
                return super.onBeforeBrowse(browser, frame, request, userGesture, isRedirect);
            }
        });
    }
}

