/*
 * Decompiled with CFR 0.152.
 */
package com.multiplatform.webview.util;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u0010\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\u001a\u0006\u0010\u0004\u001a\u00020\u0005\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0006"}, d2={"tempDirectory", "Ljava/io/File;", "getTempDirectory", "()Ljava/io/File;", "addTempDirectoryRemovalHook", "", "webview"})
public final class TempDirectoryKt {
    @NotNull
    private static final File tempDirectory;

    @NotNull
    public static final File getTempDirectory() {
        return tempDirectory;
    }

    public static final void addTempDirectoryRemovalHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(TempDirectoryKt::addTempDirectoryRemovalHook$lambda$0));
    }

    private static final void addTempDirectoryRemovalHook$lambda$0() {
        System.out.println((Object)("Attempting to delete temp directory: " + tempDirectory.getAbsolutePath()));
        boolean success = FilesKt.deleteRecursively((File)tempDirectory);
        if (success) {
            System.out.println((Object)"\u2705 Temp directory deleted successfully.");
        } else {
            System.out.println((Object)"\u274c Failed to delete temp directory.");
        }
    }

    static {
        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
        Path path = Files.createTempDirectory("webview-temp", Arrays.copyOf(fileAttributeArray, fileAttributeArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"createTempDirectory(...)");
        File file = path.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        tempDirectory = file;
    }
}

