/*
 * Decompiled with CFR 0.152.
 */
package com.multiplatform.webview.jsbridge;

import androidx.compose.runtime.Immutable;
import com.multiplatform.webview.jsbridge.IJsMessageHandler;
import com.multiplatform.webview.jsbridge.JsMessage;
import com.multiplatform.webview.web.WebViewNavigator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0001\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007J.\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\t0\u0011J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0006J\u000e\u0010\u0015\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007J\u0006\u0010\u0016\u001a\u00020\tR\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/multiplatform/webview/jsbridge/JsMessageDispatcher;", "", "<init>", "()V", "jsHandlerMap", "", "", "Lcom/multiplatform/webview/jsbridge/IJsMessageHandler;", "registerJSHandler", "", "handler", "dispatch", "message", "Lcom/multiplatform/webview/jsbridge/JsMessage;", "navigator", "Lcom/multiplatform/webview/web/WebViewNavigator;", "callback", "Lkotlin/Function1;", "canHandle", "", "id", "unregisterJSHandler", "clear", "webview"})
@Immutable
public final class JsMessageDispatcher {
    @NotNull
    private final Map<String, IJsMessageHandler> jsHandlerMap = new LinkedHashMap();
    public static final int $stable;

    public final void registerJSHandler(@NotNull IJsMessageHandler handler2) {
        Intrinsics.checkNotNullParameter((Object)handler2, (String)"handler");
        this.jsHandlerMap.put(handler2.methodName(), handler2);
    }

    public final void dispatch(@NotNull JsMessage message, @Nullable WebViewNavigator navigator, @NotNull Function1<? super String, Unit> callback) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Intrinsics.checkNotNullParameter(callback, (String)"callback");
            IJsMessageHandler iJsMessageHandler = this.jsHandlerMap.get(message.getMethodName());
            if (iJsMessageHandler == null) break block0;
            iJsMessageHandler.handle(message, navigator, callback);
        }
    }

    public static /* synthetic */ void dispatch$default(JsMessageDispatcher jsMessageDispatcher, JsMessage jsMessage, WebViewNavigator webViewNavigator, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            webViewNavigator = null;
        }
        jsMessageDispatcher.dispatch(jsMessage, webViewNavigator, (Function1<? super String, Unit>)function1);
    }

    public final boolean canHandle(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return this.jsHandlerMap.containsKey(id);
    }

    public final void unregisterJSHandler(@NotNull IJsMessageHandler handler2) {
        Intrinsics.checkNotNullParameter((Object)handler2, (String)"handler");
        this.jsHandlerMap.remove(handler2.methodName());
    }

    public final void clear() {
        this.jsHandlerMap.clear();
    }
}

