/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.types;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.freedesktop.dbus.Marshalling;
import org.freedesktop.dbus.types.Variant;

public final class VariantBuilder {
    private final Class<?> baseClass;
    private final List<Class<?>> genericTypes = new ArrayList();

    private VariantBuilder(Class<?> _baseClass) {
        this.baseClass = _baseClass;
    }

    public static VariantBuilder of(Class<?> _clz) {
        return new VariantBuilder(Objects.requireNonNull(_clz, "Class required"));
    }

    public VariantBuilder withGenericTypes(Class<?> ... _clz) {
        if (_clz == null || _clz.length == 0) {
            return this;
        }
        this.genericTypes.addAll(Arrays.asList(_clz));
        return this;
    }

    public <X> Variant<X> create(X _data) {
        Objects.requireNonNull(_data, "No data given");
        if (!this.baseClass.isAssignableFrom(_data.getClass())) {
            throw new IllegalArgumentException("Given data is not compatible with defined Variant base class");
        }
        StringBuilder sb = new StringBuilder();
        boolean isMap = false;
        if (Map.class.isAssignableFrom(this.baseClass)) {
            sb.append("a").append("{");
            isMap = true;
        } else {
            sb.append(Marshalling.convertJavaClassesToSignature(this.baseClass));
        }
        this.genericTypes.stream().map(xva$0 -> Marshalling.convertJavaClassesToSignature(xva$0)).forEach(sb::append);
        if (isMap) {
            sb.append("}");
        }
        return new Variant<X>(_data, sb.toString());
    }
}

