/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus;

import java.util.Objects;

public class DBusPath
implements Comparable<DBusPath> {
    private final String source;
    private String path;

    public DBusPath(String _source, String _path) {
        this.source = _source;
        this.path = _path;
    }

    public DBusPath(String _path) {
        this(null, _path);
    }

    public String getPath() {
        return this.path;
    }

    @Deprecated(forRemoval=true, since="5.1.1 - 2024-11-16")
    public void setPath(String _path) {
        this.path = _path;
    }

    public String getSource() {
        return this.source;
    }

    public String toString() {
        return this.getPath();
    }

    public int hashCode() {
        return Objects.hash(this.source, this.path);
    }

    public boolean equals(Object _obj) {
        if (this == _obj) {
            return true;
        }
        if (_obj == null || this.getClass() != _obj.getClass()) {
            return false;
        }
        DBusPath dbusPath = (DBusPath)_obj;
        return Objects.equals(this.path, dbusPath.path) && Objects.equals(this.source, dbusPath.source);
    }

    @Override
    public int compareTo(DBusPath _that) {
        if (this.getPath() == null || _that == null) {
            return 0;
        }
        return this.getPath().compareTo(_that.getPath());
    }

    public static DBusPath of(String ... _parts) {
        if (_parts == null || _parts.length == 0) {
            throw new IllegalArgumentException("No Strings given to build DBusPath");
        }
        String pathStr = _parts[0].indexOf(47) == 0 ? "" : "/" + String.join((CharSequence)"/", _parts);
        return new DBusPath(pathStr);
    }
}

