/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.app.shared.utils.signal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import vet.inpulse.math.SignalUtilsKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0010\u0007\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a\"\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0001\u001a\u0012\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\b*\u00020\u0002H\u0002\u001a\"\u0010\t\u001a\u00020\u0004*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0001\u001a\"\u0010\n\u001a\u00020\u0004*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0001\u001a\u001a\u0010\u000b\u001a\u00020\u0004*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004\u001a\u001a\u0010\f\u001a\u00020\u0004*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004\u001a\u001c\u0010\r\u001a\u00020\u000e*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u001a\u0017\u0010\u000f\u001a\u00020\u0010*\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0012\u001a\u0019\u0010\u0013\u001a\u00020\u0004*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0016"}, d2={"getMaximumAbsoluteValue", "", "", "fromIndex", "", "toIndex", "ref", "getPeakIndexes", "", "getIndexFromMaximumValueFromReference", "getIndexFromMinimumValueFromReference", "getIndexFromMaximumValue", "getIndexFromMinimumValue", "validateIndexes", "", "sampleIndexToDuration", "Lkotlin/time/Duration;", "samplingFrequency", "(IF)J", "toSampleIndexes", "toSampleIndexes-VtjQ1oo", "(JF)I", "shared"})
@SourceDebugExtension(value={"SMAP\nMathUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MathUtils.kt\nvet/inpulse/app/shared/utils/signal/MathUtilsKt\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,173:1\n4057#2:174\n4171#2:175\n13920#2,2:176\n4172#2,2:178\n13922#2:180\n4174#2:181\n1563#3:182\n1634#3,3:183\n1999#3,14:186\n1#4:200\n*S KotlinDebug\n*F\n+ 1 MathUtils.kt\nvet/inpulse/app/shared/utils/signal/MathUtilsKt\n*L\n26#1:174\n26#1:175\n26#1:176,2\n26#1:178,2\n26#1:180\n26#1:181\n29#1:182\n29#1:183,3\n30#1:186,14\n*E\n"})
public final class MathUtilsKt {
    /*
     * WARNING - void declaration
     */
    public static final float getMaximumAbsoluteValue(@NotNull float[] $this$getMaximumAbsoluteValue, int fromIndex, int toIndex, float ref) {
        float f;
        Object v2;
        void $this$maxByOrNull$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        void $this$filterIndexedTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$getMaximumAbsoluteValue, (String)"<this>");
        int startIndex = Math.min(fromIndex, toIndex);
        int endIndex = Math.max(fromIndex, toIndex);
        MathUtilsKt.validateIndexes($this$getMaximumAbsoluteValue, startIndex, endIndex);
        float[] $this$filterIndexed$iv = $this$getMaximumAbsoluteValue;
        boolean $i$f$filterIndexed22 = false;
        float[] fArray = $this$filterIndexed$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIndexedTo = false;
        void $this$forEachIndexed$iv$iv$iv = $this$filterIndexedTo$iv$iv;
        boolean $i$f$forEachIndexed = false;
        int index$iv$iv$iv = 0;
        for (void item$iv$iv$iv : $this$forEachIndexed$iv$iv$iv) {
            void element$iv$iv;
            int n = index$iv$iv$iv++;
            void var18_31 = item$iv$iv$iv;
            int index$iv$iv = n;
            boolean bl = false;
            int index = index$iv$iv;
            boolean bl2 = false;
            boolean bl3 = startIndex <= index ? index <= endIndex : false;
            if (!bl3) continue;
            destination$iv$iv.add(Float.valueOf((float)element$iv$iv));
        }
        float[] data = CollectionsKt.toFloatArray((Collection)((List)destination$iv$iv));
        Iterable $i$f$filterIndexed22 = MathUtilsKt.getPeakIndexes(data);
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            int n = ((Number)item$iv$iv).intValue();
            Collection collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(Float.valueOf(data[it]));
        }
        $this$map$iv = (List)destination$iv$iv2;
        boolean $i$f$maxByOrNull = false;
        Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v2 = null;
        } else {
            Object maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v2 = maxElem$iv;
            } else {
                float it = ((Number)maxElem$iv).floatValue();
                boolean bl = false;
                float maxValue$iv = Math.abs(it - ref);
                do {
                    Object e$iv = iterator$iv.next();
                    float it2 = ((Number)e$iv).floatValue();
                    $i$a$-maxByOrNull-MathUtilsKt$getMaximumAbsoluteValue$2 = false;
                    float v$iv = Math.abs(it2 - ref);
                    if (Float.compare(maxValue$iv, v$iv) >= 0) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v2 = maxElem$iv;
            }
        }
        Float f2 = v2;
        if (f2 != null) {
            f = f2.floatValue();
        } else {
            float[] $this$getMaximumAbsoluteValue_u24lambda_u243 = $this$getMaximumAbsoluteValue;
            boolean bl = false;
            float max = ArraysKt.maxOrThrow((float[])data);
            float min = ArraysKt.minOrThrow((float[])data);
            f = Math.abs(max - ref) >= Math.abs(min - ref) ? max : min;
        }
        return f;
    }

    private static final List<Integer> getPeakIndexes(float[] $this$getPeakIndexes) {
        float[] derived = SignalUtilsKt.diff((float[])$this$getPeakIndexes, (int)1);
        List peaksIndexes = new ArrayList();
        int i = 0;
        int n = derived.length - 2;
        if (i <= n) {
            while (true) {
                float v1 = derived[i];
                float v2 = derived[i + 1];
                if (v1 < 0.0f && v2 > 0.0f) {
                    peaksIndexes.add(i + 1);
                } else if (v1 > 0.0f && v2 < 0.0f) {
                    peaksIndexes.add(i + 1);
                }
                if (i == n) break;
                ++i;
            }
        }
        return peaksIndexes;
    }

    public static final int getIndexFromMaximumValueFromReference(@NotNull float[] $this$getIndexFromMaximumValueFromReference, int fromIndex, int toIndex, float ref) {
        Intrinsics.checkNotNullParameter((Object)$this$getIndexFromMaximumValueFromReference, (String)"<this>");
        int startIndex = Math.min(fromIndex, toIndex);
        int endIndex = Math.max(fromIndex, toIndex);
        MathUtilsKt.validateIndexes($this$getIndexFromMaximumValueFromReference, startIndex, endIndex);
        float maxValue = $this$getIndexFromMaximumValueFromReference[startIndex] - ref;
        int peakIndex = startIndex;
        int index = startIndex;
        if (index <= endIndex) {
            while (true) {
                float value;
                if ((value = $this$getIndexFromMaximumValueFromReference[index] - ref) > maxValue) {
                    maxValue = value;
                    peakIndex = index;
                }
                if (index == endIndex) break;
                ++index;
            }
        }
        return peakIndex;
    }

    public static final int getIndexFromMinimumValueFromReference(@NotNull float[] $this$getIndexFromMinimumValueFromReference, int fromIndex, int toIndex, float ref) {
        Intrinsics.checkNotNullParameter((Object)$this$getIndexFromMinimumValueFromReference, (String)"<this>");
        int startIndex = Math.min(fromIndex, toIndex);
        int endIndex = Math.max(fromIndex, toIndex);
        MathUtilsKt.validateIndexes($this$getIndexFromMinimumValueFromReference, startIndex, endIndex);
        float minValue = $this$getIndexFromMinimumValueFromReference[startIndex] - ref;
        int peakIndex = startIndex;
        int index = startIndex;
        if (index <= endIndex) {
            while (true) {
                float value;
                if ((value = $this$getIndexFromMinimumValueFromReference[index] - ref) < minValue) {
                    minValue = value;
                    peakIndex = index;
                }
                if (index == endIndex) break;
                ++index;
            }
        }
        return peakIndex;
    }

    public static final int getIndexFromMaximumValue(@NotNull float[] $this$getIndexFromMaximumValue, int fromIndex, int toIndex) {
        Intrinsics.checkNotNullParameter((Object)$this$getIndexFromMaximumValue, (String)"<this>");
        int startIndex = Math.min(fromIndex, toIndex);
        int endIndex = Math.max(fromIndex, toIndex);
        MathUtilsKt.validateIndexes($this$getIndexFromMaximumValue, startIndex, endIndex);
        float maxValue = Float.MIN_VALUE;
        int peakIndex = startIndex;
        int i = startIndex;
        if (i <= endIndex) {
            while (true) {
                float value;
                if ((value = $this$getIndexFromMaximumValue[i]) > maxValue) {
                    maxValue = value;
                    peakIndex = i;
                }
                if (i == endIndex) break;
                ++i;
            }
        }
        return peakIndex;
    }

    public static final int getIndexFromMinimumValue(@NotNull float[] $this$getIndexFromMinimumValue, int fromIndex, int toIndex) {
        Intrinsics.checkNotNullParameter((Object)$this$getIndexFromMinimumValue, (String)"<this>");
        int startIndex = Math.min(fromIndex, toIndex);
        int endIndex = Math.max(fromIndex, toIndex);
        MathUtilsKt.validateIndexes($this$getIndexFromMinimumValue, startIndex, endIndex);
        float minValue = Float.MAX_VALUE;
        int peakIndex = startIndex;
        int i = startIndex;
        if (i <= endIndex) {
            while (true) {
                float value;
                if ((value = $this$getIndexFromMinimumValue[i]) < minValue) {
                    minValue = value;
                    peakIndex = i;
                }
                if (i == endIndex) break;
                ++i;
            }
        }
        return peakIndex;
    }

    private static final void validateIndexes(float[] $this$validateIndexes, int fromIndex, int toIndex) {
        if (!($this$validateIndexes.length >= 2)) {
            boolean $i$a$-require-MathUtilsKt$validateIndexes$52 = false;
            String $i$a$-require-MathUtilsKt$validateIndexes$52 = "The array must have at least two elements";
            throw new IllegalArgumentException($i$a$-require-MathUtilsKt$validateIndexes$52.toString());
        }
        if (!(fromIndex >= 0)) {
            boolean $i$a$-require-MathUtilsKt$validateIndexes$62 = false;
            String $i$a$-require-MathUtilsKt$validateIndexes$62 = "The fromIndex must be greater than or equal to 0";
            throw new IllegalArgumentException($i$a$-require-MathUtilsKt$validateIndexes$62.toString());
        }
        if (!(toIndex < $this$validateIndexes.length)) {
            boolean $i$a$-require-MathUtilsKt$validateIndexes$72 = false;
            String $i$a$-require-MathUtilsKt$validateIndexes$72 = "The toIndex must be less than the array size";
            throw new IllegalArgumentException($i$a$-require-MathUtilsKt$validateIndexes$72.toString());
        }
        if (!(fromIndex <= toIndex)) {
            boolean bl = false;
            String string2 = "The fromIndex must be less than or equal to the toIndex";
            throw new IllegalArgumentException(string2.toString());
        }
    }

    public static final long sampleIndexToDuration(int $this$sampleIndexToDuration, float samplingFrequency) {
        return DurationKt.toDuration((long)((long)((float)$this$sampleIndexToDuration * 1000000.0f / samplingFrequency)), (DurationUnit)DurationUnit.MICROSECONDS);
    }

    public static final int toSampleIndexes-VtjQ1oo(long l, float samplingFrequency) {
        return MathKt.roundToInt((float)((float)Duration.getInWholeMilliseconds-impl((long)l) * samplingFrequency / (float)1000));
    }
}

