/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.app.shared.utils;

import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import vet.inpulse.krafiks.KrafiksChart;
import vet.inpulse.krafiks.WaveformScrollState;
import vet.inpulse.krafiks.WaveformViewState;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u001a\u001a\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004\u001a\u0012\u0010\u0006\u001a\u00020\u0004*\u00020\u00072\u0006\u0010\b\u001a\u00020\u0004\u001a\u0012\u0010\t\u001a\u00020\u0004*\u00020\u00072\u0006\u0010\b\u001a\u00020\u0004\u001a\u001a\u0010\n\u001a\u00020\u0004*\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0004\u001a\"\u0010\r\u001a\u00020\u0004*\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004\u00a8\u0006\u000e"}, d2={"resizeScroll2", "", "Lvet/inpulse/krafiks/WaveformViewState;", "width", "", "height", "getHorizontalStartVisibleIndex", "Lvet/inpulse/krafiks/WaveformScrollState;", "dataMaxSize", "getHorizontalEndVisibleIndex", "getVerticalStartVisibleIndex", "verticalGraphLines", "laneSize", "getVerticalEndVisibleIndex", "shared"})
public final class KrafiksUtilsKt {
    public static final void resizeScroll2(@NotNull WaveformViewState $this$resizeScroll2, int width, int height) {
        WaveformScrollState vert;
        Intrinsics.checkNotNullParameter((Object)$this$resizeScroll2, (String)"<this>");
        WaveformScrollState hor = $this$resizeScroll2.getHorizontalScrollState();
        if (hor != null) {
            float contentSize;
            Float f;
            Iterator iterator = ((Iterable)$this$resizeScroll2.getCharts()).iterator();
            if (!iterator.hasNext()) {
                f = null;
            } else {
                KrafiksChart it = (KrafiksChart)iterator.next();
                boolean bl = false;
                float f2 = it.getPosX() + it.getSizeX();
                while (iterator.hasNext()) {
                    KrafiksChart it22 = (KrafiksChart)iterator.next();
                    $i$a$-maxOfOrNull-KrafiksUtilsKt$resizeScroll2$contentSize$1 = false;
                    float it22 = it22.getPosX() + it22.getSizeX();
                    f2 = Math.max(f2, it22);
                }
                f = Float.valueOf(f2);
            }
            float f3 = contentSize = f != null ? f.floatValue() : 0.0f;
            if (contentSize > 0.0f) {
                KrafiksUtilsKt.resizeScroll2$updateSize(hor, width, (int)Math.ceil(contentSize));
            }
        }
        if ((vert = $this$resizeScroll2.getVerticalScrollState()) != null) {
            float contentSize;
            Float f;
            Iterator iterator = ((Iterable)$this$resizeScroll2.getCharts()).iterator();
            if (!iterator.hasNext()) {
                f = null;
            } else {
                KrafiksChart it = (KrafiksChart)iterator.next();
                boolean bl = false;
                float f4 = it.getPosY() + Math.abs(it.getSizeY() * (float)2) - Math.abs(it.getSizeY());
                while (iterator.hasNext()) {
                    KrafiksChart it2 = (KrafiksChart)iterator.next();
                    $i$a$-maxOfOrNull-KrafiksUtilsKt$resizeScroll2$contentSize$2 = false;
                    float f5 = it2.getPosY() + Math.abs(it2.getSizeY() * (float)2) - Math.abs(it2.getSizeY());
                    f4 = Math.max(f4, f5);
                }
                f = Float.valueOf(f4);
            }
            float f6 = contentSize = f != null ? f.floatValue() : 0.0f;
            if (contentSize > 0.0f) {
                KrafiksUtilsKt.resizeScroll2$updateSize(vert, height, (int)Math.ceil(contentSize));
            }
        }
    }

    public static final int getHorizontalStartVisibleIndex(@NotNull WaveformScrollState $this$getHorizontalStartVisibleIndex, int dataMaxSize) {
        Intrinsics.checkNotNullParameter((Object)$this$getHorizontalStartVisibleIndex, (String)"<this>");
        if ($this$getHorizontalStartVisibleIndex.getContentSize() == 0) {
            return 0;
        }
        float scrollFactor = (float)$this$getHorizontalStartVisibleIndex.getScrollPosition() / (float)$this$getHorizontalStartVisibleIndex.getContentSize();
        return RangesKt.coerceAtLeast((int)MathKt.roundToInt((float)((float)dataMaxSize * scrollFactor)), (int)0);
    }

    public static final int getHorizontalEndVisibleIndex(@NotNull WaveformScrollState $this$getHorizontalEndVisibleIndex, int dataMaxSize) {
        Intrinsics.checkNotNullParameter((Object)$this$getHorizontalEndVisibleIndex, (String)"<this>");
        if ($this$getHorizontalEndVisibleIndex.getContentSize() == 0) {
            return 0;
        }
        float scrollFactor = (float)($this$getHorizontalEndVisibleIndex.getScrollPosition() + $this$getHorizontalEndVisibleIndex.getViewportSize()) / (float)$this$getHorizontalEndVisibleIndex.getContentSize();
        return RangesKt.coerceAtMost((int)MathKt.roundToInt((float)((float)dataMaxSize * scrollFactor)), (int)(dataMaxSize - 1));
    }

    public static final int getVerticalStartVisibleIndex(@NotNull WaveformScrollState $this$getVerticalStartVisibleIndex, int verticalGraphLines, int laneSize) {
        Intrinsics.checkNotNullParameter((Object)$this$getVerticalStartVisibleIndex, (String)"<this>");
        if ((float)$this$getVerticalStartVisibleIndex.getViewportSize() <= 0.0f) {
            return 0;
        }
        int laneHeight = $this$getVerticalStartVisibleIndex.getViewportSize() / verticalGraphLines;
        int firstLineOnScreen = $this$getVerticalStartVisibleIndex.getScrollPosition() / laneHeight;
        return RangesKt.coerceAtLeast((int)(laneSize * firstLineOnScreen), (int)0);
    }

    public static final int getVerticalEndVisibleIndex(@NotNull WaveformScrollState $this$getVerticalEndVisibleIndex, int verticalGraphLines, int laneSize, int dataMaxSize) {
        Intrinsics.checkNotNullParameter((Object)$this$getVerticalEndVisibleIndex, (String)"<this>");
        if ((float)$this$getVerticalEndVisibleIndex.getViewportSize() <= 0.0f) {
            return 0;
        }
        int laneHeight = $this$getVerticalEndVisibleIndex.getViewportSize() / verticalGraphLines;
        int lastLineOnScreen = $this$getVerticalEndVisibleIndex.getScrollPosition() / laneHeight + verticalGraphLines;
        return RangesKt.coerceAtMost((int)(laneSize * lastLineOnScreen), (int)(dataMaxSize - 1));
    }

    private static final void resizeScroll2$updateSize(WaveformScrollState scrollState, int side, int contentSize) {
        WaveformScrollState $this$resizeScroll2_u24updateSize_u24lambda_u240 = scrollState;
        boolean bl = false;
        $this$resizeScroll2_u24updateSize_u24lambda_u240.setViewportSize(side);
        $this$resizeScroll2_u24updateSize_u24lambda_u240.setContentSize(contentSize);
        $this$resizeScroll2_u24updateSize_u24lambda_u240.setMax(RangesKt.coerceAtLeast((int)(contentSize - side), (int)0));
        if ($this$resizeScroll2_u24updateSize_u24lambda_u240.getScrollPosition() > $this$resizeScroll2_u24updateSize_u24lambda_u240.getMax()) {
            $this$resizeScroll2_u24updateSize_u24lambda_u240.setScrollPosition($this$resizeScroll2_u24updateSize_u24lambda_u240.getMax());
        } else if ($this$resizeScroll2_u24updateSize_u24lambda_u240.getViewportSize() > $this$resizeScroll2_u24updateSize_u24lambda_u240.getContentSize()) {
            $this$resizeScroll2_u24updateSize_u24lambda_u240.setScrollPosition(0);
        }
    }
}

