/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.app.shared.utils;

import androidx.compose.runtime.internal.StabilityInferred;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vet.inpulse.app.shared.utils.EmailValidator_sharedJvmKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0007J\u0018\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0016\u001a\u00020\u0005J\u0018\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0005H\u0002J\u0010\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u0007H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lvet/inpulse/app/shared/utils/EmailValidator;", "", "<init>", "()V", "MAX_LOCAL_PART_LENGTH", "", "LOCAL_PART_ATOM", "", "LOCAL_PART_INSIDE_QUOTES_ATOM", "LOCAL_PART_REGEX", "Lkotlin/text/Regex;", "MAX_DOMAIN_PART_LENGTH", "DOMAIN_CHARS_BASE", "STANDARD_DOMAIN_LABEL", "TLD_LABEL", "HOSTNAME_DOMAIN", "IP_DOMAIN", "IP_V6_DOMAIN", "EMAIL_DOMAIN_REGEX", "isValidEmail", "", "value", "maxEmailLocalPartLength", "isValidEmailLocalPart", "localPart", "isValidEmailDomainAddress", "domain", "shared"})
@StabilityInferred(parameters=0)
public final class EmailValidator {
    @NotNull
    public static final EmailValidator INSTANCE = new EmailValidator();
    public static final int MAX_LOCAL_PART_LENGTH = 64;
    @NotNull
    private static final String LOCAL_PART_ATOM = "[a-z0-9!#$%&'*+/=?^_`{|}~\u0080-\uffff-]";
    @NotNull
    private static final String LOCAL_PART_INSIDE_QUOTES_ATOM = "(?:[a-z0-9!#$%&'*.(),<>\\[\\]:;@+/=?^_`{|}~\u0080-\uffff-]|\\\\\\\\|\\\\\\\")";
    @NotNull
    private static final Regex LOCAL_PART_REGEX = new Regex("(?:[a-z0-9!#$%&'*+/=?^_`{|}~\u0080-\uffff-]+|\"(?:[a-z0-9!#$%&'*.(),<>\\[\\]:;@+/=?^_`{|}~\u0080-\uffff-]|\\\\\\\\|\\\\\\\")+\")(?:\\.(?:[a-z0-9!#$%&'*+/=?^_`{|}~\u0080-\uffff-]+|\"(?:[a-z0-9!#$%&'*.(),<>\\[\\]:;@+/=?^_`{|}~\u0080-\uffff-]|\\\\\\\\|\\\\\\\")+\"))*", RegexOption.IGNORE_CASE);
    public static final int MAX_DOMAIN_PART_LENGTH = 255;
    @NotNull
    private static final String DOMAIN_CHARS_BASE = "a-z0-9\u0080-\uffff";
    @NotNull
    private static final String STANDARD_DOMAIN_LABEL = "[a-z0-9\u0080-\uffff](?:[a-z0-9\u0080-\uffff-]{0,61}[a-z0-9\u0080-\uffff])?";
    @NotNull
    private static final String TLD_LABEL = "(?:[a-z\u0080-\uffff]{2,}|xn--[a-z0-9-]{2,})";
    @NotNull
    private static final String HOSTNAME_DOMAIN = "(?:[a-z0-9\u0080-\uffff](?:[a-z0-9\u0080-\uffff-]{0,61}[a-z0-9\u0080-\uffff])?\\.)+(?:[a-z\u0080-\uffff]{2,}|xn--[a-z0-9-]{2,})";
    @NotNull
    private static final String IP_DOMAIN = "\\[[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\]";
    @NotNull
    private static final String IP_V6_DOMAIN = "\\[IPv6:(?:(?:[0-9a-fA-F]{1,4}:){7,7}[0-9a-fA-F]{1,4}|(?:[0-9a-fA-F]{1,4}:){1,7}:|(?:[0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|(?:[0-9a-fA-F]{1,4}:){1,5}(?::[0-9a-fA-F]{1,4}){1,2}|(?:[0-9a-fA-F]{1,4}:){1,4}(?::[0-9a-fA-F]{1,4}){1,3}|(?:[0-9a-fA-F]{1,4}:){1,3}(?::[0-9a-fA-F]{1,4}){1,4}|(?:[0-9a-fA-F]{1,4}:){1,2}(?::[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:(?:(?::[0-9a-fA-F]{1,4}){1,6})|:(?:(?::[0-9a-fA-F]{1,4}){1,7}|:)|fe80:(?::[0-9a-fA-F]{0,4}){0,4}%[0-9a-zA-Z]{1,}|::(?:ffff(:0{1,4}){0,1}:){0,1}(?:(?:25[0-5]|(?:2[0-4]|1{0,1}[0-9]){0,1}[0-9])\\.){3,3}(?:25[0-5]|(?:2[0-4]|1{0,1}[0-9]){0,1}[0-9])|(?:[0-9a-fA-F]{1,4}:){1,4}:(?:(?:25[0-5]|(?:2[0-4]|1{0,1}[0-9]){0,1}[0-9])\\.){3,3}(?:25[0-5]|(?:2[0-4]|1{0,1}[0-9]){0,1}[0-9]))\\]";
    @NotNull
    private static final Regex EMAIL_DOMAIN_REGEX = new Regex("(?:[a-z0-9\u0080-\uffff](?:[a-z0-9\u0080-\uffff-]{0,61}[a-z0-9\u0080-\uffff])?\\.)+(?:[a-z\u0080-\uffff]{2,}|xn--[a-z0-9-]{2,})|\\[[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\]|\\[IPv6:(?:(?:[0-9a-fA-F]{1,4}:){7,7}[0-9a-fA-F]{1,4}|(?:[0-9a-fA-F]{1,4}:){1,7}:|(?:[0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|(?:[0-9a-fA-F]{1,4}:){1,5}(?::[0-9a-fA-F]{1,4}){1,2}|(?:[0-9a-fA-F]{1,4}:){1,4}(?::[0-9a-fA-F]{1,4}){1,3}|(?:[0-9a-fA-F]{1,4}:){1,3}(?::[0-9a-fA-F]{1,4}){1,4}|(?:[0-9a-fA-F]{1,4}:){1,2}(?::[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:(?:(?::[0-9a-fA-F]{1,4}){1,6})|:(?:(?::[0-9a-fA-F]{1,4}){1,7}|:)|fe80:(?::[0-9a-fA-F]{0,4}){0,4}%[0-9a-zA-Z]{1,}|::(?:ffff(:0{1,4}){0,1}:){0,1}(?:(?:25[0-5]|(?:2[0-4]|1{0,1}[0-9]){0,1}[0-9])\\.){3,3}(?:25[0-5]|(?:2[0-4]|1{0,1}[0-9]){0,1}[0-9])|(?:[0-9a-fA-F]{1,4}:){1,4}:(?:(?:25[0-5]|(?:2[0-4]|1{0,1}[0-9]){0,1}[0-9])\\.){3,3}(?:25[0-5]|(?:2[0-4]|1{0,1}[0-9]){0,1}[0-9]))\\]", RegexOption.IGNORE_CASE);
    public static final int $stable = 8;

    private EmailValidator() {
    }

    public final boolean isValidEmail(@Nullable String value) {
        return this.isValidEmail(value, 64);
    }

    public final boolean isValidEmail(@Nullable String value, int maxEmailLocalPartLength) {
        CharSequence charSequence = value;
        if (charSequence == null || charSequence.length() == 0) {
            return false;
        }
        int splitPosition = StringsKt.lastIndexOf$default((CharSequence)value, (char)'@', (int)0, (boolean)false, (int)6, null);
        if (splitPosition < 1) {
            return false;
        }
        String string2 = value.substring(0, splitPosition);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        String localPart = string2;
        String string3 = value.substring(splitPosition + 1);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        String domainPart = string3;
        if (((CharSequence)domainPart).length() == 0) {
            return false;
        }
        if (!this.isValidEmailLocalPart(localPart, maxEmailLocalPartLength)) {
            return false;
        }
        return this.isValidEmailDomainAddress(domainPart);
    }

    private final boolean isValidEmailLocalPart(String localPart, int maxEmailLocalPartLength) {
        if (localPart.length() > maxEmailLocalPartLength) {
            return false;
        }
        return LOCAL_PART_REGEX.matches((CharSequence)localPart);
    }

    private final boolean isValidEmailDomainAddress(String domain) {
        if (StringsKt.endsWith$default((String)domain, (String)".", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)domain, (String)"-", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)domain, (String)"-", (boolean)false, (int)2, null)) {
            return false;
        }
        if (!EMAIL_DOMAIN_REGEX.matches((CharSequence)domain)) {
            return false;
        }
        String string2 = EmailValidator_sharedJvmKt.toAsciiPlatform(domain);
        if (string2 == null) {
            return false;
        }
        String asciiString = string2;
        return asciiString.length() <= 255;
    }
}

