/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.app.shared.nibp.charts;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import vet.inpulse.app.shared.nibp.charts.OscillometryChartData;
import vet.inpulse.core.models.record_data.BloodPressureIndex;
import vet.inpulse.core.models.record_data.BloodPressureIndexes;
import vet.inpulse.core.models.record_data.NibpCalculatorOutput;
import vet.inpulse.sigproc.filters.FilterCoeff;
import vet.inpulse.sigproc.filters.IIR;
import vet.inpulse.sigproc.filters.IIR_TYPE;
import vet.inpulse.sigproc.filters.SimpleFilter;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u0001*\u00060\u0002j\u0002`\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u001a&\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\b0\u0007\"\u0004\b\u0000\u0010\b*\b\u0012\u0004\u0012\u0002H\b0\u00072\u0006\u0010\t\u001a\u00020\u0005H\u0002\u001a(\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0007*\b\u0012\u0004\u0012\u00020\u000b0\u00072\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u000bH\u0002\u001a\u0014\u0010\u0006\u001a\u00020\r*\u00020\r2\u0006\u0010\t\u001a\u00020\u0005H\u0002\u00a8\u0006\u000e"}, d2={"toOscillometryChart", "Lvet/inpulse/app/shared/nibp/charts/OscillometryChartData;", "Lvet/inpulse/core/models/record_data/NibpCalculatorOutput$Success;", "Lvet/inpulse/app/shared/nibp/viewModels/FullNibpData;", "downsamplingFactor", "", "downsample", "", "T", "factor", "downsampleWithFilter", "", "originalFs", "Lvet/inpulse/core/models/record_data/BloodPressureIndexes;", "shared"})
@SourceDebugExtension(value={"SMAP\nNibpChartData.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NibpChartData.kt\nvet/inpulse/app/shared/nibp/charts/NibpChartDataKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,75:1\n785#2:76\n796#2:77\n1878#2,2:78\n797#2,2:80\n1880#2:82\n799#2:83\n1563#2:84\n1634#2,3:85\n*S KotlinDebug\n*F\n+ 1 NibpChartData.kt\nvet/inpulse/app/shared/nibp/charts/NibpChartDataKt\n*L\n51#1:76\n51#1:77\n51#1:78,2\n51#1:80,2\n51#1:82\n51#1:83\n63#1:84\n63#1:85,3\n*E\n"})
public final class NibpChartDataKt {
    @NotNull
    public static final OscillometryChartData toOscillometryChart(@NotNull NibpCalculatorOutput.Success $this$toOscillometryChart, int downsamplingFactor) {
        Intrinsics.checkNotNullParameter((Object)$this$toOscillometryChart, (String)"<this>");
        float originalFs = 600.0f;
        return downsamplingFactor > 1 ? new OscillometryChartData(NibpChartDataKt.downsampleWithFilter($this$toOscillometryChart.getOscillometry(), downsamplingFactor, originalFs), NibpChartDataKt.downsampleWithFilter($this$toOscillometryChart.getEnvelope(), downsamplingFactor, originalFs), NibpChartDataKt.downsampleWithFilter($this$toOscillometryChart.getDeflation(), downsamplingFactor, originalFs), originalFs / (float)downsamplingFactor, NibpChartDataKt.downsample($this$toOscillometryChart.getBloodPressureIndexes(), downsamplingFactor), $this$toOscillometryChart.getProcedureDuration-UwyO8pc(), $this$toOscillometryChart.getDeflationDuration-UwyO8pc(), $this$toOscillometryChart.getMeanSlope(), null) : new OscillometryChartData($this$toOscillometryChart.getOscillometry(), $this$toOscillometryChart.getEnvelope(), $this$toOscillometryChart.getDeflation(), originalFs, $this$toOscillometryChart.getBloodPressureIndexes(), $this$toOscillometryChart.getProcedureDuration-UwyO8pc(), $this$toOscillometryChart.getDeflationDuration-UwyO8pc(), $this$toOscillometryChart.getMeanSlope(), null);
    }

    public static /* synthetic */ OscillometryChartData toOscillometryChart$default(NibpCalculatorOutput.Success success, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 1;
        }
        return NibpChartDataKt.toOscillometryChart(success, n);
    }

    /*
     * WARNING - void declaration
     */
    private static final <T> List<T> downsample(List<? extends T> $this$downsample, int factor) {
        void $this$filterIndexedTo$iv$iv;
        Iterable $this$filterIndexed$iv = $this$downsample;
        boolean $i$f$filterIndexed = false;
        Iterable iterable = $this$filterIndexed$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIndexedTo = false;
        void $this$forEachIndexed$iv$iv$iv = $this$filterIndexedTo$iv$iv;
        boolean $i$f$forEachIndexed = false;
        int index$iv$iv$iv = 0;
        for (Object item$iv$iv$iv : $this$forEachIndexed$iv$iv$iv) {
            void element$iv$iv;
            int n;
            if ((n = index$iv$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Object t = item$iv$iv$iv;
            int index$iv$iv = n;
            boolean bl = false;
            int index = index$iv$iv;
            boolean bl2 = false;
            if (!(index % factor == 0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<Float> downsampleWithFilter(List<Float> $this$downsampleWithFilter, int factor, float originalFs) {
        void $this$mapTo$iv$iv;
        if ($this$downsampleWithFilter.isEmpty()) {
            return $this$downsampleWithFilter;
        }
        float filterFreq = originalFs / (float)factor / 2.0f;
        FilterCoeff coeffs = IIR.INSTANCE.butter(2, filterFreq, filterFreq, MathKt.roundToInt((float)originalFs), IIR_TYPE.LOW_PASS);
        SimpleFilter filter2 = new SimpleFilter(MathKt.roundToInt((float)originalFs), coeffs);
        Iterable $this$map$iv = $this$downsampleWithFilter;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            float f = ((Number)item$iv$iv).floatValue();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Float.valueOf(filter2.filterData((float)it)));
        }
        return NibpChartDataKt.downsample((List)destination$iv$iv, factor);
    }

    private static final BloodPressureIndexes downsample(BloodPressureIndexes $this$downsample, int factor) {
        return $this$downsample.copy-wd1_05E(BloodPressureIndex.Systolic.constructor-impl((int)($this$downsample.getSystolic-gl8i1mk() / factor)), BloodPressureIndex.Mean.constructor-impl((int)($this$downsample.getMean-8HJK8HE() / factor)), BloodPressureIndex.Diastolic.constructor-impl((int)($this$downsample.getDiastolic-YiW0ZXM() / factor)));
    }
}

