/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.app.shared.analysis.qtc;

import androidx.compose.runtime.internal.StabilityInferred;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import vet.inpulse.app.shared.analysis.qtc.QtcCalculator;
import vet.inpulse.app.shared.utils.CollectionUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u00060\u0005j\u0002`\u00072\u0010\u0010\b\u001a\f\u0012\b\u0012\u00060\u0005j\u0002`\u00070\tH\u0016\u00a8\u0006\n"}, d2={"Lvet/inpulse/app/shared/analysis/qtc/VanDeWaterQtcCalculator;", "Lvet/inpulse/app/shared/analysis/qtc/QtcCalculator;", "<init>", "()V", "calculateQtc", "", "qt", "Lvet/inpulse/core/models/model/TimeDeltaInMs;", "previousRR", "", "shared"})
@StabilityInferred(parameters=1)
public final class VanDeWaterQtcCalculator
implements QtcCalculator {
    @NotNull
    public static final VanDeWaterQtcCalculator INSTANCE = new VanDeWaterQtcCalculator();
    public static final int $stable;

    private VanDeWaterQtcCalculator() {
    }

    @Override
    public float calculateQtc(float qt, @NotNull List<Float> previousRR) {
        Intrinsics.checkNotNullParameter(previousRR, (String)"previousRR");
        List<Float> last9Rrs = CollectionsKt.asReversed(previousRR).subList(0, RangesKt.coerceAtMost((int)9, (int)previousRR.size()));
        float median9LastRr = !((Collection)last9Rrs).isEmpty() ? CollectionUtilsKt.median(last9Rrs) : 1000.0f;
        double qtc = (double)qt - 0.087 * (double)(median9LastRr - 1000.0f);
        return (float)qtc;
    }
}

