/*
 * Decompiled with CFR 0.152.
 */
package org.cef.browser.mac;

import com.jetbrains.cef.JdkEx;
import java.awt.Component;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.cef.browser.CefBrowserWindow;
import sun.awt.AWTAccessor;

public class CefBrowserWindowMac
implements CefBrowserWindow {
    @Override
    public long getWindowHandle(Component comp) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException, ClassNotFoundException {
        long[] result = new long[1];
        while (comp != null) {
            if (comp.isLightweight()) {
                comp = comp.getParent();
                continue;
            }
            if (JdkEx.WindowHandleAccessor.isEnabled()) {
                return JdkEx.WindowHandleAccessor.getWindowHandle(comp);
            }
            Object peer = AWTAccessor.getComponentAccessor().getPeer(comp);
            Class<?> lw = Class.forName("sun.lwawt.LWComponentPeer");
            if (lw.isInstance(peer)) {
                Method platformWindowMethod = lw.getMethod("getPlatformWindow", new Class[0]);
                Object pWindow = platformWindowMethod.invoke(lw.cast(peer), new Object[0]);
                Class<?> cPlatformWindow = Class.forName("sun.lwawt.macosx.CPlatformWindow");
                if (cPlatformWindow.isInstance(pWindow)) {
                    Class<?> nativeAction = Class.forName("sun.lwawt.macosx.CFRetainedResource$CFNativeAction");
                    Object nativeActionInstance = Proxy.newProxyInstance(nativeAction.getClassLoader(), new Class[]{nativeAction}, (InvocationHandler)new WindowInvocationHandler(ptr -> {
                        result[0] = ptr;
                    }));
                    Method execute = cPlatformWindow.getMethod("execute", nativeAction);
                    execute.invoke(pWindow, nativeActionInstance);
                    break;
                }
            }
            comp = comp.getParent();
        }
        return result[0];
    }

    private static class WindowInvocationHandler
    implements InvocationHandler {
        private final WindowInvocationResult callback;

        WindowInvocationHandler(WindowInvocationResult callback) {
            this.callback = callback;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            this.callback.run((Long)args[0]);
            return proxy;
        }
    }

    private static interface WindowInvocationResult {
        public void run(long var1);
    }
}

