/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cef.remote.router;

import com.jetbrains.cef.remote.CefServer;
import com.jetbrains.cef.remote.RpcExecutor;
import com.jetbrains.cef.remote.router.RemoteMessageRouterImpl;
import java.util.ArrayList;
import java.util.List;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefMessageRouter;
import org.cef.handler.CefMessageRouterHandler;
import org.cef.misc.CefLog;

public class RemoteMessageRouter
extends CefMessageRouter {
    private RemoteMessageRouterImpl myImpl;
    private final List<Runnable> myDelayedActions = new ArrayList<Runnable>();
    private volatile boolean myIsDisposed = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(Runnable nativeRunnable, String name) {
        List<Runnable> list = this.myDelayedActions;
        synchronized (list) {
            if (this.myIsDisposed) {
                return;
            }
            if (this.myImpl != null) {
                nativeRunnable.run();
            } else {
                CefLog.Debug("RemoteMessageRouter: %s: add delayed action %s", this, name);
                this.myDelayedActions.add(nativeRunnable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        List<Runnable> list = this.myDelayedActions;
        synchronized (list) {
            this.myIsDisposed = true;
            this.myDelayedActions.clear();
            if (this.myImpl != null) {
                this.myImpl.disposeOnServer();
            }
        }
    }

    @Override
    public boolean addHandler(CefMessageRouterHandler handler, boolean first) {
        this.execute(() -> this.myImpl.addHandler(handler, first), "addHandler");
        return true;
    }

    @Override
    public boolean removeHandler(CefMessageRouterHandler handler) {
        this.execute(() -> this.myImpl.removeHandler(handler), "removeHandler");
        return true;
    }

    @Override
    public void cancelPending(CefBrowser browser, CefMessageRouterHandler handler) {
        this.execute(() -> this.myImpl.cancelPending(browser, handler), "cancelPending");
    }

    public RemoteMessageRouter(CefMessageRouter.CefMessageRouterConfig config) {
        super(config);
        CefServer.instance().onConnected(() -> {
            RpcExecutor service = CefServer.instance().getService();
            if (!service.isValid()) {
                CefLog.Error("Trying to create RemoteMessageRouter when not connected to server.", new Object[0]);
            }
            this.myImpl = RemoteMessageRouterImpl.create(service, this.getMessageRouterConfig());
            List<Runnable> list = this.myDelayedActions;
            synchronized (list) {
                this.myDelayedActions.forEach(r -> r.run());
                this.myDelayedActions.clear();
                if (this.myIsDisposed && this.myImpl != null) {
                    this.myImpl.disposeOnServer();
                }
            }
        }, "MessageRouter_Create", true);
    }

    public RemoteMessageRouterImpl getImpl() {
        return this.myImpl;
    }
}

