/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cef.remote.network;

import com.jetbrains.cef.remote.network.RemotePostDataElement;
import com.jetbrains.cef.remote.thrift_codegen.PostData;
import com.jetbrains.cef.remote.thrift_codegen.PostDataElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.cef.misc.DebugFormatter;
import org.cef.network.CefPostData;
import org.cef.network.CefPostDataElement;

public class RemotePostData
extends CefPostData {
    private final PostData myPostData;
    private final List<CefPostDataElement> myElements = new ArrayList<CefPostDataElement>();

    public RemotePostData(PostData postData) {
        this.myPostData = postData;
        if (this.myPostData.elements != null) {
            this.myPostData.elements.forEach(e -> this.myElements.add(new RemotePostDataElement((PostDataElement)e)));
        }
    }

    @Override
    public void dispose() {
    }

    @Override
    public boolean isReadOnly() {
        return this.myPostData.isReadOnly;
    }

    public boolean hasExcludedElements() {
        return this.myPostData.hasExcludedElements;
    }

    @Override
    public int getElementCount() {
        return this.myPostData.elements == null ? 0 : this.myPostData.elements.size();
    }

    @Override
    public void getElements(Vector<CefPostDataElement> elements) {
        elements.addAll(this.myElements);
    }

    @Override
    public boolean removeElement(CefPostDataElement element) {
        return this.myElements.remove(element);
    }

    @Override
    public boolean addElement(CefPostDataElement element) {
        return this.myElements.add(element);
    }

    @Override
    public void removeElements() {
        this.myElements.clear();
    }

    static PostData toThriftWithMap(CefPostData postData) {
        boolean hasExcluded = postData instanceof RemotePostData ? ((RemotePostData)postData).hasExcludedElements() : false;
        PostData pd = new PostData(postData.isReadOnly(), hasExcluded);
        if (postData.getElementCount() > 0) {
            Vector<CefPostDataElement> elements = new Vector<CefPostDataElement>();
            postData.getElements(elements);
            ArrayList<PostDataElement> resElements = new ArrayList<PostDataElement>();
            elements.forEach(e -> resElements.add(RemotePostDataElement.toThriftWithMap(e)));
            pd.setElements(resElements);
        }
        return pd;
    }

    @Override
    public String toString() {
        return DebugFormatter.toString_PostData(null, this);
    }
}

