/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cef.remote;

import com.jetbrains.cef.remote.CefServer;
import com.jetbrains.cef.remote.RemoteClient;
import com.jetbrains.cef.remote.RpcExecutor;
import com.jetbrains.cef.remote.network.RemoteRequestContext;
import com.jetbrains.cef.remote.thrift_codegen.RObject;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import org.cef.CefClient;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefDevToolsClient;
import org.cef.browser.CefFrame;
import org.cef.browser.CefRequestContext;
import org.cef.callback.CefPdfPrintCallback;
import org.cef.callback.CefRunFileDialogCallback;
import org.cef.callback.CefStringVisitor;
import org.cef.handler.CefDialogHandler;
import org.cef.handler.CefNativeRenderHandler;
import org.cef.handler.CefRenderHandler;
import org.cef.handler.CefWindowHandler;
import org.cef.input.CefCompositionUnderline;
import org.cef.input.CefTouchEvent;
import org.cef.misc.CefLog;
import org.cef.misc.CefPdfPrintSettings;
import org.cef.misc.CefRange;
import org.cef.network.CefRequest;

public class RemoteBrowser
implements CefBrowser {
    private final RpcExecutor myService;
    private final RemoteClient myOwner;
    private final CefClient myCefClient;
    private final RemoteRequestContext myRequestContext;
    private volatile int myBid = -1;
    private String myUrl = null;
    private Component myComponent;
    private CefNativeRenderHandler myRender;
    private final AtomicBoolean myIsNativeBrowserCreationRequested = new AtomicBoolean(false);
    private volatile Boolean myIsNativeBrowserCreationStarted = false;
    private volatile boolean myIsNativeBrowserCreated = false;
    private volatile boolean myIsClosing = false;
    private volatile boolean myIsClosed = false;
    private volatile int myNativeBrowserIdentifier = Integer.MIN_VALUE;
    private final List<Runnable> myDelayedActions = new ArrayList<Runnable>();
    private int myFrameRate = 30;

    RemoteBrowser(RpcExecutor service, RemoteClient owner, CefClient cefClient, String url, RemoteRequestContext requestContext) {
        this.myService = service;
        this.myOwner = owner;
        this.myCefClient = cefClient;
        this.myUrl = url;
        this.myRequestContext = requestContext != null ? requestContext : new RemoteRequestContext();
    }

    public int getBid() {
        return this.myBid;
    }

    public int getCid() {
        return this.myOwner.getCid();
    }

    public RemoteClient getOwner() {
        return this.myOwner;
    }

    public boolean isNativeBrowserCreationStarted() {
        return this.myIsNativeBrowserCreationStarted;
    }

    public boolean isNativeBrowserCreated() {
        return this.myIsNativeBrowserCreated;
    }

    public int getNativeBrowserIdentifier() {
        return this.myNativeBrowserIdentifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setNativeBrowserCreated(int nativeBrowserIdentifier) {
        List<Runnable> list = this.myDelayedActions;
        synchronized (list) {
            this.myIsNativeBrowserCreated = true;
            this.myNativeBrowserIdentifier = nativeBrowserIdentifier;
            this.myDelayedActions.forEach(r -> r.run());
            this.myDelayedActions.clear();
        }
    }

    public void setComponent(Component component, CefNativeRenderHandler renderHandler) {
        this.myComponent = component;
        this.myRender = renderHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execWhenCreated(Runnable runnable, String name) {
        List<Runnable> list = this.myDelayedActions;
        synchronized (list) {
            if (this.myIsNativeBrowserCreated) {
                runnable.run();
            } else {
                CefLog.Debug("%s: add delayed action %s", this, name);
                this.myDelayedActions.add(runnable);
            }
        }
    }

    @Override
    public void createImmediately() {
        if (!this.myIsNativeBrowserCreationRequested.getAndSet(true)) {
            CefServer.instance().onConnected(this::requestBid, "requestBid", false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestBid() {
        Boolean bl = this.myIsNativeBrowserCreationStarted;
        synchronized (bl) {
            if (this.myIsClosing) {
                return;
            }
            this.myIsNativeBrowserCreationStarted = true;
            int hmask = this.myOwner.getHandlersMask() | (this.myRender == null ? 0 : RemoteClient.HandlerMasks.NativeRender.val());
            this.myService.exec(s -> {
                RObject contextHandler = new RObject(-1);
                if (this.myRequestContext.getRemoteHandler() != null) {
                    contextHandler = this.myRequestContext.getRemoteHandler().thriftId();
                }
                this.myBid = s.Browser_Create(this.myOwner.getCid(), hmask, contextHandler);
            });
            if (this.myBid >= 0) {
                this.myOwner.onNewBid(this);
                CefLog.Debug("Registered bid %d with handlers: %s", this.myBid, RemoteClient.HandlerMasks.toString(hmask));
                this.myService.exec(s -> s.Browser_StartNativeCreation(this.myBid, this.myUrl));
            } else {
                CefLog.Error("Can't obtain bid, createBrowser returns %d", this.myBid);
            }
        }
        if (this.myBid >= 0) {
            this.myRequestContext.setBid(this.myBid);
        }
    }

    @Override
    public Component getUIComponent() {
        return this.myComponent;
    }

    @Override
    public CefClient getClient() {
        return this.myCefClient;
    }

    @Override
    public CefRequestContext getRequestContext() {
        return this.myRequestContext;
    }

    @Override
    public CefRenderHandler getRenderHandler() {
        return this.myRender;
    }

    @Override
    public CefWindowHandler getWindowHandler() {
        return null;
    }

    @Override
    public boolean canGoBack() {
        if (this.myIsClosing || this.myBid < 0) {
            return false;
        }
        return this.myService.execObj(s -> s.Browser_CanGoBack(this.myBid));
    }

    @Override
    public void goBack() {
        if (this.myIsClosing || this.myBid < 0) {
            return;
        }
        this.myService.exec(s -> s.Browser_GoBack(this.myBid));
    }

    @Override
    public boolean canGoForward() {
        if (this.myIsClosing || this.myBid < 0) {
            return false;
        }
        return this.myService.execObj(s -> s.Browser_CanGoForward(this.myBid));
    }

    @Override
    public void goForward() {
        if (this.myIsClosing || this.myBid < 0) {
            return;
        }
        this.myService.exec(s -> s.Browser_GoForward(this.myBid));
    }

    @Override
    public boolean isLoading() {
        if (this.myIsClosing || this.myBid < 0) {
            return false;
        }
        return this.myService.execObj(s -> s.Browser_IsLoading(this.myBid));
    }

    @Override
    public void reload() {
        if (this.myIsClosing) {
            return;
        }
        this.execWhenCreated(() -> this.myService.exec(s -> s.Browser_Reload(this.myBid)), "reload");
    }

    @Override
    public void reloadIgnoreCache() {
        if (this.myIsClosing) {
            return;
        }
        this.execWhenCreated(() -> this.myService.exec(s -> s.Browser_ReloadIgnoreCache(this.myBid)), "reloadIgnoreCache");
    }

    @Override
    public void stopLoad() {
        if (this.myIsClosing || this.myBid < 0) {
            return;
        }
        this.myService.exec(s -> s.Browser_StopLoad(this.myBid));
    }

    @Override
    public int getIdentifier() {
        return this.myNativeBrowserIdentifier;
    }

    @Override
    public CefFrame getMainFrame() {
        CefLog.Error("TODO: implement getMainFrame.", new Object[0]);
        return null;
    }

    @Override
    public CefFrame getFocusedFrame() {
        CefLog.Error("TODO: implement getFocusedFrame.", new Object[0]);
        return null;
    }

    @Override
    public CefFrame getFrameByIdentifier(String identifier) {
        CefLog.Error("TODO: implement getFrame.", new Object[0]);
        return null;
    }

    @Override
    public CefFrame getFrameByName(String name) {
        CefLog.Error("TODO: implement getFrame.", new Object[0]);
        return null;
    }

    @Override
    public Vector<String> getFrameIdentifiers() {
        CefLog.Error("TODO: implement getFrameIdentifiers.", new Object[0]);
        return null;
    }

    @Override
    public Vector<String> getFrameNames() {
        CefLog.Error("TODO: implement getFrameNames.", new Object[0]);
        return null;
    }

    @Override
    public int getFrameCount() {
        if (this.myIsClosing) {
            return 0;
        }
        if (this.myBid < 0) {
            CefLog.Debug("bid wasn't received yet and getFrameCount will return 0.", new Object[0]);
            return 0;
        }
        return this.myService.execObj(s -> s.Browser_GetFrameCount(this.myBid));
    }

    @Override
    public boolean isPopup() {
        if (this.myIsClosing || this.myBid < 0) {
            return false;
        }
        return this.myService.execObj(s -> s.Browser_IsPopup(this.myBid));
    }

    @Override
    public boolean hasDocument() {
        if (this.myIsClosing || this.myBid < 0) {
            return false;
        }
        return this.myService.execObj(s -> s.Browser_HasDocument(this.myBid));
    }

    @Override
    public void viewSource() {
        if (this.myIsClosing) {
            return;
        }
        this.execWhenCreated(() -> this.myService.exec(s -> s.Browser_ViewSource(this.myBid)), "viewSource");
    }

    @Override
    public void getSource(CefStringVisitor visitor) {
        if (this.myIsClosing) {
            return;
        }
        this.execWhenCreated(() -> this.myService.exec(s -> CefLog.Error("TODO: implement getSource.", new Object[0])), "getSource");
    }

    @Override
    public void getText(CefStringVisitor visitor) {
        if (this.myIsClosing) {
            return;
        }
        this.execWhenCreated(() -> this.myService.exec(s -> CefLog.Error("TODO: implement getText.", new Object[0])), "getText");
    }

    @Override
    public void loadRequest(CefRequest request) {
        CefLog.Error("TODO: implement loadRequest.", new Object[0]);
    }

    @Override
    public void loadURL(String url) {
        this.myUrl = url;
        if (this.myIsClosing) {
            return;
        }
        this.execWhenCreated(() -> this.myService.exec(s -> s.Browser_LoadURL(this.myBid, url)), "loadURL");
    }

    @Override
    public void executeJavaScript(String code, String url, int line) {
        if (this.myIsClosing) {
            return;
        }
        this.execWhenCreated(() -> this.myService.exec(s -> s.Browser_ExecuteJavaScript(this.myBid, code, url, line)), "executeJavaScript");
    }

    @Override
    public String getURL() {
        if (this.myBid < 0) {
            CefLog.Debug("Can't do getURL because bid wasn't created, return cached %s", this.myUrl);
            return this.myUrl;
        }
        if (this.myIsClosing) {
            return this.myUrl;
        }
        return this.myService.execObj(s -> s.Browser_GetURL(this.myBid));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(boolean force) {
        Object object = this.myIsNativeBrowserCreationStarted;
        synchronized (object) {
            if (this.myIsClosing) {
                return;
            }
            this.myIsClosing = true;
            if (this.myRender != null) {
                this.myRender.disposeNativeResources();
            }
            if (this.myBid >= 0) {
                this.myService.exec(s -> s.Browser_Close(this.myBid));
            }
        }
        object = this.myDelayedActions;
        synchronized (object) {
            this.myDelayedActions.clear();
        }
    }

    @Override
    public void setCloseAllowed() {
    }

    @Override
    public boolean doClose() {
        return false;
    }

    @Override
    public void onBeforeClose() {
        this.myIsClosed = true;
        this.myRequestContext.dispose();
    }

    @Override
    public boolean isClosing() {
        return this.myIsClosing;
    }

    @Override
    public boolean isClosed() {
        return this.myIsClosed;
    }

    @Override
    public void setFocus(boolean enable) {
        if (this.myIsClosing) {
            return;
        }
        this.execWhenCreated(() -> this.myService.exec(s -> s.Browser_SetFocus(this.myBid, enable)), "setFocus");
    }

    @Override
    public void setWindowVisibility(boolean visible) {
    }

    @Override
    public double getZoomLevel() {
        if (this.myBid < 0) {
            CefLog.Debug("Can't do getZoomLevel because bid wasn't created, return 0", new Object[0]);
            return 0.0;
        }
        if (this.myIsClosing) {
            return 0.0;
        }
        return this.myService.execObj(s -> s.Browser_GetZoomLevel(this.myBid));
    }

    @Override
    public void setZoomLevel(double zoomLevel) {
        if (this.myIsClosing) {
            return;
        }
        this.execWhenCreated(() -> this.myService.exec(s -> s.Browser_SetZoomLevel(this.myBid, zoomLevel)), "setZoomLevel");
    }

    @Override
    public void runFileDialog(CefDialogHandler.FileDialogMode mode, String title, String defaultFilePath, Vector<String> acceptFilters, CefRunFileDialogCallback callback) {
        CefLog.Error("TODO: implement runFileDialog.", new Object[0]);
    }

    @Override
    public void startDownload(String url) {
        if (this.myIsClosing) {
            return;
        }
        this.execWhenCreated(() -> this.myService.exec(s -> s.Browser_StartDownload(this.myBid, url)), "startDownload");
    }

    @Override
    public void print() {
        CefLog.Error("TODO: implement print.", new Object[0]);
    }

    @Override
    public void printToPDF(String path, CefPdfPrintSettings settings, CefPdfPrintCallback callback) {
        CefLog.Error("TODO: implement printToPDF.", new Object[0]);
    }

    @Override
    public void find(String searchText, boolean forward, boolean matchCase, boolean findNext) {
        if (this.myIsClosing) {
            return;
        }
        this.execWhenCreated(() -> this.myService.exec(s -> s.Browser_Find(this.myBid, searchText, forward, matchCase, findNext)), "find");
    }

    @Override
    public void stopFinding(boolean clearSelection) {
        if (this.myIsClosing) {
            return;
        }
        this.execWhenCreated(() -> this.myService.exec(s -> s.Browser_StopFinding(this.myBid, clearSelection)), "stopFinding");
    }

    @Override
    public CefBrowser getDevTools() {
        CefLog.Error("TODO: implement getDevTools().", new Object[0]);
        return null;
    }

    @Override
    public CefBrowser getDevTools(Point inspectAt) {
        CefLog.Error("TODO: implement getDevTools(Point).", new Object[0]);
        return null;
    }

    @Override
    public CefDevToolsClient getDevToolsClient() {
        CefLog.Error("TODO: implement getDevToolsClient(Point).", new Object[0]);
        return null;
    }

    @Override
    public void replaceMisspelling(String word) {
        if (this.myIsClosing) {
            return;
        }
        this.execWhenCreated(() -> this.myService.exec(s -> s.Browser_ReplaceMisspelling(this.myBid, word)), "replaceMisspelling");
    }

    @Override
    public void wasResized(int width, int height) {
        if (this.myIsClosing) {
            return;
        }
        this.execWhenCreated(() -> this.myService.exec(s -> s.Browser_WasResized(this.myBid)), "wasResized");
    }

    @Override
    public void notifyScreenInfoChanged() {
        if (this.myIsClosing) {
            return;
        }
        this.execWhenCreated(() -> this.myService.exec(s -> s.Browser_NotifyScreenInfoChanged(this.myBid)), "notifyScreenInfoChanged");
    }

    @Override
    public void sendKeyEvent(KeyEvent e) {
        if (this.myBid < 0) {
            CefLog.Debug("Skip sendKeyEvent because remote browser wasn't created, bid=%d", this.myBid);
            return;
        }
        if (this.myIsClosing) {
            return;
        }
        this.myService.exec(s -> s.Browser_SendKeyEvent(this.myBid, e.getID(), e.getModifiersEx(), (short)e.getKeyChar(), 0L, e.getKeyCode()));
    }

    @Override
    public void sendMouseEvent(MouseEvent e) {
        if (this.myBid < 0) {
            CefLog.Debug("Skip sendMouseEvent because remote browser wasn't created, bid=%d", this.myBid);
            return;
        }
        if (this.myIsClosing) {
            return;
        }
        this.myService.exec(s -> s.Browser_SendMouseEvent(this.myBid, e.getID(), e.getX(), e.getY(), e.getModifiersEx(), e.getClickCount(), e.getButton()));
    }

    @Override
    public void sendMouseWheelEvent(MouseWheelEvent e) {
        if (this.myBid < 0) {
            CefLog.Debug("Skip sendMouseWheelEvent because remote browser wasn't created, bid=%d", this.myBid);
            return;
        }
        if (this.myIsClosing) {
            return;
        }
        this.myService.exec(s -> s.Browser_SendMouseWheelEvent(this.myBid, e.getScrollType(), e.getX(), e.getY(), e.getModifiersEx(), e.getWheelRotation(), e.getUnitsToScroll()));
    }

    @Override
    public void sendTouchEvent(CefTouchEvent e) {
        CefLog.Error("UNIMPLEMENTED: sendTouchEvent", new Object[0]);
    }

    @Override
    public CompletableFuture<BufferedImage> createScreenshot(boolean nativeResolution) {
        return null;
    }

    @Override
    public void ImeSetComposition(String s, List<CefCompositionUnderline> list, CefRange cefRange, CefRange cefRange1) {
        CefLog.Error("ImeSetComposition is not implemented", new Object[0]);
    }

    @Override
    public void ImeCommitText(String s, CefRange cefRange, int i) {
        CefLog.Error("ImeCommitText is not implemented", new Object[0]);
    }

    @Override
    public void ImeFinishComposingText(boolean b) {
        CefLog.Error("ImeFinishComposingText is not implemented", new Object[0]);
    }

    @Override
    public void ImeCancelComposing() {
        CefLog.Error("ImeCancelComposing is not implemented", new Object[0]);
    }

    @Override
    public void setWindowlessFrameRate(int frameRate) {
        this.myFrameRate = frameRate;
        if (this.myIsClosing) {
            return;
        }
        this.execWhenCreated(() -> this.myService.exec(s -> s.Browser_SetFrameRate(this.myBid, frameRate)), "setWindowlessFrameRate");
    }

    @Override
    public CompletableFuture<Integer> getWindowlessFrameRate() {
        CefLog.Warn("%s: getWindowlessFrameRate returns cached value %d. TODO: implement real getWindowlessFrameRate.", this, this.myFrameRate);
        CompletableFuture<Integer> result = new CompletableFuture<Integer>();
        result.complete(this.myFrameRate);
        return result;
    }

    public String toString() {
        return "RemoteBrowser_" + this.myBid;
    }
}

