/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.material3.carousel;

import androidx.compose.animation.core.AnimationSpec;
import androidx.compose.animation.core.SuspendAnimationKt;
import androidx.compose.foundation.gestures.Orientation;
import androidx.compose.foundation.gestures.ScrollScope;
import androidx.compose.foundation.lazy.layout.LazyLayoutScrollScope;
import androidx.compose.foundation.pager.PagerState;
import androidx.compose.material3.ExperimentalMaterial3Api;
import androidx.compose.material3.carousel.CarouselState;
import androidx.compose.runtime.Composable;
import androidx.compose.runtime.Composer;
import androidx.compose.runtime.ComposerKt;
import androidx.compose.runtime.saveable.RememberSaveableKt;
import androidx.compose.runtime.saveable.Saver;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000F\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a%\u0010\u0000\u001a\u00020\u00012\b\b\u0002\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u0007\u00a2\u0006\u0002\u0010\u0006\u001aW\u0010\u000b\u001a\u00020\f*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\b2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\b0\u00132\u001d\u0010\u0014\u001a\u0019\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\f0\u0015\u00a2\u0006\u0002\b\u0017H\u0082@\u00a2\u0006\u0002\u0010\u0018\u001a\u001c\u0010\u0019\u001a\u00020\b*\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0003H\u0002\"\u000e\u0010\u0007\u001a\u00020\bX\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\bX\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\n\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"rememberCarouselState", "Landroidx/compose/material3/carousel/CarouselState;", "initialItem", "", "itemCount", "Lkotlin/Function0;", "(ILkotlin/jvm/functions/Function0;Landroidx/compose/runtime/Composer;II)Landroidx/compose/material3/carousel/CarouselState;", "MinPageOffset", "", "MaxPageOffset", "MaxPagesForAnimateScroll", "animateScrollToPage", "", "Landroidx/compose/foundation/lazy/layout/LazyLayoutScrollScope;", "pagerState", "Landroidx/compose/foundation/pager/PagerState;", "targetPage", "targetPageOffsetToSnappedPosition", "animationSpec", "Landroidx/compose/animation/core/AnimationSpec;", "updateTargetPage", "Lkotlin/Function2;", "Landroidx/compose/foundation/gestures/ScrollScope;", "Lkotlin/ExtensionFunctionType;", "(Landroidx/compose/foundation/lazy/layout/LazyLayoutScrollScope;Landroidx/compose/foundation/pager/PagerState;IFLandroidx/compose/animation/core/AnimationSpec;Lkotlin/jvm/functions/Function2;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "calculateScrollDistanceTo", "currentPage", "material3"})
@SourceDebugExtension(value={"SMAP\nCarouselState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CarouselState.kt\nandroidx/compose/material3/carousel/CarouselStateKt\n+ 2 Composer.kt\nandroidx/compose/runtime/ComposerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 IntSize.kt\nandroidx/compose/ui/unit/IntSize\n+ 5 InlineClassHelper.kt\nandroidx/compose/ui/util/InlineClassHelperKt\n*L\n1#1,343:1\n1282#2,6:344\n1#3:350\n54#4:351\n59#4:353\n85#5:352\n90#5:354\n*S KotlinDebug\n*F\n+ 1 CarouselState.kt\nandroidx/compose/material3/carousel/CarouselStateKt\n*L\n153#1:344,6\n266#1:351\n267#1:353\n266#1:352\n267#1:354\n*E\n"})
public final class CarouselStateKt {
    public static final float MinPageOffset = -0.5f;
    public static final float MaxPageOffset = 0.5f;
    private static final int MaxPagesForAnimateScroll = 3;

    /*
     * WARNING - void declaration
     */
    @ExperimentalMaterial3Api
    @Composable
    @NotNull
    public static final CarouselState rememberCarouselState(int initialItem, @NotNull Function0<Integer> itemCount, @Nullable Composer $composer, int $changed, int n) {
        Object object;
        void $this$cache$iv;
        Intrinsics.checkNotNullParameter(itemCount, (String)"itemCount");
        ComposerKt.sourceInformationMarkerStart((Composer)$composer, (int)-217285684, (String)"C(rememberCarouselState)152@5940L182,152@5894L228:CarouselState.kt#dcf9yb");
        if ((n & 1) != 0) {
            initialItem = 0;
        }
        if (ComposerKt.isTraceInProgress()) {
            ComposerKt.traceEventStart((int)-217285684, (int)$changed, (int)-1, (String)"androidx.compose.material3.carousel.rememberCarouselState (CarouselState.kt:151)");
        }
        Object[] objectArray = new Object[]{};
        Saver<CarouselState, ?> saver = CarouselState.Companion.getSaver();
        ComposerKt.sourceInformationMarkerStart((Composer)$composer, (int)1641861186, (String)"CC(remember):CarouselState.kt#9igjgp");
        Composer composer = $composer;
        boolean invalid$iv = (($changed & 0xE ^ 6) > 4 && $composer.changed(initialItem) || ($changed & 6) == 4) | (($changed & 0x70 ^ 0x30) > 32 && $composer.changed(itemCount) || ($changed & 0x30) == 32);
        boolean $i$f$cache = false;
        Object it$iv = $this$cache$iv.rememberedValue();
        boolean bl = false;
        if (invalid$iv || it$iv == Composer.Companion.getEmpty()) {
            Saver<CarouselState, ?> saver2 = saver;
            Object[] objectArray2 = objectArray;
            boolean bl2 = false;
            Function0 function0 = () -> CarouselStateKt.rememberCarouselState$lambda$1$lambda$0(initialItem, itemCount);
            objectArray = objectArray2;
            saver = saver2;
            Function0 value$iv = function0;
            $this$cache$iv.updateRememberedValue((Object)value$iv);
            object = value$iv;
        } else {
            object = it$iv;
        }
        Object object2 = (Function0)object;
        ComposerKt.sourceInformationMarkerEnd((Composer)$composer);
        object2 = RememberSaveableKt.rememberSaveable((Object[])objectArray, saver, (Function0)object2, (Composer)$composer, (int)0);
        CarouselState $this$rememberCarouselState_u24lambda_u242 = (CarouselState)object2;
        boolean bl3 = false;
        $this$rememberCarouselState_u24lambda_u242.getPagerState$material3().getPageCountState().setValue(itemCount);
        CarouselState carouselState = (CarouselState)object2;
        if (ComposerKt.isTraceInProgress()) {
            ComposerKt.traceEventEnd();
        }
        ComposerKt.sourceInformationMarkerEnd((Composer)$composer);
        return carouselState;
    }

    private static final Object animateScrollToPage(LazyLayoutScrollScope $this$animateScrollToPage, PagerState pagerState, int targetPage, float targetPageOffsetToSnappedPosition, AnimationSpec<Float> animationSpec, Function2<? super ScrollScope, ? super Integer, Unit> updateTargetPage, Continuation<? super Unit> $completion) {
        updateTargetPage.invoke((Object)$this$animateScrollToPage, (Object)Boxing.boxInt((int)targetPage));
        boolean forward = targetPage > $this$animateScrollToPage.getFirstVisibleItemIndex();
        int visiblePages = $this$animateScrollToPage.getLastVisibleItemIndex() - $this$animateScrollToPage.getFirstVisibleItemIndex() + 1;
        if ((forward && targetPage > $this$animateScrollToPage.getLastVisibleItemIndex() || !forward && targetPage < $this$animateScrollToPage.getFirstVisibleItemIndex()) && Math.abs(targetPage - $this$animateScrollToPage.getFirstVisibleItemIndex()) >= 3) {
            int preJumpPosition = forward ? RangesKt.coerceAtLeast((int)(targetPage - visiblePages), (int)$this$animateScrollToPage.getFirstVisibleItemIndex()) : RangesKt.coerceAtMost((int)(targetPage + visiblePages), (int)$this$animateScrollToPage.getFirstVisibleItemIndex());
            $this$animateScrollToPage.snapToItem(preJumpPosition, 0);
        }
        float displacement = CarouselStateKt.calculateScrollDistanceTo(pagerState, pagerState.getCurrentPage(), targetPage) + targetPageOffsetToSnappedPosition;
        Ref.FloatRef previousValue = new Ref.FloatRef();
        Object object = SuspendAnimationKt.animate$default((float)0.0f, (float)displacement, (float)0.0f, animationSpec, (arg_0, arg_1) -> CarouselStateKt.animateScrollToPage$lambda$3(previousValue, $this$animateScrollToPage, arg_0, arg_1), $completion, (int)4, null);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private static final float calculateScrollDistanceTo(PagerState $this$calculateScrollDistanceTo, int currentPage, int targetPage) {
        int n;
        long value$iv$iv;
        long arg0$iv;
        if ($this$calculateScrollDistanceTo.getLayoutInfo().getOrientation() == Orientation.Horizontal) {
            arg0$iv = $this$calculateScrollDistanceTo.getLayoutInfo().getViewportSize-YbymL2g();
            boolean bl = false;
            value$iv$iv = arg0$iv;
            boolean $i$f$unpackInt1 = false;
            n = (int)(value$iv$iv >> 32);
        } else {
            arg0$iv = $this$calculateScrollDistanceTo.getLayoutInfo().getViewportSize-YbymL2g();
            boolean bl = false;
            value$iv$iv = arg0$iv;
            boolean $i$f$unpackInt2 = false;
            n = (int)(value$iv$iv & 0xFFFFFFFFL);
        }
        int layoutSize = n;
        int currentPageSnapOffset = $this$calculateScrollDistanceTo.getLayoutInfo().getSnapPosition().position(layoutSize, $this$calculateScrollDistanceTo.getLayoutInfo().getPageSize(), $this$calculateScrollDistanceTo.getLayoutInfo().getBeforeContentPadding(), $this$calculateScrollDistanceTo.getLayoutInfo().getAfterContentPadding(), currentPage, $this$calculateScrollDistanceTo.getPageCount());
        int targetPageSnapOffset = $this$calculateScrollDistanceTo.getLayoutInfo().getSnapPosition().position(layoutSize, $this$calculateScrollDistanceTo.getLayoutInfo().getPageSize(), $this$calculateScrollDistanceTo.getLayoutInfo().getBeforeContentPadding(), $this$calculateScrollDistanceTo.getLayoutInfo().getAfterContentPadding(), targetPage, $this$calculateScrollDistanceTo.getPageCount());
        int snapOffsetDiff = currentPageSnapOffset - targetPageSnapOffset;
        int targetPageDiff = targetPage - currentPage;
        float pageSizeWithSpacing = (float)$this$calculateScrollDistanceTo.getLayoutInfo().getPageSize() + (float)$this$calculateScrollDistanceTo.getLayoutInfo().getPageSpacing();
        return (float)targetPageDiff * pageSizeWithSpacing + (float)snapOffsetDiff;
    }

    private static final CarouselState rememberCarouselState$lambda$1$lambda$0(int $initialItem, Function0 $itemCount) {
        return new CarouselState($initialItem, 0.0f, (Function0<Integer>)$itemCount);
    }

    private static final Unit animateScrollToPage$lambda$3(Ref.FloatRef $previousValue, LazyLayoutScrollScope $this_animateScrollToPage, float currentValue, float f) {
        float delta = currentValue - $previousValue.element;
        float consumed = $this_animateScrollToPage.scrollBy(delta);
        $previousValue.element += consumed;
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Object access$animateScrollToPage(LazyLayoutScrollScope $receiver, PagerState pagerState, int targetPage, float targetPageOffsetToSnappedPosition, AnimationSpec animationSpec, Function2 updateTargetPage, Continuation $completion) {
        return CarouselStateKt.animateScrollToPage($receiver, pagerState, targetPage, targetPageOffsetToSnappedPosition, (AnimationSpec<Float>)animationSpec, (Function2<? super ScrollScope, ? super Integer, Unit>)updateTargetPage, (Continuation<? super Unit>)$completion);
    }
}

