/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.io.okio;

import java.io.EOFException;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.io.Buffer;
import kotlinx.io.RawSink;
import kotlinx.io.RawSource;
import kotlinx.io.Segment;
import kotlinx.io.SegmentKt;
import kotlinx.io.bytestring.ByteString;
import kotlinx.io.bytestring.ByteStringKt;
import kotlinx.io.bytestring.unsafe.UnsafeByteStringOperations;
import kotlinx.io.unsafe.UnsafeBufferOperations;
import okio.ByteString;
import okio.Sink;
import okio.Source;
import okio.Timeout;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0003\u001a\u00020\u0004*\u00020\u0005\u001a\n\u0010\u0006\u001a\u00020\u0005*\u00020\u0004\u001a\n\u0010\u0007\u001a\u00020\u0002*\u00020\u0001\u001a\n\u0010\b\u001a\u00020\t*\u00020\n\u001a\n\u0010\u000b\u001a\u00020\n*\u00020\t\u00a8\u0006\f"}, d2={"asOkioSource", "Lokio/Source;", "Lkotlinx/io/RawSource;", "asOkioSink", "Lokio/Sink;", "Lkotlinx/io/RawSink;", "asKotlinxIoRawSink", "asKotlinxIoRawSource", "toKotlinxIoByteString", "Lkotlinx/io/bytestring/ByteString;", "Lokio/ByteString;", "toOkioByteString", "kotlinx-io-okio"})
@SourceDebugExtension(value={"SMAP\nOkioAdapters.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OkioAdapters.kt\nkotlinx/io/okio/OkioAdaptersKt\n+ 2 UnsafeByteStringOperations.kt\nkotlinx/io/bytestring/unsafe/UnsafeByteStringOperations\n*L\n1#1,180:1\n42#2,2:181\n*S KotlinDebug\n*F\n+ 1 OkioAdapters.kt\nkotlinx/io/okio/OkioAdaptersKt\n*L\n175#1:181,2\n*E\n"})
public final class OkioAdaptersKt {
    @NotNull
    public static final Source asOkioSource(@NotNull RawSource $this$asOkioSource) {
        Intrinsics.checkNotNullParameter((Object)$this$asOkioSource, (String)"<this>");
        return new Source($this$asOkioSource){
            private final Buffer buffer;
            final /* synthetic */ RawSource $this_asOkioSource;
            {
                this.$this_asOkioSource = $receiver;
                this.buffer = new Buffer();
            }

            public void close() {
                RawSource rawSource = this.$this_asOkioSource;
                boolean $i$f$withKxIO2OkioExceptionMapping = false;
                try {
                    boolean bl = false;
                    rawSource.close();
                }
                catch (IOException bypassIOE$iv) {
                    throw bypassIOE$iv;
                }
                catch (EOFException bypassEOF$iv) {
                    throw bypassEOF$iv;
                }
            }

            /*
             * WARNING - void declaration
             */
            public long read(okio.Buffer sink, long byteCount) {
                Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
                RawSource rawSource = this.$this_asOkioSource;
                boolean $i$f$withKxIO2OkioExceptionMapping = false;
                try {
                    void len;
                    boolean bl = false;
                    long readBytes = rawSource.readAtMostTo(this.buffer, byteCount);
                    if (readBytes == -1L) {
                        return -1L;
                    }
                    long remainingBytes = 0L;
                    for (remainingBytes = readBytes; remainingBytes > 0L; remainingBytes -= (long)len) {
                        void from;
                        void to;
                        Segment head$iv;
                        UnsafeBufferOperations unsafeBufferOperations = UnsafeBufferOperations.INSTANCE;
                        Buffer buffer$iv = this.buffer;
                        boolean $i$f$readFromHead = false;
                        if (!(!buffer$iv.exhausted())) {
                            boolean $i$a$-require-UnsafeBufferOperations$readFromHead$1$iv22 = false;
                            String $i$a$-require-UnsafeBufferOperations$readFromHead$1$iv22 = "Buffer is empty";
                            throw new IllegalArgumentException($i$a$-require-UnsafeBufferOperations$readFromHead$1$iv22.toString());
                        }
                        Intrinsics.checkNotNull((Object)buffer$iv.getHead());
                        int n = head$iv.getLimit();
                        int n2 = head$iv.getPos();
                        byte[] data = head$iv.dataAsByteArray(true);
                        boolean bl2 = false;
                        len = to - from;
                        sink.write(data, (int)from, (int)len);
                        void bytesRead$iv = len;
                        if (bytesRead$iv == false) continue;
                        if (bytesRead$iv < 0) {
                            throw new IllegalStateException("Returned negative read bytes count");
                        }
                        if (bytesRead$iv > head$iv.getSize()) {
                            throw new IllegalStateException("Returned too many bytes");
                        }
                        buffer$iv.skip((long)bytesRead$iv);
                    }
                    return readBytes;
                }
                catch (IOException bypassIOE$iv) {
                    throw bypassIOE$iv;
                }
                catch (EOFException bypassEOF$iv) {
                    throw bypassEOF$iv;
                }
            }

            public Timeout timeout() {
                return Timeout.NONE;
            }
        };
    }

    @NotNull
    public static final Sink asOkioSink(@NotNull RawSink $this$asOkioSink) {
        Intrinsics.checkNotNullParameter((Object)$this$asOkioSink, (String)"<this>");
        return new Sink($this$asOkioSink){
            private final Buffer buffer;
            final /* synthetic */ RawSink $this_asOkioSink;
            {
                this.$this_asOkioSink = $receiver;
                this.buffer = new Buffer();
            }

            public void close() {
                RawSink rawSink = this.$this_asOkioSink;
                boolean $i$f$withKxIO2OkioExceptionMapping = false;
                try {
                    boolean bl = false;
                    rawSink.close();
                }
                catch (IOException bypassIOE$iv) {
                    throw bypassIOE$iv;
                }
                catch (EOFException bypassEOF$iv) {
                    throw bypassEOF$iv;
                }
            }

            public void flush() {
                RawSink rawSink = this.$this_asOkioSink;
                boolean $i$f$withKxIO2OkioExceptionMapping = false;
                try {
                    boolean bl = false;
                    rawSink.flush();
                }
                catch (IOException bypassIOE$iv) {
                    throw bypassIOE$iv;
                }
                catch (EOFException bypassEOF$iv) {
                    throw bypassEOF$iv;
                }
            }

            public Timeout timeout() {
                return Timeout.NONE;
            }

            /*
             * WARNING - void declaration
             */
            public void write(okio.Buffer source, long byteCount) {
                Intrinsics.checkNotNullParameter((Object)source, (String)"source");
                RawSink rawSink = this.$this_asOkioSink;
                boolean $i$f$withKxIO2OkioExceptionMapping = false;
                try {
                    boolean bl = false;
                    if (!(source.size() >= byteCount)) {
                        boolean $i$a$-require-OkioAdaptersKt$asOkioSink$1$write$1$22 = false;
                        String $i$a$-require-OkioAdaptersKt$asOkioSink$1$write$1$22 = "Buffer does not contain enough bytes to write. Requested " + byteCount + ", actual size is " + source.size();
                        throw new IllegalArgumentException($i$a$-require-OkioAdaptersKt$asOkioSink$1$write$1$22.toString());
                    }
                    long remaining = 0L;
                    remaining = byteCount;
                    while (remaining > 0L) {
                        void from;
                        void to;
                        void buffer$iv;
                        UnsafeBufferOperations $i$a$-require-OkioAdaptersKt$asOkioSink$1$write$1$22 = UnsafeBufferOperations.INSTANCE;
                        Buffer buffer = this.buffer;
                        int minimumCapacity$iv = 1;
                        boolean $i$f$writeToTail = false;
                        Segment tail$iv = buffer$iv.writableSegment(minimumCapacity$iv);
                        byte[] data$iv = tail$iv.dataAsByteArray(false);
                        int n = data$iv.length;
                        int n2 = tail$iv.getLimit();
                        byte[] data = data$iv;
                        boolean bl2 = false;
                        int toWrite = (int)Math.min((long)(to - from), remaining);
                        int read = source.read(data, (int)from, toWrite);
                        if (!(read != -1)) {
                            boolean bl3 = false;
                            String string = "Buffer was exhausted from reading " + toWrite + " bytes from it.";
                            throw new IllegalStateException(string.toString());
                        }
                        remaining -= (long)read;
                        int bytesWritten$iv = read;
                        if (bytesWritten$iv == minimumCapacity$iv) {
                            tail$iv.writeBackData(data$iv, bytesWritten$iv);
                            tail$iv.setLimit(tail$iv.getLimit() + bytesWritten$iv);
                            buffer$iv.setSizeMut(buffer$iv.getSizeMut() + (long)bytesWritten$iv);
                            continue;
                        }
                        if (!(0 <= bytesWritten$iv ? bytesWritten$iv <= tail$iv.getRemainingCapacity() : false)) {
                            boolean bl4 = false;
                            String string = "Invalid number of bytes written: " + bytesWritten$iv + ". Should be in 0.." + tail$iv.getRemainingCapacity();
                            throw new IllegalStateException(string.toString());
                        }
                        if (bytesWritten$iv != 0) {
                            tail$iv.writeBackData(data$iv, bytesWritten$iv);
                            tail$iv.setLimit(tail$iv.getLimit() + bytesWritten$iv);
                            buffer$iv.setSizeMut(buffer$iv.getSizeMut() + (long)bytesWritten$iv);
                            continue;
                        }
                        if (!SegmentKt.isEmpty((Segment)tail$iv)) continue;
                        buffer$iv.recycleTail();
                    }
                    rawSink.write(this.buffer, this.buffer.getSize());
                }
                catch (IOException bypassIOE$iv) {
                    throw bypassIOE$iv;
                }
                catch (EOFException bypassEOF$iv) {
                    throw bypassEOF$iv;
                }
            }
        };
    }

    @NotNull
    public static final RawSink asKotlinxIoRawSink(@NotNull Sink $this$asKotlinxIoRawSink) {
        Intrinsics.checkNotNullParameter((Object)$this$asKotlinxIoRawSink, (String)"<this>");
        return new RawSink($this$asKotlinxIoRawSink){
            private final okio.Buffer buffer;
            final /* synthetic */ Sink $this_asKotlinxIoRawSink;
            {
                this.$this_asKotlinxIoRawSink = $receiver;
                this.buffer = new okio.Buffer();
            }

            /*
             * WARNING - void declaration
             */
            public void write(Buffer source, long byteCount) {
                Intrinsics.checkNotNullParameter((Object)source, (String)"source");
                Sink sink = this.$this_asKotlinxIoRawSink;
                boolean $i$f$withOkio2KxIOExceptionMapping = false;
                try {
                    boolean bl = false;
                    if (!(source.getSize() >= byteCount)) {
                        boolean $i$a$-require-OkioAdaptersKt$asKotlinxIoRawSink$1$write$1$22 = false;
                        String $i$a$-require-OkioAdaptersKt$asKotlinxIoRawSink$1$write$1$22 = "Buffer does not contain enough bytes to write. Requested " + byteCount + ", actual size is " + source.getSize();
                        throw new IllegalArgumentException($i$a$-require-OkioAdaptersKt$asKotlinxIoRawSink$1$write$1$22.toString());
                    }
                    long remaining = 0L;
                    remaining = byteCount;
                    while (remaining > 0L) {
                        void from;
                        void to;
                        Segment head$iv;
                        UnsafeBufferOperations this_$iv = UnsafeBufferOperations.INSTANCE;
                        boolean $i$f$readFromHead = false;
                        if (!(!source.exhausted())) {
                            boolean $i$a$-require-UnsafeBufferOperations$readFromHead$1$iv22 = false;
                            String $i$a$-require-UnsafeBufferOperations$readFromHead$1$iv22 = "Buffer is empty";
                            throw new IllegalArgumentException($i$a$-require-UnsafeBufferOperations$readFromHead$1$iv22.toString());
                        }
                        Intrinsics.checkNotNull((Object)source.getHead());
                        int n = head$iv.getLimit();
                        int n2 = head$iv.getPos();
                        byte[] data = head$iv.dataAsByteArray(true);
                        boolean bl2 = false;
                        int toRead = (int)Math.min((long)(to - from), remaining);
                        remaining -= (long)toRead;
                        this.buffer.write(data, (int)from, toRead);
                        int bytesRead$iv = toRead;
                        if (bytesRead$iv != 0) {
                            if (bytesRead$iv < 0) {
                                throw new IllegalStateException("Returned negative read bytes count");
                            }
                            if (bytesRead$iv > head$iv.getSize()) {
                                throw new IllegalStateException("Returned too many bytes");
                            }
                            source.skip((long)bytesRead$iv);
                        }
                        sink.write(this.buffer, byteCount);
                    }
                }
                catch (IOException bypassIOE$iv) {
                    throw bypassIOE$iv;
                }
                catch (EOFException bypassEOF$iv) {
                    throw bypassEOF$iv;
                }
            }

            public void flush() {
                Sink sink = this.$this_asKotlinxIoRawSink;
                boolean $i$f$withOkio2KxIOExceptionMapping = false;
                try {
                    boolean bl = false;
                    sink.flush();
                }
                catch (IOException bypassIOE$iv) {
                    throw bypassIOE$iv;
                }
                catch (EOFException bypassEOF$iv) {
                    throw bypassEOF$iv;
                }
            }

            public void close() {
                Sink sink = this.$this_asKotlinxIoRawSink;
                boolean $i$f$withOkio2KxIOExceptionMapping = false;
                try {
                    boolean bl = false;
                    sink.close();
                }
                catch (IOException bypassIOE$iv) {
                    throw bypassIOE$iv;
                }
                catch (EOFException bypassEOF$iv) {
                    throw bypassEOF$iv;
                }
            }
        };
    }

    @NotNull
    public static final RawSource asKotlinxIoRawSource(@NotNull Source $this$asKotlinxIoRawSource) {
        Intrinsics.checkNotNullParameter((Object)$this$asKotlinxIoRawSource, (String)"<this>");
        return new RawSource($this$asKotlinxIoRawSource){
            private final okio.Buffer buffer;
            final /* synthetic */ Source $this_asKotlinxIoRawSource;
            {
                this.$this_asKotlinxIoRawSource = $receiver;
                this.buffer = new okio.Buffer();
            }

            /*
             * WARNING - void declaration
             */
            public long readAtMostTo(Buffer sink, long byteCount) {
                Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
                Source source = this.$this_asKotlinxIoRawSource;
                boolean $i$f$withOkio2KxIOExceptionMapping = false;
                try {
                    boolean bl = false;
                    long readBytes = source.read(this.buffer, byteCount);
                    if (readBytes == -1L) {
                        return -1L;
                    }
                    long remaining = 0L;
                    remaining = readBytes;
                    while (remaining > 0L) {
                        void from;
                        void to;
                        UnsafeBufferOperations unsafeBufferOperations = UnsafeBufferOperations.INSTANCE;
                        int minimumCapacity$iv = 1;
                        boolean $i$f$writeToTail = false;
                        Segment tail$iv = sink.writableSegment(minimumCapacity$iv);
                        byte[] data$iv = tail$iv.dataAsByteArray(false);
                        int n = data$iv.length;
                        int n2 = tail$iv.getLimit();
                        byte[] data = data$iv;
                        boolean bl2 = false;
                        int toRead = (int)Math.min((long)(to - from), remaining);
                        int read = this.buffer.read(data, (int)from, toRead);
                        if (!(read != -1)) {
                            boolean bl3 = false;
                            String string = "Buffer was exhausted before reading " + toRead + " bytes from it.";
                            throw new IllegalStateException(string.toString());
                        }
                        remaining -= (long)read;
                        int bytesWritten$iv = read;
                        if (bytesWritten$iv == minimumCapacity$iv) {
                            tail$iv.writeBackData(data$iv, bytesWritten$iv);
                            tail$iv.setLimit(tail$iv.getLimit() + bytesWritten$iv);
                            sink.setSizeMut(sink.getSizeMut() + (long)bytesWritten$iv);
                            continue;
                        }
                        if (!(0 <= bytesWritten$iv ? bytesWritten$iv <= tail$iv.getRemainingCapacity() : false)) {
                            boolean bl4 = false;
                            String string = "Invalid number of bytes written: " + bytesWritten$iv + ". Should be in 0.." + tail$iv.getRemainingCapacity();
                            throw new IllegalStateException(string.toString());
                        }
                        if (bytesWritten$iv != 0) {
                            tail$iv.writeBackData(data$iv, bytesWritten$iv);
                            tail$iv.setLimit(tail$iv.getLimit() + bytesWritten$iv);
                            sink.setSizeMut(sink.getSizeMut() + (long)bytesWritten$iv);
                            continue;
                        }
                        if (!SegmentKt.isEmpty((Segment)tail$iv)) continue;
                        sink.recycleTail();
                    }
                    return readBytes;
                }
                catch (IOException bypassIOE$iv) {
                    throw bypassIOE$iv;
                }
                catch (EOFException bypassEOF$iv) {
                    throw bypassEOF$iv;
                }
            }

            public void close() {
                Source source = this.$this_asKotlinxIoRawSource;
                boolean $i$f$withOkio2KxIOExceptionMapping = false;
                try {
                    boolean bl = false;
                    source.close();
                }
                catch (IOException bypassIOE$iv) {
                    throw bypassIOE$iv;
                }
                catch (EOFException bypassEOF$iv) {
                    throw bypassEOF$iv;
                }
            }
        };
    }

    @NotNull
    public static final ByteString toKotlinxIoByteString(@NotNull okio.ByteString $this$toKotlinxIoByteString) {
        Intrinsics.checkNotNullParameter((Object)$this$toKotlinxIoByteString, (String)"<this>");
        if ($this$toKotlinxIoByteString.size() == 0) {
            return ByteStringKt.ByteString();
        }
        return UnsafeByteStringOperations.INSTANCE.wrapUnsafe($this$toKotlinxIoByteString.toByteArray());
    }

    @NotNull
    public static final okio.ByteString toOkioByteString(@NotNull ByteString $this$toOkioByteString) {
        Intrinsics.checkNotNullParameter((Object)$this$toOkioByteString, (String)"<this>");
        if (ByteStringKt.isEmpty((ByteString)$this$toOkioByteString)) {
            return okio.ByteString.EMPTY;
        }
        okio.ByteString resultingByteString = null;
        UnsafeByteStringOperations this_$iv = UnsafeByteStringOperations.INSTANCE;
        boolean $i$f$withByteArrayUnsafe = false;
        byte[] array = $this$toOkioByteString.getBackingArrayReference();
        boolean bl = false;
        resultingByteString = ByteString.Companion.of$default((ByteString.Companion)okio.ByteString.Companion, (byte[])array, (int)0, (int)0, (int)3, null);
        return resultingByteString;
    }
}

