/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.compression;

import java.io.Closeable;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okio.Buffer;
import okio.Source;
import okio.Timeout;
import org.jetbrains.annotations.NotNull;
import vet.inpulse.compression.Algorithm;
import vet.inpulse.compression.Compression;
import vet.inpulse.compression.Compressions;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u001bH\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020!H\u0016R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0014\"\u0004\b\u0019\u0010\u0016\u00a8\u0006\r"}, d2={"Lvet/inpulse/compression/DecompressorSource;", "Lokio/Source;", "realSource", "algorithm", "Lvet/inpulse/compression/Algorithm;", "<init>", "(Lokio/Source;Lvet/inpulse/compression/Algorithm;)V", "getRealSource", "()Lokio/Source;", "src", "Lokio/Buffer;", "getSrc", "()Lokio/Buffer;", "compression", "Lvet/inpulse/compression/Compression;", "getCompression", "()Lvet/inpulse/compression/Compression;", "done", "", "getDone", "()Z", "setDone", "(Z)V", "first", "getFirst", "setFirst", "read", "", "sink", "byteCount", "timeout", "Lokio/Timeout;", "close", ""})
@SourceDebugExtension(value={"SMAP\nDecompressorSource.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DecompressorSource.kt\nvet/inpulse/compression/DecompressorSource\n+ 2 Okio.kt\nokio/Okio__OkioKt\n*L\n1#1,76:1\n72#2:77\n58#2,4:78\n72#2:82\n58#2,22:83\n66#2,10:105\n62#2,3:115\n77#2,3:118\n*S KotlinDebug\n*F\n+ 1 DecompressorSource.kt\nvet/inpulse/compression/DecompressorSource\n*L\n28#1:77\n28#1:78,4\n34#1:82\n34#1:83,22\n28#1:105,10\n28#1:115,3\n28#1:118,3\n*E\n"})
public final class DecompressorSource
implements Source {
    @NotNull
    private final Source realSource;
    @NotNull
    private final Buffer src;
    @NotNull
    private final Compression compression;
    private boolean done;
    private boolean first;

    public DecompressorSource(@NotNull Source realSource, @NotNull Algorithm algorithm) {
        Intrinsics.checkNotNullParameter((Object)realSource, (String)"realSource");
        Intrinsics.checkNotNullParameter((Object)((Object)algorithm), (String)"algorithm");
        this.realSource = realSource;
        this.src = new Buffer();
        this.compression = Compressions.INSTANCE.decompressor(algorithm);
        this.first = true;
    }

    @NotNull
    public final Source getRealSource() {
        return this.realSource;
    }

    @NotNull
    public final Buffer getSrc() {
        return this.src;
    }

    @NotNull
    public final Compression getCompression() {
        return this.compression;
    }

    public final boolean getDone() {
        return this.done;
    }

    public final void setDone(boolean bl) {
        this.done = bl;
    }

    public final boolean getFirst() {
        return this.first;
    }

    public final void setFirst(boolean bl) {
        this.first = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long read(@NotNull Buffer sink, long byteCount) {
        Long l;
        Throwable thrown$iv;
        long written;
        block35: {
            Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
            if (this.done) {
                return -1L;
            }
            long read = this.realSource.read(this.src, 8192L);
            if (this.first && read < 0L) {
                return -1L;
            }
            this.first = false;
            long sizeBefore = sink.size();
            written = 0L;
            Closeable $this$use$iv = (Closeable)Buffer.readAndWriteUnsafe$default((Buffer)sink, null, (int)1, null);
            boolean $i$f$use = false;
            thrown$iv = null;
            try {
                Unit unit;
                Throwable thrown$iv2;
                int[] inputConsumed;
                int[] outputConsumed;
                Buffer.UnsafeCursor unsafeWrite;
                block33: {
                    unsafeWrite = (Buffer.UnsafeCursor)$this$use$iv;
                    boolean bl = false;
                    unsafeWrite.expandBuffer((int)byteCount);
                    outputConsumed = new int[1];
                    inputConsumed = new int[1];
                    Closeable $this$use$iv2 = (Closeable)Buffer.readUnsafe$default((Buffer)this.src, null, (int)1, null);
                    boolean $i$f$use2 = false;
                    thrown$iv2 = null;
                    try {
                        Buffer.UnsafeCursor unsafeRead = (Buffer.UnsafeCursor)$this$use$iv2;
                        boolean bl2 = false;
                        int available = unsafeRead.next();
                        if (available > 0) {
                            Intrinsics.checkNotNull((Object)unsafeRead.data);
                            int n = unsafeRead.start;
                            int n2 = unsafeRead.end - unsafeRead.start;
                            Intrinsics.checkNotNull((Object)unsafeWrite.data);
                            this.done = Compression.process$default(this.compression, unsafeRead.data, n, n2, inputConsumed, unsafeWrite.data, unsafeWrite.start, unsafeWrite.end - unsafeWrite.start, outputConsumed, false, 256, null);
                        } else {
                            byte[] empty = new byte[]{};
                            Intrinsics.checkNotNull((Object)unsafeWrite.data);
                            this.done = Compression.process$default(this.compression, empty, 0, 0, inputConsumed, unsafeWrite.data, unsafeWrite.start, unsafeWrite.end - unsafeWrite.start, outputConsumed, false, 256, null);
                        }
                        unit = Unit.INSTANCE;
                    }
                    catch (Throwable t$iv) {
                        try {
                            thrown$iv2 = t$iv;
                            unit = null;
                            break block33;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            block34: {
                                try {
                                    Closeable closeable = $this$use$iv2;
                                    if (closeable != null) {
                                        closeable.close();
                                    }
                                }
                                catch (Throwable t$iv2) {
                                    if (thrown$iv2 == null) {
                                        thrown$iv2 = t$iv2;
                                        break block34;
                                    }
                                    ExceptionsKt.addSuppressed((Throwable)thrown$iv2, (Throwable)t$iv2);
                                }
                            }
                        }
                    }
                    try {
                        Closeable closeable = $this$use$iv2;
                        if (closeable != null) {
                            closeable.close();
                        }
                    }
                    catch (Throwable t$iv) {
                        thrown$iv2 = t$iv;
                    }
                }
                Unit result$iv = unit;
                Throwable throwable = thrown$iv2;
                if (throwable != null) {
                    throw throwable;
                }
                this.src.skip((long)inputConsumed[0]);
                written = outputConsumed[0];
                l = unsafeWrite.resizeBuffer(sizeBefore + written);
            }
            catch (Throwable t$iv) {
                try {
                    thrown$iv = t$iv;
                    l = null;
                    break block35;
                }
                catch (Throwable throwable2) {
                    throw throwable2;
                }
                finally {
                    block36: {
                        try {
                            Closeable closeable = $this$use$iv;
                            if (closeable != null) {
                                closeable.close();
                            }
                        }
                        catch (Throwable t$iv3) {
                            if (thrown$iv == null) {
                                thrown$iv = t$iv3;
                                break block36;
                            }
                            ExceptionsKt.addSuppressed((Throwable)thrown$iv, (Throwable)t$iv3);
                        }
                    }
                }
            }
            try {
                Closeable closeable = $this$use$iv;
                if (closeable != null) {
                    closeable.close();
                }
            }
            catch (Throwable t$iv) {
                thrown$iv = t$iv;
            }
        }
        Long result$iv = l;
        Throwable throwable = thrown$iv;
        if (throwable == null) return written;
        throw throwable;
    }

    @NotNull
    public Timeout timeout() {
        return Timeout.NONE;
    }

    public void close() {
        this.compression.close();
        this.realSource.close();
    }
}

