/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.input;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.text.input.EditCommand;
import androidx.compose.ui.text.input.EditingBuffer;
import androidx.compose.ui.text.internal.InlineClassHelperKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0096\u0002J\b\u0010\u0012\u001a\u00020\u0003H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0015"}, d2={"Landroidx/compose/ui/text/input/DeleteSurroundingTextCommand;", "Landroidx/compose/ui/text/input/EditCommand;", "lengthBeforeCursor", "", "lengthAfterCursor", "<init>", "(II)V", "getLengthBeforeCursor", "()I", "getLengthAfterCursor", "applyTo", "", "buffer", "Landroidx/compose/ui/text/input/EditingBuffer;", "equals", "", "other", "", "hashCode", "toString", "", "ui-text"})
@StabilityInferred(parameters=1)
@SourceDebugExtension(value={"SMAP\nEditCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditCommand.kt\nandroidx/compose/ui/text/input/DeleteSurroundingTextCommand\n+ 2 InlineClassHelper.kt\nandroidx/compose/ui/text/internal/InlineClassHelperKt\n+ 3 MathUtils.kt\nandroidx/compose/ui/text/input/MathUtilsKt\n*L\n1#1,558:1\n118#2,4:559\n28#3,3:563\n38#3,4:566\n*S KotlinDebug\n*F\n+ 1 EditCommand.kt\nandroidx/compose/ui/text/input/DeleteSurroundingTextCommand\n*L\n250#1:559,4\n259#1:563,3\n264#1:566,4\n*E\n"})
public final class DeleteSurroundingTextCommand
implements EditCommand {
    private final int lengthBeforeCursor;
    private final int lengthAfterCursor;
    public static final int $stable;

    public DeleteSurroundingTextCommand(int lengthBeforeCursor, int lengthAfterCursor) {
        this.lengthBeforeCursor = lengthBeforeCursor;
        this.lengthAfterCursor = lengthAfterCursor;
        boolean value$iv = this.lengthBeforeCursor >= 0 && this.lengthAfterCursor >= 0;
        boolean $i$f$requirePrecondition = false;
        if (!value$iv) {
            boolean bl = false;
            InlineClassHelperKt.throwIllegalArgumentException("Expected lengthBeforeCursor and lengthAfterCursor to be non-negative, were " + this.lengthBeforeCursor + " and " + this.lengthAfterCursor + " respectively.");
        }
    }

    public final int getLengthBeforeCursor() {
        return this.lengthBeforeCursor;
    }

    public final int getLengthAfterCursor() {
        return this.lengthAfterCursor;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void applyTo(@NotNull EditingBuffer buffer) {
        boolean bl;
        void $this$subtractExactOrElse$iv;
        int n;
        void $this$addExactOrElse$iv;
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        int n2 = buffer.getSelectionEnd$ui_text();
        int right$iv = this.lengthAfterCursor;
        boolean $i$f$addExactOrElse = false;
        void result$iv = $this$addExactOrElse$iv + right$iv;
        if ((($this$addExactOrElse$iv ^ result$iv) & (right$iv ^ result$iv)) < 0) {
            boolean bl2 = false;
            n = buffer.getLength$ui_text();
        } else {
            n = result$iv;
        }
        void end = n;
        buffer.delete$ui_text(buffer.getSelectionEnd$ui_text(), Math.min((int)end, buffer.getLength$ui_text()));
        right$iv = buffer.getSelectionStart$ui_text();
        int right$iv2 = this.lengthBeforeCursor;
        boolean $i$f$subtractExactOrElse = false;
        void result$iv2 = $this$subtractExactOrElse$iv - right$iv2;
        if ((($this$subtractExactOrElse$iv ^ right$iv2) & ($this$subtractExactOrElse$iv ^ result$iv2)) < 0) {
            boolean bl3 = false;
            bl = false;
        } else {
            bl = result$iv2;
        }
        void start = bl;
        buffer.delete$ui_text(Math.max(0, (int)start), buffer.getSelectionStart$ui_text());
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DeleteSurroundingTextCommand)) {
            return false;
        }
        if (this.lengthBeforeCursor != ((DeleteSurroundingTextCommand)other).lengthBeforeCursor) {
            return false;
        }
        return this.lengthAfterCursor == ((DeleteSurroundingTextCommand)other).lengthAfterCursor;
    }

    public int hashCode() {
        int result = this.lengthBeforeCursor;
        result = 31 * result + this.lengthAfterCursor;
        return result;
    }

    @NotNull
    public String toString() {
        return "DeleteSurroundingTextCommand(lengthBeforeCursor=" + this.lengthBeforeCursor + ", lengthAfterCursor=" + this.lengthAfterCursor + ")";
    }
}

