/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.geometry.RectKt;
import androidx.compose.ui.geometry.Size;
import androidx.compose.ui.graphics.Brush;
import androidx.compose.ui.graphics.Canvas;
import androidx.compose.ui.graphics.Color;
import androidx.compose.ui.graphics.Shadow;
import androidx.compose.ui.graphics.drawscope.DrawStyle;
import androidx.compose.ui.graphics.drawscope.Fill;
import androidx.compose.ui.text.MultiParagraph;
import androidx.compose.ui.text.SpanStyle;
import androidx.compose.ui.text.TextLayoutResult;
import androidx.compose.ui.text.style.TextDecoration;
import androidx.compose.ui.text.style.TextForegroundStyle;
import androidx.compose.ui.text.style.TextOverflow;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Landroidx/compose/ui/text/TextPainter;", "", "<init>", "()V", "paint", "", "canvas", "Landroidx/compose/ui/graphics/Canvas;", "textLayoutResult", "Landroidx/compose/ui/text/TextLayoutResult;", "ui-text"})
@StabilityInferred(parameters=1)
@SourceDebugExtension(value={"SMAP\nTextPainter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextPainter.kt\nandroidx/compose/ui/text/TextPainter\n+ 2 IntSize.kt\nandroidx/compose/ui/unit/IntSize\n+ 3 InlineClassHelper.kt\nandroidx/compose/ui/util/InlineClassHelperKt\n+ 4 Size.kt\nandroidx/compose/ui/geometry/SizeKt\n*L\n1#1,389:1\n54#2:390\n59#2:392\n85#3:391\n90#3:393\n53#3,3:395\n33#4:394\n*S KotlinDebug\n*F\n+ 1 TextPainter.kt\nandroidx/compose/ui/text/TextPainter\n*L\n57#1:390\n58#1:392\n57#1:391\n58#1:393\n59#1:395,3\n59#1:394\n*E\n"})
public final class TextPainter {
    @NotNull
    public static final TextPainter INSTANCE = new TextPainter();
    public static final int $stable;

    private TextPainter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void paint(@NotNull Canvas canvas, @NotNull TextLayoutResult textLayoutResult) {
        DrawStyle drawStyle;
        Shadow shadow;
        Shadow shadow2;
        TextDecoration textDecoration;
        SpanStyle style;
        TextDecoration textDecoration2;
        boolean needClipping;
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        Intrinsics.checkNotNullParameter((Object)textLayoutResult, (String)"textLayoutResult");
        boolean bl = needClipping = textLayoutResult.getHasVisualOverflow() && !TextOverflow.equals-impl0(textLayoutResult.getLayoutInput().getOverflow-gIe3tQ8(), TextOverflow.Companion.getVisible-gIe3tQ8());
        if (needClipping) {
            void val1$iv$iv;
            void width$iv;
            long l = textLayoutResult.getSize-YbymL2g();
            boolean $i$f$getWidth-impl22 = false;
            long value$iv$iv = l;
            boolean $i$f$unpackInt32 = false;
            float width = (int)(value$iv$iv >> 32);
            $v$c$androidx-compose-ui-unit-IntSize$-this$0$iv = textLayoutResult.getSize-YbymL2g();
            boolean bl2 = false;
            long value$iv$iv2 = $v$c$androidx-compose-ui-unit-IntSize$-this$0$iv;
            boolean $i$f$unpackInt2 = false;
            float height = (int)(value$iv$iv2 & 0xFFFFFFFFL);
            float $i$f$getWidth-impl22 = width;
            float height$iv = height;
            boolean $i$f$Size = false;
            void $i$f$unpackInt32 = width$iv;
            float val2$iv$iv = height$iv;
            boolean $i$f$packFloats = false;
            long v1$iv$iv = Float.floatToRawIntBits((float)val1$iv$iv);
            long v2$iv$iv = Float.floatToRawIntBits(val2$iv$iv);
            Rect bounds = RectKt.Rect-tz77jQw((long)Offset.Companion.getZero-F1C5BW0(), (long)Size.constructor-impl((long)(v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL)));
            canvas.save();
            Canvas.clipRect-mtrdD-E$default((Canvas)canvas, (Rect)bounds, (int)0, (int)2, null);
        }
        if ((textDecoration2 = (style = textLayoutResult.getLayoutInput().getStyle().getSpanStyle$ui_text()).getTextDecoration()) == null) {
            textDecoration2 = textDecoration = TextDecoration.Companion.getNone();
        }
        if ((shadow2 = style.getShadow()) == null) {
            shadow2 = shadow = Shadow.Companion.getNone();
        }
        if ((drawStyle = style.getDrawStyle()) == null) {
            drawStyle = (DrawStyle)Fill.INSTANCE;
        }
        DrawStyle drawStyle2 = drawStyle;
        try {
            Brush brush = style.getBrush();
            if (brush != null) {
                float alpha = style.getTextForegroundStyle$ui_text() != TextForegroundStyle.Unspecified.INSTANCE ? style.getTextForegroundStyle$ui_text().getAlpha() : 1.0f;
                MultiParagraph.paint-hn5TExg$default(textLayoutResult.getMultiParagraph(), canvas, brush, alpha, shadow, textDecoration, drawStyle2, 0, 64, null);
            } else {
                long color = style.getTextForegroundStyle$ui_text() != TextForegroundStyle.Unspecified.INSTANCE ? style.getTextForegroundStyle$ui_text().getColor-0d7_KjU() : Color.Companion.getBlack-0d7_KjU();
                MultiParagraph.paint-LG529CI$default(textLayoutResult.getMultiParagraph(), canvas, color, shadow, textDecoration, drawStyle2, 0, 32, null);
            }
        }
        finally {
            if (needClipping) {
                canvas.restore();
            }
        }
    }
}

