/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text;

import androidx.collection.IntList;
import androidx.collection.IntListKt;
import androidx.collection.MutableIntList;
import androidx.compose.runtime.Immutable;
import androidx.compose.runtime.Stable;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.runtime.saveable.Saver;
import androidx.compose.ui.text.AnnotatedStringKt;
import androidx.compose.ui.text.Bullet;
import androidx.compose.ui.text.ExperimentalTextApi;
import androidx.compose.ui.text.LinkAnnotation;
import androidx.compose.ui.text.ParagraphStyle;
import androidx.compose.ui.text.SaversKt;
import androidx.compose.ui.text.SpanStyle;
import androidx.compose.ui.text.StringAnnotation;
import androidx.compose.ui.text.StringAnnotationKt;
import androidx.compose.ui.text.TextRange;
import androidx.compose.ui.text.TtsAnnotation;
import androidx.compose.ui.text.UrlAnnotation;
import androidx.compose.ui.text.internal.InlineClassHelperKt;
import androidx.compose.ui.text.style.TextIndent;
import androidx.compose.ui.unit.TextUnit;
import androidx.compose.ui.unit.TextUnitKt;
import androidx.compose.ui.unit.TextUnitType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\f\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u0000 D2\u00020\u0001:\u0005@ABCDB)\b\u0000\u0012\u0016\u0010\u0002\u001a\u0012\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tB=\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0014\b\u0002\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u00040\u0003\u0012\u0014\b\u0002\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\u00040\u0003\u00a2\u0006\u0004\b\b\u0010\u000eB)\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0016\b\u0002\u0010\u0002\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u00040\u0003\u00a2\u0006\u0004\b\b\u0010\u000fJ\u0011\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001bH\u0096\u0002J\u0018\u0010!\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020\u001bH\u0016J\u0015\u0010!\u001a\u00020\u00002\u0006\u0010$\u001a\u00020%\u00a2\u0006\u0004\b&\u0010'J\u0011\u0010(\u001a\u00020\u00002\u0006\u0010)\u001a\u00020\u0000H\u0087\u0002J*\u0010*\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00040\u00032\u0006\u0010+\u001a\u00020\u00072\u0006\u0010,\u001a\u00020\u001b2\u0006\u0010-\u001a\u00020\u001bJ\u001e\u0010.\u001a\u00020/2\u0006\u0010+\u001a\u00020\u00072\u0006\u0010,\u001a\u00020\u001b2\u0006\u0010-\u001a\u00020\u001bJ\"\u0010*\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00040\u00032\u0006\u0010,\u001a\u00020\u001b2\u0006\u0010-\u001a\u00020\u001bJ\"\u00100\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002010\u00040\u00032\u0006\u0010,\u001a\u00020\u001b2\u0006\u0010-\u001a\u00020\u001bJ$\u00102\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002030\u00040\u00032\u0006\u0010,\u001a\u00020\u001b2\u0006\u0010-\u001a\u00020\u001bH\u0007J\"\u00104\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002050\u00040\u00032\u0006\u0010,\u001a\u00020\u001b2\u0006\u0010-\u001a\u00020\u001bJ\u0016\u00106\u001a\u00020/2\u0006\u0010,\u001a\u00020\u001b2\u0006\u0010-\u001a\u00020\u001bJ\u0013\u00107\u001a\u00020/2\b\u0010)\u001a\u0004\u0018\u000108H\u0096\u0002J\b\u00109\u001a\u00020\u001bH\u0016J\b\u0010:\u001a\u00020\u0007H\u0016J\u000e\u0010;\u001a\u00020/2\u0006\u0010)\u001a\u00020\u0000J*\u0010<\u001a\u00020\u00002\"\u0010=\u001a\u001e\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0004\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u00040>J0\u0010?\u001a\u00020\u00002(\u0010=\u001a$\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0004\u0012\u0012\u0012\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u00040\u00030>R$\u0010\u0002\u001a\u0012\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0004\u0018\u00010\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\"\u0010\u0014\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u0004\u0018\u00010\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0011R\u001d\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u00040\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0011R\"\u0010\u0017\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\u0004\u0018\u00010\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0011R\u001d\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\u00040\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0011R\u0014\u0010\u001a\u001a\u00020\u001b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006E"}, d2={"Landroidx/compose/ui/text/AnnotatedString;", "", "annotations", "", "Landroidx/compose/ui/text/AnnotatedString$Range;", "Landroidx/compose/ui/text/AnnotatedString$Annotation;", "text", "", "<init>", "(Ljava/util/List;Ljava/lang/String;)V", "spanStyles", "Landroidx/compose/ui/text/SpanStyle;", "paragraphStyles", "Landroidx/compose/ui/text/ParagraphStyle;", "(Ljava/lang/String;Ljava/util/List;Ljava/util/List;)V", "(Ljava/lang/String;Ljava/util/List;)V", "getAnnotations$ui_text", "()Ljava/util/List;", "getText", "()Ljava/lang/String;", "spanStylesOrNull", "getSpanStylesOrNull$ui_text", "getSpanStyles", "paragraphStylesOrNull", "getParagraphStylesOrNull$ui_text", "getParagraphStyles", "length", "", "getLength", "()I", "get", "", "index", "subSequence", "startIndex", "endIndex", "range", "Landroidx/compose/ui/text/TextRange;", "subSequence-5zc-tL8", "(J)Landroidx/compose/ui/text/AnnotatedString;", "plus", "other", "getStringAnnotations", "tag", "start", "end", "hasStringAnnotations", "", "getTtsAnnotations", "Landroidx/compose/ui/text/TtsAnnotation;", "getUrlAnnotations", "Landroidx/compose/ui/text/UrlAnnotation;", "getLinkAnnotations", "Landroidx/compose/ui/text/LinkAnnotation;", "hasLinkAnnotations", "equals", "", "hashCode", "toString", "hasEqualAnnotations", "mapAnnotations", "transform", "Lkotlin/Function1;", "flatMapAnnotations", "Range", "Builder", "Annotation", "ExhaustiveAnnotation", "Companion", "ui-text"})
@Immutable
@SourceDebugExtension(value={"SMAP\nAnnotatedString.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnnotatedString.kt\nandroidx/compose/ui/text/AnnotatedString\n+ 2 ListUtils.kt\nandroidx/compose/ui/util/ListUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 IntList.kt\nandroidx/collection/IntList\n+ 5 InlineClassHelper.kt\nandroidx/compose/ui/text/internal/InlineClassHelperKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1622:1\n35#2,5:1623\n251#2,2:1640\n35#2,5:1642\n253#2:1647\n103#2:1648\n35#2,5:1649\n104#2:1654\n251#2,2:1655\n35#2,5:1657\n253#2:1662\n231#2,2:1663\n35#2,5:1665\n233#2:1670\n231#2,2:1671\n35#2,5:1673\n233#2:1678\n231#2,2:1679\n35#2,5:1681\n233#2:1686\n103#2:1687\n35#2,5:1688\n104#2:1693\n1056#3:1628\n366#4:1629\n70#4:1630\n118#5,4:1631\n118#5,4:1636\n1#6:1635\n*S KotlinDebug\n*F\n+ 1 AnnotatedString.kt\nandroidx/compose/ui/text/AnnotatedString\n*L\n121#1:1623,5\n221#1:1640,2\n221#1:1642,5\n221#1:1647\n231#1:1648\n231#1:1649,5\n231#1:1654\n246#1:1655,2\n246#1:1657,5\n246#1:1662\n263#1:1663,2\n263#1:1665,5\n263#1:1670\n281#1:1671,2\n281#1:1673,5\n281#1:1678\n297#1:1679,2\n297#1:1681,5\n297#1:1686\n306#1:1687\n306#1:1688,5\n306#1:1693\n137#1:1628\n148#1:1629\n151#1:1630\n153#1:1631,4\n177#1:1636,4\n*E\n"})
public final class AnnotatedString
implements CharSequence {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final List<Range<? extends Annotation>> annotations;
    @NotNull
    private final String text;
    @Nullable
    private final List<Range<SpanStyle>> spanStylesOrNull;
    @Nullable
    private final List<Range<ParagraphStyle>> paragraphStylesOrNull;
    public static final int $stable;
    @NotNull
    private static final Saver<AnnotatedString, ?> Saver;

    public AnnotatedString(@Nullable List<? extends Range<? extends Annotation>> annotations, @NotNull String text) {
        List list;
        Collection<Range<Annotation>> $this$fastForEach$iv;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.annotations = annotations;
        this.text = text;
        List spanStyles = null;
        List paragraphStyles = null;
        List<Range<? extends Annotation>> list2 = this.annotations;
        if (list2 != null) {
            $this$fastForEach$iv = list2;
            boolean $i$f$fastForEach = false;
            int n = ((Collection)$this$fastForEach$iv).size();
            for (int index$iv = 0; index$iv < n; ++index$iv) {
                Range<? extends Annotation> item$iv;
                Range<? extends Annotation> annotation = item$iv = $this$fastForEach$iv.get(index$iv);
                boolean bl = false;
                if (annotation.getItem() instanceof SpanStyle) {
                    if (spanStyles == null) {
                        spanStyles = new ArrayList();
                    }
                    Intrinsics.checkNotNull(annotation, (String)"null cannot be cast to non-null type androidx.compose.ui.text.AnnotatedString.Range<androidx.compose.ui.text.SpanStyle>");
                    spanStyles.add(annotation);
                    continue;
                }
                if (!(annotation.getItem() instanceof ParagraphStyle)) continue;
                if (paragraphStyles == null) {
                    paragraphStyles = new ArrayList();
                }
                Intrinsics.checkNotNull(annotation, (String)"null cannot be cast to non-null type androidx.compose.ui.text.AnnotatedString.Range<androidx.compose.ui.text.ParagraphStyle>");
                paragraphStyles.add(annotation);
            }
        }
        this.spanStylesOrNull = spanStyles;
        List<Range<ParagraphStyle>> list3 = this.paragraphStylesOrNull = paragraphStyles;
        if (list3 != null) {
            Iterable $this$sortedBy$iv = list3;
            boolean $i$f$sortedBy = false;
            list = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    Range it = (Range)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(it.getStart());
                    it = (Range)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getStart()));
                }
            });
        } else {
            list = null;
        }
        List sorted = list;
        $this$fastForEach$iv = sorted;
        if (!($this$fastForEach$iv == null || $this$fastForEach$iv.isEmpty())) {
            MutableIntList previousEnds = IntListKt.mutableIntListOf((int)((Range)CollectionsKt.first((List)sorted)).getEnd());
            int n = sorted.size();
            for (int i = 1; i < n; ++i) {
                Range current;
                block11: {
                    int previousEnd;
                    current = (Range)sorted.get(i);
                    while (true) {
                        IntList this_$iv = (IntList)previousEnds;
                        boolean $i$f$isNotEmpty = false;
                        if (!(this_$iv._size != 0)) break block11;
                        previousEnd = previousEnds.last();
                        if (current.getStart() < previousEnd) break;
                        IntList this_$iv2 = (IntList)previousEnds;
                        boolean $i$f$getLastIndex = false;
                        previousEnds.removeAt(this_$iv2._size - 1);
                    }
                    boolean value$iv = current.getEnd() <= previousEnd;
                    boolean $i$f$requirePrecondition = false;
                    if (!value$iv) {
                        boolean bl = false;
                        InlineClassHelperKt.throwIllegalArgumentException("Paragraph overlap not allowed, end " + current.getEnd() + " should be less than or equal to " + previousEnd);
                    }
                }
                previousEnds.add(current.getEnd());
            }
        }
    }

    @Nullable
    public final List<Range<? extends Annotation>> getAnnotations$ui_text() {
        return this.annotations;
    }

    @NotNull
    public final String getText() {
        return this.text;
    }

    @Nullable
    public final List<Range<SpanStyle>> getSpanStylesOrNull$ui_text() {
        return this.spanStylesOrNull;
    }

    @NotNull
    public final List<Range<SpanStyle>> getSpanStyles() {
        List list = this.spanStylesOrNull;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @Nullable
    public final List<Range<ParagraphStyle>> getParagraphStylesOrNull$ui_text() {
        return this.paragraphStylesOrNull;
    }

    @NotNull
    public final List<Range<ParagraphStyle>> getParagraphStyles() {
        List list = this.paragraphStylesOrNull;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    public AnnotatedString(@NotNull String text, @NotNull List<Range<SpanStyle>> spanStyles, @NotNull List<Range<ParagraphStyle>> paragraphStyles) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter(spanStyles, (String)"spanStyles");
        Intrinsics.checkNotNullParameter(paragraphStyles, (String)"paragraphStyles");
        this(AnnotatedStringKt.access$constructAnnotationsFromSpansAndParagraphs(spanStyles, paragraphStyles), text);
    }

    public /* synthetic */ AnnotatedString(String string, List list, List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 4) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        this(string, list, list2);
    }

    public AnnotatedString(@NotNull String text, @NotNull List<? extends Range<? extends Annotation>> annotations) {
        Collection collection;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter(annotations, (String)"annotations");
        AnnotatedString annotatedString = this;
        Collection collection2 = annotations;
        if (collection2.isEmpty()) {
            AnnotatedString annotatedString2 = annotatedString;
            boolean bl = false;
            collection = null;
            annotatedString = annotatedString2;
        } else {
            collection = collection2;
        }
        annotatedString((List)collection, text);
    }

    public /* synthetic */ AnnotatedString(String string, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            list = CollectionsKt.emptyList();
        }
        this(string, list);
    }

    public int getLength() {
        return this.text.length();
    }

    public char get(int index2) {
        return this.text.charAt(index2);
    }

    @Override
    @NotNull
    public AnnotatedString subSequence(int startIndex, int endIndex) {
        boolean value$iv = startIndex <= endIndex;
        boolean $i$f$requirePrecondition = false;
        if (!value$iv) {
            boolean bl = false;
            InlineClassHelperKt.throwIllegalArgumentException("start (" + startIndex + ") should be less or equal to end (" + endIndex + ")");
        }
        if (startIndex == 0 && endIndex == this.text.length()) {
            return this;
        }
        String string = this.text.substring(startIndex, endIndex);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String text = string;
        List list = AnnotatedStringKt.access$filterRanges(this.annotations, startIndex, endIndex);
        return new AnnotatedString(list, text);
    }

    @NotNull
    public final AnnotatedString subSequence-5zc-tL8(long l) {
        return this.subSequence(TextRange.getMin-impl(l), TextRange.getMax-impl(l));
    }

    @Stable
    @NotNull
    public final AnnotatedString plus(@NotNull AnnotatedString other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Builder $this$plus_u24lambda_u240 = new Builder(this);
        boolean bl = false;
        $this$plus_u24lambda_u240.append(other);
        return $this$plus_u24lambda_u240.toAnnotatedString();
    }

    @NotNull
    public final List<Range<String>> getStringAnnotations(@NotNull String tag, int start, int end) {
        List list;
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        List<Range<? extends Annotation>> list2 = this.annotations;
        if (list2 != null) {
            List<Range<? extends Annotation>> $this$fastFilteredMap$iv = list2;
            boolean $i$f$fastFilteredMap = false;
            ArrayList target$iv = new ArrayList($this$fastFilteredMap$iv.size());
            List<Range<? extends Annotation>> $this$fastForEach$iv$iv = $this$fastFilteredMap$iv;
            boolean $i$f$fastForEach = false;
            int n = ((Collection)$this$fastForEach$iv$iv).size();
            for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
                Range<? extends Annotation> item$iv$iv;
                Range<? extends Annotation> it$iv = item$iv$iv = $this$fastForEach$iv$iv.get(index$iv$iv);
                boolean bl = false;
                Range<? extends Annotation> it = it$iv;
                boolean bl2 = false;
                if (!(it.getItem() instanceof StringAnnotation && Intrinsics.areEqual((Object)tag, (Object)it.getTag()) && AnnotatedStringKt.intersect(start, end, it.getStart(), it.getEnd()))) continue;
                it = it$iv;
                Collection collection = target$iv;
                boolean bl3 = false;
                collection.add(StringAnnotationKt.unbox(it));
            }
            list = target$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    public final boolean hasStringAnnotations(@NotNull String tag, int start, int end) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            List<Range<? extends Annotation>> list = this.annotations;
            if (list != null) {
                List<Range<? extends Annotation>> $this$fastAny$iv = list;
                boolean $i$f$fastAny = false;
                List<Range<? extends Annotation>> $this$fastForEach$iv$iv = $this$fastAny$iv;
                boolean $i$f$fastForEach = false;
                int n = ((Collection)$this$fastForEach$iv$iv).size();
                for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
                    Range<? extends Annotation> item$iv$iv;
                    Range<? extends Annotation> it$iv = item$iv$iv = $this$fastForEach$iv$iv.get(index$iv$iv);
                    boolean bl2 = false;
                    Range<? extends Annotation> it = it$iv;
                    boolean bl3 = false;
                    if (!(it.getItem() instanceof StringAnnotation && Intrinsics.areEqual((Object)tag, (Object)it.getTag()) && AnnotatedStringKt.intersect(start, end, it.getStart(), it.getEnd()))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            } else {
                bl = false;
            }
        }
        return bl;
    }

    @NotNull
    public final List<Range<String>> getStringAnnotations(int start, int end) {
        List list;
        List<Range<? extends Annotation>> list2 = this.annotations;
        if (list2 != null) {
            List<Range<? extends Annotation>> $this$fastFilteredMap$iv = list2;
            boolean $i$f$fastFilteredMap = false;
            ArrayList target$iv = new ArrayList($this$fastFilteredMap$iv.size());
            List<Range<? extends Annotation>> $this$fastForEach$iv$iv = $this$fastFilteredMap$iv;
            boolean $i$f$fastForEach = false;
            int n = ((Collection)$this$fastForEach$iv$iv).size();
            for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
                Range<? extends Annotation> item$iv$iv;
                Range<? extends Annotation> it$iv = item$iv$iv = $this$fastForEach$iv$iv.get(index$iv$iv);
                boolean bl = false;
                Range<? extends Annotation> it = it$iv;
                boolean bl2 = false;
                if (!(it.getItem() instanceof StringAnnotation && AnnotatedStringKt.intersect(start, end, it.getStart(), it.getEnd()))) continue;
                it = it$iv;
                Collection collection = target$iv;
                boolean bl3 = false;
                collection.add(StringAnnotationKt.unbox(it));
            }
            list = target$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @NotNull
    public final List<Range<TtsAnnotation>> getTtsAnnotations(int start, int end) {
        List list;
        List<Range<? extends Annotation>> list2 = this.annotations;
        if (list2 != null) {
            List<Range<? extends Annotation>> $this$fastFilter$iv = list2;
            boolean $i$f$fastFilter = false;
            ArrayList target$iv = new ArrayList($this$fastFilter$iv.size());
            List<Range<? extends Annotation>> $this$fastForEach$iv$iv = $this$fastFilter$iv;
            boolean $i$f$fastForEach = false;
            int n = ((Collection)$this$fastForEach$iv$iv).size();
            for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
                Range<? extends Annotation> item$iv$iv;
                Range<? extends Annotation> it$iv = item$iv$iv = $this$fastForEach$iv$iv.get(index$iv$iv);
                boolean bl = false;
                Range<? extends Annotation> it = it$iv;
                boolean bl2 = false;
                if (!(it.getItem() instanceof TtsAnnotation && AnnotatedStringKt.intersect(start, end, it.getStart(), it.getEnd()))) continue;
                ((Collection)target$iv).add(it$iv);
            }
            list = target$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        Intrinsics.checkNotNull((Object)list, (String)"null cannot be cast to non-null type kotlin.collections.List<androidx.compose.ui.text.AnnotatedString.Range<androidx.compose.ui.text.TtsAnnotation>>");
        return list;
    }

    @Deprecated(message="Use LinkAnnotation API instead", replaceWith=@ReplaceWith(expression="getLinkAnnotations(start, end)", imports={}))
    @ExperimentalTextApi
    @NotNull
    public final List<Range<UrlAnnotation>> getUrlAnnotations(int start, int end) {
        List list;
        List<Range<? extends Annotation>> list2 = this.annotations;
        if (list2 != null) {
            List<Range<? extends Annotation>> $this$fastFilter$iv = list2;
            boolean $i$f$fastFilter = false;
            ArrayList target$iv = new ArrayList($this$fastFilter$iv.size());
            List<Range<? extends Annotation>> $this$fastForEach$iv$iv = $this$fastFilter$iv;
            boolean $i$f$fastForEach = false;
            int n = ((Collection)$this$fastForEach$iv$iv).size();
            for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
                Range<? extends Annotation> item$iv$iv;
                Range<? extends Annotation> it$iv = item$iv$iv = $this$fastForEach$iv$iv.get(index$iv$iv);
                boolean bl = false;
                Range<? extends Annotation> it = it$iv;
                boolean bl2 = false;
                if (!(it.getItem() instanceof UrlAnnotation && AnnotatedStringKt.intersect(start, end, it.getStart(), it.getEnd()))) continue;
                ((Collection)target$iv).add(it$iv);
            }
            list = target$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        Intrinsics.checkNotNull((Object)list, (String)"null cannot be cast to non-null type kotlin.collections.List<androidx.compose.ui.text.AnnotatedString.Range<androidx.compose.ui.text.UrlAnnotation>>");
        return list;
    }

    @NotNull
    public final List<Range<LinkAnnotation>> getLinkAnnotations(int start, int end) {
        List list;
        List<Range<? extends Annotation>> list2 = this.annotations;
        if (list2 != null) {
            List<Range<? extends Annotation>> $this$fastFilter$iv = list2;
            boolean $i$f$fastFilter = false;
            ArrayList target$iv = new ArrayList($this$fastFilter$iv.size());
            List<Range<? extends Annotation>> $this$fastForEach$iv$iv = $this$fastFilter$iv;
            boolean $i$f$fastForEach = false;
            int n = ((Collection)$this$fastForEach$iv$iv).size();
            for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
                Range<? extends Annotation> item$iv$iv;
                Range<? extends Annotation> it$iv = item$iv$iv = $this$fastForEach$iv$iv.get(index$iv$iv);
                boolean bl = false;
                Range<? extends Annotation> it = it$iv;
                boolean bl2 = false;
                if (!(it.getItem() instanceof LinkAnnotation && AnnotatedStringKt.intersect(start, end, it.getStart(), it.getEnd()))) continue;
                ((Collection)target$iv).add(it$iv);
            }
            list = target$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        Intrinsics.checkNotNull((Object)list, (String)"null cannot be cast to non-null type kotlin.collections.List<androidx.compose.ui.text.AnnotatedString.Range<androidx.compose.ui.text.LinkAnnotation>>");
        return list;
    }

    public final boolean hasLinkAnnotations(int start, int end) {
        boolean bl;
        block3: {
            List<Range<? extends Annotation>> list = this.annotations;
            if (list != null) {
                List<Range<? extends Annotation>> $this$fastAny$iv = list;
                boolean $i$f$fastAny = false;
                List<Range<? extends Annotation>> $this$fastForEach$iv$iv = $this$fastAny$iv;
                boolean $i$f$fastForEach = false;
                int n = ((Collection)$this$fastForEach$iv$iv).size();
                for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
                    Range<? extends Annotation> item$iv$iv;
                    Range<? extends Annotation> it$iv = item$iv$iv = $this$fastForEach$iv$iv.get(index$iv$iv);
                    boolean bl2 = false;
                    Range<? extends Annotation> it = it$iv;
                    boolean bl3 = false;
                    if (!(it.getItem() instanceof LinkAnnotation && AnnotatedStringKt.intersect(start, end, it.getStart(), it.getEnd()))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            } else {
                bl = false;
            }
        }
        return bl;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AnnotatedString)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.text, (Object)((AnnotatedString)other).text)) {
            return false;
        }
        return Intrinsics.areEqual(this.annotations, ((AnnotatedString)other).annotations);
    }

    public int hashCode() {
        int result = this.text.hashCode();
        List<Range<? extends Annotation>> list = this.annotations;
        result = 31 * result + (list != null ? ((Object)list).hashCode() : 0);
        return result;
    }

    @Override
    @NotNull
    public String toString() {
        return this.text;
    }

    public final boolean hasEqualAnnotations(@NotNull AnnotatedString other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return Intrinsics.areEqual(this.annotations, other.annotations);
    }

    @NotNull
    public final AnnotatedString mapAnnotations(@NotNull Function1<? super Range<? extends Annotation>, ? extends Range<? extends Annotation>> transform) {
        Intrinsics.checkNotNullParameter(transform, (String)"transform");
        Builder builder = new Builder(this);
        builder.mapAnnotations$ui_text(transform);
        return builder.toAnnotatedString();
    }

    @NotNull
    public final AnnotatedString flatMapAnnotations(@NotNull Function1<? super Range<? extends Annotation>, ? extends List<? extends Range<? extends Annotation>>> transform) {
        Intrinsics.checkNotNullParameter(transform, (String)"transform");
        Builder builder = new Builder(this);
        builder.flatMapAnnotations$ui_text(transform);
        return builder.toAnnotatedString();
    }

    static {
        Saver = SaversKt.getAnnotatedStringSaver();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u00020\u0001\u0082\u0001\b\u0002\u0003\u0004\u0005\u0006\u0007\b\t\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\n\u00c0\u0006\u0001"}, d2={"Landroidx/compose/ui/text/AnnotatedString$Annotation;", "", "Landroidx/compose/ui/text/AnnotatedString$ExhaustiveAnnotation;", "Landroidx/compose/ui/text/Bullet;", "Landroidx/compose/ui/text/LinkAnnotation;", "Landroidx/compose/ui/text/ParagraphStyle;", "Landroidx/compose/ui/text/SpanStyle;", "Landroidx/compose/ui/text/StringAnnotation;", "Landroidx/compose/ui/text/TtsAnnotation;", "Landroidx/compose/ui/text/UrlAnnotation;", "ui-text"})
    public static interface Annotation {
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00ba\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\u0010\r\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\b\u0007\u0018\u00002\u00060\u0001j\u0002`\u0002:\u0002UVB\u0011\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u0011\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\u0005\u0010\tB\u0011\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\n\u00a2\u0006\u0004\b\u0005\u0010\u000bJ\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0007\u001a\u00020\bJ\u0015\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0007\u00a2\u0006\u0002\b\u0017J\u0012\u0010\u0017\u001a\u00020\u00002\b\u0010\u0007\u001a\u0004\u0018\u00010\u001cH\u0016J\"\u0010\u0017\u001a\u00020\u00002\b\u0010\u0007\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u0004H\u0016J\u0010\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0007\u001a\u00020\nJ\u001e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0007\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u0004J\u001e\u0010\u001f\u001a\u00020\u00182\u0006\u0010 \u001a\u00020!2\u0006\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u0004J\u001e\u0010\u001f\u001a\u00020\u00182\u0006\u0010 \u001a\u00020\"2\u0006\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u0004J&\u0010#\u001a\u00020\u00182\u0006\u0010$\u001a\u00020\b2\u0006\u0010%\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u0004J\u001e\u0010&\u001a\u00020\u00182\u0006\u0010'\u001a\u00020(2\u0006\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u0004J \u0010)\u001a\u00020\u00182\u0006\u0010*\u001a\u00020+2\u0006\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u0004H\u0007J\u001e\u0010,\u001a\u00020\u00182\u0006\u0010-\u001a\u00020.2\u0006\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u0004J\u001e\u0010,\u001a\u00020\u00182\u0006\u0010/\u001a\u0002002\u0006\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u0004J\u001e\u00101\u001a\u00020\u00182\u0006\u00102\u001a\u0002032\u0006\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u0004J-\u00101\u001a\u00020\u00182\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u0002052\u0006\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u0004\u00a2\u0006\u0004\b6\u00107J\u000e\u00108\u001a\u00020\u00042\u0006\u0010 \u001a\u00020!J\u000e\u00108\u001a\u00020\u00042\u0006\u0010 \u001a\u00020\"J\u000e\u00109\u001a\u00020\u00042\u0006\u00102\u001a\u000203JD\u0010<\u001a\u0002H=\"\b\b\u0000\u0010=*\u00020\u00112\b\b\u0002\u00104\u001a\u0002052\b\b\u0002\u00102\u001a\u0002032\u0017\u0010>\u001a\u0013\u0012\u0004\u0012\u00020;\u0012\u0004\u0012\u0002H=0?\u00a2\u0006\u0002\b@\u00a2\u0006\u0004\bA\u0010BJ>\u0010C\u001a\u0002H=\"\b\b\u0000\u0010=*\u00020\u0011*\u00020;2\n\b\u0002\u00102\u001a\u0004\u0018\u0001032\u0017\u0010>\u001a\u0013\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u0002H=0?\u00a2\u0006\u0002\b@\u00a2\u0006\u0002\u0010DJ\u0016\u0010E\u001a\u00020\u00042\u0006\u0010$\u001a\u00020\b2\u0006\u0010%\u001a\u00020\bJ\u000e\u0010F\u001a\u00020\u00042\u0006\u0010'\u001a\u00020(J\u0010\u0010G\u001a\u00020\u00042\u0006\u0010*\u001a\u00020+H\u0007J\u000e\u0010H\u001a\u00020\u00042\u0006\u0010I\u001a\u00020JJ\u0006\u0010K\u001a\u00020\u0018J\u000e\u0010K\u001a\u00020\u00182\u0006\u0010L\u001a\u00020\u0004J\u0006\u0010M\u001a\u00020\nJ1\u0010N\u001a\u00020\u00182\"\u0010O\u001a\u001e\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00130P\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00130P0?H\u0000\u00a2\u0006\u0002\bQJ7\u0010R\u001a\u00020\u00182(\u0010O\u001a$\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00130P\u0012\u0012\u0012\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00130P0S0?H\u0000\u00a2\u0006\u0002\bTR\u0012\u0010\u0007\u001a\u00060\fj\u0002`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000e\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00110\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0012\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0014\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010:\u001a\u00020;X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006W"}, d2={"Landroidx/compose/ui/text/AnnotatedString$Builder;", "Ljava/lang/Appendable;", "Lkotlin/text/Appendable;", "capacity", "", "<init>", "(I)V", "text", "", "(Ljava/lang/String;)V", "Landroidx/compose/ui/text/AnnotatedString;", "(Landroidx/compose/ui/text/AnnotatedString;)V", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "styleStack", "", "Landroidx/compose/ui/text/AnnotatedString$Builder$MutableRange;", "", "annotations", "Landroidx/compose/ui/text/AnnotatedString$Annotation;", "length", "getLength", "()I", "append", "", "deprecated_append_returning_void", "char", "", "", "start", "end", "addStyle", "style", "Landroidx/compose/ui/text/SpanStyle;", "Landroidx/compose/ui/text/ParagraphStyle;", "addStringAnnotation", "tag", "annotation", "addTtsAnnotation", "ttsAnnotation", "Landroidx/compose/ui/text/TtsAnnotation;", "addUrlAnnotation", "urlAnnotation", "Landroidx/compose/ui/text/UrlAnnotation;", "addLink", "url", "Landroidx/compose/ui/text/LinkAnnotation$Url;", "clickable", "Landroidx/compose/ui/text/LinkAnnotation$Clickable;", "addBullet", "bullet", "Landroidx/compose/ui/text/Bullet;", "indentation", "Landroidx/compose/ui/unit/TextUnit;", "addBullet-r9BaKPg", "(Landroidx/compose/ui/text/Bullet;JII)V", "pushStyle", "pushBullet", "bulletScope", "Landroidx/compose/ui/text/AnnotatedString$Builder$BulletScope;", "withBulletList", "R", "block", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "withBulletList-o2QH7mI", "(JLandroidx/compose/ui/text/Bullet;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "withBulletListItem", "(Landroidx/compose/ui/text/AnnotatedString$Builder$BulletScope;Landroidx/compose/ui/text/Bullet;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "pushStringAnnotation", "pushTtsAnnotation", "pushUrlAnnotation", "pushLink", "link", "Landroidx/compose/ui/text/LinkAnnotation;", "pop", "index", "toAnnotatedString", "mapAnnotations", "transform", "Landroidx/compose/ui/text/AnnotatedString$Range;", "mapAnnotations$ui_text", "flatMapAnnotations", "", "flatMapAnnotations$ui_text", "MutableRange", "BulletScope", "ui-text"})
    @StabilityInferred(parameters=0)
    @SourceDebugExtension(value={"SMAP\nAnnotatedString.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnnotatedString.kt\nandroidx/compose/ui/text/AnnotatedString$Builder\n+ 2 ListUtils.kt\nandroidx/compose/ui/util/ListUtilsKt\n+ 3 InlineClassHelper.kt\nandroidx/compose/ui/text/internal/InlineClassHelperKt\n*L\n1#1,1622:1\n35#2,5:1623\n35#2,5:1628\n151#2,2:1645\n35#2,5:1647\n153#2:1652\n530#2,2:1653\n35#2,3:1655\n532#2:1658\n151#2,2:1659\n35#2,5:1661\n153#2:1666\n533#2,2:1667\n39#2:1669\n535#2:1670\n81#3,4:1633\n81#3,4:1637\n81#3,4:1641\n*S KotlinDebug\n*F\n+ 1 AnnotatedString.kt\nandroidx/compose/ui/text/AnnotatedString$Builder\n*L\n544#1:1623,5\n563#1:1628,5\n1003#1:1645,2\n1003#1:1647,5\n1003#1:1652\n1020#1:1653,2\n1020#1:1655,3\n1020#1:1658\n1021#1:1659,2\n1021#1:1661,5\n1021#1:1666\n1020#1:1667,2\n1020#1:1669\n1020#1:1670\n833#1:1633,4\n974#1:1637,4\n991#1:1641,4\n*E\n"})
    public static final class Builder
    implements Appendable {
        @NotNull
        private final StringBuilder text;
        @NotNull
        private final List<MutableRange<? extends Object>> styleStack;
        @NotNull
        private final List<MutableRange<? extends Annotation>> annotations;
        @NotNull
        private final BulletScope bulletScope;
        public static final int $stable = 8;

        public Builder(int capacity) {
            this.text = new StringBuilder(capacity);
            this.styleStack = new ArrayList();
            this.annotations = new ArrayList();
            this.bulletScope = new BulletScope(this);
        }

        public /* synthetic */ Builder(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                n = 16;
            }
            this(n);
        }

        public Builder(@NotNull String text) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            this(0, 1, null);
            this.append(text);
        }

        public Builder(@NotNull AnnotatedString text) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            this(0, 1, null);
            this.append(text);
        }

        public final int getLength() {
            return this.text.length();
        }

        public final void append(@NotNull String text) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            this.text.append(text);
        }

        @Deprecated(message="Replaced by the append(Char) method that returns an Appendable. This method must be kept around for binary compatibility.", level=DeprecationLevel.HIDDEN)
        @JvmName(name="append")
        public final /* synthetic */ void append(char c) {
            this.append(c);
        }

        @Override
        @NotNull
        public Builder append(@Nullable CharSequence text) {
            if (text instanceof AnnotatedString) {
                this.append((AnnotatedString)text);
            } else {
                this.text.append(text);
            }
            return this;
        }

        @Override
        @NotNull
        public Builder append(@Nullable CharSequence text, int start, int end) {
            if (text instanceof AnnotatedString) {
                this.append((AnnotatedString)text, start, end);
            } else {
                this.text.append(text, start, end);
            }
            return this;
        }

        @Override
        @NotNull
        public Builder append(char c) {
            this.text.append(c);
            return this;
        }

        public final void append(@NotNull AnnotatedString text) {
            block1: {
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                int start = this.text.length();
                this.text.append(text.getText());
                List<Range<? extends Annotation>> list = text.getAnnotations$ui_text();
                if (list == null) break block1;
                List<Range<? extends Annotation>> $this$fastForEach$iv = list;
                boolean $i$f$fastForEach = false;
                int n = ((Collection)$this$fastForEach$iv).size();
                for (int index$iv = 0; index$iv < n; ++index$iv) {
                    Range<? extends Annotation> item$iv;
                    Range<? extends Annotation> it = item$iv = $this$fastForEach$iv.get(index$iv);
                    boolean bl = false;
                    this.annotations.add(new MutableRange<Annotation>(it.getItem(), start + it.getStart(), start + it.getEnd(), it.getTag()));
                }
            }
        }

        public final void append(@NotNull AnnotatedString text, int start, int end) {
            block1: {
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                int insertionStart = this.text.length();
                this.text.append(text.getText(), start, end);
                List list = AnnotatedStringKt.getLocalAnnotations$default(text, start, end, null, 4, null);
                if (list == null) break block1;
                List $this$fastForEach$iv = list;
                boolean $i$f$fastForEach = false;
                int n = ((Collection)$this$fastForEach$iv).size();
                for (int index$iv = 0; index$iv < n; ++index$iv) {
                    Object item$iv = $this$fastForEach$iv.get(index$iv);
                    Range it = (Range)item$iv;
                    boolean bl = false;
                    this.annotations.add(new MutableRange(it.getItem(), insertionStart + it.getStart(), insertionStart + it.getEnd(), it.getTag()));
                }
            }
        }

        public final void addStyle(@NotNull SpanStyle style, int start, int end) {
            Intrinsics.checkNotNullParameter((Object)style, (String)"style");
            this.annotations.add(new MutableRange(style, start, end, null, 8, null));
        }

        public final void addStyle(@NotNull ParagraphStyle style, int start, int end) {
            Intrinsics.checkNotNullParameter((Object)style, (String)"style");
            this.annotations.add(new MutableRange(style, start, end, null, 8, null));
        }

        public final void addStringAnnotation(@NotNull String tag, @NotNull String annotation, int start, int end) {
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
            this.annotations.add(new MutableRange<StringAnnotation>(StringAnnotation.box-impl(StringAnnotation.constructor-impl(annotation)), start, end, tag));
        }

        public final void addTtsAnnotation(@NotNull TtsAnnotation ttsAnnotation, int start, int end) {
            Intrinsics.checkNotNullParameter((Object)ttsAnnotation, (String)"ttsAnnotation");
            this.annotations.add(new MutableRange(ttsAnnotation, start, end, null, 8, null));
        }

        @Deprecated(message="Use LinkAnnotation API for links instead", replaceWith=@ReplaceWith(expression="addLink(, start, end)", imports={}))
        @ExperimentalTextApi
        public final void addUrlAnnotation(@NotNull UrlAnnotation urlAnnotation, int start, int end) {
            Intrinsics.checkNotNullParameter((Object)urlAnnotation, (String)"urlAnnotation");
            this.annotations.add(new MutableRange(urlAnnotation, start, end, null, 8, null));
        }

        public final void addLink(@NotNull LinkAnnotation.Url url, int start, int end) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            this.annotations.add(new MutableRange(url, start, end, null, 8, null));
        }

        public final void addLink(@NotNull LinkAnnotation.Clickable clickable, int start, int end) {
            Intrinsics.checkNotNullParameter((Object)clickable, (String)"clickable");
            this.annotations.add(new MutableRange(clickable, start, end, null, 8, null));
        }

        public final void addBullet(@NotNull Bullet bullet, int start, int end) {
            Intrinsics.checkNotNullParameter((Object)bullet, (String)"bullet");
            this.annotations.add(new MutableRange(bullet, start, end, null, 8, null));
        }

        public final void addBullet-r9BaKPg(@NotNull Bullet bullet, long l, int start, int end) {
            Intrinsics.checkNotNullParameter((Object)bullet, (String)"bullet");
            ParagraphStyle bulletParStyle = new ParagraphStyle(0, 0, 0L, new TextIndent(l, l, null), null, null, 0, 0, null, 503, null);
            this.annotations.add(new MutableRange(bulletParStyle, start, end, null, 8, null));
            this.annotations.add(new MutableRange(bullet, start, end, null, 8, null));
        }

        public final int pushStyle(@NotNull SpanStyle style) {
            MutableRange mutableRange;
            Intrinsics.checkNotNullParameter((Object)style, (String)"style");
            MutableRange it = mutableRange = new MutableRange(style, this.text.length(), 0, null, 12, null);
            boolean bl = false;
            this.styleStack.add(it);
            this.annotations.add(it);
            return this.styleStack.size() - 1;
        }

        public final int pushStyle(@NotNull ParagraphStyle style) {
            MutableRange mutableRange;
            Intrinsics.checkNotNullParameter((Object)style, (String)"style");
            MutableRange it = mutableRange = new MutableRange(style, this.text.length(), 0, null, 12, null);
            boolean bl = false;
            this.styleStack.add(it);
            this.annotations.add(it);
            return this.styleStack.size() - 1;
        }

        public final int pushBullet(@NotNull Bullet bullet) {
            MutableRange mutableRange;
            Intrinsics.checkNotNullParameter((Object)bullet, (String)"bullet");
            MutableRange it = mutableRange = new MutableRange(bullet, this.text.length(), 0, null, 12, null);
            boolean bl = false;
            this.styleStack.add(it);
            this.annotations.add(it);
            return this.styleStack.size() - 1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @NotNull
        public final <R> R withBulletList-o2QH7mI(long l, @NotNull Bullet bullet, @NotNull Function1<? super BulletScope, ? extends R> block) {
            boolean bl;
            Object object;
            long l2;
            Intrinsics.checkNotNullParameter((Object)bullet, (String)"bullet");
            Intrinsics.checkNotNullParameter(block, (String)"block");
            Pair pair = (Pair)CollectionsKt.lastOrNull(this.bulletScope.getBulletListSettingStack$ui_text());
            if (pair != null) {
                long it = ((TextUnit)pair.getFirst()).unbox-impl();
                boolean bl2 = false;
                boolean value$iv = TextUnitType.equals-impl0((long)TextUnit.getType-UIouoOA((long)it), (long)TextUnit.getType-UIouoOA((long)l));
                boolean $i$f$checkPrecondition = false;
                if (!value$iv) {
                    boolean bl3 = false;
                    InlineClassHelperKt.throwIllegalStateException("Indentation unit types of nested bullet lists must match. Current " + TextUnit.toString-impl((long)it) + " and previous is " + TextUnit.toString-impl((long)l));
                }
                long l3 = TextUnit.getType-UIouoOA((long)l);
                l2 = TextUnitType.equals-impl0((long)l3, (long)TextUnitType.Companion.getSp-UIouoOA()) ? TextUnitKt.getSp((float)(TextUnit.getValue-impl((long)l) + TextUnit.getValue-impl((long)it))) : (TextUnitType.equals-impl0((long)l3, (long)TextUnitType.Companion.getEm-UIouoOA()) ? TextUnitKt.getEm((float)(TextUnit.getValue-impl((long)l) + TextUnit.getValue-impl((long)it))) : l);
            } else {
                l2 = l;
            }
            long adjustedIndentation = l2;
            int parIndex = this.pushStyle(new ParagraphStyle(0, 0, 0L, new TextIndent(adjustedIndentation, adjustedIndentation, null), null, null, 0, 0, null, 503, null));
            this.bulletScope.getBulletListSettingStack$ui_text().add((Pair<TextUnit, Bullet>)new Pair((Object)TextUnit.box-impl((long)adjustedIndentation), (Object)bullet));
            try {
                object = block.invoke((Object)this.bulletScope);
                bl = !((Collection)this.bulletScope.getBulletListSettingStack$ui_text()).isEmpty();
            }
            catch (Throwable throwable) {
                if (!((Collection)this.bulletScope.getBulletListSettingStack$ui_text()).isEmpty()) {
                    this.bulletScope.getBulletListSettingStack$ui_text().remove(CollectionsKt.getLastIndex(this.bulletScope.getBulletListSettingStack$ui_text()));
                }
                this.pop(parIndex);
                throw throwable;
            }
            if (bl) {
                this.bulletScope.getBulletListSettingStack$ui_text().remove(CollectionsKt.getLastIndex(this.bulletScope.getBulletListSettingStack$ui_text()));
            }
            this.pop(parIndex);
            return (R)object;
        }

        public static /* synthetic */ Object withBulletList-o2QH7mI$default(Builder builder, long l, Bullet bullet, Function1 function1, int n, Object object) {
            if ((n & 1) != 0) {
                l = Bullet.Companion.getDefaultIndentation-XSAIIZE();
            }
            if ((n & 2) != 0) {
                bullet = Bullet.Companion.getDefault();
            }
            return builder.withBulletList-o2QH7mI(l, bullet, function1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final <R> R withBulletListItem(@NotNull BulletScope $this$withBulletListItem, @Nullable Bullet bullet, @NotNull Function1<? super Builder, ? extends R> block) {
            Object object;
            Pair lastItemInStack;
            Intrinsics.checkNotNullParameter((Object)$this$withBulletListItem, (String)"<this>");
            Intrinsics.checkNotNullParameter(block, (String)"block");
            Pair pair = lastItemInStack = (Pair)CollectionsKt.lastOrNull($this$withBulletListItem.getBulletListSettingStack$ui_text());
            long itemIndentation = pair != null ? ((TextUnit)pair.getFirst()).unbox-impl() : Bullet.Companion.getDefaultIndentation-XSAIIZE();
            Bullet bullet2 = bullet;
            if (bullet2 == null && ((bullet2 = lastItemInStack) == null || (bullet2 = (Bullet)bullet2.getSecond()) == null)) {
                bullet2 = Bullet.Companion.getDefault();
            }
            Bullet itemBullet = bullet2;
            int parIndex = $this$withBulletListItem.getBuilder$ui_text().pushStyle(new ParagraphStyle(0, 0, 0L, new TextIndent(itemIndentation, itemIndentation, null), null, null, 0, 0, null, 503, null));
            int bulletIndex = $this$withBulletListItem.getBuilder$ui_text().pushBullet(itemBullet);
            try {
                object = block.invoke((Object)$this$withBulletListItem.getBuilder$ui_text());
            }
            finally {
                $this$withBulletListItem.getBuilder$ui_text().pop(bulletIndex);
                $this$withBulletListItem.getBuilder$ui_text().pop(parIndex);
            }
            return (R)object;
        }

        public static /* synthetic */ Object withBulletListItem$default(Builder builder, BulletScope bulletScope, Bullet bullet, Function1 function1, int n, Object object) {
            if ((n & 1) != 0) {
                bullet = null;
            }
            return builder.withBulletListItem(bulletScope, bullet, function1);
        }

        public final int pushStringAnnotation(@NotNull String tag, @NotNull String annotation) {
            MutableRange mutableRange;
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
            MutableRange it = mutableRange = new MutableRange(StringAnnotation.box-impl(StringAnnotation.constructor-impl(annotation)), this.text.length(), 0, tag, 4, null);
            boolean bl = false;
            this.styleStack.add(it);
            this.annotations.add(it);
            return this.styleStack.size() - 1;
        }

        public final int pushTtsAnnotation(@NotNull TtsAnnotation ttsAnnotation) {
            MutableRange mutableRange;
            Intrinsics.checkNotNullParameter((Object)ttsAnnotation, (String)"ttsAnnotation");
            MutableRange it = mutableRange = new MutableRange(ttsAnnotation, this.text.length(), 0, null, 12, null);
            boolean bl = false;
            this.styleStack.add(it);
            this.annotations.add(it);
            return this.styleStack.size() - 1;
        }

        @Deprecated(message="Use LinkAnnotation API for links instead", replaceWith=@ReplaceWith(expression="pushLink(, start, end)", imports={}))
        @ExperimentalTextApi
        public final int pushUrlAnnotation(@NotNull UrlAnnotation urlAnnotation) {
            MutableRange mutableRange;
            Intrinsics.checkNotNullParameter((Object)urlAnnotation, (String)"urlAnnotation");
            MutableRange it = mutableRange = new MutableRange(urlAnnotation, this.text.length(), 0, null, 12, null);
            boolean bl = false;
            this.styleStack.add(it);
            this.annotations.add(it);
            return this.styleStack.size() - 1;
        }

        public final int pushLink(@NotNull LinkAnnotation link) {
            MutableRange mutableRange;
            Intrinsics.checkNotNullParameter((Object)link, (String)"link");
            MutableRange it = mutableRange = new MutableRange(link, this.text.length(), 0, null, 12, null);
            boolean bl = false;
            this.styleStack.add(it);
            this.annotations.add(it);
            return this.styleStack.size() - 1;
        }

        public final void pop() {
            boolean value$iv = !((Collection)this.styleStack).isEmpty();
            boolean $i$f$checkPrecondition = false;
            if (!value$iv) {
                boolean bl = false;
                InlineClassHelperKt.throwIllegalStateException("Nothing to pop.");
            }
            MutableRange<? extends Object> item = this.styleStack.remove(this.styleStack.size() - 1);
            item.setEnd(this.text.length());
        }

        public final void pop(int index2) {
            boolean value$iv = index2 < this.styleStack.size();
            boolean $i$f$checkPrecondition = false;
            if (!value$iv) {
                boolean bl = false;
                InlineClassHelperKt.throwIllegalStateException(index2 + " should be less than " + this.styleStack.size());
            }
            while (this.styleStack.size() - 1 >= index2) {
                this.pop();
            }
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final AnnotatedString toAnnotatedString() {
            void $this$fastMap$iv;
            String string = this.text.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            List<MutableRange<? extends Annotation>> list = this.annotations;
            String string2 = string;
            boolean $i$f$fastMap = false;
            ArrayList target$iv = new ArrayList($this$fastMap$iv.size());
            void $this$fastForEach$iv$iv = $this$fastMap$iv;
            boolean $i$f$fastForEach = false;
            int n = ((Collection)$this$fastForEach$iv$iv).size();
            for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
                void it;
                Object item$iv$iv;
                Object it$iv = item$iv$iv = $this$fastForEach$iv$iv.get(index$iv$iv);
                boolean bl = false;
                MutableRange mutableRange = (MutableRange)it$iv;
                Collection collection = target$iv;
                boolean bl2 = false;
                collection.add(it.toRange(this.text.length()));
            }
            List list2 = target$iv;
            String string3 = string2;
            return new AnnotatedString(string3, list2);
        }

        public final void mapAnnotations$ui_text(@NotNull Function1<? super Range<? extends Annotation>, ? extends Range<? extends Annotation>> transform) {
            Intrinsics.checkNotNullParameter(transform, (String)"transform");
            int n = ((Collection)this.annotations).size();
            for (int i = 0; i < n; ++i) {
                Range newAnnotation = (Range)transform.invoke((Object)MutableRange.toRange$default(this.annotations.get(i), 0, 1, null));
                this.annotations.set(i, MutableRange.Companion.fromRange(newAnnotation));
            }
        }

        /*
         * WARNING - void declaration
         */
        public final void flatMapAnnotations$ui_text(@NotNull Function1<? super Range<? extends Annotation>, ? extends List<? extends Range<? extends Annotation>>> transform) {
            Intrinsics.checkNotNullParameter(transform, (String)"transform");
            List<MutableRange<? extends Annotation>> $this$fastFlatMap$iv = this.annotations;
            boolean $i$f$fastFlatMap = false;
            ArrayList target$iv = new ArrayList($this$fastFlatMap$iv.size());
            List<MutableRange<? extends Annotation>> $this$fastForEach$iv$iv = $this$fastFlatMap$iv;
            boolean $i$f$fastForEach = false;
            int n = ((Collection)$this$fastForEach$iv$iv).size();
            for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
                MutableRange<? extends Annotation> item$iv$iv;
                MutableRange<? extends Annotation> e$iv = item$iv$iv = $this$fastForEach$iv$iv.get(index$iv$iv);
                boolean bl = false;
                MutableRange<? extends Annotation> annotation = e$iv;
                boolean bl2 = false;
                List $this$fastMap$iv = (List)transform.invoke((Object)MutableRange.toRange$default(annotation, 0, 1, null));
                boolean $i$f$fastMap = false;
                ArrayList target$iv2 = new ArrayList($this$fastMap$iv.size());
                List $this$fastForEach$iv$iv2 = $this$fastMap$iv;
                boolean $i$f$fastForEach2 = false;
                int n2 = ((Collection)$this$fastForEach$iv$iv2).size();
                for (int index$iv$iv2 = 0; index$iv$iv2 < n2; ++index$iv$iv2) {
                    void it;
                    Object item$iv$iv2;
                    Object it$iv = item$iv$iv2 = $this$fastForEach$iv$iv2.get(index$iv$iv2);
                    boolean bl3 = false;
                    Range range = (Range)it$iv;
                    Collection collection = target$iv2;
                    boolean bl4 = false;
                    collection.add(MutableRange.Companion.fromRange(it));
                }
                Iterable list$iv = target$iv2;
                CollectionsKt.addAll((Collection)target$iv, (Iterable)list$iv);
            }
            List replacedAnnotations = target$iv;
            this.annotations.clear();
            this.annotations.addAll(replacedAnnotations);
        }

        public Builder() {
            this(0, 1, null);
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0011\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R&\u0010\b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n0\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Landroidx/compose/ui/text/AnnotatedString$Builder$BulletScope;", "", "builder", "Landroidx/compose/ui/text/AnnotatedString$Builder;", "<init>", "(Landroidx/compose/ui/text/AnnotatedString$Builder;)V", "getBuilder$ui_text", "()Landroidx/compose/ui/text/AnnotatedString$Builder;", "bulletListSettingStack", "", "Lkotlin/Pair;", "Landroidx/compose/ui/unit/TextUnit;", "Landroidx/compose/ui/text/Bullet;", "getBulletListSettingStack$ui_text", "()Ljava/util/List;", "ui-text"})
        @StabilityInferred(parameters=0)
        public static final class BulletScope {
            @NotNull
            private final Builder builder;
            @NotNull
            private final List<Pair<TextUnit, Bullet>> bulletListSettingStack;
            public static final int $stable = 8;

            public BulletScope(@NotNull Builder builder) {
                Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
                this.builder = builder;
                this.bulletListSettingStack = new ArrayList();
            }

            @NotNull
            public final Builder getBuilder$ui_text() {
                return this.builder;
            }

            @NotNull
            public final List<Pair<TextUnit, Bullet>> getBulletListSettingStack$ui_text() {
                return this.bulletListSettingStack;
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0082\b\u0018\u0000 &*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001&B+\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u00162\b\b\u0002\u0010\u0017\u001a\u00020\u0005J0\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00180\u0016\"\u0004\b\u0001\u0010\u00182\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u0002H\u00180\u001a2\b\b\u0002\u0010\u0017\u001a\u00020\u0005J\u000e\u0010\u001b\u001a\u00028\u0000H\u00c6\u0003\u00a2\u0006\u0002\u0010\fJ\t\u0010\u001c\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\bH\u00c6\u0003J<\u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\b\b\u0002\u0010\u0003\u001a\u00028\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001\u00a2\u0006\u0002\u0010 J\u0013\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010$\u001a\u00020\u0005H\u00d6\u0001J\t\u0010%\u001a\u00020\bH\u00d6\u0001R\u0013\u0010\u0003\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0006\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u000f\"\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006'"}, d2={"Landroidx/compose/ui/text/AnnotatedString$Builder$MutableRange;", "T", "", "item", "start", "", "end", "tag", "", "<init>", "(Ljava/lang/Object;IILjava/lang/String;)V", "getItem", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getStart", "()I", "getEnd", "setEnd", "(I)V", "getTag", "()Ljava/lang/String;", "toRange", "Landroidx/compose/ui/text/AnnotatedString$Range;", "defaultEnd", "R", "transform", "Lkotlin/Function1;", "component1", "component2", "component3", "component4", "copy", "(Ljava/lang/Object;IILjava/lang/String;)Landroidx/compose/ui/text/AnnotatedString$Builder$MutableRange;", "equals", "", "other", "hashCode", "toString", "Companion", "ui-text"})
        @SourceDebugExtension(value={"SMAP\nAnnotatedString.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnnotatedString.kt\nandroidx/compose/ui/text/AnnotatedString$Builder$MutableRange\n+ 2 InlineClassHelper.kt\nandroidx/compose/ui/text/internal/InlineClassHelperKt\n*L\n1#1,1622:1\n81#2,4:1623\n81#2,4:1627\n*S KotlinDebug\n*F\n+ 1 AnnotatedString.kt\nandroidx/compose/ui/text/AnnotatedString$Builder$MutableRange\n*L\n418#1:1623,4\n429#1:1627,4\n*E\n"})
        private static final class MutableRange<T> {
            @NotNull
            public static final Companion Companion = new Companion(null);
            private final T item;
            private final int start;
            private int end;
            @NotNull
            private final String tag;

            public MutableRange(T item, int start, int end, @NotNull String tag) {
                Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
                this.item = item;
                this.start = start;
                this.end = end;
                this.tag = tag;
            }

            public /* synthetic */ MutableRange(Object object, int n, int n2, String string, int n3, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n3 & 4) != 0) {
                    n2 = Integer.MIN_VALUE;
                }
                if ((n3 & 8) != 0) {
                    string = "";
                }
                this(object, n, n2, string);
            }

            public final T getItem() {
                return this.item;
            }

            public final int getStart() {
                return this.start;
            }

            public final int getEnd() {
                return this.end;
            }

            public final void setEnd(int n) {
                this.end = n;
            }

            @NotNull
            public final String getTag() {
                return this.tag;
            }

            @NotNull
            public final Range<T> toRange(int defaultEnd) {
                int end = this.end == Integer.MIN_VALUE ? defaultEnd : this.end;
                boolean value$iv = end != Integer.MIN_VALUE;
                boolean $i$f$checkPrecondition = false;
                if (!value$iv) {
                    boolean bl = false;
                    InlineClassHelperKt.throwIllegalStateException("Item.end should be set first");
                }
                return new Range<T>(this.item, this.start, end, this.tag);
            }

            public static /* synthetic */ Range toRange$default(MutableRange mutableRange, int n, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    n = Integer.MIN_VALUE;
                }
                return mutableRange.toRange(n);
            }

            @NotNull
            public final <R> Range<R> toRange(@NotNull Function1<? super T, ? extends R> transform, int defaultEnd) {
                Intrinsics.checkNotNullParameter(transform, (String)"transform");
                int end = this.end == Integer.MIN_VALUE ? defaultEnd : this.end;
                boolean value$iv = end != Integer.MIN_VALUE;
                boolean $i$f$checkPrecondition = false;
                if (!value$iv) {
                    boolean bl = false;
                    InlineClassHelperKt.throwIllegalStateException("Item.end should be set first");
                }
                return new Range<Object>(transform.invoke(this.item), this.start, end, this.tag);
            }

            public static /* synthetic */ Range toRange$default(MutableRange mutableRange, Function1 function1, int n, int n2, Object object) {
                if ((n2 & 2) != 0) {
                    n = Integer.MIN_VALUE;
                }
                return mutableRange.toRange(function1, n);
            }

            public final T component1() {
                return this.item;
            }

            public final int component2() {
                return this.start;
            }

            public final int component3() {
                return this.end;
            }

            @NotNull
            public final String component4() {
                return this.tag;
            }

            @NotNull
            public final MutableRange<T> copy(T item, int start, int end, @NotNull String tag) {
                Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
                return new MutableRange<T>(item, start, end, tag);
            }

            public static /* synthetic */ MutableRange copy$default(MutableRange mutableRange, Object object, int n, int n2, String string, int n3, Object object2) {
                if ((n3 & 1) != 0) {
                    object = mutableRange.item;
                }
                if ((n3 & 2) != 0) {
                    n = mutableRange.start;
                }
                if ((n3 & 4) != 0) {
                    n2 = mutableRange.end;
                }
                if ((n3 & 8) != 0) {
                    string = mutableRange.tag;
                }
                return mutableRange.copy(object, n, n2, string);
            }

            @NotNull
            public String toString() {
                return "MutableRange(item=" + this.item + ", start=" + this.start + ", end=" + this.end + ", tag=" + this.tag + ")";
            }

            public int hashCode() {
                int result = this.item == null ? 0 : this.item.hashCode();
                result = result * 31 + Integer.hashCode(this.start);
                result = result * 31 + Integer.hashCode(this.end);
                result = result * 31 + this.tag.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof MutableRange)) {
                    return false;
                }
                MutableRange mutableRange = (MutableRange)other;
                if (!Intrinsics.areEqual(this.item, mutableRange.item)) {
                    return false;
                }
                if (this.start != mutableRange.start) {
                    return false;
                }
                if (this.end != mutableRange.end) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.tag, (Object)mutableRange.tag);
            }

            @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0005\"\u0004\b\u0001\u0010\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00060\b\u00a8\u0006\t"}, d2={"Landroidx/compose/ui/text/AnnotatedString$Builder$MutableRange$Companion;", "", "<init>", "()V", "fromRange", "Landroidx/compose/ui/text/AnnotatedString$Builder$MutableRange;", "T", "range", "Landroidx/compose/ui/text/AnnotatedString$Range;", "ui-text"})
            public static final class Companion {
                private Companion() {
                }

                @NotNull
                public final <T> MutableRange<T> fromRange(@NotNull Range<T> range) {
                    Intrinsics.checkNotNullParameter(range, (String)"range");
                    return new MutableRange<T>(range.getItem(), range.getStart(), range.getEnd(), range.getTag());
                }

                public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                    this();
                }
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001b\u0010\u0004\u001a\f\u0012\u0004\u0012\u00020\u0006\u0012\u0002\b\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Landroidx/compose/ui/text/AnnotatedString$Companion;", "", "<init>", "()V", "Saver", "Landroidx/compose/runtime/saveable/Saver;", "Landroidx/compose/ui/text/AnnotatedString;", "getSaver", "()Landroidx/compose/runtime/saveable/Saver;", "ui-text"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Saver<AnnotatedString, ?> getSaver() {
            return Saver;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Landroidx/compose/ui/text/AnnotatedString$ExhaustiveAnnotation;", "Landroidx/compose/ui/text/AnnotatedString$Annotation;", "<init>", "()V", "ui-text"})
    private static final class ExhaustiveAnnotation
    implements Annotation {
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0087\b\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B'\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nB!\b\u0016\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\t\u0010\u000bJ\u000e\u0010\u0014\u001a\u00028\u0000H\u00c6\u0003\u00a2\u0006\u0002\u0010\rJ\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\bH\u00c6\u0003J<\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\b\b\u0002\u0010\u0003\u001a\u00028\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001\u00a2\u0006\u0002\u0010\u0019J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u001e\u001a\u00020\bH\u00d6\u0001R\u0013\u0010\u0003\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001f"}, d2={"Landroidx/compose/ui/text/AnnotatedString$Range;", "T", "", "item", "start", "", "end", "tag", "", "<init>", "(Ljava/lang/Object;IILjava/lang/String;)V", "(Ljava/lang/Object;II)V", "getItem", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getStart", "()I", "getEnd", "getTag", "()Ljava/lang/String;", "component1", "component2", "component3", "component4", "copy", "(Ljava/lang/Object;IILjava/lang/String;)Landroidx/compose/ui/text/AnnotatedString$Range;", "equals", "", "other", "hashCode", "toString", "ui-text"})
    @Immutable
    @SourceDebugExtension(value={"SMAP\nAnnotatedString.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnnotatedString.kt\nandroidx/compose/ui/text/AnnotatedString$Range\n+ 2 InlineClassHelper.kt\nandroidx/compose/ui/text/internal/InlineClassHelperKt\n*L\n1#1,1622:1\n118#2,4:1623\n*S KotlinDebug\n*F\n+ 1 AnnotatedString.kt\nandroidx/compose/ui/text/AnnotatedString$Range\n*L\n387#1:1623,4\n*E\n"})
    public static final class Range<T> {
        private final T item;
        private final int start;
        private final int end;
        @NotNull
        private final String tag;
        public static final int $stable;

        public Range(T item, int start, int end, @NotNull String tag) {
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            this.item = item;
            this.start = start;
            this.end = end;
            this.tag = tag;
            boolean value$iv = this.start <= this.end;
            boolean $i$f$requirePrecondition = false;
            if (!value$iv) {
                boolean bl = false;
                InlineClassHelperKt.throwIllegalArgumentException("Reversed range is not supported");
            }
        }

        public final T getItem() {
            return this.item;
        }

        public final int getStart() {
            return this.start;
        }

        public final int getEnd() {
            return this.end;
        }

        @NotNull
        public final String getTag() {
            return this.tag;
        }

        public Range(T item, int start, int end) {
            this(item, start, end, "");
        }

        public final T component1() {
            return this.item;
        }

        public final int component2() {
            return this.start;
        }

        public final int component3() {
            return this.end;
        }

        @NotNull
        public final String component4() {
            return this.tag;
        }

        @NotNull
        public final Range<T> copy(T item, int start, int end, @NotNull String tag) {
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            return new Range<T>(item, start, end, tag);
        }

        public static /* synthetic */ Range copy$default(Range range, Object object, int n, int n2, String string, int n3, Object object2) {
            if ((n3 & 1) != 0) {
                object = range.item;
            }
            if ((n3 & 2) != 0) {
                n = range.start;
            }
            if ((n3 & 4) != 0) {
                n2 = range.end;
            }
            if ((n3 & 8) != 0) {
                string = range.tag;
            }
            return range.copy(object, n, n2, string);
        }

        @NotNull
        public String toString() {
            return "Range(item=" + this.item + ", start=" + this.start + ", end=" + this.end + ", tag=" + this.tag + ")";
        }

        public int hashCode() {
            int result = this.item == null ? 0 : this.item.hashCode();
            result = result * 31 + Integer.hashCode(this.start);
            result = result * 31 + Integer.hashCode(this.end);
            result = result * 31 + this.tag.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Range)) {
                return false;
            }
            Range range = (Range)other;
            if (!Intrinsics.areEqual(this.item, range.item)) {
                return false;
            }
            if (this.start != range.start) {
                return false;
            }
            if (this.end != range.end) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.tag, (Object)range.tag);
        }
    }
}

