/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.glkontext;

import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.HexExtensionsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import vet.inpulse.glkontext.GlKontextKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lvet/inpulse/glkontext/GlKontext;", "", "<init>", "()V", "Companion", "glkontext"})
public final class GlKontext {
    @NotNull
    public static final Companion Companion;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Path extractedFilePath;
        block45: {
            URL url;
            block48: {
                String string;
                Companion = new Companion(null);
                String osName = System.getProperty("os.name");
                String osArch = System.getProperty("os.arch");
                Intrinsics.checkNotNull((Object)osName);
                if (StringsKt.startsWith$default((String)osName, (String)"Windows", (boolean)false, (int)2, null)) {
                    string = "windows";
                } else if (StringsKt.startsWith$default((String)osName, (String)"Linux", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)osName, (String)"FreeBSD", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)osName, (String)"SunOS", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)osName, (String)"Unix", (boolean)false, (int)2, null)) {
                    string = "linux";
                } else if (StringsKt.startsWith$default((String)osName, (String)"Mac OS X", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)osName, (String)"Darwin", (boolean)false, (int)2, null)) {
                    string = "macos";
                } else {
                    throw new IllegalStateException("Bruv, we don't support this OS: " + osName);
                }
                String os = string;
                Intrinsics.checkNotNull((Object)osArch);
                boolean is64Bit = StringsKt.contains$default((CharSequence)osArch, (CharSequence)"64", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)osArch, (String)"armv8", (boolean)false, (int)2, null);
                String arch = StringsKt.startsWith$default((String)osArch, (String)"arm", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)osArch, (String)"aarch64", (boolean)false, (int)2, null) ? (is64Bit ? "aarch64" : "arm32") : (is64Bit ? "x86-64" : "x86");
                String suffix = switch (os) {
                    case "windows" -> "dll";
                    case "linux" -> "so";
                    case "macos" -> "dylib";
                    default -> throw new IllegalStateException("Platform is not supported");
                };
                String prefix = switch (os) {
                    case "windows" -> "";
                    case "linux", "macos" -> "lib";
                    default -> throw new IllegalStateException("Platform is not supported");
                };
                String fileName = prefix + "glkontext-native." + suffix;
                String basePath = os + "/" + arch;
                String resource = basePath + "/" + fileName;
                ClassLoader classLoader = GlKontext.class.getClassLoader();
                Intrinsics.checkNotNull((Object)classLoader);
                URL uRL = classLoader.getResource(resource);
                if (uRL == null) {
                    throw new IllegalStateException("could not find shared library for current platform. resource: " + resource);
                }
                url = uRL;
                Object object = url.openStream();
                if (object == null || (object = Companion.sha256((InputStream)object)) == null) {
                    throw new IllegalStateException("Could not open url: " + url);
                }
                Object originalHash = object;
                String string2 = System.getProperty("java.io.tmpdir");
                Intrinsics.checkNotNull((Object)string2);
                Path path = Paths.get(string2, new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
                Path tempDir = path;
                Path path2 = tempDir.resolve(basePath);
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
                FileAttribute[] fileAttributeArray = new FileAttribute[]{};
                Path path3 = Files.createDirectories(path2, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"createDirectories(...)");
                extractedFilePath = path3.resolve(fileName);
                Intrinsics.checkNotNull((Object)extractedFilePath);
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (Files.notExists(extractedFilePath, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) break block48;
                OpenOption[] openOptionArray = new OpenOption[]{};
                InputStream inputStream = Files.newInputStream(extractedFilePath, Arrays.copyOf(openOptionArray, openOptionArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(...)");
                if (Intrinsics.areEqual((Object)Companion.sha256(inputStream), (Object)originalHash)) break block45;
            }
            OpenOption[] openOptionArray = new OpenOption[]{};
            OutputStream outputStream = Files.newOutputStream(extractedFilePath, Arrays.copyOf(openOptionArray, openOptionArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"newOutputStream(...)");
            Closeable closeable = outputStream;
            Throwable throwable = null;
            try {
                long l;
                OutputStream output = (OutputStream)closeable;
                boolean bl = false;
                InputStream inputStream = url.openStream();
                Intrinsics.checkNotNull((Object)inputStream);
                Closeable closeable2 = inputStream;
                Throwable throwable2 = null;
                try {
                    InputStream input = (InputStream)closeable2;
                    boolean bl2 = false;
                    l = input.transferTo(output);
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                }
                long l2 = l;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        System.load(((Object)extractedFilePath.toAbsolutePath()).toString());
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\n\u0010\u0004\u001a\u00020\u0005*\u00020\u0006J\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010\t\u001a\u00020\nJ\u0006\u0010\u000b\u001a\u00020\nJ\u000e\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u000f\u001a\u00020\u000e2\b\b\u0002\u0010\u0010\u001a\u00020\bJ\u000e\u0010\u0011\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014\u00a8\u0006\u0015"}, d2={"Lvet/inpulse/glkontext/GlKontext$Companion;", "", "<init>", "()V", "sha256", "", "Ljava/io/InputStream;", "load", "", "saveContext", "", "restoreContext", "destroyContext", "context", "", "createContext", "debug", "makeContextCurrent", "getByteBufferAddress", "byteBuffer", "Ljava/nio/ByteBuffer;", "glkontext"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String sha256(@NotNull InputStream $this$sha256) {
            Intrinsics.checkNotNullParameter((Object)$this$sha256, (String)"<this>");
            byte[] buffer = new byte[8196];
            MessageDigest digest = MessageDigest.getInstance("SHA256");
            int read = 0;
            do {
                if ((read = $this$sha256.read(buffer)) <= 0) continue;
                digest.update(buffer, 0, read);
            } while (read > 0);
            byte[] byArray = digest.digest();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"digest(...)");
            return HexExtensionsKt.toHexString$default((byte[])byArray, null, (int)1, null);
        }

        public final boolean load() {
            return GlKontextKt.nGlkLoad();
        }

        public final void saveContext() {
            GlKontextKt.nGlkSaveContext();
        }

        public final void restoreContext() {
            GlKontextKt.nGlkRestoreContext();
        }

        public final void destroyContext(long context) {
            GlKontextKt.nGlkDestroyContext(context);
        }

        public final long createContext(boolean debug) {
            return GlKontextKt.nGlkCreateContext(debug);
        }

        public static /* synthetic */ long createContext$default(Companion companion, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                bl = false;
            }
            return companion.createContext(bl);
        }

        public final void makeContextCurrent(long context) {
            GlKontextKt.nGlkMakeContextCurrent(context);
        }

        public final long getByteBufferAddress(@NotNull ByteBuffer byteBuffer) {
            Intrinsics.checkNotNullParameter((Object)byteBuffer, (String)"byteBuffer");
            if (!byteBuffer.isDirect()) {
                boolean bl = false;
                String string = "ByteBuffer must be direct";
                throw new IllegalArgumentException(string.toString());
            }
            return GlKontextKt.nGlkGetDirectByteBufferAddress(byteBuffer);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

