/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.multik.kotlin.stat;

import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.multik.api.stat.Statistics;
import org.jetbrains.kotlinx.multik.kotlin.math.KEMath;
import org.jetbrains.kotlinx.multik.kotlin.math.KEMathKt;
import org.jetbrains.kotlinx.multik.ndarray.data.D1;
import org.jetbrains.kotlinx.multik.ndarray.data.D2;
import org.jetbrains.kotlinx.multik.ndarray.data.D3;
import org.jetbrains.kotlinx.multik.ndarray.data.D4;
import org.jetbrains.kotlinx.multik.ndarray.data.DN;
import org.jetbrains.kotlinx.multik.ndarray.data.DataType;
import org.jetbrains.kotlinx.multik.ndarray.data.DimN;
import org.jetbrains.kotlinx.multik.ndarray.data.Dimension;
import org.jetbrains.kotlinx.multik.ndarray.data.ImmutableMemoryView;
import org.jetbrains.kotlinx.multik.ndarray.data.MemoryView;
import org.jetbrains.kotlinx.multik.ndarray.data.MemoryViewKt;
import org.jetbrains.kotlinx.multik.ndarray.data.MultiArray;
import org.jetbrains.kotlinx.multik.ndarray.data.NDArray;
import org.jetbrains.kotlinx.multik.ndarray.data.RInt;
import org.jetbrains.kotlinx.multik.ndarray.data.SliceKt;
import org.jetbrains.kotlinx.multik.ndarray.data.ViewGettersAndSettersKt;
import org.jetbrains.kotlinx.multik.ndarray.operations.IteratingNDArrayKt;
import org.jetbrains.kotlinx.multik.ndarray.operations._ArithmeticNDArrayKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0004\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JF\u0010\u0003\u001a\u00020\u0004\"\b\b\u0000\u0010\u0005*\u00020\u0006\"\b\b\u0001\u0010\u0007*\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u0002H\u00070\n2\u0014\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u0002H\u0007\u0018\u00010\nH\u0016J0\u0010\f\u001a\u00020\u0004\"\b\b\u0000\u0010\u0005*\u00020\u0006\"\b\b\u0001\u0010\u0007*\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u0002H\u00070\nH\u0016JN\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u0002H\u000e0\r\"\b\b\u0000\u0010\u0005*\u00020\u0006\"\b\b\u0001\u0010\u0007*\u00020\b\"\b\b\u0002\u0010\u000e*\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u0002H\u00070\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J:\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00120\r\"\b\b\u0000\u0010\u0005*\u00020\u00062\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u00020\u00130\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J:\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00130\r\"\b\b\u0000\u0010\u0005*\u00020\u00062\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u00020\u00150\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J:\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00150\r\"\b\b\u0000\u0010\u0005*\u00020\u00062\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u00020\u00170\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J:\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00170\r\"\b\b\u0000\u0010\u0005*\u00020\u00062\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u00020\u00190\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J7\u0010\u001a\u001a\u0004\u0018\u00010\u0004\"\b\b\u0000\u0010\u0005*\u00020\u0006\"\b\b\u0001\u0010\u0007*\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u0002H\u00070\nH\u0016\u00a2\u0006\u0002\u0010\u001b\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlinx/multik/kotlin/stat/KEStatistics;", "Lorg/jetbrains/kotlinx/multik/api/stat/Statistics;", "()V", "average", "", "T", "", "D", "Lorg/jetbrains/kotlinx/multik/ndarray/data/Dimension;", "a", "Lorg/jetbrains/kotlinx/multik/ndarray/data/MultiArray;", "weights", "mean", "Lorg/jetbrains/kotlinx/multik/ndarray/data/NDArray;", "O", "axis", "", "meanD2", "Lorg/jetbrains/kotlinx/multik/ndarray/data/D1;", "Lorg/jetbrains/kotlinx/multik/ndarray/data/D2;", "meanD3", "Lorg/jetbrains/kotlinx/multik/ndarray/data/D3;", "meanD4", "Lorg/jetbrains/kotlinx/multik/ndarray/data/D4;", "meanDN", "Lorg/jetbrains/kotlinx/multik/ndarray/data/DN;", "median", "(Lorg/jetbrains/kotlinx/multik/ndarray/data/MultiArray;)Ljava/lang/Double;", "multik-kotlin"})
@SourceDebugExtension(value={"SMAP\nKEStatistics.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KEStatistics.kt\norg/jetbrains/kotlinx/multik/kotlin/stat/KEStatistics\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 Dimensions.kt\norg/jetbrains/kotlinx/multik/ndarray/data/DimensionsKt\n*L\n1#1,77:1\n1#2:78\n12762#3,3:79\n25#4,7:82\n*S KotlinDebug\n*F\n+ 1 KEStatistics.kt\norg/jetbrains/kotlinx/multik/kotlin/stat/KEStatistics\n*L\n48#1:79,3\n65#1:82,7\n*E\n"})
public final class KEStatistics
implements Statistics {
    @NotNull
    public static final KEStatistics INSTANCE = new KEStatistics();

    private KEStatistics() {
    }

    @Nullable
    public <T extends Number, D extends Dimension> Double median(@NotNull MultiArray<T, D> a) {
        Double d;
        Intrinsics.checkNotNullParameter(a, (String)"a");
        int size = a.getSize();
        if (size == 1) {
            d = ((Number)IteratingNDArrayKt.first(a)).doubleValue();
        } else if (size > 1) {
            NDArray sorted = IteratingNDArrayKt.sorted(a);
            int mid = size / 2;
            d = size % 2 != 0 ? ((Number)sorted.getData().get(mid)).doubleValue() : (((Number)sorted.getData().get(mid - 1)).doubleValue() + ((Number)sorted.getData().get(mid)).doubleValue()) / (double)2;
        } else {
            d = null;
        }
        return d;
    }

    public <T extends Number, D extends Dimension> double average(@NotNull MultiArray<T, D> a, @Nullable MultiArray<T, D> weights) {
        Intrinsics.checkNotNullParameter(a, (String)"a");
        if (weights == null) {
            return this.mean(a);
        }
        return ((Number)KEMath.INSTANCE.sum((MultiArray)_ArithmeticNDArrayKt.times(a, weights))).doubleValue() / ((Number)KEMath.INSTANCE.sum(weights)).doubleValue();
    }

    public <T extends Number, D extends Dimension> double mean(@NotNull MultiArray<T, D> a) {
        Intrinsics.checkNotNullParameter(a, (String)"a");
        T ret = KEMath.INSTANCE.sum(a);
        return ((Number)ret).doubleValue() / (double)a.getSize();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public <T extends Number, D extends Dimension, O extends Dimension> NDArray<Double, O> mean(@NotNull MultiArray<T, D> a, int axis) {
        DimN dimN;
        int n;
        void $this$fold$iv;
        int[] newShape;
        Intrinsics.checkNotNullParameter(a, (String)"a");
        if (!(a.getDim().getD() > 1)) {
            boolean $i$a$-require-KEStatistics$mean$32 = false;
            String $i$a$-require-KEStatistics$mean$32 = "NDArray of dimension one, use the `mean` function without axis.";
            throw new IllegalArgumentException($i$a$-require-KEStatistics$mean$32.toString());
        }
        if (!(0 <= axis ? axis < a.getDim().getD() : false)) {
            boolean $i$a$-require-KEStatistics$mean$42 = false;
            String $i$a$-require-KEStatistics$mean$42 = "axis " + axis + " is out of bounds for this ndarray of dimension " + a.getDim().getD() + '.';
            throw new IllegalArgumentException($i$a$-require-KEStatistics$mean$42.toString());
        }
        int[] nArray = newShape = KEMathKt.remove(a.getShape(), axis);
        int initial$iv = 1;
        int $i$f$fold = 0;
        int accumulator$iv = initial$iv;
        for (void element$iv : $this$fold$iv) {
            void p1;
            n = element$iv;
            int p0 = accumulator$iv;
            boolean bl = false;
            accumulator$iv = p0 * p1;
        }
        MemoryView retData = MemoryViewKt.initMemoryView((int)accumulator$iv, (DataType)DataType.DoubleDataType);
        Map indexMap = new LinkedHashMap();
        $i$f$fold = a.getShape().length;
        for (int i = 0; i < $i$f$fold; ++i) {
            if (i == axis) continue;
            Integer n2 = i;
            indexMap.put(n2, RInt.until-impl((int)SliceKt.getR((int)0), (int)a.getShape()[i]));
        }
        $i$f$fold = a.getShape()[axis];
        for (int index = 0; index < $i$f$fold; ++index) {
            Integer n3 = axis;
            indexMap.put(n3, RInt.box-impl((int)SliceKt.getR((int)index)));
            NDArray t = ViewGettersAndSettersKt.slice(a, (Map)indexMap);
            int count = 0;
            for (Number element : t) {
                n = count++;
                retData.set(n, (Object)(((Number)retData.get(n)).doubleValue() + element.doubleValue()));
            }
        }
        ImmutableMemoryView immutableMemoryView = (ImmutableMemoryView)retData;
        int dim$iv = newShape.length;
        boolean $i$f$dimensionOf = false;
        switch (dim$iv) {
            case 1: {
                dimN = (DimN)D1.Companion;
                break;
            }
            case 2: {
                dimN = (DimN)D2.Companion;
                break;
            }
            case 3: {
                dimN = (DimN)D3.Companion;
                break;
            }
            case 4: {
                dimN = (DimN)D4.Companion;
                break;
            }
            default: {
                dimN = (DimN)new DN(dim$iv);
            }
        }
        Intrinsics.checkNotNull((Object)dimN, (String)"null cannot be cast to non-null type D of org.jetbrains.kotlinx.multik.ndarray.data.DimensionsKt.dimensionOf");
        return _ArithmeticNDArrayKt.div((MultiArray)((MultiArray)new NDArray(immutableMemoryView, 0, newShape, null, (Dimension)dimN, null, 40, null)), (Object)a.getShape()[axis]);
    }

    @NotNull
    public <T extends Number> NDArray<Double, D1> meanD2(@NotNull MultiArray<T, D2> a, int axis) {
        Intrinsics.checkNotNullParameter(a, (String)"a");
        return this.mean(a, axis);
    }

    @NotNull
    public <T extends Number> NDArray<Double, D2> meanD3(@NotNull MultiArray<T, D3> a, int axis) {
        Intrinsics.checkNotNullParameter(a, (String)"a");
        return this.mean(a, axis);
    }

    @NotNull
    public <T extends Number> NDArray<Double, D3> meanD4(@NotNull MultiArray<T, D4> a, int axis) {
        Intrinsics.checkNotNullParameter(a, (String)"a");
        return this.mean(a, axis);
    }

    @NotNull
    public <T extends Number> NDArray<Double, D4> meanDN(@NotNull MultiArray<T, DN> a, int axis) {
        Intrinsics.checkNotNullParameter(a, (String)"a");
        return this.mean(a, axis);
    }
}

