/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.multik.kotlin.math;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.multik.api.ConstructorsKt;
import org.jetbrains.kotlinx.multik.api.Multik;
import org.jetbrains.kotlinx.multik.api.math.Math;
import org.jetbrains.kotlinx.multik.api.math.MathEx;
import org.jetbrains.kotlinx.multik.kotlin.math.KEMathEx;
import org.jetbrains.kotlinx.multik.kotlin.math.KEMathKt;
import org.jetbrains.kotlinx.multik.ndarray.data.D1;
import org.jetbrains.kotlinx.multik.ndarray.data.D2;
import org.jetbrains.kotlinx.multik.ndarray.data.D3;
import org.jetbrains.kotlinx.multik.ndarray.data.D4;
import org.jetbrains.kotlinx.multik.ndarray.data.DN;
import org.jetbrains.kotlinx.multik.ndarray.data.DataType;
import org.jetbrains.kotlinx.multik.ndarray.data.DimN;
import org.jetbrains.kotlinx.multik.ndarray.data.Dimension;
import org.jetbrains.kotlinx.multik.ndarray.data.ImmutableMemoryView;
import org.jetbrains.kotlinx.multik.ndarray.data.InternalsKt;
import org.jetbrains.kotlinx.multik.ndarray.data.MemoryView;
import org.jetbrains.kotlinx.multik.ndarray.data.MemoryViewKt;
import org.jetbrains.kotlinx.multik.ndarray.data.MultiArray;
import org.jetbrains.kotlinx.multik.ndarray.data.MutableMultiArray;
import org.jetbrains.kotlinx.multik.ndarray.data.NDArray;
import org.jetbrains.kotlinx.multik.ndarray.data.RInt;
import org.jetbrains.kotlinx.multik.ndarray.data.ScalarsGettersAndSettersKt;
import org.jetbrains.kotlinx.multik.ndarray.data.SliceKt;
import org.jetbrains.kotlinx.multik.ndarray.data.ViewGettersAndSettersKt;
import org.jetbrains.kotlinx.multik.ndarray.operations.IteratingNDArrayKt;
import org.jetbrains.kotlinx.multik.ndarray.operations._ArithmeticNDArrayKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0004\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0011\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0007\u001a\u00020\b\"\b\b\u0000\u0010\t*\u00020\n\"\b\b\u0001\u0010\u000b*\u00020\f2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u0002H\t\u0012\u0004\u0012\u0002H\u000b0\u000eH\u0016JN\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u0002H\u00100\u000f\"\b\b\u0000\u0010\t*\u00020\n\"\b\b\u0001\u0010\u000b*\u00020\f\"\b\b\u0002\u0010\u0010*\u00020\f2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u0002H\t\u0012\u0004\u0012\u0002H\u000b0\u000e2\u0006\u0010\u0011\u001a\u00020\bH\u0016J:\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00130\u000f\"\b\b\u0000\u0010\t*\u00020\n2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u0002H\t\u0012\u0004\u0012\u00020\u00140\u000e2\u0006\u0010\u0011\u001a\u00020\bH\u0016J:\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00140\u000f\"\b\b\u0000\u0010\t*\u00020\n2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u0002H\t\u0012\u0004\u0012\u00020\u00160\u000e2\u0006\u0010\u0011\u001a\u00020\bH\u0016J:\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00160\u000f\"\b\b\u0000\u0010\t*\u00020\n2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u0002H\t\u0012\u0004\u0012\u00020\u00180\u000e2\u0006\u0010\u0011\u001a\u00020\bH\u0016J:\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u001a0\u000f\"\b\b\u0000\u0010\t*\u00020\n2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u0002H\t\u0012\u0004\u0012\u00020\u001a0\u000e2\u0006\u0010\u0011\u001a\u00020\bH\u0016J0\u0010\u001b\u001a\u00020\b\"\b\b\u0000\u0010\t*\u00020\n\"\b\b\u0001\u0010\u000b*\u00020\f2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u0002H\t\u0012\u0004\u0012\u0002H\u000b0\u000eH\u0016JN\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u0002H\u00100\u000f\"\b\b\u0000\u0010\t*\u00020\n\"\b\b\u0001\u0010\u000b*\u00020\f\"\b\b\u0002\u0010\u0010*\u00020\f2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u0002H\t\u0012\u0004\u0012\u0002H\u000b0\u000e2\u0006\u0010\u0011\u001a\u00020\bH\u0016J:\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00130\u000f\"\b\b\u0000\u0010\t*\u00020\n2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u0002H\t\u0012\u0004\u0012\u00020\u00140\u000e2\u0006\u0010\u0011\u001a\u00020\bH\u0016J:\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00140\u000f\"\b\b\u0000\u0010\t*\u00020\n2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u0002H\t\u0012\u0004\u0012\u00020\u00160\u000e2\u0006\u0010\u0011\u001a\u00020\bH\u0016J:\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00160\u000f\"\b\b\u0000\u0010\t*\u00020\n2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u0002H\t\u0012\u0004\u0012\u00020\u00180\u000e2\u0006\u0010\u0011\u001a\u00020\bH\u0016J:\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u001a0\u000f\"\b\b\u0000\u0010\t*\u00020\n2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u0002H\t\u0012\u0004\u0012\u00020\u001a0\u000e2\u0006\u0010\u0011\u001a\u00020\bH\u0016JF\u0010 \u001a\u0018\u0012\u0004\u0012\u0002H\t\u0012\u0004\u0012\u00020\u00130\u000fj\b\u0012\u0004\u0012\u0002H\t`!\"\b\b\u0000\u0010\t*\u00020\n\"\b\b\u0001\u0010\u000b*\u00020\f2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u0002H\t\u0012\u0004\u0012\u0002H\u000b0\u000eH\u0016JD\u0010 \u001a\u000e\u0012\u0004\u0012\u0002H\t\u0012\u0004\u0012\u0002H\u000b0\u000f\"\b\b\u0000\u0010\t*\u00020\n\"\b\b\u0001\u0010\u000b*\u00020\f2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u0002H\t\u0012\u0004\u0012\u0002H\u000b0\u000e2\u0006\u0010\u0011\u001a\u00020\bH\u0016J5\u0010\"\u001a\u0002H\t\"\b\b\u0000\u0010\t*\u00020\n\"\b\b\u0001\u0010\u000b*\u00020\f2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u0002H\t\u0012\u0004\u0012\u0002H\u000b0\u000eH\u0016\u00a2\u0006\u0002\u0010#JN\u0010\"\u001a\u000e\u0012\u0004\u0012\u0002H\t\u0012\u0004\u0012\u0002H\u00100\u000f\"\b\b\u0000\u0010\t*\u00020\n\"\b\b\u0001\u0010\u000b*\u00020\f\"\b\b\u0002\u0010\u0010*\u00020\f2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u0002H\t\u0012\u0004\u0012\u0002H\u000b0\u000e2\u0006\u0010\u0011\u001a\u00020\bH\u0016J:\u0010$\u001a\u000e\u0012\u0004\u0012\u0002H\t\u0012\u0004\u0012\u00020\u00130\u000f\"\b\b\u0000\u0010\t*\u00020\n2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u0002H\t\u0012\u0004\u0012\u00020\u00140\u000e2\u0006\u0010\u0011\u001a\u00020\bH\u0016J:\u0010%\u001a\u000e\u0012\u0004\u0012\u0002H\t\u0012\u0004\u0012\u00020\u00140\u000f\"\b\b\u0000\u0010\t*\u00020\n2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u0002H\t\u0012\u0004\u0012\u00020\u00160\u000e2\u0006\u0010\u0011\u001a\u00020\bH\u0016J:\u0010&\u001a\u000e\u0012\u0004\u0012\u0002H\t\u0012\u0004\u0012\u00020\u00160\u000f\"\b\b\u0000\u0010\t*\u00020\n2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u0002H\t\u0012\u0004\u0012\u00020\u00180\u000e2\u0006\u0010\u0011\u001a\u00020\bH\u0016J:\u0010'\u001a\u000e\u0012\u0004\u0012\u0002H\t\u0012\u0004\u0012\u00020\u001a0\u000f\"\b\b\u0000\u0010\t*\u00020\n2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u0002H\t\u0012\u0004\u0012\u00020\u001a0\u000e2\u0006\u0010\u0011\u001a\u00020\bH\u0016J5\u0010(\u001a\u0002H\t\"\b\b\u0000\u0010\t*\u00020\n\"\b\b\u0001\u0010\u000b*\u00020\f2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u0002H\t\u0012\u0004\u0012\u0002H\u000b0\u000eH\u0016\u00a2\u0006\u0002\u0010#JN\u0010(\u001a\u000e\u0012\u0004\u0012\u0002H\t\u0012\u0004\u0012\u0002H\u00100\u000f\"\b\b\u0000\u0010\t*\u00020\n\"\b\b\u0001\u0010\u000b*\u00020\f\"\b\b\u0002\u0010\u0010*\u00020\f2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u0002H\t\u0012\u0004\u0012\u0002H\u000b0\u000e2\u0006\u0010\u0011\u001a\u00020\bH\u0016J:\u0010)\u001a\u000e\u0012\u0004\u0012\u0002H\t\u0012\u0004\u0012\u00020\u00130\u000f\"\b\b\u0000\u0010\t*\u00020\n2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u0002H\t\u0012\u0004\u0012\u00020\u00140\u000e2\u0006\u0010\u0011\u001a\u00020\bH\u0016J:\u0010*\u001a\u000e\u0012\u0004\u0012\u0002H\t\u0012\u0004\u0012\u00020\u00140\u000f\"\b\b\u0000\u0010\t*\u00020\n2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u0002H\t\u0012\u0004\u0012\u00020\u00160\u000e2\u0006\u0010\u0011\u001a\u00020\bH\u0016J:\u0010+\u001a\u000e\u0012\u0004\u0012\u0002H\t\u0012\u0004\u0012\u00020\u00160\u000f\"\b\b\u0000\u0010\t*\u00020\n2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u0002H\t\u0012\u0004\u0012\u00020\u00180\u000e2\u0006\u0010\u0011\u001a\u00020\bH\u0016J:\u0010,\u001a\u000e\u0012\u0004\u0012\u0002H\t\u0012\u0004\u0012\u00020\u001a0\u000f\"\b\b\u0000\u0010\t*\u00020\n2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u0002H\t\u0012\u0004\u0012\u00020\u001a0\u000e2\u0006\u0010\u0011\u001a\u00020\bH\u0016J5\u0010-\u001a\u0002H\t\"\b\b\u0000\u0010\t*\u00020\n\"\b\b\u0001\u0010\u000b*\u00020\f2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u0002H\t\u0012\u0004\u0012\u0002H\u000b0\u000eH\u0016\u00a2\u0006\u0002\u0010#JN\u0010-\u001a\u000e\u0012\u0004\u0012\u0002H\t\u0012\u0004\u0012\u0002H\u00100\u000f\"\b\b\u0000\u0010\t*\u00020\n\"\b\b\u0001\u0010\u000b*\u00020\f\"\b\b\u0002\u0010\u0010*\u00020\f2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u0002H\t\u0012\u0004\u0012\u0002H\u000b0\u000e2\u0006\u0010\u0011\u001a\u00020\bH\u0016J:\u0010.\u001a\u000e\u0012\u0004\u0012\u0002H\t\u0012\u0004\u0012\u00020\u00130\u000f\"\b\b\u0000\u0010\t*\u00020\n2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u0002H\t\u0012\u0004\u0012\u00020\u00140\u000e2\u0006\u0010\u0011\u001a\u00020\bH\u0016J:\u0010/\u001a\u000e\u0012\u0004\u0012\u0002H\t\u0012\u0004\u0012\u00020\u00140\u000f\"\b\b\u0000\u0010\t*\u00020\n2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u0002H\t\u0012\u0004\u0012\u00020\u00160\u000e2\u0006\u0010\u0011\u001a\u00020\bH\u0016J:\u00100\u001a\u000e\u0012\u0004\u0012\u0002H\t\u0012\u0004\u0012\u00020\u00160\u000f\"\b\b\u0000\u0010\t*\u00020\n2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u0002H\t\u0012\u0004\u0012\u00020\u00180\u000e2\u0006\u0010\u0011\u001a\u00020\bH\u0016J:\u00101\u001a\u000e\u0012\u0004\u0012\u0002H\t\u0012\u0004\u0012\u00020\u001a0\u000f\"\b\b\u0000\u0010\t*\u00020\n2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u0002H\t\u0012\u0004\u0012\u00020\u001a0\u000e2\u0006\u0010\u0011\u001a\u00020\bH\u0016R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u00062"}, d2={"Lorg/jetbrains/kotlinx/multik/kotlin/math/KEMath;", "Lorg/jetbrains/kotlinx/multik/api/math/Math;", "()V", "mathEx", "Lorg/jetbrains/kotlinx/multik/api/math/MathEx;", "getMathEx", "()Lorg/jetbrains/kotlinx/multik/api/math/MathEx;", "argMax", "", "T", "", "D", "Lorg/jetbrains/kotlinx/multik/ndarray/data/Dimension;", "a", "Lorg/jetbrains/kotlinx/multik/ndarray/data/MultiArray;", "Lorg/jetbrains/kotlinx/multik/ndarray/data/NDArray;", "O", "axis", "argMaxD2", "Lorg/jetbrains/kotlinx/multik/ndarray/data/D1;", "Lorg/jetbrains/kotlinx/multik/ndarray/data/D2;", "argMaxD3", "Lorg/jetbrains/kotlinx/multik/ndarray/data/D3;", "argMaxD4", "Lorg/jetbrains/kotlinx/multik/ndarray/data/D4;", "argMaxDN", "Lorg/jetbrains/kotlinx/multik/ndarray/data/DN;", "argMin", "argMinD2", "argMinD3", "argMinD4", "argMinDN", "cumSum", "Lorg/jetbrains/kotlinx/multik/ndarray/data/D1Array;", "max", "(Lorg/jetbrains/kotlinx/multik/ndarray/data/MultiArray;)Ljava/lang/Number;", "maxD2", "maxD3", "maxD4", "maxDN", "min", "minD2", "minD3", "minD4", "minDN", "sum", "sumD2", "sumD3", "sumD4", "sumDN", "multik-kotlin"})
@SourceDebugExtension(value={"SMAP\nKEMath.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KEMath.kt\norg/jetbrains/kotlinx/multik/kotlin/math/KEMath\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 Dimensions.kt\norg/jetbrains/kotlinx/multik/ndarray/data/DimensionsKt\n*L\n1#1,330:1\n1#2:331\n12762#3,3:332\n12762#3,3:342\n12762#3,3:352\n12762#3,3:362\n25#4,7:335\n25#4,7:345\n25#4,7:355\n25#4,7:365\n*S KotlinDebug\n*F\n+ 1 KEMath.kt\norg/jetbrains/kotlinx/multik/kotlin/math/KEMath\n*L\n41#1:332,3\n91#1:342,3\n133#1:352,3\n173#1:362,3\n61#1:335,7\n111#1:345,7\n151#1:355,7\n191#1:365,7\n*E\n"})
public final class KEMath
implements Math {
    @NotNull
    public static final KEMath INSTANCE = new KEMath();

    private KEMath() {
    }

    @NotNull
    public MathEx getMathEx() {
        return KEMathEx.INSTANCE;
    }

    public <T extends Number, D extends Dimension> int argMax(@NotNull MultiArray<T, D> a) {
        Intrinsics.checkNotNullParameter(a, (String)"a");
        int arg = 0;
        int count = 0;
        Number max2 = (Number)IteratingNDArrayKt.first(a);
        for (Number el : a) {
            if (InternalsKt.compareTo((Number)max2, (Number)el) < 0) {
                max2 = el;
                arg = count;
            }
            ++count;
        }
        return arg;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public <T extends Number, D extends Dimension, O extends Dimension> NDArray<Integer, O> argMax(@NotNull MultiArray<T, D> a, int axis) {
        DimN dimN;
        int n;
        void $this$fold$iv;
        Intrinsics.checkNotNullParameter(a, (String)"a");
        if (!(a.getDim().getD() > 1)) {
            boolean $i$a$-require-KEMath$argMax$32 = false;
            String $i$a$-require-KEMath$argMax$32 = "NDArray of dimension one, use the `argMax` function without axis.";
            throw new IllegalArgumentException($i$a$-require-KEMath$argMax$32.toString());
        }
        if (!(0 <= axis ? axis < a.getDim().getD() : false)) {
            boolean $i$a$-require-KEMath$argMax$42 = false;
            String $i$a$-require-KEMath$argMax$42 = "axis " + axis + " is out of bounds for this ndarray of dimension " + a.getDim().getD() + '.';
            throw new IllegalArgumentException($i$a$-require-KEMath$argMax$42.toString());
        }
        int[] newShape = KEMathKt.remove(a.getShape(), axis);
        T min2 = this.min(a);
        int[] nArray = newShape;
        int initial$iv22 = 1;
        int $i$f$fold = 0;
        int accumulator$iv = initial$iv22;
        int n2 = ((void)$this$fold$iv).length;
        for (n = 0; n < n2; ++n) {
            void p1;
            void element$iv;
            void var13_22 = element$iv = $this$fold$iv[n];
            int p0 = accumulator$iv;
            boolean bl = false;
            accumulator$iv = p0 * p1;
        }
        int size = accumulator$iv;
        ArrayList<T> initial$iv22 = new ArrayList<T>(size);
        $i$f$fold = 0;
        while ($i$f$fold < size) {
            n = accumulator$iv = $i$f$fold++;
            ArrayList<T> arrayList = initial$iv22;
            boolean bl = false;
            arrayList.add(min2);
        }
        List maxArray = initial$iv22;
        MemoryView argMaxData = MemoryViewKt.initMemoryView((int)size, (DataType)DataType.IntDataType);
        Map indexMap = new LinkedHashMap();
        int it = a.getShape().length;
        for (int i = 0; i < it; ++i) {
            if (i == axis) continue;
            Integer element$iv = i;
            indexMap.put(element$iv, RInt.until-impl((int)SliceKt.getR((int)0), (int)a.getShape()[i]));
        }
        it = a.getShape()[axis];
        for (int index = 0; index < it; ++index) {
            Integer element$iv = axis;
            indexMap.put(element$iv, RInt.box-impl((int)SliceKt.getR((int)index)));
            NDArray t = ViewGettersAndSettersKt.slice(a, (Map)indexMap);
            int count = 0;
            for (Number el : t) {
                if (InternalsKt.compareTo((Number)((Number)maxArray.get(count)), (Number)el) < 0) {
                    argMaxData.set(count, (Object)index);
                    maxArray.set(count, el);
                }
                ++count;
            }
        }
        ImmutableMemoryView immutableMemoryView = (ImmutableMemoryView)argMaxData;
        int dim$iv = newShape.length;
        boolean $i$f$dimensionOf = false;
        switch (dim$iv) {
            case 1: {
                dimN = (DimN)D1.Companion;
                break;
            }
            case 2: {
                dimN = (DimN)D2.Companion;
                break;
            }
            case 3: {
                dimN = (DimN)D3.Companion;
                break;
            }
            case 4: {
                dimN = (DimN)D4.Companion;
                break;
            }
            default: {
                dimN = (DimN)new DN(dim$iv);
            }
        }
        Intrinsics.checkNotNull((Object)dimN, (String)"null cannot be cast to non-null type D of org.jetbrains.kotlinx.multik.ndarray.data.DimensionsKt.dimensionOf");
        return new NDArray(immutableMemoryView, 0, newShape, null, (Dimension)dimN, null, 40, null);
    }

    @NotNull
    public <T extends Number> NDArray<Integer, D1> argMaxD2(@NotNull MultiArray<T, D2> a, int axis) {
        Intrinsics.checkNotNullParameter(a, (String)"a");
        return this.argMax(a, axis);
    }

    @NotNull
    public <T extends Number> NDArray<Integer, D2> argMaxD3(@NotNull MultiArray<T, D3> a, int axis) {
        Intrinsics.checkNotNullParameter(a, (String)"a");
        return this.argMax(a, axis);
    }

    @NotNull
    public <T extends Number> NDArray<Integer, D3> argMaxD4(@NotNull MultiArray<T, D4> a, int axis) {
        Intrinsics.checkNotNullParameter(a, (String)"a");
        return this.argMax(a, axis);
    }

    @NotNull
    public <T extends Number> NDArray<Integer, DN> argMaxDN(@NotNull MultiArray<T, DN> a, int axis) {
        Intrinsics.checkNotNullParameter(a, (String)"a");
        return this.argMax(a, axis);
    }

    public <T extends Number, D extends Dimension> int argMin(@NotNull MultiArray<T, D> a) {
        Intrinsics.checkNotNullParameter(a, (String)"a");
        int arg = 0;
        int count = 0;
        Number min2 = (Number)IteratingNDArrayKt.first(a);
        for (Number el : a) {
            if (InternalsKt.compareTo((Number)min2, (Number)el) > 0) {
                min2 = el;
                arg = count;
            }
            ++count;
        }
        return arg;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public <T extends Number, D extends Dimension, O extends Dimension> NDArray<Integer, O> argMin(@NotNull MultiArray<T, D> a, int axis) {
        DimN dimN;
        int n;
        void $this$fold$iv;
        Intrinsics.checkNotNullParameter(a, (String)"a");
        if (!(a.getDim().getD() > 1)) {
            boolean $i$a$-require-KEMath$argMin$32 = false;
            String $i$a$-require-KEMath$argMin$32 = "NDArray of dimension one, use the `argMin` function without axis.";
            throw new IllegalArgumentException($i$a$-require-KEMath$argMin$32.toString());
        }
        if (!(0 <= axis ? axis < a.getDim().getD() : false)) {
            boolean $i$a$-require-KEMath$argMin$42 = false;
            String $i$a$-require-KEMath$argMin$42 = "axis " + axis + " is out of bounds for this ndarray of dimension " + a.getDim().getD() + '.';
            throw new IllegalArgumentException($i$a$-require-KEMath$argMin$42.toString());
        }
        int[] newShape = KEMathKt.remove(a.getShape(), axis);
        T max2 = this.max(a);
        int[] nArray = newShape;
        int initial$iv22 = 1;
        int $i$f$fold = 0;
        int accumulator$iv = initial$iv22;
        int n2 = ((void)$this$fold$iv).length;
        for (n = 0; n < n2; ++n) {
            void p1;
            void element$iv;
            void var13_22 = element$iv = $this$fold$iv[n];
            int p0 = accumulator$iv;
            boolean bl = false;
            accumulator$iv = p0 * p1;
        }
        int size = accumulator$iv;
        ArrayList<T> initial$iv22 = new ArrayList<T>(size);
        $i$f$fold = 0;
        while ($i$f$fold < size) {
            n = accumulator$iv = $i$f$fold++;
            ArrayList<T> arrayList = initial$iv22;
            boolean bl = false;
            arrayList.add(max2);
        }
        List minArray = initial$iv22;
        MemoryView argMinData = MemoryViewKt.initMemoryView((int)size, (DataType)DataType.IntDataType);
        Map indexMap = new LinkedHashMap();
        int it = a.getShape().length;
        for (int i = 0; i < it; ++i) {
            if (i == axis) continue;
            Integer element$iv = i;
            indexMap.put(element$iv, RInt.until-impl((int)SliceKt.getR((int)0), (int)a.getShape()[i]));
        }
        it = a.getShape()[axis];
        for (int index = 0; index < it; ++index) {
            Integer element$iv = axis;
            indexMap.put(element$iv, RInt.box-impl((int)SliceKt.getR((int)index)));
            NDArray t = ViewGettersAndSettersKt.slice(a, (Map)indexMap);
            int count = 0;
            for (Number el : t) {
                if (InternalsKt.compareTo((Number)((Number)minArray.get(count)), (Number)el) > 0) {
                    argMinData.set(count, (Object)index);
                    minArray.set(count, el);
                }
                ++count;
            }
        }
        ImmutableMemoryView immutableMemoryView = (ImmutableMemoryView)argMinData;
        int dim$iv = newShape.length;
        boolean $i$f$dimensionOf = false;
        switch (dim$iv) {
            case 1: {
                dimN = (DimN)D1.Companion;
                break;
            }
            case 2: {
                dimN = (DimN)D2.Companion;
                break;
            }
            case 3: {
                dimN = (DimN)D3.Companion;
                break;
            }
            case 4: {
                dimN = (DimN)D4.Companion;
                break;
            }
            default: {
                dimN = (DimN)new DN(dim$iv);
            }
        }
        Intrinsics.checkNotNull((Object)dimN, (String)"null cannot be cast to non-null type D of org.jetbrains.kotlinx.multik.ndarray.data.DimensionsKt.dimensionOf");
        return new NDArray(immutableMemoryView, 0, newShape, null, (Dimension)dimN, null, 40, null);
    }

    @NotNull
    public <T extends Number> NDArray<Integer, D1> argMinD2(@NotNull MultiArray<T, D2> a, int axis) {
        Intrinsics.checkNotNullParameter(a, (String)"a");
        return this.argMin(a, axis);
    }

    @NotNull
    public <T extends Number> NDArray<Integer, D2> argMinD3(@NotNull MultiArray<T, D3> a, int axis) {
        Intrinsics.checkNotNullParameter(a, (String)"a");
        return this.argMin(a, axis);
    }

    @NotNull
    public <T extends Number> NDArray<Integer, D3> argMinD4(@NotNull MultiArray<T, D4> a, int axis) {
        Intrinsics.checkNotNullParameter(a, (String)"a");
        return this.argMin(a, axis);
    }

    @NotNull
    public <T extends Number> NDArray<Integer, DN> argMinDN(@NotNull MultiArray<T, DN> a, int axis) {
        Intrinsics.checkNotNullParameter(a, (String)"a");
        return this.argMin(a, axis);
    }

    @NotNull
    public <T extends Number, D extends Dimension> T max(@NotNull MultiArray<T, D> a) {
        Intrinsics.checkNotNullParameter(a, (String)"a");
        Number max2 = (Number)IteratingNDArrayKt.first(a);
        for (Number el : a) {
            if (InternalsKt.compareTo((Number)max2, (Number)el) >= 0) continue;
            max2 = el;
        }
        return (T)max2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public <T extends Number, D extends Dimension, O extends Dimension> NDArray<T, O> max(@NotNull MultiArray<T, D> a, int axis) {
        DimN dimN;
        void $this$fold$iv;
        Intrinsics.checkNotNullParameter(a, (String)"a");
        if (!(a.getDim().getD() > 1)) {
            boolean $i$a$-require-KEMath$max$32 = false;
            String $i$a$-require-KEMath$max$32 = "NDArray of dimension one, use the `max` function without axis.";
            throw new IllegalArgumentException($i$a$-require-KEMath$max$32.toString());
        }
        if (!(0 <= axis ? axis < a.getDim().getD() : false)) {
            boolean $i$a$-require-KEMath$max$42 = false;
            String $i$a$-require-KEMath$max$42 = "axis " + axis + " is out of bounds for this ndarray of dimension " + a.getDim().getD() + '.';
            throw new IllegalArgumentException($i$a$-require-KEMath$max$42.toString());
        }
        int[] newShape = KEMathKt.remove(a.getShape(), axis);
        T min2 = this.min(a);
        int[] nArray = newShape;
        int initial$iv = 1;
        boolean $i$f$fold = false;
        int accumulator$iv = initial$iv;
        int n = ((void)$this$fold$iv).length;
        for (int i = 0; i < n; ++i) {
            void p1;
            void element$iv;
            void var13_21 = element$iv = $this$fold$iv[i];
            int p0 = accumulator$iv;
            boolean bl = false;
            accumulator$iv = p0 * p1;
        }
        int size = accumulator$iv;
        MemoryView maxData2 = MemoryViewKt.initMemoryView((int)size, (DataType)a.getDtype(), (Function1)new Function1<Integer, T>(min2){
            final /* synthetic */ T $min;
            {
                this.$min = $min;
                super(1);
            }

            @NotNull
            public final T invoke(int it) {
                return this.$min;
            }
        });
        Map indexMap = new LinkedHashMap();
        accumulator$iv = a.getShape().length;
        for (int i = 0; i < accumulator$iv; ++i) {
            if (i == axis) continue;
            Integer n2 = i;
            indexMap.put(n2, RInt.until-impl((int)SliceKt.getR((int)0), (int)a.getShape()[i]));
        }
        accumulator$iv = a.getShape()[axis];
        for (int index = 0; index < accumulator$iv; ++index) {
            Integer n3 = axis;
            indexMap.put(n3, RInt.box-impl((int)SliceKt.getR((int)index)));
            NDArray t = ViewGettersAndSettersKt.slice(a, (Map)indexMap);
            int count = 0;
            for (Number el : t) {
                if (InternalsKt.compareTo((Number)((Number)maxData2.get(count)), (Number)el) < 0) {
                    maxData2.set(count, (Object)el);
                }
                ++count;
            }
        }
        ImmutableMemoryView immutableMemoryView = (ImmutableMemoryView)maxData2;
        int dim$iv = newShape.length;
        boolean $i$f$dimensionOf = false;
        switch (dim$iv) {
            case 1: {
                dimN = (DimN)D1.Companion;
                break;
            }
            case 2: {
                dimN = (DimN)D2.Companion;
                break;
            }
            case 3: {
                dimN = (DimN)D3.Companion;
                break;
            }
            case 4: {
                dimN = (DimN)D4.Companion;
                break;
            }
            default: {
                dimN = (DimN)new DN(dim$iv);
            }
        }
        Intrinsics.checkNotNull((Object)dimN, (String)"null cannot be cast to non-null type D of org.jetbrains.kotlinx.multik.ndarray.data.DimensionsKt.dimensionOf");
        return new NDArray(immutableMemoryView, 0, newShape, null, (Dimension)dimN, null, 40, null);
    }

    @NotNull
    public <T extends Number> NDArray<T, D1> maxD2(@NotNull MultiArray<T, D2> a, int axis) {
        Intrinsics.checkNotNullParameter(a, (String)"a");
        return this.max(a, axis);
    }

    @NotNull
    public <T extends Number> NDArray<T, D2> maxD3(@NotNull MultiArray<T, D3> a, int axis) {
        Intrinsics.checkNotNullParameter(a, (String)"a");
        return this.max(a, axis);
    }

    @NotNull
    public <T extends Number> NDArray<T, D3> maxD4(@NotNull MultiArray<T, D4> a, int axis) {
        Intrinsics.checkNotNullParameter(a, (String)"a");
        return this.max(a, axis);
    }

    @NotNull
    public <T extends Number> NDArray<T, DN> maxDN(@NotNull MultiArray<T, DN> a, int axis) {
        Intrinsics.checkNotNullParameter(a, (String)"a");
        return this.max(a, axis);
    }

    @NotNull
    public <T extends Number, D extends Dimension> T min(@NotNull MultiArray<T, D> a) {
        Intrinsics.checkNotNullParameter(a, (String)"a");
        Number min2 = (Number)IteratingNDArrayKt.first(a);
        for (Number el : a) {
            if (InternalsKt.compareTo((Number)min2, (Number)el) <= 0) continue;
            min2 = el;
        }
        return (T)min2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public <T extends Number, D extends Dimension, O extends Dimension> NDArray<T, O> min(@NotNull MultiArray<T, D> a, int axis) {
        DimN dimN;
        void $this$fold$iv;
        Intrinsics.checkNotNullParameter(a, (String)"a");
        if (!(a.getDim().getD() > 1)) {
            boolean $i$a$-require-KEMath$min$32 = false;
            String $i$a$-require-KEMath$min$32 = "NDArray of dimension one, use the `min` function without axis.";
            throw new IllegalArgumentException($i$a$-require-KEMath$min$32.toString());
        }
        if (!(0 <= axis ? axis < a.getDim().getD() : false)) {
            boolean $i$a$-require-KEMath$min$42 = false;
            String $i$a$-require-KEMath$min$42 = "axis " + axis + " is out of bounds for this ndarray of dimension " + a.getDim().getD() + '.';
            throw new IllegalArgumentException($i$a$-require-KEMath$min$42.toString());
        }
        int[] newShape = KEMathKt.remove(a.getShape(), axis);
        T max2 = this.max(a);
        int[] nArray = newShape;
        int initial$iv = 1;
        boolean $i$f$fold = false;
        int accumulator$iv = initial$iv;
        int n = ((void)$this$fold$iv).length;
        for (int i = 0; i < n; ++i) {
            void p1;
            void element$iv;
            void var13_21 = element$iv = $this$fold$iv[i];
            int p0 = accumulator$iv;
            boolean bl = false;
            accumulator$iv = p0 * p1;
        }
        int size = accumulator$iv;
        MemoryView minData2 = MemoryViewKt.initMemoryView((int)size, (DataType)a.getDtype(), (Function1)new Function1<Integer, T>(max2){
            final /* synthetic */ T $max;
            {
                this.$max = $max;
                super(1);
            }

            @NotNull
            public final T invoke(int it) {
                return this.$max;
            }
        });
        Map indexMap = new LinkedHashMap();
        accumulator$iv = a.getShape().length;
        for (int i = 0; i < accumulator$iv; ++i) {
            if (i == axis) continue;
            Integer n2 = i;
            indexMap.put(n2, RInt.until-impl((int)SliceKt.getR((int)0), (int)a.getShape()[i]));
        }
        accumulator$iv = a.getShape()[axis];
        for (int index = 0; index < accumulator$iv; ++index) {
            Integer n3 = axis;
            indexMap.put(n3, RInt.box-impl((int)SliceKt.getR((int)index)));
            NDArray t = ViewGettersAndSettersKt.slice(a, (Map)indexMap);
            int count = 0;
            for (Number el : t) {
                if (InternalsKt.compareTo((Number)((Number)minData2.get(count)), (Number)el) > 0) {
                    minData2.set(count, (Object)el);
                }
                ++count;
            }
        }
        ImmutableMemoryView immutableMemoryView = (ImmutableMemoryView)minData2;
        int dim$iv = newShape.length;
        boolean $i$f$dimensionOf = false;
        switch (dim$iv) {
            case 1: {
                dimN = (DimN)D1.Companion;
                break;
            }
            case 2: {
                dimN = (DimN)D2.Companion;
                break;
            }
            case 3: {
                dimN = (DimN)D3.Companion;
                break;
            }
            case 4: {
                dimN = (DimN)D4.Companion;
                break;
            }
            default: {
                dimN = (DimN)new DN(dim$iv);
            }
        }
        Intrinsics.checkNotNull((Object)dimN, (String)"null cannot be cast to non-null type D of org.jetbrains.kotlinx.multik.ndarray.data.DimensionsKt.dimensionOf");
        return new NDArray(immutableMemoryView, 0, newShape, null, (Dimension)dimN, null, 40, null);
    }

    @NotNull
    public <T extends Number> NDArray<T, D1> minD2(@NotNull MultiArray<T, D2> a, int axis) {
        Intrinsics.checkNotNullParameter(a, (String)"a");
        return this.min(a, axis);
    }

    @NotNull
    public <T extends Number> NDArray<T, D2> minD3(@NotNull MultiArray<T, D3> a, int axis) {
        Intrinsics.checkNotNullParameter(a, (String)"a");
        return this.min(a, axis);
    }

    @NotNull
    public <T extends Number> NDArray<T, D3> minD4(@NotNull MultiArray<T, D4> a, int axis) {
        Intrinsics.checkNotNullParameter(a, (String)"a");
        return this.min(a, axis);
    }

    @NotNull
    public <T extends Number> NDArray<T, DN> minDN(@NotNull MultiArray<T, DN> a, int axis) {
        Intrinsics.checkNotNullParameter(a, (String)"a");
        return this.min(a, axis);
    }

    @NotNull
    public <T extends Number, D extends Dimension> T sum(@NotNull MultiArray<T, D> a) {
        Intrinsics.checkNotNullParameter(a, (String)"a");
        return (T)KEMathKt.access$summation(a);
    }

    @NotNull
    public <T extends Number, D extends Dimension, O extends Dimension> NDArray<T, O> sum(@NotNull MultiArray<T, D> a, int axis) {
        Integer n;
        Intrinsics.checkNotNullParameter(a, (String)"a");
        if (!(a.getDim().getD() > 1)) {
            boolean $i$a$-require-KEMath$sum$32 = false;
            String $i$a$-require-KEMath$sum$32 = "NDArray of dimension one, use the `sum` function without axis.";
            throw new IllegalArgumentException($i$a$-require-KEMath$sum$32.toString());
        }
        if (!(0 <= axis ? axis < a.getDim().getD() : false)) {
            boolean $i$a$-require-KEMath$sum$42 = false;
            String $i$a$-require-KEMath$sum$42 = "axis " + axis + " is out of bounds for this ndarray of dimension " + a.getDim().getD() + '.';
            throw new IllegalArgumentException($i$a$-require-KEMath$sum$42.toString());
        }
        int[] newShape = KEMathKt.remove(a.getShape(), axis);
        NDArray ret = ConstructorsKt.zeros((Multik)Multik.INSTANCE, (int[])newShape, (DataType)a.getDtype());
        Map indexMap = new LinkedHashMap();
        int n2 = a.getShape().length;
        for (int i = 0; i < n2; ++i) {
            if (i == axis) continue;
            n = i;
            indexMap.put(n, RInt.until-impl((int)SliceKt.getR((int)0), (int)a.getShape()[i]));
        }
        n2 = a.getShape()[axis];
        for (int index = 0; index < n2; ++index) {
            n = axis;
            indexMap.put(n, RInt.box-impl((int)SliceKt.getR((int)index)));
            _ArithmeticNDArrayKt.plusAssign((MutableMultiArray)((MutableMultiArray)ret), (MultiArray)((MultiArray)ViewGettersAndSettersKt.slice(a, (Map)indexMap)));
        }
        return ret;
    }

    @NotNull
    public <T extends Number> NDArray<T, D1> sumD2(@NotNull MultiArray<T, D2> a, int axis) {
        Intrinsics.checkNotNullParameter(a, (String)"a");
        return this.sum(a, axis);
    }

    @NotNull
    public <T extends Number> NDArray<T, D2> sumD3(@NotNull MultiArray<T, D3> a, int axis) {
        Intrinsics.checkNotNullParameter(a, (String)"a");
        return this.sum(a, axis);
    }

    @NotNull
    public <T extends Number> NDArray<T, D3> sumD4(@NotNull MultiArray<T, D4> a, int axis) {
        Intrinsics.checkNotNullParameter(a, (String)"a");
        return this.sum(a, axis);
    }

    @NotNull
    public <T extends Number> NDArray<T, DN> sumDN(@NotNull MultiArray<T, DN> a, int axis) {
        Intrinsics.checkNotNullParameter(a, (String)"a");
        return this.sum(a, axis);
    }

    @NotNull
    public <T extends Number, D extends Dimension> NDArray<T, D1> cumSum(@NotNull MultiArray<T, D> a) {
        Intrinsics.checkNotNullParameter(a, (String)"a");
        int[] nArray = new int[]{a.getSize()};
        NDArray ret = new NDArray((ImmutableMemoryView)MemoryViewKt.initMemoryView((int)a.getSize(), (DataType)DataType.DoubleDataType), 0, nArray, null, (Dimension)D1.Companion, null, 42, null);
        int ind = 0;
        double accum = 0.0;
        double compens = 0.0;
        for (Number el : a) {
            double y = el.doubleValue() - compens;
            double t = accum + y;
            compens = t - accum - y;
            accum = t;
            ScalarsGettersAndSettersKt.doubleSet1((MutableMultiArray)((MutableMultiArray)ret), (int)ind++, (double)accum);
        }
        return ret.asType(a.getDtype());
    }

    @NotNull
    public <T extends Number, D extends Dimension> NDArray<T, D> cumSum(@NotNull MultiArray<T, D> a, int axis) {
        Integer n;
        Intrinsics.checkNotNullParameter(a, (String)"a");
        if (!(0 <= axis ? axis < a.getDim().getD() : false)) {
            boolean $i$a$-require-KEMath$cumSum$22 = false;
            String $i$a$-require-KEMath$cumSum$22 = "axis " + axis + " is out of bounds for this ndarray of dimension " + a.getDim().getD() + '.';
            throw new IllegalArgumentException($i$a$-require-KEMath$cumSum$22.toString());
        }
        NDArray ret = ((NDArray)a).deepCopy();
        Map indexMap = new LinkedHashMap();
        int n2 = a.getShape().length;
        for (int i = 0; i < n2; ++i) {
            if (i == axis) continue;
            n = i;
            indexMap.put(n, RInt.until-impl((int)SliceKt.getR((int)0), (int)a.getShape()[i]));
        }
        n2 = a.getShape()[axis];
        for (int index = 1; index < n2; ++index) {
            n = axis;
            indexMap.put(n, RInt.box-impl((int)SliceKt.getR((int)index)));
            NDArray tmp = ViewGettersAndSettersKt.slice((MultiArray)((MultiArray)ret), (Map)indexMap);
            Integer n3 = axis;
            indexMap.put(n3, RInt.box-impl((int)RInt.minus-NPMiDX8((int)SliceKt.getR((int)index), (int)SliceKt.getR((int)1))));
            _ArithmeticNDArrayKt.plusAssign((MutableMultiArray)((MutableMultiArray)tmp), (MultiArray)((MultiArray)ViewGettersAndSettersKt.slice((MultiArray)((MultiArray)ret), (Map)indexMap)));
        }
        return ret;
    }
}

