/*
 * Decompiled with CFR 0.152.
 */
package med.inpulse.signal_processing.filters;

import med.inpulse.signal_processing.filters.FilterCoefficients;
import med.inpulse.signal_processing.filters.IIRType;
import med.inpulse.signal_processing.jni.JNIObject;

public class IIR
extends JNIObject {
    private native void _free(long var1);

    private native long _butter(int var1, float var2, float var3, int var4, int var5);

    private native long _notch(float var1, int var2, int var3);

    private native long _baseline_coeff(int var1, float var2);

    public IIR() {
    }

    public IIR(long reference) {
        super(reference);
    }

    @Override
    public void free() {
        this._free(this.reference);
    }

    public FilterCoefficients Butter(int Order, float Fc1, float Fc2, int samplingRate, IIRType iir_type) {
        FilterCoefficients ret = null;
        long filterCoeff = this._butter(Order, Fc1, Fc2, samplingRate, iir_type.getValue());
        if (filterCoeff != 0L) {
            ret = new FilterCoefficients(filterCoeff);
        }
        return ret;
    }

    public FilterCoefficients Notch(int NotchFreq, int SamplingRate, int NotchWidth) {
        FilterCoefficients ret = null;
        long filterCoeff = this._notch(NotchFreq, SamplingRate, NotchWidth);
        if (filterCoeff != 0L) {
            ret = new FilterCoefficients(filterCoeff);
        }
        return ret;
    }

    public FilterCoefficients BaselineCoeff(int SamplingRate, float BaselineFreq) {
        FilterCoefficients ret = null;
        long filterCoeff = this._baseline_coeff(SamplingRate, BaselineFreq);
        if (filterCoeff != 0L) {
            ret = new FilterCoefficients(filterCoeff);
        }
        return ret;
    }
}

