/*
 * Decompiled with CFR 0.152.
 */
package med.inpulse.signal_processing.filters;

import med.inpulse.signal_processing.exceptions.InvalidInputException;
import med.inpulse.signal_processing.exceptions.NativeMemoryException;
import med.inpulse.signal_processing.filters.BaselineFilter;
import med.inpulse.signal_processing.filters.Filter;
import med.inpulse.signal_processing.filters.IIRType;
import med.inpulse.signal_processing.filters.SimpleFilter;
import med.inpulse.signal_processing.jni.JNIObject;

public class CombinedFilter
extends JNIObject
implements Filter {
    private native long _init(int var1) throws NativeMemoryException;

    private native void _free(long var1);

    private native void _reset(long var1);

    private native void _add(long var1, int var3, long var4) throws InvalidInputException;

    private native float _filter_data(long var1, float var3);

    private native float[] _filter_array(long var1, int var3, float[] var4) throws NativeMemoryException;

    private native void _filter_filtfilt(long var1, float[] var3, int var4, float[] var5, int var6, int var7);

    private native boolean _get_activated(long var1);

    private native void _set_activated(long var1);

    private native void _unset_activated(long var1);

    public CombinedFilter(int samplingRate) throws NativeMemoryException {
        this.reference = this._init(samplingRate);
    }

    public CombinedFilter(long reference) {
        super(reference);
    }

    @Override
    public void free() {
        this._free(this.reference);
    }

    public void reset() {
        this._reset(this.reference);
    }

    public void add(CombinedFilter filter, IIRType type) {
        this._add(this.reference, type.getValue(), filter.getReference());
    }

    public void add(SimpleFilter filter, IIRType type) {
        this._add(this.reference, type.getValue(), filter.getReference());
    }

    public void add(BaselineFilter filter, IIRType type) {
        this._add(this.reference, type.getValue(), filter.getReference());
    }

    @Override
    public float filterData(float inputSample) {
        return this._filter_data(this.reference, inputSample);
    }

    public void filterArray(float[] source, float[] filtered, int samplingRate) throws NativeMemoryException {
        if (source.length != filtered.length) {
            throw new IllegalArgumentException("source and destination array must have the same length");
        }
        float[] temp_data = this._filter_array(this.reference, samplingRate, source);
        System.arraycopy(temp_data, 0, filtered, 0, filtered.length);
    }

    public float[] filterArray(float[] source, int samplingRate) throws NativeMemoryException {
        return this._filter_array(this.reference, samplingRate, source);
    }

    public void filtFilt(float[] src, int src_offset, float[] dest, int dest_offset, int length) {
        this._filter_filtfilt(this.reference, src, src_offset, dest, dest_offset, length);
    }

    public boolean getActivated() {
        return this._get_activated(this.reference);
    }

    public void setActivated() {
        this._set_activated(this.reference);
    }

    public void unsetActivated() {
        this._unset_activated(this.reference);
    }
}

