/*
 * Decompiled with CFR 0.152.
 */
package med.inpulse.signal_processing.ecg;

import med.inpulse.signal_processing.ecg.MarkerType;
import med.inpulse.signal_processing.exceptions.NativeMemoryException;
import med.inpulse.signal_processing.jni.JNIObject;

public class Marker
extends JNIObject {
    private native long _init(int var1, long var2);

    private native void _free(long var1);

    private native int _get_type(long var1);

    private native long _get_sample_index(long var1);

    public Marker(MarkerType type, long sampleIndex) throws NativeMemoryException {
        if (sampleIndex < 0L) {
            throw new IllegalArgumentException("Sample index cannot be negative.");
        }
        this.reference = this._init(type.getValue(), sampleIndex);
        if (this.reference == 0L) {
            throw new NativeMemoryException("Failed to initialize marker.");
        }
    }

    public Marker(long reference) {
        super(reference);
    }

    @Override
    public void free() {
        this._free(this.reference);
        this.reference = 0L;
    }

    public MarkerType getType() {
        MarkerType ret = null;
        if (this.reference != 0L) {
            ret = MarkerType.values()[this._get_type(this.reference)];
        }
        return ret;
    }

    public long getSampleIndex() {
        if (this.reference != 0L) {
            return this._get_sample_index(this.reference);
        }
        return 0L;
    }
}

