/*
 * Decompiled with CFR 0.152.
 */
package med.inpulse.signal_processing.data_structures;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import med.inpulse.signal_processing.exceptions.NativeMemoryException;
import med.inpulse.signal_processing.jni.JNIObject;

public class LinkedList<T extends JNIObject>
extends JNIObject {
    private Constructor<T> elementConstructor;

    private native long _init();

    private native void _free(long var1);

    private native int _add(long var1, long var3);

    private native int _set(long var1, long var3, long var5);

    private native long _remove_first(long var1);

    private native long _remove_last(long var1);

    private native long _remove_at(long var1, long var3);

    private native long _get(long var1, long var3);

    private native long _length(long var1);

    public LinkedList(long reference, Class<T> contentClass) {
        super(reference);
        try {
            this.elementConstructor = contentClass.getConstructor(Long.TYPE);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Requested element class not suported.");
        }
        catch (SecurityException e) {
            throw new IllegalArgumentException("Requested element class not suported.");
        }
    }

    public LinkedList(Class<T> contentClass) throws NativeMemoryException {
        this.reference = this._init();
        if (this.reference == 0L) {
            throw new NativeMemoryException("Failed to initialize list.");
        }
        try {
            this.elementConstructor = contentClass.getConstructor(Long.TYPE);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Requested element class not suported.");
        }
        catch (SecurityException e) {
            throw new IllegalArgumentException("Requested element class not suported.");
        }
    }

    @Override
    public void free() {
        this._free(this.reference);
        this.reference = 0L;
    }

    public void add(T value) throws NativeMemoryException {
        int code;
        if (this.reference != 0L && (code = this._add(this.reference, ((JNIObject)value).getReference())) == -2) {
            throw new NativeMemoryException("Failed to allocate memory for new element.");
        }
    }

    public void set(long index, T value) throws NativeMemoryException {
        if (this.reference != 0L) {
            int code = this._set(this.reference, index, ((JNIObject)value).getReference());
            switch (code) {
                case -2: {
                    throw new NativeMemoryException("Failed to allocate memory for new element.");
                }
                case -6: {
                    throw new IndexOutOfBoundsException("Index " + index + " is out of bounds.");
                }
            }
        }
    }

    public void clear() {
        long length = this.lenth();
        while (length-- > 0L) {
            ((JNIObject)this.removeFirst()).free();
        }
    }

    public T removeFirst() {
        long element_ref;
        T ret = null;
        if (this.reference != 0L && (element_ref = this._remove_first(this.reference)) != 0L) {
            ret = this.getElementObject(element_ref);
        }
        return ret;
    }

    public T removeLast() {
        long element_ref;
        T ret = null;
        if (this.reference != 0L && (element_ref = this._remove_last(this.reference)) != 0L) {
            ret = this.getElementObject(element_ref);
        }
        return ret;
    }

    public T remove(long index) {
        T ret = null;
        if (this.reference != 0L) {
            long element_ref = this._remove_at(this.reference, index);
            if (element_ref == 0L) {
                throw new IndexOutOfBoundsException("Index " + index + " is out of bounds.");
            }
            ret = this.getElementObject(element_ref);
        }
        return ret;
    }

    public T get(long index) {
        T ret = null;
        if (this.reference != 0L) {
            long element_ref = this._get(this.reference, index);
            if (element_ref == 0L) {
                throw new IndexOutOfBoundsException("Index " + index + " is out of bounds.");
            }
            ret = this.getElementObject(element_ref);
        }
        return ret;
    }

    public long lenth() {
        if (this.reference != 0L) {
            return this._length(this.reference);
        }
        return 0L;
    }

    public Iterator first() throws NativeMemoryException {
        return new Iterator();
    }

    private T getElementObject(long element_ref) {
        JNIObject ret = null;
        try {
            ret = (JNIObject)this.elementConstructor.newInstance(element_ref);
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        return (T)ret;
    }

    public class Iterator
    extends JNIObject {
        private native long _first(long var1);

        private native void _free(long var1);

        private native void _next(long var1);

        private native int _done(long var1, long var3);

        private native long _value(long var1);

        private native long _position(long var1);

        protected Iterator() throws NativeMemoryException {
            if (LinkedList.this.getReference() != 0L) {
                this.reference = this._first(LinkedList.this.getReference());
                if (this.reference == 0L) {
                    throw new NativeMemoryException("Failed to initialize iterator.");
                }
            } else {
                this.reference = 0L;
            }
        }

        @Override
        public void free() {
            this._free(this.reference);
            this.reference = 0L;
        }

        public void next() {
            if (this.reference != 0L) {
                this._next(this.reference);
            }
        }

        public boolean done() {
            boolean done = true;
            if (this.reference != 0L) {
                done = this._done(LinkedList.this.getReference(), this.reference) == 1;
            }
            return done;
        }

        public T value() {
            long element_ref;
            JNIObject ret = null;
            if (this.reference != 0L && (element_ref = this._value(this.reference)) != 0L) {
                ret = LinkedList.this.getElementObject(element_ref);
            }
            return ret;
        }

        public long position() {
            if (this.reference != 0L) {
                return this._position(this.reference);
            }
            return 0L;
        }
    }
}

