/*
 * Decompiled with CFR 0.152.
 */
package med.inpulse.signal_processing;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import med.inpulse.signal_processing.exceptions.NativeLoadingException;

public class SignalProcessing {
    public static void load() throws NativeLoadingException {
        String libname = "sigproc";
        boolean isAndroid = System.getProperty("java.vendor.url", "").contains("android");
        boolean isLinux = System.getProperty("os.name").contains("nux");
        if (isAndroid) {
            System.loadLibrary(libname);
        } else {
            if (isLinux) {
                libname = System.mapLibraryName(libname);
                try {
                    System.load(SignalProcessing.extractNativeLib(libname).getAbsolutePath());
                }
                catch (IOException ioException) {
                    throw new NativeLoadingException("Error loading native library.", ioException);
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    throw new NativeLoadingException("Error loading native library.", unsatisfiedLinkError);
                }
            }
            String archType = System.getProperty("sun.arch.data.model");
            libname = archType.contains("64") ? libname + "64" : libname + "32";
            libname = System.mapLibraryName(libname);
            try {
                System.load(SignalProcessing.extractNativeLib(libname).getAbsolutePath());
            }
            catch (IOException ioException) {
                throw new NativeLoadingException("Error loading native library.", ioException);
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                throw new NativeLoadingException("Error loading native library.", unsatisfiedLinkError);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File extractNativeLib(String libname) throws IOException {
        File libFile;
        block5: {
            InputStream inStream = null;
            OutputStream outStream = null;
            libFile = null;
            try {
                String prefix = libname.substring(0, libname.lastIndexOf("."));
                String sufix = libname.substring(libname.lastIndexOf(".") + 1, libname.length());
                libFile = File.createTempFile(prefix, "." + sufix);
                libFile.deleteOnExit();
                outStream = new FileOutputStream(libFile);
                inStream = SignalProcessing.class.getResourceAsStream(libname);
                if (inStream != null) {
                    int len;
                    byte[] buffer = new byte[1024];
                    while ((len = inStream.read(buffer)) > 0) {
                        outStream.write(buffer, 0, len);
                    }
                    inStream.close();
                    break block5;
                }
                throw new IOException("Could not find native resource " + libname);
            }
            finally {
                outStream.close();
            }
        }
        return libFile;
    }
}

