/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.krafiks;

import androidx.compose.runtime.internal.StabilityInferred;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vet.inpulse.krafiks.GLESKt;
import vet.inpulse.krafiks.GLES_jvmKt;
import vet.inpulse.krafiks.Shader;
import vet.inpulse.krafiks.Usage;
import vet.inpulse.krafiks.VertexBufferLayout;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u0017\n\u0002\b\u0005\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\n\b\u0007\u0018\u0000 /2\u00020\u0001:\u0002/0B/\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\u0003\u00a2\u0006\u0004\b\n\u0010\u000bJ,\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u00172\b\b\u0002\u0010\u0018\u001a\u00020\u00032\b\b\u0002\u0010\u0019\u001a\u00020\u00032\b\b\u0002\u0010\u001a\u001a\u00020\u0003J4\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u001d2\b\b\u0002\u0010\u0018\u001a\u00020\u00032\b\b\u0002\u0010\u0019\u001a\u00020\u00032\b\b\u0002\u0010\u001a\u001a\u00020\u0003J4\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00032\u0006\u0010!\u001a\u00020\u001d2\b\b\u0002\u0010\"\u001a\u00020\u00032\b\b\u0002\u0010\u0019\u001a\u00020\u00032\b\b\u0002\u0010#\u001a\u00020\u0003J\u000e\u0010$\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0003J\u000e\u0010%\u001a\u00020\u001f2\u0006\u0010&\u001a\u00020'J\u0006\u0010(\u001a\u00020\u0003J\u001a\u0010)\u001a\u00020\u001f2\b\b\u0002\u0010\u0018\u001a\u00020\u00032\b\b\u0002\u0010*\u001a\u00020\u0003J\"\u0010+\u001a\u00020\u001f2\b\b\u0002\u0010\u0018\u001a\u00020\u00032\b\b\u0002\u0010*\u001a\u00020\u00032\u0006\u0010,\u001a\u00020\u0003J\u0006\u0010-\u001a\u00020\u001fJ\u0006\u0010.\u001a\u00020\u001fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR\u000e\u0010\t\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u00061"}, d2={"Lvet/inpulse/krafiks/Mesh;", "", "primitiveType", "", "buffers", "", "layouts", "", "Lvet/inpulse/krafiks/VertexBufferLayout;", "indexBuffer", "<init>", "(I[I[Lvet/inpulse/krafiks/VertexBufferLayout;I)V", "[Lvet/inpulse/krafiks/VertexBufferLayout;", "vertexBufferSizes", "getVertexBufferSizes", "()[I", "indexBufferSize", "getIndexBufferSize", "()I", "setIndexBufferSize", "(I)V", "indexData", "data", "", "offset", "length", "hint", "bufferData", "bufferIndex", "", "bufferSubData", "", "index", "src", "srcOffset", "destOffset", "bindBuffer", "bind", "shader", "Lvet/inpulse/krafiks/Shader;", "numVertices", "render", "count", "renderInstanced", "instances", "unbind", "release", "Companion", "Builder", "krafiks-core"})
@StabilityInferred(parameters=0)
public final class Mesh {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int primitiveType;
    @NotNull
    private final int[] buffers;
    @NotNull
    private final VertexBufferLayout[] layouts;
    private final int indexBuffer;
    @NotNull
    private final int[] vertexBufferSizes;
    private int indexBufferSize;
    public static final int $stable = 8;

    private Mesh(int primitiveType, int[] buffers, VertexBufferLayout[] layouts, int indexBuffer) {
        this.primitiveType = primitiveType;
        this.buffers = buffers;
        this.layouts = layouts;
        this.indexBuffer = indexBuffer;
        this.vertexBufferSizes = new int[this.buffers.length];
    }

    @NotNull
    public final int[] getVertexBufferSizes() {
        return this.vertexBufferSizes;
    }

    public final int getIndexBufferSize() {
        return this.indexBufferSize;
    }

    public final void setIndexBufferSize(int n) {
        this.indexBufferSize = n;
    }

    @NotNull
    public final Mesh indexData(@NotNull short[] data, int offset, int length, int hint) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (!(this.indexBuffer != 0)) {
            boolean bl = false;
            String string2 = "Trying to put data into indexBuffer but mesh was created without one";
            throw new IllegalArgumentException(string2.toString());
        }
        GLES_jvmKt.glBindBuffer(34963, this.indexBuffer);
        GLES_jvmKt.glBufferData(34963, data, offset, length, hint);
        this.indexBufferSize = length;
        return this;
    }

    public static /* synthetic */ Mesh indexData$default(Mesh mesh, short[] sArray, int n, int n2, int n3, int n4, Object object) {
        if ((n4 & 2) != 0) {
            n = 0;
        }
        if ((n4 & 4) != 0) {
            n2 = sArray.length;
        }
        if ((n4 & 8) != 0) {
            n3 = 35044;
        }
        return mesh.indexData(sArray, n, n2, n3);
    }

    @NotNull
    public final Mesh bufferData(int bufferIndex, @NotNull float[] data, int offset, int length, int hint) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        GLES_jvmKt.glBindBuffer(34962, this.buffers[bufferIndex]);
        GLES_jvmKt.glBufferData(34962, data, offset, length, hint);
        this.vertexBufferSizes[bufferIndex] = length;
        return this;
    }

    public static /* synthetic */ Mesh bufferData$default(Mesh mesh, int n, float[] fArray, int n2, int n3, int n4, int n5, Object object) {
        if ((n5 & 4) != 0) {
            n2 = 0;
        }
        if ((n5 & 8) != 0) {
            n3 = fArray.length;
        }
        if ((n5 & 0x10) != 0) {
            n4 = 35044;
        }
        return mesh.bufferData(n, fArray, n2, n3, n4);
    }

    public final void bufferSubData(int index, @NotNull float[] src, int srcOffset, int length, int destOffset) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        int currentSize = this.vertexBufferSizes[index];
        if (currentSize <= 0) {
            GLES_jvmKt.glBindBuffer(34962, this.buffers[index]);
            GLES_jvmKt.glBufferData(34962, src, srcOffset, length, 35048);
            this.vertexBufferSizes[index] = length;
            return;
        }
        if (currentSize < destOffset + length) {
            if (GLES_jvmKt.supportCopySubData()) {
                int newSize = RangesKt.coerceAtLeast((int)(currentSize * 2), (int)(destOffset + length));
                int newBuffer = Companion.generateBuffers(1)[0];
                GLES_jvmKt.glBindBuffer(34962, newBuffer);
                GLES_jvmKt.glBufferData(34962, (long)newSize * 4L, 35048);
                GLES_jvmKt.glBindBuffer(36663, newBuffer);
                GLES_jvmKt.glBindBuffer(36662, this.buffers[index]);
                GLES_jvmKt.glCopyBufferSubData(36662, 36663, 0L, 0L, (long)currentSize * 4L);
                GLES_jvmKt.glBindBuffer(36663, 0);
                GLES_jvmKt.glBindBuffer(36662, 0);
                GLES_jvmKt.glDeleteBuffers(this.buffers, index, 1);
                this.buffers[index] = newBuffer;
                this.vertexBufferSizes[index] = newSize;
            } else {
                String string2 = "we don't support reallocating buffer yet";
                throw new NotImplementedError("An operation is not implemented: " + string2);
            }
        }
        GLES_jvmKt.glBindBuffer(34962, this.buffers[index]);
        GLESKt.glConsumeErrors((Function1<? super String, Unit>)((Function1)Mesh::bufferSubData$lambda$1));
        GLES_jvmKt.glBufferSubData(34962, src, srcOffset, length, destOffset);
        GLESKt.glConsumeErrors((Function1<? super String, Unit>)((Function1)Mesh::bufferSubData$lambda$2));
        GLES_jvmKt.glBindBuffer(34962, 0);
    }

    public static /* synthetic */ void bufferSubData$default(Mesh mesh, int n, float[] fArray, int n2, int n3, int n4, int n5, Object object) {
        if ((n5 & 4) != 0) {
            n2 = 0;
        }
        if ((n5 & 8) != 0) {
            n3 = fArray.length;
        }
        if ((n5 & 0x10) != 0) {
            n4 = 0;
        }
        mesh.bufferSubData(n, fArray, n2, n3, n4);
    }

    public final void bindBuffer(int index) {
        GLES_jvmKt.glBindBuffer(34962, this.buffers[index]);
    }

    public final void bind(@NotNull Shader shader) {
        Intrinsics.checkNotNullParameter((Object)shader, (String)"shader");
        int n = this.buffers.length;
        for (int i = 0; i < n; ++i) {
            int buffer = this.buffers[i];
            VertexBufferLayout layout = this.layouts[i];
            GLES_jvmKt.glBindBuffer(34962, buffer);
            GLESKt.glConsumeErrors((Function1<? super String, Unit>)((Function1)Mesh::bind$lambda$3));
            int offset = 0;
            for (Usage usage : layout.getUsages()) {
                Integer handle = shader.getAttributes().get((Object)usage);
                if (handle != null) {
                    GLES_jvmKt.glEnableVertexAttribArray(handle);
                    GLESKt.glConsumeErrors((Function1<? super String, Unit>)((Function1)Mesh::bind$lambda$4));
                    GLES_jvmKt.glVertexAttribPointer(handle, usage.getStorage().getCount(), usage.getStorage().getType(), false, layout.getStride(), offset);
                    GLESKt.glConsumeErrors((Function1<? super String, Unit>)((Function1)Mesh::bind$lambda$5));
                }
                offset += usage.getStorage().getSize();
            }
        }
        if (this.indexBuffer != 0) {
            GLES_jvmKt.glBindBuffer(34963, this.indexBuffer);
            GLESKt.glConsumeErrors((Function1<? super String, Unit>)((Function1)Mesh::bind$lambda$6));
        }
    }

    public final int numVertices() {
        int n;
        if (this.indexBufferSize > 0) {
            n = this.indexBufferSize;
        } else {
            VertexBufferLayout layout = this.layouts[0];
            int size = this.vertexBufferSizes[0];
            n = size / layout.getStride();
        }
        return n;
    }

    public final void render(int offset, int count) {
        if (this.indexBuffer > 0) {
            GLES_jvmKt.glDrawElements(this.primitiveType, count, 5123, offset);
        } else {
            GLES_jvmKt.glDrawArrays(this.primitiveType, offset, count);
        }
    }

    public static /* synthetic */ void render$default(Mesh mesh, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = 0;
        }
        if ((n3 & 2) != 0) {
            n2 = mesh.numVertices();
        }
        mesh.render(n, n2);
    }

    public final void renderInstanced(int offset, int count, int instances) {
        if (this.indexBuffer > 0) {
            GLES_jvmKt.glDrawElementsInstanced(this.primitiveType, count, 5123, 0, instances);
        } else {
            GLES_jvmKt.glDrawArraysInstanced(this.primitiveType, offset, count, instances);
        }
    }

    public static /* synthetic */ void renderInstanced$default(Mesh mesh, int n, int n2, int n3, int n4, Object object) {
        if ((n4 & 1) != 0) {
            n = 0;
        }
        if ((n4 & 2) != 0) {
            n2 = mesh.numVertices();
        }
        mesh.renderInstanced(n, n2, n3);
    }

    public final void unbind() {
        GLES_jvmKt.glBindBuffer(34962, 0);
        GLES_jvmKt.glBindBuffer(34963, 0);
    }

    public final void release() {
        GLES_jvmKt.glDeleteBuffers(this.buffers, 0, this.buffers.length);
        if (this.indexBuffer > 0) {
            int[] nArray = new int[]{this.indexBuffer};
            int[] buf = nArray;
            GLES_jvmKt.glDeleteBuffers(buf, 0, 1);
        }
    }

    private static final Unit bufferSubData$lambda$1(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        System.out.println((Object)("glBindBuffer: " + it));
        return Unit.INSTANCE;
    }

    private static final Unit bufferSubData$lambda$2(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        System.out.println((Object)("glBufferSubData: " + it));
        return Unit.INSTANCE;
    }

    private static final Unit bind$lambda$3(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        System.out.println((Object)("glBindBuffer GL_ARRAY_BUFFER " + it));
        return Unit.INSTANCE;
    }

    private static final Unit bind$lambda$4(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        System.out.println((Object)("glEnableVertexAttribArray " + it));
        return Unit.INSTANCE;
    }

    private static final Unit bind$lambda$5(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        System.out.println((Object)("glVertexAttribPointer " + it));
        return Unit.INSTANCE;
    }

    private static final Unit bind$lambda$6(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        System.out.println((Object)("glBindBuffer GL_ELEMENT_ARRAY_BUFFER " + it));
        return Unit.INSTANCE;
    }

    public /* synthetic */ Mesh(int primitiveType, int[] buffers, VertexBufferLayout[] layouts, int indexBuffer, DefaultConstructorMarker $constructor_marker) {
        this(primitiveType, buffers, layouts, indexBuffer);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\r\u001a\u00020\u00002\u0012\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\"\u00020\u0006\u00a2\u0006\u0002\u0010\u000fJ\u0006\u0010\u0010\u001a\u00020\u0000J\u000e\u0010\n\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010\u0011\u001a\u00020\u0012R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\f\u00a8\u0006\u0013"}, d2={"Lvet/inpulse/krafiks/Mesh$Builder;", "", "<init>", "()V", "layouts", "", "Lvet/inpulse/krafiks/VertexBufferLayout;", "[Lvet/inpulse/krafiks/VertexBufferLayout;", "useIndexBuffer", "", "primitive", "", "Ljava/lang/Integer;", "layout", "buffers", "([Lvet/inpulse/krafiks/VertexBufferLayout;)Lvet/inpulse/krafiks/Mesh$Builder;", "withIndices", "build", "Lvet/inpulse/krafiks/Mesh;", "krafiks-core"})
    @StabilityInferred(parameters=0)
    @SourceDebugExtension(value={"SMAP\nMesh.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Mesh.kt\nvet/inpulse/krafiks/Mesh$Builder\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,221:1\n12476#2,2:222\n*S KotlinDebug\n*F\n+ 1 Mesh.kt\nvet/inpulse/krafiks/Mesh$Builder\n*L\n55#1:222,2\n*E\n"})
    public static final class Builder {
        @NotNull
        private VertexBufferLayout[] layouts = new VertexBufferLayout[0];
        private boolean useIndexBuffer;
        @Nullable
        private Integer primitive;
        public static final int $stable = 8;

        @NotNull
        public final Builder layout(VertexBufferLayout ... buffers) {
            Intrinsics.checkNotNullParameter((Object)buffers, (String)"buffers");
            this.layouts = Arrays.copyOf(buffers, buffers.length);
            return this;
        }

        @NotNull
        public final Builder withIndices() {
            this.useIndexBuffer = true;
            return this;
        }

        @NotNull
        public final Builder primitive(int primitive) {
            this.primitive = primitive;
            return this;
        }

        @NotNull
        public final Mesh build() {
            boolean bl;
            int[] vertexBuffers;
            block5: {
                if (!(!(this.layouts.length == 0))) {
                    boolean $i$a$-require-Mesh$Builder$build$32 = false;
                    String $i$a$-require-Mesh$Builder$build$32 = "Trying to create a mesh without vertex buffer array layouts";
                    throw new IllegalArgumentException($i$a$-require-Mesh$Builder$build$32.toString());
                }
                if (!(this.primitive != null)) {
                    boolean $i$a$-require-Mesh$Builder$build$42 = false;
                    String $i$a$-require-Mesh$Builder$build$42 = "Trying to create a mesh without setting OpenGL primitive type. GL_TRIANGLE, ...";
                    throw new IllegalArgumentException($i$a$-require-Mesh$Builder$build$42.toString());
                }
                vertexBuffers = new int[this.layouts.length];
                GLES_jvmKt.glGenBuffers(this.layouts.length, vertexBuffers, 0);
                int[] $this$all$iv = vertexBuffers;
                boolean $i$f$all = false;
                int n = $this$all$iv.length;
                for (int i = 0; i < n; ++i) {
                    int element$iv;
                    int it = element$iv = $this$all$iv[i];
                    boolean bl2 = false;
                    if (it != 0) continue;
                    bl = false;
                    break block5;
                }
                bl = true;
            }
            if (!bl) {
                boolean $i$a$-check-Mesh$Builder$build$52 = false;
                GLESKt.glConsumeErrors((Function1<? super String, Unit>)((Function1)Builder::build$lambda$4$lambda$3));
                String $i$a$-check-Mesh$Builder$build$52 = "Error creating buffers";
                throw new IllegalStateException($i$a$-check-Mesh$Builder$build$52.toString());
            }
            int indexBuffer = 0;
            if (this.useIndexBuffer) {
                int[] buffers = new int[1];
                GLES_jvmKt.glGenBuffers(buffers.length, buffers, 0);
                indexBuffer = buffers[0];
            }
            Integer n = this.primitive;
            Intrinsics.checkNotNull((Object)n);
            return new Mesh(n, vertexBuffers, this.layouts, indexBuffer, null);
        }

        private static final Unit build$lambda$4$lambda$3(String it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            System.out.println((Object)("glGenBuffers " + it));
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lvet/inpulse/krafiks/Mesh$Companion;", "", "<init>", "()V", "generateBuffers", "", "size", "", "krafiks-core"})
    @SourceDebugExtension(value={"SMAP\nMesh.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Mesh.kt\nvet/inpulse/krafiks/Mesh$Companion\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,221:1\n12476#2,2:222\n*S KotlinDebug\n*F\n+ 1 Mesh.kt\nvet/inpulse/krafiks/Mesh$Companion\n*L\n14#1:222,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final int[] generateBuffers(int size) {
            boolean bl;
            int[] vertexBuffers;
            block2: {
                vertexBuffers = new int[size];
                GLES_jvmKt.glGenBuffers(size, vertexBuffers, 0);
                int[] $this$all$iv = vertexBuffers;
                boolean $i$f$all = false;
                int n = $this$all$iv.length;
                for (int i = 0; i < n; ++i) {
                    int element$iv;
                    int it = element$iv = $this$all$iv[i];
                    boolean bl2 = false;
                    if (it != 0) continue;
                    bl = false;
                    break block2;
                }
                bl = true;
            }
            if (!bl) {
                boolean bl3 = false;
                GLESKt.glConsumeErrors((Function1<? super String, Unit>)((Function1)Companion::generateBuffers$lambda$2$lambda$1));
                String string2 = "Error creating buffers";
                throw new IllegalStateException(string2.toString());
            }
            return vertexBuffers;
        }

        private static final Unit generateBuffers$lambda$2$lambda$1(String it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            System.out.println((Object)("glGenBuffers " + it));
            return Unit.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

