/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.krafiks;

import androidx.compose.runtime.internal.StabilityInferred;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.HexExtensionsKt;
import org.jetbrains.annotations.NotNull;
import vet.inpulse.krafiks.GLESKt;
import vet.inpulse.krafiks.GLES_jvmKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0011\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\f\b\u0007\u0018\u0000 $2\u00020\u0001:\u0001$BA\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0003\u0012\b\b\u0002\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0004\b\t\u0010\nJ\u0006\u0010\u0014\u001a\u00020\u0015J\u0006\u0010\u0016\u001a\u00020\u0015J\u001e\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u0003J\u000e\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u0000J\u001e\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u00032\u0006\u0010 \u001a\u00020\u0003J\u0016\u0010!\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0003J\u0016\u0010\"\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0003J\u0006\u0010#\u001a\u00020\u0015R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000fR\u0011\u0010\u0012\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u000f\u00a8\u0006%"}, d2={"Lvet/inpulse/krafiks/Framebuffer;", "", "storageWidth", "", "storageHeight", "fb", "texture", "rbo", "multisamples", "<init>", "(IIIIII)V", "usableWidth", "usableHeight", "width", "getWidth", "()I", "height", "getHeight", "framebufferId", "getFramebufferId", "bind", "", "unbind", "readData", "buffer", "", "offset", "length", "blitTo", "target", "targetId", "targetWidth", "targetHeight", "resize", "resizeIfNeeded", "destroy", "Companion", "krafiks-core"})
@StabilityInferred(parameters=0)
public final class Framebuffer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int storageWidth;
    private int storageHeight;
    private int fb;
    private int texture;
    private int rbo;
    private int multisamples;
    private int usableWidth;
    private int usableHeight;
    public static final int $stable = 8;
    @NotNull
    private static final int[] tempArray = new int[1];

    private Framebuffer(int storageWidth, int storageHeight, int fb, int texture, int rbo, int multisamples) {
        this.storageWidth = storageWidth;
        this.storageHeight = storageHeight;
        this.fb = fb;
        this.texture = texture;
        this.rbo = rbo;
        this.multisamples = multisamples;
        this.usableWidth = this.storageWidth;
        this.usableHeight = this.storageHeight;
    }

    /* synthetic */ Framebuffer(int n, int n2, int n3, int n4, int n5, int n6, int n7, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n7 & 4) != 0) {
            n3 = 0;
        }
        if ((n7 & 8) != 0) {
            n4 = 0;
        }
        if ((n7 & 0x10) != 0) {
            n5 = 0;
        }
        if ((n7 & 0x20) != 0) {
            n6 = 1;
        }
        this(n, n2, n3, n4, n5, n6);
    }

    public final int getWidth() {
        return this.usableWidth;
    }

    public final int getHeight() {
        return this.usableHeight;
    }

    public final int getFramebufferId() {
        return this.fb;
    }

    public final void bind() {
        GLES_jvmKt.glBindFramebuffer(36160, this.fb);
    }

    public final void unbind() {
        GLES_jvmKt.glBindFramebuffer(36160, 0);
    }

    public final void readData(@NotNull byte[] buffer, int offset, int length) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        GLES_jvmKt.glBindFramebuffer(36160, this.fb);
        GLES_jvmKt.glReadPixels(0, 0, this.getWidth(), this.getHeight(), 6408, 5121, buffer, offset, length);
        GLES_jvmKt.glBindFramebuffer(36160, 0);
    }

    public final void blitTo(@NotNull Framebuffer target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        GLES_jvmKt.glBindFramebuffer(36008, this.fb);
        GLES_jvmKt.glBindFramebuffer(36009, target.fb);
        GLES_jvmKt.glBlitFramebuffer(0, 0, this.getWidth(), this.getHeight(), 0, 0, target.getWidth(), target.getHeight(), 16384, 9729);
        GLES_jvmKt.glBindFramebuffer(36008, 0);
        GLES_jvmKt.glBindFramebuffer(36009, 0);
    }

    public final void blitTo(int targetId, int targetWidth, int targetHeight) {
        GLES_jvmKt.glBindFramebuffer(36008, this.fb);
        GLES_jvmKt.glBindFramebuffer(36009, targetId);
        GLES_jvmKt.glBlitFramebuffer(0, 0, this.getWidth(), this.getHeight(), 0, 0, targetWidth, targetHeight, 16384, 9729);
        GLES_jvmKt.glBindFramebuffer(36008, 0);
        GLES_jvmKt.glBindFramebuffer(36009, 0);
    }

    public final void resize(int width, int height) {
        this.destroy();
        this.fb = Framebuffer.Companion.generateFramebuffer();
        this.texture = Framebuffer.Companion.generateTexture(width, height, this.multisamples);
        this.rbo = Framebuffer.Companion.generateRenderBuffer(width, height, this.multisamples);
        Framebuffer.Companion.attachTextureAndRbo(this.fb, this.texture, this.rbo, this.multisamples);
        this.storageWidth = width;
        this.storageHeight = height;
        this.usableWidth = width;
        this.usableHeight = height;
    }

    public final void resizeIfNeeded(int width, int height) {
        if (this.storageWidth < width || this.storageHeight < height) {
            this.resize(width, height);
        } else {
            this.usableWidth = width;
            this.usableHeight = height;
        }
    }

    public final void destroy() {
        GLES_jvmKt.glDeleteRenderbuffers(this.rbo);
        GLES_jvmKt.glDeleteTextures(this.texture);
        GLES_jvmKt.glDeleteFramebuffers(this.fb);
        this.rbo = 0;
        this.texture = 0;
        this.fb = 0;
    }

    public /* synthetic */ Framebuffer(int storageWidth, int storageHeight, int fb, int texture, int rbo, int multisamples, DefaultConstructorMarker $constructor_marker) {
        this(storageWidth, storageHeight, fb, texture, rbo, multisamples);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0006\u001a\u00020\u0007H\u0002J \u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0007H\u0002J \u0010\f\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0007H\u0002J(\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0007H\u0002J \u0010\u0012\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u00072\b\b\u0002\u0010\u000b\u001a\u00020\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lvet/inpulse/krafiks/Framebuffer$Companion;", "", "<init>", "()V", "tempArray", "", "generateFramebuffer", "", "generateTexture", "width", "height", "multisamples", "generateRenderBuffer", "attachTextureAndRbo", "", "fb", "texture", "rbo", "create", "Lvet/inpulse/krafiks/Framebuffer;", "krafiks-core"})
    public static final class Companion {
        private Companion() {
        }

        private final int generateFramebuffer() {
            GLES_jvmKt.glGenFramebuffers(tempArray);
            int fb = tempArray[0];
            if (!(fb != 0)) {
                boolean bl = false;
                String string2 = "Could not generate FBO";
                throw new IllegalStateException(string2.toString());
            }
            return fb;
        }

        private final int generateTexture(int width, int height, int multisamples) {
            GLES_jvmKt.glGenTextures(tempArray);
            int texture = tempArray[0];
            if (!(texture != 0)) {
                boolean $i$a$-check-Framebuffer$Companion$generateTexture$22 = false;
                String $i$a$-check-Framebuffer$Companion$generateTexture$22 = "Could not generate texture";
                throw new IllegalStateException($i$a$-check-Framebuffer$Companion$generateTexture$22.toString());
            }
            int target = multisamples > 1 && GLES_jvmKt.supportMultisampleFb() ? 37120 : 3553;
            GLES_jvmKt.glBindTexture(target, texture);
            if (target == 37120) {
                int maxSamples = GLES_jvmKt.maxSamples();
                int samples = RangesKt.coerceAtMost((int)multisamples, (int)maxSamples);
                GLES_jvmKt.glTexImage2DMultisample(target, samples, 32856, width, height, true);
            } else {
                GLES_jvmKt.glTexImage2D(target, 0, 35907, width, height, 0, 6408, 5121, null);
                GLES_jvmKt.glTexParameteri(target, 10241, 9729);
                GLES_jvmKt.glTexParameteri(target, 10240, 9729);
            }
            GLES_jvmKt.glBindTexture(target, 0);
            return texture;
        }

        private final int generateRenderBuffer(int width, int height, int multisamples) {
            GLES_jvmKt.glGenRenderbuffers(tempArray);
            int rbo = tempArray[0];
            if (!(rbo != 0)) {
                boolean $i$a$-check-Framebuffer$Companion$generateRenderBuffer$22 = false;
                String $i$a$-check-Framebuffer$Companion$generateRenderBuffer$22 = "could not generate rbo";
                throw new IllegalStateException($i$a$-check-Framebuffer$Companion$generateRenderBuffer$22.toString());
            }
            boolean useMultisample = multisamples > 1 && GLES_jvmKt.supportMultisampleFb();
            GLES_jvmKt.glBindRenderbuffer(36161, rbo);
            GLESKt.glConsumeErrors((Function1<? super String, Unit>)((Function1)Companion::generateRenderBuffer$lambda$3));
            if (useMultisample) {
                int maxSamples = GLES_jvmKt.maxSamples();
                int samples = RangesKt.coerceAtMost((int)multisamples, (int)maxSamples);
                GLES_jvmKt.glRenderbufferStorageMultisample(36161, samples, 35056, width, height);
            } else {
                GLES_jvmKt.glRenderbufferStorage(36161, 35056, width, height);
            }
            GLESKt.glConsumeErrors((Function1<? super String, Unit>)((Function1)Companion::generateRenderBuffer$lambda$4));
            GLES_jvmKt.glBindRenderbuffer(36161, 0);
            GLESKt.glConsumeErrors((Function1<? super String, Unit>)((Function1)Companion::generateRenderBuffer$lambda$5));
            return rbo;
        }

        private final void attachTextureAndRbo(int fb, int texture, int rbo, int multisamples) {
            GLES_jvmKt.glBindFramebuffer(36160, fb);
            if (multisamples > 1 && GLES_jvmKt.supportMultisampleFb()) {
                GLES_jvmKt.glFramebufferTexture2D(36160, 36064, 37120, texture, 0);
            } else {
                GLES_jvmKt.glFramebufferTexture2D(36160, 36064, 3553, texture, 0);
            }
            GLES_jvmKt.glFramebufferRenderbuffer(36160, 33306, 36161, rbo);
        }

        @NotNull
        public final Framebuffer create(int width, int height, int multisamples) {
            int fb = this.generateFramebuffer();
            GLESKt.glConsumeErrors((Function1<? super String, Unit>)((Function1)Companion::create$lambda$6));
            int texture = this.generateTexture(width, height, multisamples);
            GLESKt.glConsumeErrors((Function1<? super String, Unit>)((Function1)Companion::create$lambda$7));
            int rbo = this.generateRenderBuffer(width, height, multisamples);
            GLESKt.glConsumeErrors((Function1<? super String, Unit>)((Function1)Companion::create$lambda$8));
            this.attachTextureAndRbo(fb, texture, rbo, multisamples);
            GLESKt.glConsumeErrors((Function1<? super String, Unit>)((Function1)Companion::create$lambda$9));
            int status = GLES_jvmKt.glCheckFramebufferStatus(36160);
            if (!(status == 36053)) {
                boolean bl = false;
                String string2 = "Framebuffer is not complete. status=" + HexExtensionsKt.toHexString$default((int)status, null, (int)1, null);
                throw new IllegalArgumentException(string2.toString());
            }
            return new Framebuffer(width, height, fb, texture, rbo, multisamples, null);
        }

        public static /* synthetic */ Framebuffer create$default(Companion companion, int n, int n2, int n3, int n4, Object object) {
            if ((n4 & 4) != 0) {
                n3 = 1;
            }
            return companion.create(n, n2, n3);
        }

        private static final Unit generateRenderBuffer$lambda$3(String it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            System.out.println((Object)("glBindRenderbuffer " + it));
            return Unit.INSTANCE;
        }

        private static final Unit generateRenderBuffer$lambda$4(String it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            System.out.println((Object)("glRenderbufferStorage " + it));
            return Unit.INSTANCE;
        }

        private static final Unit generateRenderBuffer$lambda$5(String it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            System.out.println((Object)("glBindRenderbuffer " + it));
            return Unit.INSTANCE;
        }

        private static final Unit create$lambda$6(String it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            System.out.println((Object)("fb error " + it));
            return Unit.INSTANCE;
        }

        private static final Unit create$lambda$7(String it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            System.out.println((Object)("texture error " + it));
            return Unit.INSTANCE;
        }

        private static final Unit create$lambda$8(String it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            System.out.println((Object)("rbo error " + it));
            return Unit.INSTANCE;
        }

        private static final Unit create$lambda$9(String it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            System.out.println((Object)("attach error " + it));
            return Unit.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

