/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.krafiks;

import androidx.compose.runtime.internal.StabilityInferred;
import dev.romainguy.kotlin.math.Float4;
import dev.romainguy.kotlin.math.Mat4;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import vet.inpulse.krafiks.Camera;
import vet.inpulse.krafiks.LayoutBuilder;
import vet.inpulse.krafiks.LineRenderer;
import vet.inpulse.krafiks.M4;
import vet.inpulse.krafiks.M4Kt;
import vet.inpulse.krafiks.Mesh;
import vet.inpulse.krafiks.Shader;
import vet.inpulse.krafiks.ShaderKt;
import vet.inpulse.krafiks.VertexBufferLayout;
import vet.inpulse.krafiks.VertexBufferLayoutKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0014\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\b\u0007\u0018\u0000 =2\u00020\u0001:\u0001=B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u000204H\u0016J\b\u00106\u001a\u00020.H\u0016J\u0010\u00107\u001a\u00020.2\u0006\u00108\u001a\u00020\u0013H\u0002J\u0018\u00109\u001a\u00020.2\u0006\u0010:\u001a\u00020\u001f2\u0006\u0010;\u001a\u00020\u001fH\u0016J\b\u0010<\u001a\u00020.H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\u0019X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\u00020\u001fX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u001a\u0010$\u001a\u00020\u0019X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010\u001b\"\u0004\b&\u0010\u001dR\u001a\u0010'\u001a\u00020\u001fX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010!\"\u0004\b)\u0010#R\u001a\u0010*\u001a\u00020\u001fX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010!\"\u0004\b,\u0010#\u00a8\u0006>"}, d2={"Lvet/inpulse/krafiks/FilledLineRenderer;", "Lvet/inpulse/krafiks/LineRenderer;", "<init>", "()V", "shader", "Lvet/inpulse/krafiks/Shader;", "getShader", "()Lvet/inpulse/krafiks/Shader;", "mesh", "Lvet/inpulse/krafiks/Mesh;", "getMesh", "()Lvet/inpulse/krafiks/Mesh;", "lineData", "", "getLineData", "()[F", "setLineData", "([F)V", "points", "", "getPoints", "()I", "setPoints", "(I)V", "lineColorMin", "Ldev/romainguy/kotlin/math/Float4;", "getLineColorMin", "()Ldev/romainguy/kotlin/math/Float4;", "setLineColorMin", "(Ldev/romainguy/kotlin/math/Float4;)V", "lineValueMin", "", "getLineValueMin", "()F", "setLineValueMin", "(F)V", "lineColorMax", "getLineColorMax", "setLineColorMax", "lineValueMax", "getLineValueMax", "setLineValueMax", "lineThickness", "getLineThickness", "setLineThickness", "render", "", "camera", "Lvet/inpulse/krafiks/Camera;", "model", "Ldev/romainguy/kotlin/math/Mat4;", "strip", "", "cap", "release", "resizeIfNeeded", "toAdd", "addPoint", "x", "y", "reset", "Companion", "krafiks-core"})
@StabilityInferred(parameters=0)
public final class FilledLineRenderer
implements LineRenderer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Shader shader = ShaderKt.shaderFromResource$default("/gradient_shader.vert", "/simple_shader.frag", null, 4, null);
    @NotNull
    private final Mesh mesh;
    @NotNull
    private float[] lineData;
    private int points;
    @NotNull
    private Float4 lineColorMin;
    private float lineValueMin;
    @NotNull
    private Float4 lineColorMax;
    private float lineValueMax;
    private float lineThickness;
    public static final int $stable = 8;
    @NotNull
    public static final String U_COLOR_MIN = "u_color_min";
    @NotNull
    public static final String U_VALUE_MIN = "u_value_min";
    @NotNull
    public static final String U_COLOR_MAX = "u_color_max";
    @NotNull
    public static final String U_VALUE_MAX = "u_value_max";

    public FilledLineRenderer() {
        VertexBufferLayout[] vertexBufferLayoutArray = new VertexBufferLayout[]{VertexBufferLayoutKt.bufferLayout((Function1<? super LayoutBuilder, Unit>)((Function1)FilledLineRenderer::mesh$lambda$0))};
        this.mesh = new Mesh.Builder().layout(vertexBufferLayoutArray).primitive(5).build();
        this.lineData = new float[1024];
        this.lineColorMin = new Float4(0.0f, 0.0f, 0.0f, 1.0f);
        this.lineColorMax = new Float4(0.0f, 0.0f, 0.0f, 1.0f);
        this.lineValueMax = 1.0f;
        this.lineThickness = 1.0f;
    }

    @NotNull
    public final Shader getShader() {
        return this.shader;
    }

    @NotNull
    public final Mesh getMesh() {
        return this.mesh;
    }

    @NotNull
    public final float[] getLineData() {
        return this.lineData;
    }

    public final void setLineData(@NotNull float[] fArray) {
        Intrinsics.checkNotNullParameter((Object)fArray, (String)"<set-?>");
        this.lineData = fArray;
    }

    public final int getPoints() {
        return this.points;
    }

    public final void setPoints(int n) {
        this.points = n;
    }

    @Override
    @NotNull
    public Float4 getLineColorMin() {
        return this.lineColorMin;
    }

    @Override
    public void setLineColorMin(@NotNull Float4 float4) {
        Intrinsics.checkNotNullParameter((Object)float4, (String)"<set-?>");
        this.lineColorMin = float4;
    }

    @Override
    public float getLineValueMin() {
        return this.lineValueMin;
    }

    @Override
    public void setLineValueMin(float f) {
        this.lineValueMin = f;
    }

    @Override
    @NotNull
    public Float4 getLineColorMax() {
        return this.lineColorMax;
    }

    @Override
    public void setLineColorMax(@NotNull Float4 float4) {
        Intrinsics.checkNotNullParameter((Object)float4, (String)"<set-?>");
        this.lineColorMax = float4;
    }

    @Override
    public float getLineValueMax() {
        return this.lineValueMax;
    }

    @Override
    public void setLineValueMax(float f) {
        this.lineValueMax = f;
    }

    @Override
    public float getLineThickness() {
        return this.lineThickness;
    }

    @Override
    public void setLineThickness(float f) {
        this.lineThickness = f;
    }

    @Override
    public void render(@NotNull Camera camera, @NotNull Mat4 model, boolean strip, boolean cap) {
        Intrinsics.checkNotNullParameter((Object)camera, (String)"camera");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        if (this.points < 9) {
            return;
        }
        this.mesh.bufferSubData(0, this.lineData, 0, this.points, 0);
        this.shader.bind();
        this.mesh.bind(this.shader);
        this.shader.setMvpMatrix-hHmvo7A(M4.times-AMxtLaU(M4Kt.toM4(camera.getVp()), M4Kt.toM4(model)));
        this.shader.setUniformFloat4(this.shader.getAllUniforms().get(U_COLOR_MIN), this.getLineColorMin());
        this.shader.setUniformFloat(this.shader.getAllUniforms().get(U_VALUE_MIN), this.getLineValueMin());
        this.shader.setUniformFloat4(this.shader.getAllUniforms().get(U_COLOR_MAX), this.getLineColorMax());
        this.shader.setUniformFloat(this.shader.getAllUniforms().get(U_VALUE_MAX), this.getLineValueMax());
        Mesh.render$default(this.mesh, 0, this.points / 3, 1, null);
        this.mesh.unbind();
        this.shader.unbind();
    }

    @Override
    public void release() {
        this.shader.release();
        this.mesh.release();
    }

    private final void resizeIfNeeded(int toAdd) {
        if (this.points + toAdd > this.lineData.length) {
            int newSize = RangesKt.coerceAtLeast((int)(this.lineData.length * 2), (int)(this.points + toAdd));
            float[] fArray = Arrays.copyOf(this.lineData, newSize);
            Intrinsics.checkNotNullExpressionValue((Object)fArray, (String)"copyOf(...)");
            this.lineData = fArray;
        }
    }

    @Override
    public void addPoint(float x, float y) {
        this.resizeIfNeeded(6);
        this.lineData[this.points + 0] = x;
        this.lineData[this.points + 1] = 0.0f;
        this.lineData[this.points + 2] = 0.0f;
        this.lineData[this.points + 3] = x;
        this.lineData[this.points + 4] = y;
        this.lineData[this.points + 5] = 0.0f;
        this.points += 6;
    }

    @Override
    public void reset() {
        this.points = 0;
    }

    private static final Unit mesh$lambda$0(LayoutBuilder $this$bufferLayout) {
        Intrinsics.checkNotNullParameter((Object)$this$bufferLayout, (String)"$this$bufferLayout");
        $this$bufferLayout.position();
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lvet/inpulse/krafiks/FilledLineRenderer$Companion;", "", "<init>", "()V", "U_COLOR_MIN", "", "U_VALUE_MIN", "U_COLOR_MAX", "U_VALUE_MAX", "krafiks-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

