/*
 * Decompiled with CFR 0.152.
 */
package com.github.panpf.zoomimage.subsampling.internal;

import androidx.annotation.MainThread;
import com.github.panpf.zoomimage.subsampling.BitmapTileImage;
import com.github.panpf.zoomimage.subsampling.ImageInfo;
import com.github.panpf.zoomimage.subsampling.SamplingTiles;
import com.github.panpf.zoomimage.subsampling.SubsamplingImage;
import com.github.panpf.zoomimage.subsampling.Tile;
import com.github.panpf.zoomimage.subsampling.TileAnimationSpec;
import com.github.panpf.zoomimage.subsampling.TileBitmap_nonAndroidKt;
import com.github.panpf.zoomimage.subsampling.TileImage;
import com.github.panpf.zoomimage.subsampling.TileSnapshot;
import com.github.panpf.zoomimage.subsampling.TileSnapshotKt;
import com.github.panpf.zoomimage.subsampling.internal.SubsamplingsKt;
import com.github.panpf.zoomimage.subsampling.internal.TileDecoder;
import com.github.panpf.zoomimage.subsampling.internal.TileImageCacheHelper;
import com.github.panpf.zoomimage.subsampling.internal.TileImageConvertor;
import com.github.panpf.zoomimage.subsampling.internal.TileManager;
import com.github.panpf.zoomimage.subsampling.internal.Tile_managesKt;
import com.github.panpf.zoomimage.util.Core_utils_commonKt;
import com.github.panpf.zoomimage.util.Coroutines_nonJsCommonKt;
import com.github.panpf.zoomimage.util.IntRectCompat;
import com.github.panpf.zoomimage.util.IntRectCompatKt;
import com.github.panpf.zoomimage.util.IntSizeCompatKt;
import com.github.panpf.zoomimage.util.Logger;
import com.github.panpf.zoomimage.zoom.ContinuousTransformType;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.JobKt;
import kotlinx.coroutines.SupervisorKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.skia.Bitmap;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00a6\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 e2\u00020\u0001:\u0001eB\u00b2\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u000f\u0012!\u0010\u0011\u001a\u001d\u0012\u0013\u0012\u00110\u0000\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0015\u0012\u0004\u0012\u00020\u00160\u0012\u0012!\u0010\u0017\u001a\u001d\u0012\u0013\u0012\u00110\u0000\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0015\u0012\u0004\u0012\u00020\u00160\u0012\u0012!\u0010\u0018\u001a\u001d\u0012\u0013\u0012\u00110\u0000\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0015\u0012\u0004\u0012\u00020\u00160\u0012\u00a2\u0006\u0004\b\u0019\u0010\u001aJ0\u0010M\u001a\u00020$2\u0006\u0010N\u001a\u00020!2\u0006\u0010O\u001a\u00020&2\u0006\u0010P\u001a\u00020$2\u0006\u0010Q\u001a\u00020$2\u0006\u0010R\u001a\u00020SH\u0007J \u0010T\u001a\u00020/2\u0006\u0010#\u001a\u00020$2\u0006\u0010U\u001a\u00020$2\u0006\u0010V\u001a\u00020$H\u0002J\u0010\u0010W\u001a\u00020/2\u0006\u0010N\u001a\u00020!H\u0002J\u0010\u0010X\u001a\u00020/2\u0006\u0010O\u001a\u00020&H\u0002J\u0010\u0010Y\u001a\u00020\u00162\u0006\u0010R\u001a\u00020SH\u0007J\u0010\u0010Z\u001a\u00020/2\u0006\u0010[\u001a\u00020\\H\u0003J\u001a\u0010]\u001a\u00020/2\u0006\u0010[\u001a\u00020\\2\b\b\u0002\u0010^\u001a\u00020/H\u0003J \u0010_\u001a\u00020$2\f\u0010`\u001a\b\u0012\u0004\u0012\u00020\\0<2\b\b\u0002\u0010^\u001a\u00020/H\u0003J\u0010\u0010a\u001a\u00020\u00162\u0006\u0010R\u001a\u00020SH\u0002J\b\u0010b\u001a\u00020\u0016H\u0002J\b\u0010c\u001a\u00020\u0016H\u0002J\b\u0010d\u001a\u00020\u0016H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001bR\u0010\u0010\u0010\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001bR)\u0010\u0011\u001a\u001d\u0012\u0013\u0012\u00110\u0000\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0015\u0012\u0004\u0012\u00020\u00160\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R)\u0010\u0017\u001a\u001d\u0012\u0013\u0012\u00110\u0000\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0015\u0012\u0004\u0012\u00020\u00160\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R)\u0010\u0018\u001a\u001d\u0012\u0013\u0012\u00110\u0000\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0015\u0012\u0004\u0012\u00020\u00160\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010 \u001a\u0004\u0018\u00010!X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\"R\u000e\u0010#\u001a\u00020$X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010%\u001a\u0004\u0018\u00010&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010'\u001a\u0004\u0018\u00010(X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010)\u001a\u00020$X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-R$\u00100\u001a\u00020/2\u0006\u0010.\u001a\u00020/@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u00102\"\u0004\b3\u00104R\u001a\u00105\u001a\u000206X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u00108\"\u0004\b9\u0010:R\u0017\u0010;\u001a\b\u0012\u0004\u0012\u00020=0<\u00a2\u0006\b\n\u0000\u001a\u0004\b>\u0010?R$\u0010@\u001a\u00020$2\u0006\u0010.\u001a\u00020$@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bA\u0010+\"\u0004\bB\u0010-R$\u0010C\u001a\u00020&2\u0006\u0010.\u001a\u00020&@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bD\u0010E\"\u0004\bF\u0010GR*\u0010I\u001a\b\u0012\u0004\u0012\u00020H0<2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020H0<@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\bJ\u0010?R*\u0010K\u001a\b\u0012\u0004\u0012\u00020H0<2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020H0<@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\bL\u0010?\u00a8\u0006f"}, d2={"Lcom/github/panpf/zoomimage/subsampling/internal/TileManager;", "", "logger", "Lcom/github/panpf/zoomimage/util/Logger;", "subsamplingImage", "Lcom/github/panpf/zoomimage/subsampling/SubsamplingImage;", "tileDecoder", "Lcom/github/panpf/zoomimage/subsampling/internal/TileDecoder;", "tileImageConvertor", "Lcom/github/panpf/zoomimage/subsampling/internal/TileImageConvertor;", "tileImageCacheHelper", "Lcom/github/panpf/zoomimage/subsampling/internal/TileImageCacheHelper;", "imageInfo", "Lcom/github/panpf/zoomimage/subsampling/ImageInfo;", "contentSize", "Lcom/github/panpf/zoomimage/util/IntSizeCompat;", "preferredTileSize", "onTileChanged", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "tileManager", "", "onSampleSizeChanged", "onImageLoadRectChanged", "<init>", "(Lcom/github/panpf/zoomimage/util/Logger;Lcom/github/panpf/zoomimage/subsampling/SubsamplingImage;Lcom/github/panpf/zoomimage/subsampling/internal/TileDecoder;Lcom/github/panpf/zoomimage/subsampling/internal/TileImageConvertor;Lcom/github/panpf/zoomimage/subsampling/internal/TileImageCacheHelper;Lcom/github/panpf/zoomimage/subsampling/ImageInfo;JJLkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/internal/DefaultConstructorMarker;)V", "J", "decodeDispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "lastScale", "", "Ljava/lang/Float;", "lastSampleSize", "", "lastContentVisibleRect", "Lcom/github/panpf/zoomimage/util/IntRectCompat;", "updateTileSnapshotListJob", "Lkotlinx/coroutines/Job;", "pausedContinuousTransformTypes", "getPausedContinuousTransformTypes", "()I", "setPausedContinuousTransformTypes", "(I)V", "value", "", "disabledBackgroundTiles", "getDisabledBackgroundTiles", "()Z", "setDisabledBackgroundTiles", "(Z)V", "tileAnimationSpec", "Lcom/github/panpf/zoomimage/subsampling/TileAnimationSpec;", "getTileAnimationSpec", "()Lcom/github/panpf/zoomimage/subsampling/TileAnimationSpec;", "setTileAnimationSpec", "(Lcom/github/panpf/zoomimage/subsampling/TileAnimationSpec;)V", "sortedTileGridMap", "", "Lcom/github/panpf/zoomimage/subsampling/SamplingTiles;", "getSortedTileGridMap", "()Ljava/util/List;", "sampleSize", "getSampleSize", "setSampleSize", "imageLoadRect", "getImageLoadRect", "()Lcom/github/panpf/zoomimage/util/IntRectCompat;", "setImageLoadRect", "(Lcom/github/panpf/zoomimage/util/IntRectCompat;)V", "Lcom/github/panpf/zoomimage/subsampling/TileSnapshot;", "foregroundTiles", "getForegroundTiles", "backgroundTiles", "getBackgroundTiles", "refreshTiles", "scale", "contentVisibleRect", "rotation", "continuousTransformType", "caller", "", "isBackground", "currentSampleSize", "eachSampleSize", "resetSampleSize", "resetImageLoadRect", "clean", "loadTile", "tile", "Lcom/github/panpf/zoomimage/subsampling/Tile;", "freeTile", "skipNotify", "freeTiles", "tiles", "updateTileSnapshotList", "notifyTileChanged", "notifySampleSizeChanged", "notifyImageLoadRectChanged", "Companion", "zoomimage-core"})
@SourceDebugExtension(value={"SMAP\nTileManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TileManager.kt\ncom/github/panpf/zoomimage/subsampling/internal/TileManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,690:1\n774#2:691\n865#2,2:692\n1869#2:695\n1869#2,2:696\n1869#2,2:698\n1870#2:700\n1869#2,2:701\n1869#2,2:703\n1#3:694\n*S KotlinDebug\n*F\n+ 1 TileManager.kt\ncom/github/panpf/zoomimage/subsampling/internal/TileManager\n*L\n160#1:691\n160#1:692,2\n272#1:695\n276#1:696,2\n292#1:698,2\n272#1:700\n402#1:701,2\n549#1:703,2\n*E\n"})
public final class TileManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Logger logger;
    @NotNull
    private final SubsamplingImage subsamplingImage;
    @NotNull
    private final TileDecoder tileDecoder;
    @Nullable
    private final TileImageConvertor tileImageConvertor;
    @NotNull
    private final TileImageCacheHelper tileImageCacheHelper;
    @NotNull
    private final ImageInfo imageInfo;
    private final long contentSize;
    private final long preferredTileSize;
    @NotNull
    private final Function1<TileManager, Unit> onTileChanged;
    @NotNull
    private final Function1<TileManager, Unit> onSampleSizeChanged;
    @NotNull
    private final Function1<TileManager, Unit> onImageLoadRectChanged;
    @NotNull
    private final CoroutineDispatcher decodeDispatcher;
    @NotNull
    private final CoroutineScope coroutineScope;
    @Nullable
    private Float lastScale;
    private int lastSampleSize;
    @Nullable
    private IntRectCompat lastContentVisibleRect;
    @Nullable
    private Job updateTileSnapshotListJob;
    private int pausedContinuousTransformTypes;
    private boolean disabledBackgroundTiles;
    @NotNull
    private TileAnimationSpec tileAnimationSpec;
    @NotNull
    private final List<SamplingTiles> sortedTileGridMap;
    private int sampleSize;
    @NotNull
    private IntRectCompat imageLoadRect;
    @NotNull
    private List<TileSnapshot> foregroundTiles;
    @NotNull
    private List<TileSnapshot> backgroundTiles;
    public static final int DefaultPausedContinuousTransformTypes = 39;

    /*
     * WARNING - void declaration
     */
    private TileManager(Logger logger, SubsamplingImage subsamplingImage, TileDecoder tileDecoder, TileImageConvertor tileImageConvertor, TileImageCacheHelper tileImageCacheHelper, ImageInfo imageInfo, long contentSize, long preferredTileSize, Function1<? super TileManager, Unit> onTileChanged, Function1<? super TileManager, Unit> onSampleSizeChanged, Function1<? super TileManager, Unit> onImageLoadRectChanged) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)subsamplingImage, (String)"subsamplingImage");
        Intrinsics.checkNotNullParameter((Object)tileDecoder, (String)"tileDecoder");
        Intrinsics.checkNotNullParameter((Object)tileImageCacheHelper, (String)"tileImageCacheHelper");
        Intrinsics.checkNotNullParameter((Object)imageInfo, (String)"imageInfo");
        Intrinsics.checkNotNullParameter(onTileChanged, (String)"onTileChanged");
        Intrinsics.checkNotNullParameter(onSampleSizeChanged, (String)"onSampleSizeChanged");
        Intrinsics.checkNotNullParameter(onImageLoadRectChanged, (String)"onImageLoadRectChanged");
        this.logger = logger;
        this.subsamplingImage = subsamplingImage;
        this.tileDecoder = tileDecoder;
        this.tileImageConvertor = tileImageConvertor;
        this.tileImageCacheHelper = tileImageCacheHelper;
        this.imageInfo = imageInfo;
        this.contentSize = contentSize;
        this.preferredTileSize = preferredTileSize;
        this.onTileChanged = onTileChanged;
        this.onSampleSizeChanged = onSampleSizeChanged;
        this.onImageLoadRectChanged = onImageLoadRectChanged;
        this.decodeDispatcher = CoroutineDispatcher.limitedParallelism$default((CoroutineDispatcher)Coroutines_nonJsCommonKt.ioCoroutineDispatcher(), (int)2, null, (int)2, null);
        this.coroutineScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)SupervisorKt.SupervisorJob$default(null, (int)1, null).plus((CoroutineContext)Dispatchers.getMain()));
        this.pausedContinuousTransformTypes = 39;
        this.tileAnimationSpec = TileAnimationSpec.Companion.getDefault();
        this.imageLoadRect = IntRectCompat.Companion.getZero();
        this.foregroundTiles = CollectionsKt.emptyList();
        this.backgroundTiles = CollectionsKt.emptyList();
        int maxSampleSize = Tile_managesKt.findSampleSize-kjLh3nM(this.imageInfo.getSize-wTLXMmk(), this.contentSize, 1.0f);
        Iterable iterable = Tile_managesKt.calculateTileGridMap-MEmoHmQ(this.imageInfo.getSize-wTLXMmk(), this.preferredTileSize);
        TileManager tileManager = this;
        boolean $i$f$filter = false;
        void var17_17 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            SamplingTiles it = (SamplingTiles)element$iv$iv;
            boolean bl = false;
            if (!(it.getSampleSize() <= maxSampleSize)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        tileManager.sortedTileGridMap = (List)destination$iv$iv;
        this.logger.v((Function0<String>)((Function0)() -> TileManager._init_$lambda$1(this, maxSampleSize)));
        for (SamplingTiles tiles : this.sortedTileGridMap) {
            this.logger.v((Function0<String>)((Function0)() -> TileManager._init_$lambda$3(tiles, this)));
        }
    }

    public final int getPausedContinuousTransformTypes() {
        return this.pausedContinuousTransformTypes;
    }

    public final void setPausedContinuousTransformTypes(int n) {
        this.pausedContinuousTransformTypes = n;
    }

    public final boolean getDisabledBackgroundTiles() {
        return this.disabledBackgroundTiles;
    }

    public final void setDisabledBackgroundTiles(boolean value) {
        if (this.disabledBackgroundTiles != value) {
            this.disabledBackgroundTiles = value;
            this.updateTileSnapshotList("disabledBackgroundTilesChanged");
        }
    }

    @NotNull
    public final TileAnimationSpec getTileAnimationSpec() {
        return this.tileAnimationSpec;
    }

    public final void setTileAnimationSpec(@NotNull TileAnimationSpec tileAnimationSpec) {
        Intrinsics.checkNotNullParameter((Object)tileAnimationSpec, (String)"<set-?>");
        this.tileAnimationSpec = tileAnimationSpec;
    }

    @NotNull
    public final List<SamplingTiles> getSortedTileGridMap() {
        return this.sortedTileGridMap;
    }

    public final int getSampleSize() {
        return this.sampleSize;
    }

    private final void setSampleSize(int value) {
        if (this.sampleSize != value) {
            this.sampleSize = value;
            this.notifySampleSizeChanged();
        }
    }

    @NotNull
    public final IntRectCompat getImageLoadRect() {
        return this.imageLoadRect;
    }

    private final void setImageLoadRect(IntRectCompat value) {
        if (!Intrinsics.areEqual((Object)this.imageLoadRect, (Object)value)) {
            this.imageLoadRect = value;
            this.notifyImageLoadRectChanged();
        }
    }

    @NotNull
    public final List<TileSnapshot> getForegroundTiles() {
        return this.foregroundTiles;
    }

    @NotNull
    public final List<TileSnapshot> getBackgroundTiles() {
        return this.backgroundTiles;
    }

    @MainThread
    public final int refreshTiles(float scale2, @NotNull IntRectCompat contentVisibleRect, int rotation, int continuousTransformType, @NotNull String caller) {
        List<Tile> foregroundTiles;
        Object v0;
        IntRectCompat newImageLoadRect;
        int newSampleSize;
        boolean imageLoadRectChanged;
        boolean sampleSizeChanged;
        IntRectCompat oldImageLoadRect;
        int oldSampleSize;
        block15: {
            Intrinsics.checkNotNullParameter((Object)contentVisibleRect, (String)"contentVisibleRect");
            Intrinsics.checkNotNullParameter((Object)caller, (String)"caller");
            if (rotation % 90 != 0) {
                this.logger.d((Function0<String>)((Function0)() -> TileManager.refreshTiles$lambda$4(caller, rotation, this)));
                return -1;
            }
            if ((continuousTransformType & this.pausedContinuousTransformTypes) != 0) {
                this.logger.d((Function0<String>)((Function0)() -> TileManager.refreshTiles$lambda$5(continuousTransformType, caller, this)));
                return -2;
            }
            oldSampleSize = this.sampleSize;
            oldImageLoadRect = this.imageLoadRect;
            sampleSizeChanged = this.resetSampleSize(scale2);
            imageLoadRectChanged = this.resetImageLoadRect(contentVisibleRect);
            newSampleSize = this.sampleSize;
            newImageLoadRect = this.imageLoadRect;
            Iterable iterable = this.sortedTileGridMap;
            for (Object t : iterable) {
                SamplingTiles it = (SamplingTiles)t;
                boolean bl = false;
                if (!(it.getSampleSize() == newSampleSize)) continue;
                v0 = t;
                break block15;
            }
            v0 = null;
        }
        SamplingTiles samplingTiles = v0;
        List<Tile> list = foregroundTiles = samplingTiles != null ? samplingTiles.getTiles() : null;
        if (foregroundTiles == null || foregroundTiles.size() == 1) {
            this.logger.d((Function0<String>)((Function0)() -> TileManager.refreshTiles$lambda$7(caller, foregroundTiles, sampleSizeChanged, oldSampleSize, newSampleSize, this, scale2)));
            if (sampleSizeChanged) {
                this.clean("refreshTiles:foregroundTilesEmptyOrOne");
                this.updateTileSnapshotList("refreshTiles:foregroundTilesEmptyOrOne");
            }
            return -3;
        }
        if (newImageLoadRect.isEmpty()) {
            this.logger.d((Function0<String>)((Function0)() -> TileManager.refreshTiles$lambda$8(caller, oldImageLoadRect, newImageLoadRect, this, contentVisibleRect)));
            if (imageLoadRectChanged) {
                this.clean("refreshTiles:contentVisibleRectEmpty");
                this.updateTileSnapshotList("refreshTiles:contentVisibleRectEmpty");
            }
            return -4;
        }
        Ref.IntRef expectLoadCount = new Ref.IntRef();
        Ref.IntRef actualLoadCount = new Ref.IntRef();
        Ref.IntRef expectFreeCount = new Ref.IntRef();
        Ref.IntRef actualFreeCount = new Ref.IntRef();
        int lastSampleSize = this.lastSampleSize;
        Iterable $this$forEach$iv = this.sortedTileGridMap;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            int n;
            boolean $i$f$forEach2;
            Iterable $this$forEach$iv2;
            SamplingTiles it = (SamplingTiles)element$iv;
            boolean bl = false;
            int eachSampleSize = it.getSampleSize();
            List<Tile> eachTiles = it.getTiles();
            if (eachSampleSize == newSampleSize) {
                $this$forEach$iv2 = eachTiles;
                $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    Tile foregroundTile = (Tile)element$iv2;
                    boolean bl2 = false;
                    if (foregroundTile.getSrcRect().overlaps(newImageLoadRect)) {
                        n = expectLoadCount.element;
                        expectLoadCount.element = n + 1;
                        if (!this.loadTile(foregroundTile)) continue;
                        n = actualLoadCount.element;
                        actualLoadCount.element = n + 1;
                        continue;
                    }
                    n = expectFreeCount.element;
                    expectFreeCount.element = n + 1;
                    if (!this.freeTile(foregroundTile, true)) continue;
                    n = actualFreeCount.element;
                    actualFreeCount.element = n + 1;
                }
                continue;
            }
            if (!this.disabledBackgroundTiles && this.isBackground(lastSampleSize, newSampleSize, eachSampleSize)) {
                $this$forEach$iv2 = eachTiles;
                $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    Tile backgroundTile = (Tile)element$iv2;
                    boolean bl3 = false;
                    if (backgroundTile.getSrcRect().overlaps(newImageLoadRect)) {
                        if (backgroundTile.getState() != 1) continue;
                        n = expectFreeCount.element;
                        expectFreeCount.element = n + 1;
                        if (!this.freeTile(backgroundTile, true)) continue;
                        n = actualFreeCount.element;
                        actualFreeCount.element = n + 1;
                        continue;
                    }
                    n = expectFreeCount.element;
                    expectFreeCount.element = n + 1;
                    if (!this.freeTile(backgroundTile, true)) continue;
                    n = actualFreeCount.element;
                    actualFreeCount.element = n + 1;
                }
                continue;
            }
            expectFreeCount.element += eachTiles.size();
            actualFreeCount.element += this.freeTiles(eachTiles, true);
        }
        this.logger.d((Function0<String>)((Function0)() -> TileManager.refreshTiles$lambda$12(continuousTransformType, caller, actualLoadCount, expectLoadCount, actualFreeCount, expectFreeCount, oldSampleSize, newSampleSize, foregroundTiles, oldImageLoadRect, newImageLoadRect, scale2, contentVisibleRect, this)));
        if (sampleSizeChanged || imageLoadRectChanged || actualFreeCount.element > 0) {
            this.updateTileSnapshotList("refreshTiles:loadOrFreeTile");
        }
        return 0;
    }

    private final boolean isBackground(int lastSampleSize, int currentSampleSize, int eachSampleSize) {
        if (lastSampleSize == 0) {
            return false;
        }
        if (lastSampleSize > currentSampleSize && eachSampleSize > currentSampleSize) {
            return true;
        }
        return lastSampleSize < currentSampleSize && eachSampleSize < currentSampleSize;
    }

    private final boolean resetSampleSize(float scale2) {
        int newSampleSize;
        Float lastScale = this.lastScale;
        int currentSampleSize = this.sampleSize;
        if (currentSampleSize != 0 && Intrinsics.areEqual((float)scale2, (Float)lastScale)) {
            return false;
        }
        this.lastScale = Float.valueOf(scale2);
        int n = newSampleSize = scale2 > 1.0f ? Tile_managesKt.findSampleSize-kjLh3nM(this.imageInfo.getSize-wTLXMmk(), this.contentSize, scale2) : 0;
        if (newSampleSize == currentSampleSize) {
            return false;
        }
        this.lastSampleSize = currentSampleSize;
        this.setSampleSize(newSampleSize);
        return true;
    }

    private final boolean resetImageLoadRect(IntRectCompat contentVisibleRect) {
        if (Intrinsics.areEqual((Object)this.lastContentVisibleRect, (Object)contentVisibleRect)) {
            return false;
        }
        this.lastContentVisibleRect = contentVisibleRect;
        IntRectCompat newImageLoadRect = Tile_managesKt.calculateImageLoadRect-uV7mNCg(this.imageInfo.getSize-wTLXMmk(), this.contentSize, this.preferredTileSize, contentVisibleRect);
        if (Intrinsics.areEqual((Object)newImageLoadRect, (Object)this.imageLoadRect)) {
            return false;
        }
        this.setImageLoadRect(newImageLoadRect);
        return true;
    }

    @MainThread
    public final void clean(@NotNull String caller) {
        int sampleSize;
        Intrinsics.checkNotNullParameter((Object)caller, (String)"caller");
        Job updateTileSnapshotListJob = this.updateTileSnapshotListJob;
        if (updateTileSnapshotListJob != null && updateTileSnapshotListJob.isActive()) {
            this.logger.d((Function0<String>)((Function0)() -> TileManager.clean$lambda$13(caller, this)));
            JobKt.cancel$default((Job)updateTileSnapshotListJob, (String)("clean:" + caller), null, (int)2, null);
            this.updateTileSnapshotListJob = null;
        }
        if ((sampleSize = this.sampleSize) != 0) {
            Ref.IntRef freeCount = new Ref.IntRef();
            Iterable $this$forEach$iv = this.sortedTileGridMap;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                SamplingTiles it = (SamplingTiles)element$iv;
                boolean bl = false;
                freeCount.element += this.freeTiles(it.getTiles(), true);
            }
            this.logger.d((Function0<String>)((Function0)() -> TileManager.clean$lambda$15(caller, freeCount, this)));
            if (freeCount.element > 0) {
                this.updateTileSnapshotList("clean:" + caller);
            }
        }
    }

    @MainThread
    private final boolean loadTile(Tile tile) {
        Job job;
        if (tile.getTileImage() != null) {
            this.logger.v((Function0<String>)((Function0)() -> TileManager.loadTile$lambda$16(tile, this)));
            return false;
        }
        Job job2 = job = tile.getLoadJob$zoomimage_core();
        boolean bl = job2 != null ? job2.isActive() : false;
        if (bl) {
            this.logger.v((Function0<String>)((Function0)() -> TileManager.loadTile$lambda$17(tile, this)));
            return false;
        }
        this.logger.v("TileManager. loadTile. started. " + tile + ". '" + this.subsamplingImage.getKey() + '\'');
        tile.setLoadJob$zoomimage_core((Job)BuildersKt.async$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, tile, null){
            Object L$1;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ TileManager this$0;
            final /* synthetic */ Tile $tile;
            {
                this.this$0 = $receiver;
                this.$tile = $tile;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                block18: {
                    var10_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            $this$async = (CoroutineScope)this.L$0;
                            tileKey = "tile_" + TileManager.access$getSubsamplingImage$p(this.this$0).getImageSource().getKey() + "_rect=" + IntRectCompatKt.toShortString(this.$tile.getSrcRect()) + "_sampleSize=" + this.$tile.getSampleSize();
                            cachedValue = TileManager.access$getTileImageCacheHelper$p(this.this$0).get(tileKey);
                            if (cachedValue == null) break;
                            v0 = TileManager.access$getTileImageConvertor$p(this.this$0);
                            if (v0 == null) ** GOTO lbl22
                            this.L$0 = cachedValue;
                            this.label = 1;
                            v1 = v0.convert(cachedValue, (Continuation<? super TileImage>)((Continuation)this));
                            if (v1 == var10_2) {
                                return var10_2;
                            }
                            ** GOTO lbl21
                        }
                        case 1: {
                            cachedValue = (TileImage)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
lbl21:
                            // 2 sources

                            if ((v0 = (TileImage)v1) != null) ** GOTO lbl23
lbl22:
                            // 2 sources

                            v0 = cachedValue;
lbl23:
                            // 2 sources

                            convertedTileImage = v0;
                            this.$tile.setTileImage(convertedTileImage, 1, true);
                            this.$tile.setState(2);
                            TileManager.access$getLogger$p(this.this$0).v((Function0<String>)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, invokeSuspend$lambda$0(com.github.panpf.zoomimage.subsampling.Tile com.github.panpf.zoomimage.subsampling.internal.TileManager ), ()Ljava/lang/String;)((Tile)this.$tile, (TileManager)this.this$0));
                            TileManager.access$updateTileSnapshotList(this.this$0, "loadTile:fromMemory");
                            break block18;
                        }
                    }
                    this.$tile.cleanTileImage();
                    this.$tile.setState(1);
                    TileManager.access$updateTileSnapshotList(this.this$0, "loadTile:loading");
                    this.L$0 = $this$async;
                    this.L$1 = tileKey;
                    this.label = 2;
                    v2 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)TileManager.access$getDecodeDispatcher$p(this.this$0)), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Result<? extends Bitmap>>, Object>(this.this$0, this.$tile, null){
                        int label;
                        final /* synthetic */ TileManager this$0;
                        final /* synthetic */ Tile $tile;
                        {
                            this.this$0 = $receiver;
                            this.$tile = $tile;
                            super(2, $completion);
                        }

                        public final Object invokeSuspend(Object object) {
                            IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    Object object2;
                                    ResultKt.throwOnFailure((Object)object);
                                    TileManager tileManager = this.this$0;
                                    Tile tile = this.$tile;
                                    try {
                                        boolean bl = false;
                                        object2 = Result.constructor-impl((Object)TileManager.access$getTileDecoder$p(tileManager).decode(tile.getSrcRect(), tile.getSampleSize()));
                                    }
                                    catch (Throwable throwable) {
                                        object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                                    }
                                    return Result.box-impl((Object)object2);
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        public final Object invoke(CoroutineScope p1, Continuation<? super Result<Bitmap>> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (Continuation)((Continuation)this));
                    if (v2 == var10_2) {
                        return var10_2;
                    }
                    ** GOTO lbl44
                    {
                        case 2: {
                            tileKey = (String)this.L$1;
                            $this$async = (CoroutineScope)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v2 = $result;
lbl44:
                            // 2 sources

                            tileBitmap = (Bitmap)(Result.isFailure-impl((Object)(decodeResult = ((Result)v2).unbox-impl())) != false ? null : decodeResult);
                            if (!Result.isFailure-impl((Object)decodeResult)) ** GOTO lbl53
                            this.$tile.cleanTileImage();
                            this.$tile.setState(3);
                            v3 = Result.exceptionOrNull-impl((Object)decodeResult);
                            TileManager.access$getLogger$p(this.this$0).e("TileManager. loadTile. failed, " + (v3 != null ? v3.getMessage() : null) + ". " + this.$tile + ". '" + TileManager.access$getSubsamplingImage$p(this.this$0).getKey() + '\'');
                            TileManager.access$updateTileSnapshotList(this.this$0, "loadTile:failed");
                            break block18;
lbl53:
                            // 1 sources

                            if (tileBitmap != null) ** GOTO lbl59
                            this.$tile.cleanTileImage();
                            this.$tile.setState(3);
                            TileManager.access$getLogger$p(this.this$0).e("TileManager. loadTile. failed, bitmap null. " + this.$tile + ". '" + TileManager.access$getSubsamplingImage$p(this.this$0).getKey() + '\'');
                            TileManager.access$updateTileSnapshotList(this.this$0, "loadTile:failed");
                            break block18;
lbl59:
                            // 1 sources

                            if (this.$tile.getSampleSize() != 1 || this.$tile.getSrcRect().getWidth() == TileBitmap_nonAndroidKt.getWidth(tileBitmap) && this.$tile.getSrcRect().getHeight() == TileBitmap_nonAndroidKt.getHeight(tileBitmap)) ** GOTO lbl66
                            this.$tile.cleanTileImage();
                            this.$tile.setState(3);
                            TileManager.access$getLogger$p(this.this$0).e("TileManager. loadTile. failed, size is different. " + this.$tile + ". " + tileBitmap + ". '" + TileManager.access$getSubsamplingImage$p(this.this$0).getKey() + '\'');
                            TileBitmap_nonAndroidKt.recycle(tileBitmap);
                            TileManager.access$updateTileSnapshotList(this.this$0, "loadTile:failed");
                            break block18;
lbl66:
                            // 1 sources

                            if (!CoroutineScopeKt.isActive((CoroutineScope)$this$async)) break;
                            tileImage = new BitmapTileImage(tileBitmap);
                            v4 = TileManager.access$getTileImageCacheHelper$p(this.this$0).put((String)var3_4, tileImage, TileManager.access$getSubsamplingImage$p(this.this$0).getImageSource().getKey(), TileManager.access$getImageInfo$p(this.this$0));
                            if (v4 == null) {
                                v4 = cacheTileImage = (TileImage)tileImage;
                            }
                            if ((v5 = TileManager.access$getTileImageConvertor$p(this.this$0)) == null) ** GOTO lbl84
                            this.L$0 = cacheTileImage;
                            this.L$1 = null;
                            this.label = 3;
                            v6 = v5.convert(cacheTileImage, (Continuation<? super TileImage>)((Continuation)this));
                            if (v6 == var10_2) {
                                return var10_2;
                            }
                            ** GOTO lbl83
                        }
                        case 3: {
                            cacheTileImage = (TileImage)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v6 = $result;
lbl83:
                            // 2 sources

                            if ((v5 = (TileImage)v6) != null) ** GOTO lbl85
lbl84:
                            // 2 sources

                            v5 = cacheTileImage;
lbl85:
                            // 2 sources

                            convertedTileImage = v5;
                            this.$tile.setTileImage(convertedTileImage, 2, true);
                            this.$tile.setState(2);
                            TileManager.access$getLogger$p(this.this$0).v((Function0<String>)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, invokeSuspend$lambda$1(com.github.panpf.zoomimage.subsampling.Tile com.github.panpf.zoomimage.subsampling.internal.TileManager ), ()Ljava/lang/String;)((Tile)this.$tile, (TileManager)this.this$0));
                            TileManager.access$updateTileSnapshotList(this.this$0, "loadTile:successful");
                            break block18;
                        }
                    }
                    TileManager.access$getLogger$p(this.this$0).d((Function0<String>)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, invokeSuspend$lambda$2(org.jetbrains.skia.Bitmap com.github.panpf.zoomimage.subsampling.Tile com.github.panpf.zoomimage.subsampling.internal.TileManager ), ()Ljava/lang/String;)((Bitmap)tileBitmap, (Tile)this.$tile, (TileManager)this.this$0));
                    this.$tile.cleanTileImage();
                    this.$tile.setState(3);
                    TileBitmap_nonAndroidKt.recycle(tileBitmap);
                    TileManager.access$updateTileSnapshotList(this.this$0, "loadTile:canceled");
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)function2;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final String invokeSuspend$lambda$0(Tile $tile, TileManager this$0) {
                return "TileManager. loadTile. successful, fromMemory. " + $tile + ". '" + TileManager.access$getSubsamplingImage$p(this$0).getKey() + '\'';
            }

            private static final String invokeSuspend$lambda$1(Tile $tile, TileManager this$0) {
                return "TileManager. loadTile. successful. " + $tile + ". '" + TileManager.access$getSubsamplingImage$p(this$0).getKey() + '\'';
            }

            private static final String invokeSuspend$lambda$2(Bitmap $tileBitmap, Tile $tile, TileManager this$0) {
                return "TileManager. loadTile. canceled. bitmap=" + $tileBitmap + ", " + $tile + ". '" + TileManager.access$getSubsamplingImage$p(this$0).getKey() + '\'';
            }
        }), (int)3, null));
        return true;
    }

    @MainThread
    private final boolean freeTile(Tile tile, boolean skipNotify) {
        TileImage tileImage;
        if (tile.getState() == 0) {
            return false;
        }
        tile.setState(0);
        Job loadJob = tile.getLoadJob$zoomimage_core();
        if (loadJob != null && loadJob.isActive()) {
            Job.DefaultImpls.cancel$default((Job)loadJob, null, (int)1, null);
            tile.setLoadJob$zoomimage_core(null);
        }
        if ((tileImage = tile.getTileImage()) != null) {
            this.logger.v((Function0<String>)((Function0)() -> TileManager.freeTile$lambda$18(tile, this)));
            tile.cleanTileImage();
        }
        if (!skipNotify) {
            this.updateTileSnapshotList("freeTile");
        }
        return true;
    }

    static /* synthetic */ boolean freeTile$default(TileManager tileManager, Tile tile, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return tileManager.freeTile(tile, bl);
    }

    @MainThread
    private final int freeTiles(List<Tile> tiles, boolean skipNotify) {
        int freeCount = 0;
        Iterable $this$forEach$iv = tiles;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Tile tile = (Tile)element$iv;
            boolean bl = false;
            if (!this.freeTile(tile, skipNotify)) continue;
            ++freeCount;
        }
        if (!skipNotify && freeCount > 0) {
            this.updateTileSnapshotList("freeTiles");
        }
        return freeCount;
    }

    static /* synthetic */ int freeTiles$default(TileManager tileManager, List list, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return tileManager.freeTiles(list, bl);
    }

    private final void updateTileSnapshotList(String caller) {
        Job job = this.updateTileSnapshotListJob;
        boolean bl = job != null ? job.isActive() : false;
        if (bl) {
            this.logger.v((Function0<String>)((Function0)() -> TileManager.updateTileSnapshotList$lambda$20(caller, this)));
            return;
        }
        this.logger.v((Function0<String>)((Function0)() -> TileManager.updateTileSnapshotList$lambda$21(caller, this)));
        this.updateTileSnapshotListJob = BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, caller, null){
            Object L$1;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ TileManager this$0;
            final /* synthetic */ String $caller;
            {
                this.this$0 = $receiver;
                this.$caller = $caller;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            public final Object invokeSuspend(Object object) {
                Object object2;
                Ref.BooleanRef running;
                CoroutineScope $this$launch;
                Object object3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        $this$launch = (CoroutineScope)this.L$0;
                        running = new Ref.BooleanRef();
                        running.element = true;
                        break;
                    }
                    case 1: {
                        void $result;
                        running = (Ref.BooleanRef)this.L$1;
                        $this$launch = (CoroutineScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        object2 = $result;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }
                }
                while (running.element && CoroutineScopeKt.isActive((CoroutineScope)$this$launch)) {
                    void $this$forEach$iv;
                    List<Tile> foregroundTiles;
                    Object v1;
                    Object object4;
                    Ref.IntRef foregroundAnimatingCount;
                    Ref.IntRef foregroundLoadingCount;
                    Ref.IntRef foregroundLoadedCount;
                    Ref.IntRef foregroundOutsideCount;
                    Ref.IntRef foregroundInsideCount;
                    Ref.BooleanRef foregroundAnimationAllFinished;
                    Ref.BooleanRef foregroundLoadAllCompleted;
                    List foregroundTileSnapshots;
                    IntRectCompat imageLoadRect;
                    int sampleSize;
                    block19: {
                        sampleSize = this.this$0.getSampleSize();
                        imageLoadRect = this.this$0.getImageLoadRect();
                        foregroundTileSnapshots = new ArrayList<E>();
                        foregroundLoadAllCompleted = new Ref.BooleanRef();
                        foregroundLoadAllCompleted.element = true;
                        foregroundAnimationAllFinished = new Ref.BooleanRef();
                        foregroundAnimationAllFinished.element = true;
                        foregroundInsideCount = new Ref.IntRef();
                        foregroundOutsideCount = new Ref.IntRef();
                        foregroundLoadedCount = new Ref.IntRef();
                        foregroundLoadingCount = new Ref.IntRef();
                        foregroundAnimatingCount = new Ref.IntRef();
                        object4 = this.this$0.getSortedTileGridMap();
                        Iterator<T> iterator = object4.iterator();
                        while (iterator.hasNext()) {
                            T t = iterator.next();
                            SamplingTiles it = (SamplingTiles)t;
                            boolean bl = false;
                            if (!(it.getSampleSize() == sampleSize)) continue;
                            v1 = t;
                            break block19;
                        }
                        v1 = null;
                    }
                    SamplingTiles samplingTiles = v1;
                    List<Tile> list = foregroundTiles = samplingTiles != null ? samplingTiles.getTiles() : null;
                    int foregroundTileCount = list != null ? list.size() : 0;
                    List<Tile> list2 = foregroundTiles;
                    if (list2 != null) {
                        void $this$forEach$iv2;
                        Iterable iterable = list2;
                        object4 = this.this$0;
                        boolean $i$f$forEach = false;
                        for (E element$iv : $this$forEach$iv2) {
                            int n;
                            Tile foregroundTile = (Tile)element$iv;
                            boolean bl = false;
                            Tile.AnimationState animationState = foregroundTile.getAnimationState();
                            animationState.calculate(((TileManager)object4).getTileAnimationSpec().getDuration());
                            if (animationState.getRunning()) {
                                n = foregroundAnimatingCount.element;
                                foregroundAnimatingCount.element = n + 1;
                            }
                            boolean bl2 = foregroundAnimationAllFinished.element = foregroundAnimationAllFinished.element && !animationState.getRunning();
                            if (foregroundTile.getState() == 2) {
                                n = foregroundLoadedCount.element;
                                foregroundLoadedCount.element = n + 1;
                            } else if (foregroundTile.getState() == 1) {
                                n = foregroundLoadingCount.element;
                                foregroundLoadingCount.element = n + 1;
                            }
                            if (foregroundTile.getSrcRect().overlaps(imageLoadRect)) {
                                foregroundLoadAllCompleted.element = foregroundLoadAllCompleted.element && foregroundTile.getState() == 2;
                                n = foregroundInsideCount.element;
                                foregroundInsideCount.element = n + 1;
                            } else {
                                n = foregroundOutsideCount.element;
                                foregroundOutsideCount.element = n + 1;
                            }
                            foregroundTileSnapshots.add(TileSnapshotKt.toSnapshot(foregroundTile));
                        }
                    }
                    Ref.IntRef backgroundTileCount = new Ref.IntRef();
                    Ref.IntRef backgroundFreeCount = new Ref.IntRef();
                    List backgroundTileSnapshots = new ArrayList<E>();
                    int currentSampleSize = sampleSize;
                    int lastSampleSize = TileManager.access$getLastSampleSize$p(this.this$0);
                    boolean disabledBackgroundTiles = this.this$0.getDisabledBackgroundTiles();
                    Iterable bl = this.this$0.getSortedTileGridMap();
                    TileManager tileManager = this.this$0;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        int freeCount;
                        SamplingTiles samplingTiles2 = (SamplingTiles)element$iv;
                        boolean bl3 = false;
                        int eachSampleSize = samplingTiles2.component1();
                        List<Tile> eachTiles = samplingTiles2.component2();
                        if (eachSampleSize == currentSampleSize) continue;
                        if (!disabledBackgroundTiles && TileManager.access$isBackground(tileManager, lastSampleSize, currentSampleSize, eachSampleSize)) {
                            if (foregroundLoadAllCompleted.element && foregroundAnimationAllFinished.element) {
                                freeCount = TileManager.access$freeTiles(tileManager, eachTiles, true);
                                backgroundFreeCount.element += freeCount;
                                continue;
                            }
                            Iterable $this$forEach$iv3 = eachTiles;
                            boolean $i$f$forEach2 = false;
                            for (T element$iv2 : $this$forEach$iv3) {
                                Tile backgroundTile = (Tile)element$iv2;
                                boolean bl4 = false;
                                if (!backgroundTile.getSrcRect().overlaps(imageLoadRect) || backgroundTile.getState() != 2) continue;
                                int n = backgroundTileCount.element;
                                backgroundTileCount.element = n + 1;
                                if (backgroundTile.getAnimationState().getRunning()) {
                                    backgroundTile.getAnimationState().stop();
                                }
                                backgroundTileSnapshots.add(TileSnapshotKt.toSnapshot(backgroundTile));
                            }
                            continue;
                        }
                        freeCount = TileManager.access$freeTiles(tileManager, eachTiles, true);
                        backgroundFreeCount.element += freeCount;
                    }
                    TileManager.access$getLogger$p(this.this$0).v((Function0<String>)((Function0)() -> updateTileSnapshotList.3.invokeSuspend$lambda$4(sampleSize, foregroundTileCount, foregroundInsideCount, foregroundOutsideCount, foregroundLoadedCount, foregroundLoadingCount, foregroundAnimatingCount, backgroundTileCount, backgroundFreeCount)));
                    TileManager.access$setForegroundTiles$p(this.this$0, foregroundTileSnapshots);
                    TileManager.access$setBackgroundTiles$p(this.this$0, backgroundTileSnapshots);
                    TileManager.access$notifyTileChanged(this.this$0);
                    boolean bl5 = running.element = !foregroundAnimationAllFinished.element;
                    if (!running.element) continue;
                    this.L$0 = $this$launch;
                    this.L$1 = running;
                    this.label = 1;
                    object2 = DelayKt.delay((long)this.this$0.getTileAnimationSpec().getInterval(), (Continuation)((Continuation)this));
                    if (object2 != object3) continue;
                    return object3;
                }
                TileManager.access$getLogger$p(this.this$0).v((Function0<String>)((Function0)() -> updateTileSnapshotList.3.invokeSuspend$lambda$5(this.$caller, running, $this$launch, this.this$0)));
                return Unit.INSTANCE;
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)function2;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final String invokeSuspend$lambda$4(int $sampleSize, int $foregroundTileCount, Ref.IntRef $foregroundInsideCount, Ref.IntRef $foregroundOutsideCount, Ref.IntRef $foregroundLoadedCount, Ref.IntRef $foregroundLoadingCount, Ref.IntRef $foregroundAnimatingCount, Ref.IntRef $backgroundTileCount, Ref.IntRef $backgroundFreeCount) {
                return "TileManager. updateTileSnapshotList. sampleSize=" + $sampleSize + ", foregroundTileCount=" + $foregroundTileCount + ", foregroundInsideCount=" + $foregroundInsideCount.element + ", foregroundOutsideCount=" + $foregroundOutsideCount.element + ", foregroundLoadedCount=" + $foregroundLoadedCount.element + ", foregroundLoadingCount=" + $foregroundLoadingCount.element + ", foregroundAnimatingCount=" + $foregroundAnimatingCount.element + ", backgroundTileCount=" + $backgroundTileCount.element + ", backgroundFreeCount=" + $backgroundFreeCount.element + ", ";
            }

            private static final String invokeSuspend$lambda$5(String $caller, Ref.BooleanRef $running, CoroutineScope $$this$launch, TileManager this$0) {
                return "TileManager. updateTileSnapshotList:" + $caller + ". end. running=" + $running.element + ", active=" + CoroutineScopeKt.isActive((CoroutineScope)$$this$launch) + ". '" + TileManager.access$getSubsamplingImage$p(this$0).getKey() + '\'';
            }
        }), (int)3, null);
    }

    private final void notifyTileChanged() {
        this.onTileChanged.invoke((Object)this);
    }

    private final void notifySampleSizeChanged() {
        this.onSampleSizeChanged.invoke((Object)this);
    }

    private final void notifyImageLoadRectChanged() {
        this.onImageLoadRectChanged.invoke((Object)this);
    }

    private static final String _init_$lambda$1(TileManager this$0, int $maxSampleSize) {
        return "TileManager. init. imageSize=" + IntSizeCompatKt.toShortString-grz_zgQ(this$0.imageInfo.getSize-wTLXMmk()) + ", contentSize=" + IntSizeCompatKt.toShortString-grz_zgQ(this$0.contentSize) + ", preferredTileSize=" + IntSizeCompatKt.toShortString-grz_zgQ(this$0.preferredTileSize) + ", maxSampleSize=" + $maxSampleSize + ", sortedTileGridMap=" + SubsamplingsKt.toIntroString(this$0.sortedTileGridMap) + ". '" + this$0.subsamplingImage.getKey() + '\'';
    }

    private static final CharSequence lambda$3$lambda$2(Tile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return IntRectCompatKt.toShortString2(it.getSrcRect());
    }

    private static final String _init_$lambda$3(SamplingTiles $tiles, TileManager this$0) {
        String tilesString = CollectionsKt.joinToString$default((Iterable)$tiles.getTiles(), null, (CharSequence)"[", (CharSequence)"]", (int)0, null, TileManager::lambda$3$lambda$2, (int)25, null);
        return "TileManager. init. sortedTileGridMap. " + $tiles.getSampleSize() + ':' + tilesString + ". '" + this$0.subsamplingImage.getKey() + '\'';
    }

    private static final String refreshTiles$lambda$4(String $caller, int $rotation, TileManager this$0) {
        return "TileManager. refreshTiles:" + $caller + ". interrupted, rotation is not a multiple of 90: " + $rotation + ". '" + this$0.subsamplingImage.getKey() + '\'';
    }

    private static final String refreshTiles$lambda$5(int $continuousTransformType, String $caller, TileManager this$0) {
        String continuousTransformTypeName = ContinuousTransformType.Companion.name($continuousTransformType);
        return "TileManager. refreshTiles:" + $caller + ". interrupted, continuousTransformType is " + continuousTransformTypeName + ". '" + this$0.subsamplingImage.getKey() + '\'';
    }

    private static final String refreshTiles$lambda$7(String $caller, List $foregroundTiles, boolean $sampleSizeChanged, int $oldSampleSize, int $newSampleSize, TileManager this$0, float $scale) {
        StringBuilder stringBuilder = new StringBuilder();
        List list = $foregroundTiles;
        stringBuilder.append("TileManager. refreshTiles:").append($caller).append(". interrupted, foregroundTiles is null or size is 1. foregroundTilesSize=").append(list != null ? list.size() : 0).append(", sampleSizeChanged=").append($sampleSizeChanged).append(", sampleSize=").append($oldSampleSize).append(" -> ").append($newSampleSize).append(", imageSize=").append(IntSizeCompatKt.toShortString-grz_zgQ(this$0.imageInfo.getSize-wTLXMmk())).append(", contentSize=").append(IntSizeCompatKt.toShortString-grz_zgQ(this$0.contentSize)).append(", scale=").append(Core_utils_commonKt.format($scale, 4)).append(", preferredTileSize=").append(IntSizeCompatKt.toShortString-grz_zgQ(this$0.preferredTileSize)).append(", tileGridMap=").append(SubsamplingsKt.toIntroString(this$0.sortedTileGridMap)).append(". '").append(this$0.subsamplingImage.getKey()).append('\'');
        return stringBuilder.toString();
    }

    private static final String refreshTiles$lambda$8(String $caller, IntRectCompat $oldImageLoadRect, IntRectCompat $newImageLoadRect, TileManager this$0, IntRectCompat $contentVisibleRect) {
        return "TileManager. refreshTiles:" + $caller + ". interrupted, imageLoadRect is empty. imageLoadRect=" + IntRectCompatKt.toShortString($oldImageLoadRect) + " -> " + IntRectCompatKt.toShortString($newImageLoadRect) + ", imageSize=" + IntSizeCompatKt.toShortString-grz_zgQ(this$0.imageInfo.getSize-wTLXMmk()) + ", contentSize=" + IntSizeCompatKt.toShortString-grz_zgQ(this$0.contentSize) + ", preferredTileSize=" + IntSizeCompatKt.toShortString-grz_zgQ(this$0.preferredTileSize) + ", contentVisibleRect=" + IntRectCompatKt.toShortString($contentVisibleRect) + ", '" + this$0.subsamplingImage.getKey() + '\'';
    }

    private static final String refreshTiles$lambda$12(int $continuousTransformType, String $caller, Ref.IntRef $actualLoadCount, Ref.IntRef $expectLoadCount, Ref.IntRef $actualFreeCount, Ref.IntRef $expectFreeCount, int $oldSampleSize, int $newSampleSize, List $foregroundTiles, IntRectCompat $oldImageLoadRect, IntRectCompat $newImageLoadRect, float $scale, IntRectCompat $contentVisibleRect, TileManager this$0) {
        String continuousTransformTypeName = ContinuousTransformType.Companion.name($continuousTransformType);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("TileManager. refreshTiles:").append($caller).append(". loadCount=").append($actualLoadCount.element).append('/').append($expectLoadCount.element).append(", freeCount=").append($actualFreeCount.element).append('/').append($expectFreeCount.element).append(". sampleSize=").append($oldSampleSize).append(" -> ").append($newSampleSize).append(", foregroundTiles=").append($foregroundTiles.size()).append(", imageLoadRect=").append(IntRectCompatKt.toShortString($oldImageLoadRect)).append(" -> ").append(IntRectCompatKt.toShortString($newImageLoadRect)).append(". scale=").append($scale).append(", contentVisibleRect=");
        stringBuilder.append(IntRectCompatKt.toShortString($contentVisibleRect)).append(", contentSize=").append(IntSizeCompatKt.toShortString-grz_zgQ(this$0.contentSize)).append(", continuousTransformType=").append(continuousTransformTypeName).append(", imageInfo=").append(this$0.imageInfo.toShortString()).append(", '").append(this$0.subsamplingImage.getKey());
        return stringBuilder.toString();
    }

    private static final String clean$lambda$13(String $caller, TileManager this$0) {
        return "TileManager. cleanTiles:" + $caller + ". cancel updateTileSnapshotListJob. '" + this$0.subsamplingImage.getKey();
    }

    private static final String clean$lambda$15(String $caller, Ref.IntRef $freeCount, TileManager this$0) {
        return "TileManager. cleanTiles:" + $caller + ". freeCount=" + $freeCount.element + ". '" + this$0.subsamplingImage.getKey();
    }

    private static final String loadTile$lambda$16(Tile $tile, TileManager this$0) {
        return "TileManager. loadTile. skipped, loaded. " + $tile + ". '" + this$0.subsamplingImage.getKey() + '\'';
    }

    private static final String loadTile$lambda$17(Tile $tile, TileManager this$0) {
        return "TileManager. loadTile. skipped, loading. " + $tile + ". '" + this$0.subsamplingImage.getKey() + '\'';
    }

    private static final String freeTile$lambda$18(Tile $tile, TileManager this$0) {
        return "TileManager. freeTile. " + $tile + ". '" + this$0.subsamplingImage.getKey() + '\'';
    }

    private static final String updateTileSnapshotList$lambda$20(String $caller, TileManager this$0) {
        return "TileManager. updateTileSnapshotList:" + $caller + ". skipped, notifyTileSnapshotListJob is running. '" + this$0.subsamplingImage.getKey() + '\'';
    }

    private static final String updateTileSnapshotList$lambda$21(String $caller, TileManager this$0) {
        return "TileManager. updateTileSnapshotList:" + $caller + ". launched. '" + this$0.subsamplingImage.getKey() + '\'';
    }

    public /* synthetic */ TileManager(Logger logger, SubsamplingImage subsamplingImage, TileDecoder tileDecoder, TileImageConvertor tileImageConvertor, TileImageCacheHelper tileImageCacheHelper, ImageInfo imageInfo, long contentSize, long preferredTileSize, Function1 onTileChanged, Function1 onSampleSizeChanged, Function1 onImageLoadRectChanged, DefaultConstructorMarker $constructor_marker) {
        this(logger, subsamplingImage, tileDecoder, tileImageConvertor, tileImageCacheHelper, imageInfo, contentSize, preferredTileSize, (Function1<? super TileManager, Unit>)onTileChanged, (Function1<? super TileManager, Unit>)onSampleSizeChanged, (Function1<? super TileManager, Unit>)onImageLoadRectChanged);
    }

    public static final /* synthetic */ SubsamplingImage access$getSubsamplingImage$p(TileManager $this) {
        return $this.subsamplingImage;
    }

    public static final /* synthetic */ TileImageCacheHelper access$getTileImageCacheHelper$p(TileManager $this) {
        return $this.tileImageCacheHelper;
    }

    public static final /* synthetic */ TileImageConvertor access$getTileImageConvertor$p(TileManager $this) {
        return $this.tileImageConvertor;
    }

    public static final /* synthetic */ Logger access$getLogger$p(TileManager $this) {
        return $this.logger;
    }

    public static final /* synthetic */ void access$updateTileSnapshotList(TileManager $this, String caller) {
        $this.updateTileSnapshotList(caller);
    }

    public static final /* synthetic */ CoroutineDispatcher access$getDecodeDispatcher$p(TileManager $this) {
        return $this.decodeDispatcher;
    }

    public static final /* synthetic */ TileDecoder access$getTileDecoder$p(TileManager $this) {
        return $this.tileDecoder;
    }

    public static final /* synthetic */ ImageInfo access$getImageInfo$p(TileManager $this) {
        return $this.imageInfo;
    }

    public static final /* synthetic */ int access$getLastSampleSize$p(TileManager $this) {
        return $this.lastSampleSize;
    }

    public static final /* synthetic */ void access$setForegroundTiles$p(TileManager $this, List list) {
        $this.foregroundTiles = list;
    }

    public static final /* synthetic */ void access$setBackgroundTiles$p(TileManager $this, List list) {
        $this.backgroundTiles = list;
    }

    public static final /* synthetic */ void access$notifyTileChanged(TileManager $this) {
        $this.notifyTileChanged();
    }

    public static final /* synthetic */ boolean access$isBackground(TileManager $this, int lastSampleSize, int currentSampleSize, int eachSampleSize) {
        return $this.isBackground(lastSampleSize, currentSampleSize, eachSampleSize);
    }

    public static final /* synthetic */ int access$freeTiles(TileManager $this, List tiles, boolean skipNotify) {
        return $this.freeTiles(tiles, skipNotify);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/github/panpf/zoomimage/subsampling/internal/TileManager$Companion;", "", "<init>", "()V", "DefaultPausedContinuousTransformTypes", "", "zoomimage-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

