/*
 * Decompiled with CFR 0.152.
 */
package com.github.panpf.zoomimage.subsampling.internal;

import androidx.annotation.MainThread;
import com.github.panpf.zoomimage.subsampling.ImageInfo;
import com.github.panpf.zoomimage.subsampling.RegionDecoder;
import com.github.panpf.zoomimage.subsampling.SamplingTiles;
import com.github.panpf.zoomimage.subsampling.SubsamplingImage;
import com.github.panpf.zoomimage.subsampling.Tile;
import com.github.panpf.zoomimage.subsampling.internal.TileDecoder;
import com.github.panpf.zoomimage.util.Core_utils_commonKt;
import com.github.panpf.zoomimage.util.IntOffsetCompat;
import com.github.panpf.zoomimage.util.IntOffsetCompatKt;
import com.github.panpf.zoomimage.util.IntSizeCompat;
import com.github.panpf.zoomimage.util.IntSizeCompatKt;
import com.github.panpf.zoomimage.util.Logger;
import com.github.panpf.zoomimage.util.ScaleFactorCompatKt;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\\\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0007\u001a<\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0087@\u00a2\u0006\u0004\b\f\u0010\r\u001a%\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\u0013\u0010\u0014\u001a)\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\b2\b\b\u0002\u0010\u0019\u001a\u00020\u001aH\u0007\u00a2\u0006\u0004\b\u001b\u0010\u001c\u001a\u0010\u0010\u001d\u001a\u00020\u001e*\b\u0012\u0004\u0012\u00020\u001f0\n\u001a\u0015\u0010 \u001a\u00020\b2\u0006\u0010!\u001a\u00020\b\u00a2\u0006\u0004\b\"\u0010#\u001a\u001d\u0010$\u001a\u00020\u00162\u0006\u0010%\u001a\u00020\b2\u0006\u0010&\u001a\u00020\b\u00a2\u0006\u0004\b'\u0010(\u001a\u001d\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\b2\u0006\u0010,\u001a\u00020\b\u00a2\u0006\u0004\b-\u0010.\u001a\u001d\u0010/\u001a\u00020*2\u0006\u0010+\u001a\u00020\b2\u0006\u0010,\u001a\u00020\b\u00a2\u0006\u0004\b0\u0010.\u00a8\u00061"}, d2={"createTileDecoder", "Lkotlin/Result;", "Lcom/github/panpf/zoomimage/subsampling/internal/TileDecoder;", "logger", "Lcom/github/panpf/zoomimage/util/Logger;", "subsamplingImage", "Lcom/github/panpf/zoomimage/subsampling/SubsamplingImage;", "contentSize", "Lcom/github/panpf/zoomimage/util/IntSizeCompat;", "regionDecoders", "", "Lcom/github/panpf/zoomimage/subsampling/RegionDecoder$Factory;", "createTileDecoder-zxZl2uU", "(Lcom/github/panpf/zoomimage/util/Logger;Lcom/github/panpf/zoomimage/subsampling/SubsamplingImage;JLjava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "checkImageInfo", "", "imageInfo", "Lcom/github/panpf/zoomimage/subsampling/ImageInfo;", "factory", "checkImageInfo-ZYX0fMU", "(Lcom/github/panpf/zoomimage/subsampling/ImageInfo;Lcom/github/panpf/zoomimage/subsampling/RegionDecoder$Factory;J)V", "canUseSubsamplingByAspectRatio", "", "imageSize", "thumbnailSize", "maxDifference", "", "canUseSubsamplingByAspectRatio-kjLh3nM", "(JJF)Z", "toIntroString", "", "Lcom/github/panpf/zoomimage/subsampling/SamplingTiles;", "calculatePreferredTileSize", "containerSize", "calculatePreferredTileSize-grz_zgQ", "(J)J", "checkNewPreferredTileSize", "oldPreferredTileSize", "newPreferredTileSize", "checkNewPreferredTileSize-MEmoHmQ", "(JJ)Z", "calculateOriginToThumbnailScaleFactor", "Lcom/github/panpf/zoomimage/util/ScaleFactorCompat;", "originImageSize", "thumbnailImageSize", "calculateOriginToThumbnailScaleFactor-MEmoHmQ", "(JJ)J", "calculateThumbnailToOriginScaleFactor", "calculateThumbnailToOriginScaleFactor-MEmoHmQ", "zoomimage-core"})
@SourceDebugExtension(value={"SMAP\nsubsamplings.kt\nKotlin\n*S Kotlin\n*F\n+ 1 subsamplings.kt\ncom/github/panpf/zoomimage/subsampling/internal/SubsamplingsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,237:1\n1#2:238\n*E\n"})
public final class SubsamplingsKt {
    /*
     * Exception decompiling
     */
    @MainThread
    @Nullable
    public static final Object createTileDecoder-zxZl2uU(@NotNull Logger var0, @NotNull SubsamplingImage var1_1, long var2_2, @NotNull List<? extends RegionDecoder.Factory> var4_3, @NotNull Continuation<? super Result<TileDecoder>> $completion) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 9[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static final void checkImageInfo-ZYX0fMU(@NotNull ImageInfo imageInfo, @NotNull RegionDecoder.Factory factory, long contentSize) {
        Intrinsics.checkNotNullParameter((Object)imageInfo, (String)"imageInfo");
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        long imageSize = imageInfo.getSize-wTLXMmk();
        if (IntSizeCompatKt.isEmpty-grz_zgQ(imageSize)) {
            throw new Exception("image size invalid: " + imageInfo.getWidth() + 'x' + imageInfo.getHeight());
        }
        if (IntSizeCompatKt.isEmpty-grz_zgQ(contentSize)) {
            throw new Exception("content size invalid: " + IntSizeCompat.getWidth-impl(contentSize) + 'x' + IntSizeCompat.getHeight-impl(contentSize));
        }
        if (IntSizeCompat.getWidth-impl(contentSize) >= IntSizeCompat.getWidth-impl(imageSize) || IntSizeCompat.getHeight-impl(contentSize) >= IntSizeCompat.getHeight-impl(imageSize)) {
            throw new Exception("the thumbnail size is greater than or equal to the original image. contentSize=" + IntSizeCompatKt.toShortString-grz_zgQ(contentSize) + ", imageSize=" + IntSizeCompatKt.toShortString-grz_zgQ(imageSize));
        }
        if (!Core_utils_commonKt.isThumbnailWithSize-kjLh3nM(imageSize, contentSize, 2.0f)) {
            throw new Exception("The aspect ratio of thumbnail and original image is different. contentSize=" + IntSizeCompatKt.toShortString-grz_zgQ(contentSize) + ", imageSize=" + IntSizeCompatKt.toShortString-grz_zgQ(imageSize));
        }
        String it = imageInfo.getMimeType();
        boolean bl = false;
        Boolean supportRegion = factory.checkSupport(it);
        if (Intrinsics.areEqual((Object)supportRegion, (Object)false)) {
            throw new Exception("Image type not support subsampling. mimeType=" + imageInfo.getMimeType());
        }
    }

    @Deprecated(message="Use isThumbnailWithSize instead")
    public static final boolean canUseSubsamplingByAspectRatio-kjLh3nM(long imageSize, long thumbnailSize, float maxDifference) {
        if (IntSizeCompatKt.isEmpty-grz_zgQ(imageSize) || IntSizeCompatKt.isEmpty-grz_zgQ(thumbnailSize)) {
            return false;
        }
        if (IntSizeCompat.getWidth-impl(imageSize) <= IntSizeCompat.getWidth-impl(thumbnailSize) || IntSizeCompat.getHeight-impl(imageSize) <= IntSizeCompat.getHeight-impl(thumbnailSize)) {
            return false;
        }
        return Core_utils_commonKt.isThumbnailWithSize-kjLh3nM(imageSize, thumbnailSize, 2.0f);
    }

    public static /* synthetic */ boolean canUseSubsamplingByAspectRatio-kjLh3nM$default(long l, long l2, float f, int n, Object object) {
        if ((n & 4) != 0) {
            f = 1.0f;
        }
        return SubsamplingsKt.canUseSubsamplingByAspectRatio-kjLh3nM(l, l2, f);
    }

    @NotNull
    public static final String toIntroString(@NotNull List<SamplingTiles> $this$toIntroString) {
        Intrinsics.checkNotNullParameter($this$toIntroString, (String)"<this>");
        return CollectionsKt.joinToString$default((Iterable)$this$toIntroString, (CharSequence)",", (CharSequence)"[", (CharSequence)"]", (int)0, null, SubsamplingsKt::toIntroString$lambda$5, (int)24, null);
    }

    public static final long calculatePreferredTileSize-grz_zgQ(long containerSize) {
        return IntSizeCompat.div-0Y-eDJY(containerSize, 2);
    }

    public static final boolean checkNewPreferredTileSize-MEmoHmQ(long oldPreferredTileSize, long newPreferredTileSize) {
        if (IntSizeCompatKt.isEmpty-grz_zgQ(newPreferredTileSize)) {
            return false;
        }
        if (IntSizeCompatKt.isEmpty-grz_zgQ(oldPreferredTileSize)) {
            return true;
        }
        int widthDifferent = Math.abs(IntSizeCompat.getWidth-impl(newPreferredTileSize) - IntSizeCompat.getWidth-impl(oldPreferredTileSize));
        float widthTargetMultiple = IntSizeCompat.getWidth-impl(newPreferredTileSize) > IntSizeCompat.getWidth-impl(oldPreferredTileSize) ? 1.0f : 0.5f;
        float widthTarget = (float)IntSizeCompat.getWidth-impl(oldPreferredTileSize) * widthTargetMultiple;
        if ((float)widthDifferent >= widthTarget) {
            return true;
        }
        int heightDifferent = Math.abs(IntSizeCompat.getHeight-impl(newPreferredTileSize) - IntSizeCompat.getHeight-impl(oldPreferredTileSize));
        float heightTargetMultiple = IntSizeCompat.getHeight-impl(newPreferredTileSize) > IntSizeCompat.getHeight-impl(oldPreferredTileSize) ? 1.0f : 0.5f;
        float heightTarget = (float)IntSizeCompat.getHeight-impl(oldPreferredTileSize) * heightTargetMultiple;
        return (float)heightDifferent >= heightTarget;
    }

    public static final long calculateOriginToThumbnailScaleFactor-MEmoHmQ(long originImageSize, long thumbnailImageSize) {
        float widthScale = (float)IntSizeCompat.getWidth-impl(thumbnailImageSize) / (float)IntSizeCompat.getWidth-impl(originImageSize);
        float heightScale = (float)IntSizeCompat.getHeight-impl(thumbnailImageSize) / (float)IntSizeCompat.getHeight-impl(originImageSize);
        return ScaleFactorCompatKt.ScaleFactorCompat(widthScale, heightScale);
    }

    public static final long calculateThumbnailToOriginScaleFactor-MEmoHmQ(long originImageSize, long thumbnailImageSize) {
        float widthScale = (float)IntSizeCompat.getWidth-impl(originImageSize) / (float)IntSizeCompat.getWidth-impl(thumbnailImageSize);
        float heightScale = (float)IntSizeCompat.getHeight-impl(originImageSize) / (float)IntSizeCompat.getHeight-impl(thumbnailImageSize);
        return ScaleFactorCompatKt.ScaleFactorCompat(widthScale, heightScale);
    }

    private static final CharSequence toIntroString$lambda$5(SamplingTiles it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        long it2 = ((Tile)CollectionsKt.last(it.getTiles())).getCoordinate-QQ-czBQ();
        boolean bl = false;
        long gridSize = IntOffsetCompatKt.IntOffsetCompat(IntOffsetCompat.getX-impl(it2) + 1, IntOffsetCompat.getY-impl(it2) + 1);
        return "" + it.getSampleSize() + ':' + it.getTiles().size() + ':' + IntOffsetCompatKt.toShortString-1tlllzA(gridSize);
    }
}

