/*
 * Decompiled with CFR 0.152.
 */
package com.github.panpf.zoomimage.subsampling.internal;

import com.github.panpf.zoomimage.subsampling.ImageInfo;
import com.github.panpf.zoomimage.subsampling.ImageSource;
import com.github.panpf.zoomimage.subsampling.RegionDecoder;
import com.github.panpf.zoomimage.subsampling.SubsamplingImage;
import com.github.panpf.zoomimage.util.Core_utils_commonKt;
import com.github.panpf.zoomimage.util.Core_utils_nonAndroidKt;
import com.github.panpf.zoomimage.util.IntRectCompat;
import com.github.panpf.zoomimage.util.IntRectCompatKt;
import java.io.Closeable;
import java.util.Locale;
import kotlin.ExceptionsKt;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import okio.BufferedSource;
import okio.Okio;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.skia.Bitmap;
import org.jetbrains.skia.Canvas;
import org.jetbrains.skia.Codec;
import org.jetbrains.skia.Data;
import org.jetbrains.skia.EncodedImageFormat;
import org.jetbrains.skia.Image;
import org.jetbrains.skia.Rect;
import org.jetbrains.skia.impl.Managed;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u00012B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010!\u001a\u00020\u0007H\u0002J\b\u0010\"\u001a\u00020#H\u0016J\u0018\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u001d2\u0006\u0010'\u001a\u00020(H\u0016J\b\u0010)\u001a\u00020#H\u0016J\b\u0010*\u001a\u00020\u0001H\u0016J\u0013\u0010+\u001a\u00020,2\b\u0010-\u001a\u0004\u0018\u00010.H\u0096\u0002J\b\u0010/\u001a\u00020(H\u0016J\b\u00100\u001a\u000201H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001b\u0010\b\u001a\u00020\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0010\u0010\u0011R\u001b\u0010\u0014\u001a\u00020\u00158BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0013\u001a\u0004\b\u0016\u0010\u0017R\u001b\u0010\u0006\u001a\u00020\u00078VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\u0013\u001a\u0004\b\u0019\u0010\u001aR\u001b\u0010\u001c\u001a\u00020\u001d8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b \u0010\u0013\u001a\u0004\b\u001e\u0010\u001f\u00a8\u00063"}, d2={"Lcom/github/panpf/zoomimage/subsampling/internal/SkiaRegionDecoder;", "Lcom/github/panpf/zoomimage/subsampling/RegionDecoder;", "subsamplingImage", "Lcom/github/panpf/zoomimage/subsampling/SubsamplingImage;", "imageSource", "Lcom/github/panpf/zoomimage/subsampling/ImageSource;", "imageInfo", "Lcom/github/panpf/zoomimage/subsampling/ImageInfo;", "bytes", "", "<init>", "(Lcom/github/panpf/zoomimage/subsampling/SubsamplingImage;Lcom/github/panpf/zoomimage/subsampling/ImageSource;Lcom/github/panpf/zoomimage/subsampling/ImageInfo;[B)V", "getSubsamplingImage", "()Lcom/github/panpf/zoomimage/subsampling/SubsamplingImage;", "getImageSource", "()Lcom/github/panpf/zoomimage/subsampling/ImageSource;", "getBytes", "()[B", "bytes$delegate", "Lkotlin/Lazy;", "image", "Lorg/jetbrains/skia/Image;", "getImage", "()Lorg/jetbrains/skia/Image;", "image$delegate", "getImageInfo", "()Lcom/github/panpf/zoomimage/subsampling/ImageInfo;", "imageInfo$delegate", "regionRectBounds", "Lcom/github/panpf/zoomimage/util/IntRectCompat;", "getRegionRectBounds", "()Lcom/github/panpf/zoomimage/util/IntRectCompat;", "regionRectBounds$delegate", "decodeImageInfo", "prepare", "", "decodeRegion", "Lorg/jetbrains/skia/Bitmap;", "region", "sampleSize", "", "close", "copy", "equals", "", "other", "", "hashCode", "toString", "", "Factory", "zoomimage-core"})
@SourceDebugExtension(value={"SMAP\nSkiaRegionDecoder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SkiaRegionDecoder.kt\ncom/github/panpf/zoomimage/subsampling/internal/SkiaRegionDecoder\n+ 2 Managed.kt\norg/jetbrains/skia/impl/ManagedKt\n+ 3 Okio.kt\nokio/Okio__OkioKt\n*L\n1#1,178:1\n22#2,5:179\n72#3:184\n58#3,22:185\n*S KotlinDebug\n*F\n+ 1 SkiaRegionDecoder.kt\ncom/github/panpf/zoomimage/subsampling/internal/SkiaRegionDecoder\n*L\n68#1:179,5\n54#1:184\n54#1:185,22\n*E\n"})
public final class SkiaRegionDecoder
implements RegionDecoder {
    @NotNull
    private final SubsamplingImage subsamplingImage;
    @NotNull
    private final ImageSource imageSource;
    @NotNull
    private final Lazy bytes$delegate;
    @NotNull
    private final Lazy image$delegate;
    @NotNull
    private final Lazy imageInfo$delegate;
    @NotNull
    private final Lazy regionRectBounds$delegate;

    public SkiaRegionDecoder(@NotNull SubsamplingImage subsamplingImage, @NotNull ImageSource imageSource, @Nullable ImageInfo imageInfo, @Nullable byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)subsamplingImage, (String)"subsamplingImage");
        Intrinsics.checkNotNullParameter((Object)imageSource, (String)"imageSource");
        this.subsamplingImage = subsamplingImage;
        this.imageSource = imageSource;
        this.bytes$delegate = LazyKt.lazy(() -> SkiaRegionDecoder.bytes_delegate$lambda$1(bytes, this));
        this.image$delegate = LazyKt.lazy(() -> SkiaRegionDecoder.image_delegate$lambda$2(this));
        this.imageInfo$delegate = LazyKt.lazy(() -> SkiaRegionDecoder.imageInfo_delegate$lambda$3(imageInfo, this));
        this.regionRectBounds$delegate = LazyKt.lazy(() -> SkiaRegionDecoder.regionRectBounds_delegate$lambda$4(this));
    }

    public /* synthetic */ SkiaRegionDecoder(SubsamplingImage subsamplingImage, ImageSource imageSource, ImageInfo imageInfo, byte[] byArray, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            imageInfo = subsamplingImage.getImageInfo();
        }
        if ((n & 8) != 0) {
            byArray = null;
        }
        this(subsamplingImage, imageSource, imageInfo, byArray);
    }

    @Override
    @NotNull
    public SubsamplingImage getSubsamplingImage() {
        return this.subsamplingImage;
    }

    @NotNull
    public final ImageSource getImageSource() {
        return this.imageSource;
    }

    private final byte[] getBytes() {
        Lazy lazy = this.bytes$delegate;
        return (byte[])lazy.getValue();
    }

    private final Image getImage() {
        Lazy lazy = this.image$delegate;
        return (Image)lazy.getValue();
    }

    @Override
    @NotNull
    public ImageInfo getImageInfo() {
        Lazy lazy = this.imageInfo$delegate;
        return (ImageInfo)lazy.getValue();
    }

    private final IntRectCompat getRegionRectBounds() {
        Lazy lazy = this.regionRectBounds$delegate;
        return (IntRectCompat)lazy.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ImageInfo decodeImageInfo() {
        EncodedImageFormat encodedImageFormat;
        Data data = Data.Companion.makeFromBytes$default((Data.Companion)Data.Companion, (byte[])this.getBytes(), (int)0, (int)0, (int)6, null);
        boolean $i$f$use = false;
        try (Managed $this$use$iv = (Managed)Codec.Companion.makeFromData(data);){
            Codec it = (Codec)$this$use$iv;
            boolean bl = false;
            encodedImageFormat = it.getEncodedImageFormat();
        }
        EncodedImageFormat encodedImageFormat2 = encodedImageFormat;
        StringBuilder stringBuilder = new StringBuilder().append("image/");
        String string = encodedImageFormat2.name().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        String mimeType = stringBuilder.append(string).toString();
        return new ImageInfo(this.getImage().getWidth(), this.getImage().getHeight(), mimeType);
    }

    @Override
    public void prepare() {
    }

    @Override
    @NotNull
    public Bitmap decodeRegion(@NotNull IntRectCompat region, int sampleSize) {
        Bitmap bitmap;
        Intrinsics.checkNotNullParameter((Object)region, (String)"region");
        IntRectCompat finalRegionRect = IntRectCompatKt.limitTo(region, this.getRegionRectBounds());
        double widthValue = (double)finalRegionRect.getWidth() / (double)sampleSize;
        double heightValue = (double)finalRegionRect.getHeight() / (double)sampleSize;
        int bitmapWidth = (int)Math.ceil(widthValue);
        int bitmapHeight = (int)Math.ceil(heightValue);
        Bitmap $this$decodeRegion_u24lambda_u246 = bitmap = new Bitmap();
        boolean bl = false;
        Bitmap.allocN32Pixels$default((Bitmap)$this$decodeRegion_u24lambda_u246, (int)bitmapWidth, (int)bitmapHeight, (boolean)false, (int)4, null);
        Bitmap bitmap2 = bitmap;
        Canvas canvas = new Canvas(bitmap2, null, 2, null);
        canvas.drawImageRect(this.getImage(), Core_utils_nonAndroidKt.toSkiaRect(finalRegionRect), Rect.Companion.makeWH((float)bitmapWidth, (float)bitmapHeight));
        return bitmap2;
    }

    @Override
    public void close() {
        try {
            this.getImage().close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    @NotNull
    public RegionDecoder copy() {
        return new SkiaRegionDecoder(this.getSubsamplingImage(), this.imageSource, this.getImageInfo(), this.getBytes());
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        SkiaRegionDecoder cfr_ignored_0 = (SkiaRegionDecoder)other;
        if (!Intrinsics.areEqual((Object)this.getSubsamplingImage(), (Object)((SkiaRegionDecoder)other).getSubsamplingImage())) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.imageSource, (Object)((SkiaRegionDecoder)other).imageSource);
    }

    @Override
    public int hashCode() {
        int result = this.getSubsamplingImage().hashCode();
        result = 31 * result + this.imageSource.hashCode();
        return result;
    }

    @Override
    @NotNull
    public String toString() {
        return "SkiaRegionDecoder(subsamplingImage=" + this.getSubsamplingImage() + ", imageSource=" + this.imageSource + ')';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final byte[] bytes_delegate$lambda$1(byte[] $bytes, SkiaRegionDecoder this$0) {
        byte[] byArray2;
        Throwable thrown$iv;
        byte[] byArray;
        block15: {
            byArray = $bytes;
            if ($bytes != null) return byArray;
            Closeable $this$use$iv = (Closeable)Okio.buffer((Source)this$0.imageSource.openSource());
            boolean $i$f$use = false;
            thrown$iv = null;
            try {
                BufferedSource it = (BufferedSource)$this$use$iv;
                boolean bl = false;
                byArray2 = it.readByteArray();
            }
            catch (Throwable t$iv) {
                try {
                    thrown$iv = t$iv;
                    byArray2 = null;
                    break block15;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    block16: {
                        try {
                            Closeable closeable = $this$use$iv;
                            if (closeable != null) {
                                closeable.close();
                            }
                        }
                        catch (Throwable t$iv2) {
                            if (thrown$iv == null) {
                                thrown$iv = t$iv2;
                                break block16;
                            }
                            ExceptionsKt.addSuppressed((Throwable)thrown$iv, (Throwable)t$iv2);
                        }
                    }
                }
            }
            try {
                Closeable closeable = $this$use$iv;
                if (closeable != null) {
                    closeable.close();
                }
            }
            catch (Throwable t$iv) {
                thrown$iv = t$iv;
            }
        }
        byte[] result$iv = byArray2;
        Throwable throwable = thrown$iv;
        if (throwable != null) {
            throw throwable;
        }
        byArray = result$iv;
        return byArray;
    }

    private static final Image image_delegate$lambda$2(SkiaRegionDecoder this$0) {
        return Image.Companion.makeFromEncoded(this$0.getBytes());
    }

    private static final ImageInfo imageInfo_delegate$lambda$3(ImageInfo $imageInfo, SkiaRegionDecoder this$0) {
        ImageInfo imageInfo = $imageInfo;
        if (imageInfo == null) {
            imageInfo = this$0.decodeImageInfo();
        }
        return imageInfo;
    }

    private static final IntRectCompat regionRectBounds_delegate$lambda$4(SkiaRegionDecoder this$0) {
        ImageInfo imageInfo = this$0.getImageInfo();
        return new IntRectCompat(0, 0, imageInfo.getWidth(), imageInfo.getHeight());
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0096@\u00a2\u0006\u0002\u0010\bJ\u0017\u0010\t\u001a\u0004\u0018\u00010\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010\fJ\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0013\u0010\u0011\u001a\u00020\u00052\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0096\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u000bH\u0016\u00a8\u0006\u0017"}, d2={"Lcom/github/panpf/zoomimage/subsampling/internal/SkiaRegionDecoder$Factory;", "Lcom/github/panpf/zoomimage/subsampling/RegionDecoder$Factory;", "<init>", "()V", "accept", "", "subsamplingImage", "Lcom/github/panpf/zoomimage/subsampling/SubsamplingImage;", "(Lcom/github/panpf/zoomimage/subsampling/SubsamplingImage;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "checkSupport", "mimeType", "", "(Ljava/lang/String;)Ljava/lang/Boolean;", "create", "Lcom/github/panpf/zoomimage/subsampling/internal/SkiaRegionDecoder;", "imageSource", "Lcom/github/panpf/zoomimage/subsampling/ImageSource;", "equals", "other", "", "hashCode", "", "toString", "zoomimage-core"})
    public static final class Factory
    implements RegionDecoder.Factory {
        @Override
        @Nullable
        public Object accept(@NotNull SubsamplingImage subsamplingImage, @NotNull Continuation<? super Boolean> $completion) {
            return Boxing.boxBoolean((boolean)true);
        }

        /*
         * Unable to fully structure code
         */
        @Override
        @Nullable
        public Boolean checkSupport(@NotNull String mimeType) {
            block20: {
                block19: {
                    Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
                    if (!StringsKt.startsWith$default((String)mimeType, (String)"image/", (boolean)false, (int)2, null)) {
                        return false;
                    }
                    var2_2 = mimeType;
                    switch (var2_2.hashCode()) {
                        case -879258763: {
                            if (!var2_2.equals("image/png")) {
                                ** break;
                            }
                            ** GOTO lbl39
                        }
                        case -1487656890: {
                            if (!var2_2.equals("image/avif")) {
                                ** break;
                            }
                            break block19;
                        }
                        case -1487394660: {
                            if (!var2_2.equals("image/jpeg")) {
                                ** break;
                            }
                            ** GOTO lbl39
                        }
                        case -879272239: {
                            if (!var2_2.equals("image/bmp")) {
                                ** break;
                            }
                            ** GOTO lbl39
                        }
                        case -879267568: {
                            if (!var2_2.equals("image/gif")) {
                                ** break;
                            }
                            ** GOTO lbl39
                        }
                        case -227171396: {
                            if (var2_2.equals("image/svg+xml")) break;
                            ** break;
                        }
                        case -1487464690: {
                            if (!var2_2.equals("image/heif")) {
                                ** break;
                            }
                            break block19;
                        }
                        case -1487464693: {
                            if (!var2_2.equals("image/heic")) {
                                ** break;
                            }
                            break block19;
                        }
                        case -1487018032: {
                            if (!var2_2.equals("image/webp")) ** break;
lbl39:
                            // 5 sources

                            v0 = true;
                            break block20;
                        }
                    }
                    v0 = false;
                    break block20;
                }
                v0 = Core_utils_commonKt.compareVersions(skikoVersionName = "0.9.4", "0.9.4") <= 0 ? Boolean.valueOf(false) : null;
                break block20;
lbl46:
                // 10 sources

                v0 = null;
            }
            return v0;
        }

        @Override
        @NotNull
        public SkiaRegionDecoder create(@NotNull SubsamplingImage subsamplingImage, @NotNull ImageSource imageSource) {
            Intrinsics.checkNotNullParameter((Object)subsamplingImage, (String)"subsamplingImage");
            Intrinsics.checkNotNullParameter((Object)imageSource, (String)"imageSource");
            return new SkiaRegionDecoder(subsamplingImage, imageSource, null, null, 12, null);
        }

        @Override
        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            return other != null && this.getClass() == other.getClass();
        }

        @Override
        public int hashCode() {
            return Reflection.getOrCreateKotlinClass(this.getClass()).hashCode();
        }

        @Override
        @NotNull
        public String toString() {
            return "SkiaRegionDecoder";
        }
    }
}

