/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.transport.tcp;

import java.net.ServerSocket;
import java.util.Random;
import org.freedesktop.dbus.connections.BusAddress;
import org.freedesktop.dbus.connections.config.TransportConfig;
import org.freedesktop.dbus.connections.transports.AbstractTransport;
import org.freedesktop.dbus.exceptions.TransportConfigurationException;
import org.freedesktop.dbus.spi.transport.ITransportProvider;
import org.freedesktop.dbus.transport.tcp.TcpBusAddress;
import org.freedesktop.dbus.transport.tcp.TcpTransport;
import org.freedesktop.dbus.utils.Util;
import org.slf4j.LoggerFactory;

public class TcpTransportProvider
implements ITransportProvider {
    public static final int TCP_CONNECT_TIMEOUT = 100000;
    private static final Random RANDOM = new Random();

    public String getTransportName() {
        return "dbus-java-transport-tcp";
    }

    public AbstractTransport createTransport(BusAddress _address, TransportConfig _config) throws TransportConfigurationException {
        TcpBusAddress tba;
        TcpBusAddress address = null;
        address = _address instanceof TcpBusAddress ? (tba = (TcpBusAddress)_address) : new TcpBusAddress(_address);
        int timeout = _config.getTimeout();
        return new TcpTransport(address, timeout, _config);
    }

    public String getSupportedBusType() {
        return "TCP";
    }

    public String createDynamicSessionAddress(boolean _listeningSocket) {
        int port;
        Object address = "tcp:host=localhost";
        try (ServerSocket s = new ServerSocket();){
            s.bind(null);
            port = s.getLocalPort();
        }
        catch (Exception _ex) {
            port = 32768 + Math.abs(RANDOM.nextInt(0, Integer.MAX_VALUE)) % 28232;
        }
        address = (String)address + ",port=" + port;
        if (_listeningSocket) {
            address = (String)address + ",listen=true";
        }
        address = (String)address + ",guid=" + Util.genGUID();
        LoggerFactory.getLogger(this.getClass()).debug("Created Session address: {}", address);
        return address;
    }
}

