/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.util.soundfile;

import com.jsyn.data.FloatSample;
import com.jsyn.data.SampleMarker;
import com.jsyn.util.SampleLoader;
import com.jsyn.util.soundfile.AudioFileParser;
import com.jsyn.util.soundfile.ChunkHandler;
import com.jsyn.util.soundfile.IFFParser;
import java.io.EOFException;
import java.io.IOException;

class WAVEFileParser
extends AudioFileParser
implements ChunkHandler {
    static final short WAVE_FORMAT_PCM = 1;
    static final short WAVE_FORMAT_IEEE_FLOAT = 3;
    static final short WAVE_FORMAT_EXTENSIBLE = -2;
    static final byte[] KSDATAFORMAT_SUBTYPE_IEEE_FLOAT = new byte[]{3, 0, 0, 0, 0, 0, 16, 0, -128, 0, 0, -86, 0, 56, -101, 113};
    static final byte[] KSDATAFORMAT_SUBTYPE_PCM = new byte[]{1, 0, 0, 0, 0, 0, 16, 0, -128, 0, 0, -86, 0, 56, -101, 113};
    static final int WAVE_ID = 1463899717;
    static final int FMT_ID = 1718449184;
    static final int DATA_ID = 1684108385;
    static final int CUE_ID = 1668637984;
    static final int FACT_ID = 1717658484;
    static final int SMPL_ID = 1936552044;
    static final int LTXT_ID = 1819572340;
    static final int LABL_ID = 1818321516;
    int samplesPerBlock = 0;
    int blockAlign = 0;
    private int numFactSamples = 0;
    private short format;

    WAVEFileParser() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    FloatSample finish() throws IOException {
        if (this.byteData == null) {
            throw new IOException("No data found in audio sample.");
        }
        float[] floatData = new float[this.numFrames * this.samplesPerFrame];
        if (this.bitsPerSample == 16) {
            SampleLoader.decodeLittleI16ToF32(this.byteData, 0, this.byteData.length, floatData, 0);
            return this.makeSample(floatData);
        } else if (this.bitsPerSample == 24) {
            SampleLoader.decodeLittleI24ToF32(this.byteData, 0, this.byteData.length, floatData, 0);
            return this.makeSample(floatData);
        } else {
            if (this.bitsPerSample != 32) throw new IOException("WAV: Unsupported bitsPerSample = " + this.bitsPerSample);
            if (this.format == 3) {
                SampleLoader.decodeLittleF32ToF32(this.byteData, 0, this.byteData.length, floatData, 0);
                return this.makeSample(floatData);
            } else {
                if (this.format != 1) throw new IOException("WAV: Unsupported format = " + this.format);
                SampleLoader.decodeLittleI32ToF32(this.byteData, 0, this.byteData.length, floatData, 0);
            }
        }
        return this.makeSample(floatData);
    }

    void parseCueChunk(IFFParser parser, int ckSize) throws IOException {
        int numCuePoints = parser.readIntLittle();
        if (ckSize - 4 != 24 * numCuePoints) {
            throw new EOFException("Cue chunk too short!");
        }
        for (int i = 0; i < numCuePoints; ++i) {
            int dwName = parser.readIntLittle();
            int position = parser.readIntLittle();
            parser.skip(12L);
            int sampleOffset = parser.readIntLittle();
            SampleMarker cuePoint = this.findOrCreateCuePoint(dwName);
            cuePoint.position = position;
        }
    }

    void parseLablChunk(IFFParser parser, int ckSize) throws IOException {
        int dwName = parser.readIntLittle();
        int textLength = ckSize - 4 - 1;
        String text = this.parseString(parser, textLength);
        SampleMarker cuePoint = this.findOrCreateCuePoint(dwName);
        cuePoint.name = text;
    }

    void parseLtxtChunk(IFFParser parser, int ckSize) throws IOException {
        int dwName = parser.readIntLittle();
        int dwSampleLength = parser.readIntLittle();
        parser.skip(12L);
        int textLength = ckSize - 24 - 1;
        if (textLength > 0) {
            String text = this.parseString(parser, textLength);
            SampleMarker cuePoint = this.findOrCreateCuePoint(dwName);
            cuePoint.comment = text;
        }
    }

    void parseFmtChunk(IFFParser parser, int ckSize) throws IOException {
        this.format = parser.readShortLittle();
        this.samplesPerFrame = parser.readShortLittle();
        this.frameRate = parser.readIntLittle();
        parser.readIntLittle();
        this.blockAlign = parser.readShortLittle();
        this.bitsPerSample = parser.readShortLittle();
        this.bytesPerFrame = this.blockAlign;
        this.bytesPerSample = this.bytesPerFrame / this.samplesPerFrame;
        this.samplesPerBlock = 8 * this.blockAlign / this.bitsPerSample;
        if (this.format == -2) {
            short extraSize = parser.readShortLittle();
            short validBitsPerSample = parser.readShortLittle();
            int channelMask = parser.readIntLittle();
            byte[] guid = new byte[16];
            parser.read(guid);
            if (this.matchBytes(guid, KSDATAFORMAT_SUBTYPE_IEEE_FLOAT)) {
                this.format = (short)3;
            } else if (this.matchBytes(guid, KSDATAFORMAT_SUBTYPE_PCM)) {
                this.format = 1;
            }
        }
        if (this.format != 1 && this.format != 3) {
            throw new IOException("Only WAVE_FORMAT_PCM and WAVE_FORMAT_IEEE_FLOAT supported. format = " + this.format);
        }
        if (this.bitsPerSample != 16 && this.bitsPerSample != 24 && this.bitsPerSample != 32) {
            throw new IOException("Only 16 and 24 bit PCM or 32-bit float WAV files supported. width = " + this.bitsPerSample);
        }
    }

    private boolean matchBytes(byte[] bar1, byte[] bar2) {
        if (bar1.length != bar2.length) {
            return false;
        }
        for (int i = 0; i < bar1.length; ++i) {
            if (bar1[i] == bar2[i]) continue;
            return false;
        }
        return true;
    }

    private int convertByteToFrame(int byteOffset) throws IOException {
        if (this.blockAlign == 0) {
            throw new IOException("WAV file has bytesPerBlock = zero");
        }
        if (this.samplesPerFrame == 0) {
            throw new IOException("WAV file has samplesPerFrame = zero");
        }
        return this.samplesPerBlock * byteOffset / (this.samplesPerFrame * this.blockAlign);
    }

    private int calculateNumFrames(int numBytes) throws IOException {
        int nFrames = this.numFactSamples > 0 ? this.numFactSamples : this.convertByteToFrame(numBytes);
        return nFrames;
    }

    private double readFraction(IFFParser parser) throws IOException {
        long maxFraction = 0xFFFFFFFFL;
        long fraction = (long)parser.readIntLittle() & maxFraction;
        return (double)fraction / (double)maxFraction;
    }

    void parseSmplChunk(IFFParser parser, int ckSize) throws IOException {
        parser.readIntLittle();
        parser.readIntLittle();
        parser.readIntLittle();
        int unityNote = parser.readIntLittle();
        double pitchFraction = this.readFraction(parser);
        this.originalPitch = (double)unityNote + pitchFraction;
        parser.readIntLittle();
        parser.readIntLittle();
        int numLoops = parser.readIntLittle();
        parser.readIntLittle();
        int lastCueID = Integer.MAX_VALUE;
        for (int i = 0; i < numLoops; ++i) {
            int cueID = parser.readIntLittle();
            parser.readIntLittle();
            int loopStartPosition = parser.readIntLittle();
            int loopEndPosition = parser.readIntLittle() + 1;
            double endFraction = this.readFraction(parser);
            parser.readIntLittle();
            if (cueID >= lastCueID) continue;
            this.sustainBegin = loopStartPosition;
            this.sustainEnd = loopEndPosition;
        }
    }

    void parseFactChunk(IFFParser parser, int ckSize) throws IOException {
        this.numFactSamples = parser.readIntLittle();
    }

    void parseDataChunk(IFFParser parser, int ckSize) throws IOException {
        long numRead;
        this.dataPosition = parser.getOffset();
        if (this.ifLoadData) {
            this.byteData = new byte[ckSize];
            numRead = parser.read(this.byteData);
        } else {
            numRead = parser.skip(ckSize);
        }
        if (numRead != (long)ckSize) {
            throw new EOFException("WAV data chunk too short! Read " + numRead + " instead of " + ckSize);
        }
        this.numFrames = this.calculateNumFrames(ckSize);
    }

    @Override
    public void handleForm(IFFParser parser, int ckID, int ckSize, int type) throws IOException {
        if (ckID == 1380533830 && type != 1463899717) {
            throw new IOException("Bad WAV form type = " + IFFParser.IDToString(type));
        }
    }

    @Override
    public void handleChunk(IFFParser parser, int ckID, int ckSize) throws IOException {
        switch (ckID) {
            case 1718449184: {
                this.parseFmtChunk(parser, ckSize);
                break;
            }
            case 1684108385: {
                this.parseDataChunk(parser, ckSize);
                break;
            }
            case 1668637984: {
                this.parseCueChunk(parser, ckSize);
                break;
            }
            case 1717658484: {
                this.parseFactChunk(parser, ckSize);
                break;
            }
            case 1936552044: {
                this.parseSmplChunk(parser, ckSize);
                break;
            }
            case 1818321516: {
                this.parseLablChunk(parser, ckSize);
                break;
            }
            case 1819572340: {
                this.parseLtxtChunk(parser, ckSize);
                break;
            }
        }
    }

    boolean isLittleEndian() {
        return true;
    }
}

