/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.util.soundfile;

import com.jsyn.data.FloatSample;
import com.jsyn.data.SampleMarker;
import com.jsyn.util.soundfile.ChunkHandler;
import com.jsyn.util.soundfile.IFFParser;
import java.io.IOException;
import java.util.HashMap;

abstract class AudioFileParser
implements ChunkHandler {
    IFFParser parser;
    protected byte[] byteData;
    boolean ifLoadData = true;
    long dataPosition;
    protected int bitsPerSample;
    protected int bytesPerFrame;
    protected int bytesPerSample;
    protected HashMap<Integer, SampleMarker> cueMap = new HashMap();
    protected short samplesPerFrame;
    protected double frameRate;
    protected int numFrames;
    protected double originalPitch = 60.0;
    protected int sustainBegin = -1;
    protected int sustainEnd = -1;

    public long getDataPosition() {
        return this.dataPosition;
    }

    public synchronized long getNumBytesRead() {
        IFFParser p = this.parser;
        if (p != null) {
            return p.getOffset();
        }
        return 0L;
    }

    public synchronized long getFileSize() {
        IFFParser p = this.parser;
        if (p != null) {
            return p.getFileSize();
        }
        return 0L;
    }

    protected SampleMarker findOrCreateCuePoint(int uniqueID) {
        SampleMarker cuePoint = this.cueMap.get(uniqueID);
        if (cuePoint == null) {
            cuePoint = new SampleMarker();
            this.cueMap.put(uniqueID, cuePoint);
        }
        return cuePoint;
    }

    public FloatSample load(IFFParser parser) throws IOException {
        this.parser = parser;
        parser.parseAfterHead(this);
        return this.finish();
    }

    abstract FloatSample finish() throws IOException;

    FloatSample makeSample(float[] floatData) throws IOException {
        FloatSample floatSample = new FloatSample(floatData, (int)this.samplesPerFrame);
        floatSample.setChannelsPerFrame(this.samplesPerFrame);
        floatSample.setFrameRate(this.frameRate);
        floatSample.setPitch(this.originalPitch);
        if (this.sustainBegin >= 0) {
            floatSample.setSustainBegin(this.sustainBegin);
            floatSample.setSustainEnd(this.sustainEnd);
        }
        for (SampleMarker marker : this.cueMap.values()) {
            floatSample.addMarker(marker);
        }
        if (floatSample.getMarkerCount() >= 2) {
            floatSample.setSustainBegin(floatSample.getMarker((int)0).position);
            floatSample.setSustainEnd(floatSample.getMarker((int)1).position);
        }
        return floatSample;
    }

    protected String parseString(IFFParser parser, int textLength) throws IOException {
        byte[] bar = new byte[textLength];
        parser.read(bar);
        return new String(bar);
    }
}

