/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.unitgen;

import com.jsyn.ports.UnitOutputPort;
import com.jsyn.unitgen.VariableRateDataReader;

public class VariableRateMonoReader
extends VariableRateDataReader {
    private double phase;
    private double baseIncrement;
    private double source;
    private double current;
    private double target;
    private boolean starved;
    private boolean ranout;

    public VariableRateMonoReader() {
        this.output = new UnitOutputPort("Output");
        this.addPort(this.output);
        this.starved = true;
        this.baseIncrement = 1.0;
    }

    @Override
    public void generate(int start, int limit) {
        double[] amplitudes = this.amplitude.getValues();
        double[] rates = this.rate.getValues();
        double[] outputs = this.output.getValues();
        for (int i = start; i < limit; ++i) {
            if (this.phase >= 1.0) {
                while (this.phase >= 1.0) {
                    this.source = this.target;
                    this.phase -= 1.0;
                    this.baseIncrement = this.advanceToNextFrame();
                }
            } else if (i == 0 && (this.starved || !this.dataQueue.isTargetValid())) {
                this.source = this.target = this.current;
                this.phase = 0.0;
                this.baseIncrement = this.advanceToNextFrame();
            }
            this.current = (this.target - this.source) * this.phase + this.source;
            outputs[i] = this.current * amplitudes[i];
            double phaseIncrement = this.baseIncrement * rates[i];
            this.phase += this.limitPhaseIncrement(phaseIncrement);
        }
        if (this.ranout) {
            this.ranout = false;
            if (this.dataQueue.testAndClearAutoStop()) {
                this.autoStop();
            }
        }
    }

    public double limitPhaseIncrement(double phaseIncrement) {
        return phaseIncrement;
    }

    private double advanceToNextFrame() {
        this.dataQueue.firePendingCallbacks();
        if (this.dataQueue.hasMore()) {
            this.starved = false;
            this.target = this.dataQueue.readNextMonoDouble(this.getFramePeriod());
            return this.getFramePeriod() * this.dataQueue.getNormalizedRate();
        }
        this.starved = true;
        this.ranout = true;
        this.phase = 0.0;
        return 0.0;
    }
}

