/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.scope.swing;

import com.jsyn.scope.WaveTraceModel;
import com.jsyn.swing.ExponentialRangeModel;
import java.awt.Color;
import java.awt.Graphics;
import javax.swing.JToggleButton;

public class WaveTraceView {
    private static final double AUTO_DECAY = 0.95;
    private WaveTraceModel waveTraceModel;
    private Color color;
    private ExponentialRangeModel verticalScaleModel;
    private JToggleButton.ToggleButtonModel autoScaleButtonModel;
    private double xScaler;
    private double yScalar;
    private int centerY;

    public WaveTraceView(JToggleButton.ToggleButtonModel autoButtonModel, ExponentialRangeModel verticalRangeModel) {
        this.verticalScaleModel = verticalRangeModel;
        this.autoScaleButtonModel = autoButtonModel;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public ExponentialRangeModel getVerticalRangeModel() {
        return this.verticalScaleModel;
    }

    public JToggleButton.ToggleButtonModel getAutoButtonModel() {
        return this.autoScaleButtonModel;
    }

    public void setModel(WaveTraceModel waveTraceModel) {
        this.waveTraceModel = waveTraceModel;
    }

    public int convertRealToY(double r) {
        return this.centerY - (int)(this.yScalar * r);
    }

    public void drawWave(Graphics g, int width, int height) {
        double sampleMax = 0.0;
        double sampleMin = 0.0;
        g.setColor(this.color);
        int numSamples = this.waveTraceModel.getVisibleSize();
        if (numSamples > 0) {
            this.xScaler = (double)width / (double)numSamples;
            this.yScalar = 0.5 * (double)height / this.verticalScaleModel.getDoubleValue();
            this.centerY = height / 2;
            int x1 = 0;
            int offset = this.waveTraceModel.getStartIndex();
            double value = this.waveTraceModel.getSample(offset);
            int y1 = this.convertRealToY(value);
            for (int i = 1; i < numSamples; ++i) {
                int x2 = (int)((double)i * this.xScaler);
                value = this.waveTraceModel.getSample(offset + i);
                int y2 = this.convertRealToY(value);
                g.drawLine(x1, y1, x2, y2);
                x1 = x2;
                y1 = y2;
                if (value > sampleMax) {
                    sampleMax = value;
                    continue;
                }
                if (!(value < sampleMin)) continue;
                sampleMin = value;
            }
            this.autoScaleRange(sampleMax);
        }
    }

    private void autoScaleRange(double sampleMax) {
        if (this.autoScaleButtonModel.isSelected()) {
            double scaledMax = sampleMax * 1.1;
            double current = this.verticalScaleModel.getDoubleValue();
            if (scaledMax > current) {
                this.verticalScaleModel.setDoubleValue(scaledMax);
            } else {
                double decayed = current * 0.95;
                if (decayed > (double)this.verticalScaleModel.getMinimum() && scaledMax < decayed) {
                    this.verticalScaleModel.setDoubleValue(decayed);
                }
            }
        }
    }
}

