/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.ports;

import com.jsyn.ports.UnitInputPort;
import com.jsyn.unitgen.UnitGenerator;
import com.softsynth.shared.time.ScheduledCommand;
import com.softsynth.shared.time.TimeStamp;

public class UnitGatePort
extends UnitInputPort {
    private boolean autoDisableEnabled = false;
    private boolean triggered = false;
    private boolean off = true;
    private UnitGenerator gatedUnit;
    public static final double THRESHOLD = 0.01;

    public UnitGatePort(String name) {
        super(name);
    }

    public void on() {
        this.setOn(true);
    }

    public void off() {
        this.setOn(false);
    }

    public void off(TimeStamp timeStamp) {
        this.setOn(false, timeStamp);
    }

    public void on(TimeStamp timeStamp) {
        this.setOn(true, timeStamp);
    }

    private void setOn(final boolean on) {
        this.queueCommand(new ScheduledCommand(){

            @Override
            public void run() {
                UnitGatePort.this.setOnInternal(on);
            }
        });
    }

    private void setOn(final boolean on, TimeStamp timeStamp) {
        this.scheduleCommand(timeStamp, new ScheduledCommand(){

            @Override
            public void run() {
                UnitGatePort.this.setOnInternal(on);
            }
        });
    }

    private void setOnInternal(boolean on) {
        if (on) {
            this.triggerInternal();
        }
        this.setValueInternal(on ? 1.0 : 0.0);
    }

    private void triggerInternal() {
        this.getGatedUnit().setEnabled(true);
        this.triggered = true;
    }

    public void trigger() {
        this.queueCommand(new ScheduledCommand(){

            @Override
            public void run() {
                UnitGatePort.this.triggerInternal();
            }
        });
    }

    public void trigger(TimeStamp timeStamp) {
        this.scheduleCommand(timeStamp, new ScheduledCommand(){

            @Override
            public void run() {
                UnitGatePort.this.triggerInternal();
            }
        });
    }

    public boolean checkGate(int i) {
        double[] inputs = this.getValues();
        boolean result = this.triggered;
        this.triggered = false;
        if (this.off) {
            if (inputs[i] >= 0.01) {
                result = true;
                this.off = false;
            }
        } else if (inputs[i] < 0.01) {
            this.off = true;
        }
        return result;
    }

    public boolean isOff() {
        return this.off;
    }

    public boolean isAutoDisableEnabled() {
        return this.autoDisableEnabled;
    }

    public void setAutoDisableEnabled(boolean autoDisableEnabled) {
        this.autoDisableEnabled = autoDisableEnabled;
    }

    public void checkAutoDisable() {
        if (this.autoDisableEnabled) {
            this.getGatedUnit().setEnabled(false);
        }
    }

    private UnitGenerator getGatedUnit() {
        return this.gatedUnit == null ? this.getUnitGenerator() : this.gatedUnit;
    }

    public void setupAutoDisable(UnitGenerator unit) {
        this.gatedUnit = unit;
        this.setAutoDisableEnabled(true);
        this.gatedUnit.setEnabled(false);
    }
}

