/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.midi;

public class MessageParser {
    private int[] parameterIndices = new int[16];
    private int[] parameterValues = new int[16];
    private int BIT_NON_RPM = 16384;
    private int MASK_14BIT = 16383;

    public void parse(byte[] message) {
        this.parse(message, 0, message.length);
    }

    public void parse(byte[] message, int offset, int length) {
        this.checkMessageLength(1, length);
        byte status = message[offset];
        int command = status & 0xF0;
        int channel = status & 0xF;
        switch (command) {
            case 144: {
                this.checkMessageLength(3, length);
                byte velocity = message[offset + 2];
                if (velocity == 0) {
                    this.noteOff(channel, message[offset + 1], velocity);
                    break;
                }
                this.noteOn(channel, message[offset + 1], velocity);
                break;
            }
            case 128: {
                this.checkMessageLength(3, length);
                this.noteOff(channel, message[offset + 1], message[offset + 2]);
                break;
            }
            case 160: {
                this.checkMessageLength(3, length);
                this.polyphonicAftertouch(channel, message[offset + 1], message[offset + 2]);
                break;
            }
            case 208: {
                this.checkMessageLength(2, length);
                this.channelPressure(channel, message[offset + 1]);
                break;
            }
            case 176: {
                this.checkMessageLength(3, length);
                this.rawControlChange(channel, message[offset + 1], message[offset + 2]);
                break;
            }
            case 192: {
                this.checkMessageLength(2, length);
                this.programChange(channel, message[offset + 1]);
                break;
            }
            case 224: {
                this.checkMessageLength(3, length);
                int bend = (message[offset + 2] << 7) + message[offset + 1];
                this.pitchBend(channel, bend);
                break;
            }
        }
    }

    public void rawControlChange(int channel, int index, int value) {
        switch (index) {
            case 6: {
                this.parameterValues[channel] = value << 7;
                this.fireParameterChange(channel);
                break;
            }
            case 38: {
                int paramValue = this.parameterValues[channel] & 0xFFFFFF80;
                this.parameterValues[channel] = paramValue |= value;
                this.fireParameterChange(channel);
                break;
            }
            case 98: {
                int paramIndex = this.parameterIndices[channel] & 0xFFFFFF80;
                this.parameterIndices[channel] = paramIndex |= value | this.BIT_NON_RPM;
                break;
            }
            case 99: {
                this.parameterIndices[channel] = value << 7 | this.BIT_NON_RPM;
                break;
            }
            case 100: {
                int paramIndex = this.parameterIndices[channel] & 0xFFFFFF80;
                this.parameterIndices[channel] = paramIndex |= value;
                break;
            }
            case 101: {
                this.parameterIndices[channel] = value << 7;
                break;
            }
            default: {
                this.controlChange(channel, index, value);
            }
        }
    }

    private void fireParameterChange(int channel) {
        int paramIndex = this.parameterIndices[channel];
        if ((paramIndex & this.BIT_NON_RPM) == 0) {
            this.registeredParameter(channel, paramIndex, this.parameterValues[channel]);
        } else {
            this.nonRegisteredParameter(channel, paramIndex & this.MASK_14BIT, this.parameterValues[channel]);
        }
    }

    private void checkMessageLength(int expectedLength, int actualLength) {
        if (actualLength < expectedLength) {
            throw new IllegalArgumentException("Expected message of at least " + expectedLength + " bytes but got " + actualLength + " bytes.");
        }
    }

    public void nonRegisteredParameter(int channel, int index14, int value14) {
    }

    public void registeredParameter(int channel, int index14, int value14) {
    }

    public void pitchBend(int channel, int bend) {
    }

    public void programChange(int channel, int program) {
    }

    public void polyphonicAftertouch(int channel, int pitch, int pressure) {
    }

    public void channelPressure(int channel, int pressure) {
    }

    public void controlChange(int channel, int index, int value) {
    }

    public void noteOn(int channel, int pitch, int velocity) {
    }

    public void noteOff(int channel, int pitch, int velocity) {
    }
}

